/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.collections;

import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.AdvancedMarkerOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.maps.android.collections.MapObjectManager;

public class MarkerManager
extends MapObjectManager<Marker, Collection>
implements GoogleMap.OnInfoWindowClickListener,
GoogleMap.OnMarkerClickListener,
GoogleMap.OnMarkerDragListener,
GoogleMap.InfoWindowAdapter,
GoogleMap.OnInfoWindowLongClickListener,
GoogleMap.OnInfoWindowCloseListener {
    public MarkerManager(GoogleMap map) {
        super(map);
    }

    @Override
    void setListenersOnUiThread() {
        if (this.mMap != null) {
            this.mMap.setOnInfoWindowClickListener((GoogleMap.OnInfoWindowClickListener)this);
            this.mMap.setOnInfoWindowLongClickListener((GoogleMap.OnInfoWindowLongClickListener)this);
            this.mMap.setOnMarkerClickListener((GoogleMap.OnMarkerClickListener)this);
            this.mMap.setOnMarkerDragListener((GoogleMap.OnMarkerDragListener)this);
            this.mMap.setInfoWindowAdapter((GoogleMap.InfoWindowAdapter)this);
        }
    }

    @Override
    public Collection newCollection() {
        return new Collection();
    }

    public View getInfoWindow(@NonNull Marker marker) {
        Collection collection = (Collection)this.mAllObjects.get(marker);
        if (collection != null && collection.mInfoWindowAdapter != null) {
            return collection.mInfoWindowAdapter.getInfoWindow(marker);
        }
        return null;
    }

    public View getInfoContents(@NonNull Marker marker) {
        Collection collection = (Collection)this.mAllObjects.get(marker);
        if (collection != null && collection.mInfoWindowAdapter != null) {
            return collection.mInfoWindowAdapter.getInfoContents(marker);
        }
        return null;
    }

    public void onInfoWindowClick(@NonNull Marker marker) {
        Collection collection = (Collection)this.mAllObjects.get(marker);
        if (collection != null && collection.mInfoWindowClickListener != null) {
            collection.mInfoWindowClickListener.onInfoWindowClick(marker);
        }
    }

    public void onInfoWindowLongClick(@NonNull Marker marker) {
        Collection collection = (Collection)this.mAllObjects.get(marker);
        if (collection != null && collection.mInfoWindowLongClickListener != null) {
            collection.mInfoWindowLongClickListener.onInfoWindowLongClick(marker);
        }
    }

    public void onInfoWindowClose(@NonNull Marker marker) {
        Collection collection = (Collection)this.mAllObjects.get(marker);
        if (collection != null && collection.mInfoWindowCloseListener != null) {
            collection.mInfoWindowCloseListener.onInfoWindowClose(marker);
        }
    }

    public boolean onMarkerClick(@NonNull Marker marker) {
        Collection collection = (Collection)this.mAllObjects.get(marker);
        if (collection != null && collection.mMarkerClickListener != null) {
            return collection.mMarkerClickListener.onMarkerClick(marker);
        }
        return false;
    }

    public void onMarkerDragStart(@NonNull Marker marker) {
        Collection collection = (Collection)this.mAllObjects.get(marker);
        if (collection != null && collection.mMarkerDragListener != null) {
            collection.mMarkerDragListener.onMarkerDragStart(marker);
        }
    }

    public void onMarkerDrag(@NonNull Marker marker) {
        Collection collection = (Collection)this.mAllObjects.get(marker);
        if (collection != null && collection.mMarkerDragListener != null) {
            collection.mMarkerDragListener.onMarkerDrag(marker);
        }
    }

    public void onMarkerDragEnd(@NonNull Marker marker) {
        Collection collection = (Collection)this.mAllObjects.get(marker);
        if (collection != null && collection.mMarkerDragListener != null) {
            collection.mMarkerDragListener.onMarkerDragEnd(marker);
        }
    }

    @Override
    protected void removeObjectFromMap(Marker object) {
        object.remove();
    }

    public class Collection
    extends MapObjectManager.Collection {
        private GoogleMap.OnInfoWindowClickListener mInfoWindowClickListener;
        private GoogleMap.OnInfoWindowLongClickListener mInfoWindowLongClickListener;
        private GoogleMap.OnInfoWindowCloseListener mInfoWindowCloseListener;
        private GoogleMap.OnMarkerClickListener mMarkerClickListener;
        private GoogleMap.OnMarkerDragListener mMarkerDragListener;
        private GoogleMap.InfoWindowAdapter mInfoWindowAdapter;

        public Marker addMarker(MarkerOptions opts) {
            Marker marker = MarkerManager.this.mMap.addMarker(opts);
            super.add(marker);
            return marker;
        }

        public Marker addMarker(AdvancedMarkerOptions opts) {
            Marker marker = MarkerManager.this.mMap.addMarker((MarkerOptions)opts);
            super.add(marker);
            return marker;
        }

        public void addAll(java.util.Collection<MarkerOptions> opts) {
            for (MarkerOptions opt : opts) {
                this.addMarker(opt);
            }
        }

        public void addAll(java.util.Collection<MarkerOptions> opts, boolean defaultVisible) {
            for (MarkerOptions opt : opts) {
                this.addMarker(opt).setVisible(defaultVisible);
            }
        }

        public void showAll() {
            for (Marker marker : this.getMarkers()) {
                marker.setVisible(true);
            }
        }

        public void hideAll() {
            for (Marker marker : this.getMarkers()) {
                marker.setVisible(false);
            }
        }

        public boolean remove(Marker marker) {
            return super.remove(marker);
        }

        public java.util.Collection<Marker> getMarkers() {
            return this.getObjects();
        }

        public void setOnInfoWindowClickListener(GoogleMap.OnInfoWindowClickListener infoWindowClickListener) {
            this.mInfoWindowClickListener = infoWindowClickListener;
        }

        public void setOnInfoWindowLongClickListener(GoogleMap.OnInfoWindowLongClickListener infoWindowLongClickListener) {
            this.mInfoWindowLongClickListener = infoWindowLongClickListener;
        }

        public void setOnInfoWindowCloseListener(GoogleMap.OnInfoWindowCloseListener infoWindowCloseListener) {
            this.mInfoWindowCloseListener = infoWindowCloseListener;
        }

        public void setOnMarkerClickListener(GoogleMap.OnMarkerClickListener markerClickListener) {
            this.mMarkerClickListener = markerClickListener;
        }

        public void setOnMarkerDragListener(GoogleMap.OnMarkerDragListener markerDragListener) {
            this.mMarkerDragListener = markerDragListener;
        }

        public void setInfoWindowAdapter(GoogleMap.InfoWindowAdapter infoWindowAdapter) {
            this.mInfoWindowAdapter = infoWindowAdapter;
        }
    }
}

