/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0007J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/google/maps/android/MathUtil;", "", "<init>", "()V", "EARTH_RADIUS", "", "clamp", "x", "low", "high", "wrap", "n", "min", "max", "mod", "m", "mercator", "lat", "inverseMercator", "y", "hav", "arcHav", "sinFromHav", "h", "havFromSin", "sinSumFromHav", "havDistance", "lat1", "lat2", "dLng", "library_release"})
public final class MathUtil {
    @NotNull
    public static final MathUtil INSTANCE = new MathUtil();
    public static final double EARTH_RADIUS = 6371009.0;

    private MathUtil() {
    }

    @JvmStatic
    public static final double clamp(double x, double low, double high) {
        return x < low ? low : (x > high ? high : x);
    }

    @JvmStatic
    public static final double wrap(double n, double min, double max) {
        return n >= min && n < max ? n : MathUtil.mod(n - min, max - min) + min;
    }

    @JvmStatic
    public static final double mod(double x, double m) {
        return (x % m + m) % m;
    }

    @JvmStatic
    public static final double mercator(double lat) {
        if (lat > 1.5707963257948965) {
            return Double.POSITIVE_INFINITY;
        }
        if (lat < -1.5707963257948965) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(Math.tan(lat * 0.5 + 0.7853981633974483));
    }

    @JvmStatic
    public static final double inverseMercator(double y) {
        return (double)2 * Math.atan(Math.exp(y)) - 1.5707963267948966;
    }

    @JvmStatic
    public static final double hav(double x) {
        double sinHalf = Math.sin(x * 0.5);
        return sinHalf * sinHalf;
    }

    @JvmStatic
    public static final double arcHav(double x) {
        return (double)2 * Math.asin(Math.sqrt(x));
    }

    @JvmStatic
    public static final double sinFromHav(double h) {
        return (double)2 * Math.sqrt(h * (1.0 - h));
    }

    @JvmStatic
    public static final double havFromSin(double x) {
        double x2 = x * x;
        return x2 / (1.0 + Math.sqrt(1.0 - x2)) * 0.5;
    }

    @JvmStatic
    public static final double sinSumFromHav(double x, double y) {
        double a = Math.sqrt(x * (1.0 - x));
        double b = Math.sqrt(y * (1.0 - y));
        return (double)2 * (a + b - (double)2 * (a * y + b * x));
    }

    @JvmStatic
    public static final double havDistance(double lat1, double lat2, double dLng) {
        return MathUtil.hav(lat1 - lat2) + MathUtil.hav(dLng) * Math.cos(lat1) * Math.cos(lat2);
    }
}

