/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.algo.AbstractAlgorithm;
import com.google.maps.android.clustering.algo.StaticCluster;
import com.google.maps.android.geometry.Bounds;
import com.google.maps.android.geometry.Point;
import com.google.maps.android.projection.SphericalMercatorProjection;
import com.google.maps.android.quadtree.PointQuadTree;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class NonHierarchicalDistanceBasedAlgorithm<T extends ClusterItem>
extends AbstractAlgorithm<T> {
    private static final int DEFAULT_MAX_DISTANCE_AT_ZOOM = 100;
    private int mMaxDistance = 100;
    private final Collection<QuadItem<T>> mItems = new LinkedHashSet<QuadItem<T>>();
    private final PointQuadTree<QuadItem<T>> mQuadTree = new PointQuadTree(0.0, 1.0, 0.0, 1.0);
    private static final SphericalMercatorProjection PROJECTION = new SphericalMercatorProjection(1.0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addItem(T item) {
        boolean result;
        QuadItem quadItem = new QuadItem((ClusterItem)item, null);
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            result = this.mItems.add(quadItem);
            if (result) {
                this.mQuadTree.add(quadItem);
            }
        }
        return result;
    }

    @Override
    public boolean addItems(Collection<T> items) {
        boolean result = false;
        for (ClusterItem item : items) {
            boolean individualResult = this.addItem(item);
            if (!individualResult) continue;
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearItems() {
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            this.mItems.clear();
            this.mQuadTree.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeItem(T item) {
        boolean result;
        QuadItem quadItem = new QuadItem((ClusterItem)item, null);
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            result = this.mItems.remove(quadItem);
            if (result) {
                this.mQuadTree.remove(quadItem);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeItems(Collection<T> items) {
        boolean result = false;
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            for (ClusterItem item : items) {
                QuadItem quadItem = new QuadItem(item, null);
                boolean individualResult = this.mItems.remove(quadItem);
                if (!individualResult) continue;
                this.mQuadTree.remove(quadItem);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateItem(T item) {
        boolean result;
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            result = this.removeItem(item);
            if (result) {
                result = this.addItem(item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends Cluster<T>> getClusters(float zoom) {
        int discreteZoom = (int)zoom;
        double zoomSpecificSpan = (double)this.mMaxDistance / Math.pow(2.0, discreteZoom) / 256.0;
        HashSet<QuadItem<T>> visitedCandidates = new HashSet<QuadItem<T>>();
        HashSet<Cluster<T>> results = new HashSet<Cluster<T>>();
        HashMap<QuadItem<T>, Double> distanceToCluster = new HashMap<QuadItem<T>, Double>();
        HashMap itemToCluster = new HashMap();
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            for (QuadItem<T> candidate : this.getClusteringItems(this.mQuadTree, zoom)) {
                if (visitedCandidates.contains(candidate)) continue;
                Bounds searchBounds = this.createBoundsFromSpan(candidate.getPoint(), zoomSpecificSpan);
                Collection<QuadItem<T>> clusterItems = this.mQuadTree.search(searchBounds);
                if (clusterItems.size() == 1) {
                    results.add(candidate);
                    visitedCandidates.add(candidate);
                    distanceToCluster.put(candidate, 0.0);
                    continue;
                }
                StaticCluster<ClusterItem> cluster = new StaticCluster<ClusterItem>(((QuadItem)candidate).mClusterItem.getPosition());
                results.add(cluster);
                for (QuadItem<T> clusterItem : clusterItems) {
                    Double existingDistance = (Double)distanceToCluster.get(clusterItem);
                    double distance = this.distanceSquared(clusterItem.getPoint(), candidate.getPoint());
                    if (existingDistance != null) {
                        if (existingDistance < distance) continue;
                        ((StaticCluster)itemToCluster.get(clusterItem)).remove(((QuadItem)clusterItem).mClusterItem);
                    }
                    distanceToCluster.put(clusterItem, distance);
                    cluster.add(((QuadItem)clusterItem).mClusterItem);
                    itemToCluster.put(clusterItem, cluster);
                }
                visitedCandidates.addAll(clusterItems);
            }
        }
        return results;
    }

    protected Collection<QuadItem<T>> getClusteringItems(PointQuadTree<QuadItem<T>> quadTree, float zoom) {
        return this.mItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> getItems() {
        LinkedHashSet<ClusterItem> items = new LinkedHashSet<ClusterItem>();
        PointQuadTree<QuadItem<T>> pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            for (QuadItem<T> quadItem : this.mItems) {
                items.add(((QuadItem)quadItem).mClusterItem);
            }
        }
        return items;
    }

    @Override
    public void setMaxDistanceBetweenClusteredItems(int maxDistance) {
        this.mMaxDistance = maxDistance;
    }

    @Override
    public int getMaxDistanceBetweenClusteredItems() {
        return this.mMaxDistance;
    }

    private double distanceSquared(Point a, Point b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
    }

    private Bounds createBoundsFromSpan(Point p, double span) {
        double halfSpan = span / 2.0;
        return new Bounds(p.x - halfSpan, p.x + halfSpan, p.y - halfSpan, p.y + halfSpan);
    }

    protected static class QuadItem<T extends ClusterItem>
    implements PointQuadTree.Item,
    Cluster<T> {
        private final T mClusterItem;
        private final Point mPoint;
        private final LatLng mPosition;
        private Set<T> singletonSet;

        private QuadItem(T item) {
            this.mClusterItem = item;
            this.mPosition = item.getPosition();
            this.mPoint = PROJECTION.toPoint(this.mPosition);
            this.singletonSet = Collections.singleton(this.mClusterItem);
        }

        @Override
        public Point getPoint() {
            return this.mPoint;
        }

        @Override
        public LatLng getPosition() {
            return this.mPosition;
        }

        @Override
        public Set<T> getItems() {
            return this.singletonSet;
        }

        @Override
        public int getSize() {
            return 1;
        }

        public int hashCode() {
            return this.mClusterItem.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof QuadItem)) {
                return false;
            }
            return ((QuadItem)other).mClusterItem.equals(this.mClusterItem);
        }

        /* synthetic */ QuadItem(ClusterItem x0, 1 x1) {
            this(x0);
        }
    }
}

