/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import androidx.collection.LruCache;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.algo.AbstractAlgorithm;
import com.google.maps.android.clustering.algo.Algorithm;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PreCachingAlgorithmDecorator<T extends ClusterItem>
extends AbstractAlgorithm<T> {
    private final Algorithm<T> mAlgorithm;
    private final LruCache<Integer, Set<? extends Cluster<T>>> mCache = new LruCache(5);
    private final ReadWriteLock mCacheLock = new ReentrantReadWriteLock();
    private final Executor mExecutor = Executors.newCachedThreadPool();

    public PreCachingAlgorithmDecorator(Algorithm<T> algorithm) {
        this.mAlgorithm = algorithm;
    }

    @Override
    public boolean addItem(T item) {
        boolean result = this.mAlgorithm.addItem(item);
        if (result) {
            this.clearCache();
        }
        return result;
    }

    @Override
    public boolean addItems(Collection<T> items) {
        boolean result = this.mAlgorithm.addItems(items);
        if (result) {
            this.clearCache();
        }
        return result;
    }

    @Override
    public void clearItems() {
        this.mAlgorithm.clearItems();
        this.clearCache();
    }

    @Override
    public boolean removeItem(T item) {
        boolean result = this.mAlgorithm.removeItem(item);
        if (result) {
            this.clearCache();
        }
        return result;
    }

    @Override
    public boolean removeItems(Collection<T> items) {
        boolean result = this.mAlgorithm.removeItems(items);
        if (result) {
            this.clearCache();
        }
        return result;
    }

    @Override
    public boolean updateItem(T item) {
        boolean result = this.mAlgorithm.updateItem(item);
        if (result) {
            this.clearCache();
        }
        return result;
    }

    private void clearCache() {
        this.mCache.evictAll();
    }

    @Override
    public Set<? extends Cluster<T>> getClusters(float zoom) {
        int discreteZoom = (int)zoom;
        Set<Cluster<T>> results = this.getClustersInternal(discreteZoom);
        if (this.mCache.get((Object)(discreteZoom + 1)) == null) {
            this.mExecutor.execute(new PrecacheRunnable(discreteZoom + 1));
        }
        if (this.mCache.get((Object)(discreteZoom - 1)) == null) {
            this.mExecutor.execute(new PrecacheRunnable(discreteZoom - 1));
        }
        return results;
    }

    @Override
    public Collection<T> getItems() {
        return this.mAlgorithm.getItems();
    }

    @Override
    public void setMaxDistanceBetweenClusteredItems(int maxDistance) {
        this.mAlgorithm.setMaxDistanceBetweenClusteredItems(maxDistance);
        this.clearCache();
    }

    @Override
    public int getMaxDistanceBetweenClusteredItems() {
        return this.mAlgorithm.getMaxDistanceBetweenClusteredItems();
    }

    private Set<? extends Cluster<T>> getClustersInternal(int discreteZoom) {
        this.mCacheLock.readLock().lock();
        Set<Cluster<T>> results = (Set<Cluster<T>>)this.mCache.get((Object)discreteZoom);
        this.mCacheLock.readLock().unlock();
        if (results == null) {
            this.mCacheLock.writeLock().lock();
            results = (Set)this.mCache.get((Object)discreteZoom);
            if (results == null) {
                results = this.mAlgorithm.getClusters(discreteZoom);
                this.mCache.put((Object)discreteZoom, results);
            }
            this.mCacheLock.writeLock().unlock();
        }
        return results;
    }

    private class PrecacheRunnable
    implements Runnable {
        private final int mZoom;

        public PrecacheRunnable(int zoom) {
            this.mZoom = zoom;
        }

        @Override
        public void run() {
            try {
                Thread.sleep((long)(Math.random() * 500.0 + 500.0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PreCachingAlgorithmDecorator.this.getClustersInternal(this.mZoom);
        }
    }
}

