/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.quadtree;

import com.google.maps.android.geometry.Bounds;
import com.google.maps.android.geometry.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PointQuadTree<T extends Item> {
    private final Bounds mBounds;
    private final int mDepth;
    private static final int MAX_ELEMENTS = 50;
    private Set<T> mItems;
    private static final int MAX_DEPTH = 40;
    private List<PointQuadTree<T>> mChildren = null;

    public PointQuadTree(double minX, double maxX, double minY, double maxY) {
        this(new Bounds(minX, maxX, minY, maxY));
    }

    public PointQuadTree(Bounds bounds) {
        this(bounds, 0);
    }

    private PointQuadTree(double minX, double maxX, double minY, double maxY, int depth) {
        this(new Bounds(minX, maxX, minY, maxY), depth);
    }

    private PointQuadTree(Bounds bounds, int depth) {
        this.mBounds = bounds;
        this.mDepth = depth;
    }

    public void add(T item) {
        Point point = item.getPoint();
        if (this.mBounds.contains(point.x, point.y)) {
            this.insert(point.x, point.y, item);
        }
    }

    private void insert(double x, double y, T item) {
        if (this.mChildren != null) {
            if (y < this.mBounds.midY) {
                if (x < this.mBounds.midX) {
                    super.insert(x, y, item);
                } else {
                    super.insert(x, y, item);
                }
            } else if (x < this.mBounds.midX) {
                super.insert(x, y, item);
            } else {
                super.insert(x, y, item);
            }
            return;
        }
        if (this.mItems == null) {
            this.mItems = new HashSet<T>();
        }
        this.mItems.add(item);
        if (this.mItems.size() > 50 && this.mDepth < 40) {
            this.split();
        }
    }

    private void split() {
        this.mChildren = new ArrayList<PointQuadTree<T>>(4);
        this.mChildren.add(new PointQuadTree<T>(this.mBounds.minX, this.mBounds.midX, this.mBounds.minY, this.mBounds.midY, this.mDepth + 1));
        this.mChildren.add(new PointQuadTree<T>(this.mBounds.midX, this.mBounds.maxX, this.mBounds.minY, this.mBounds.midY, this.mDepth + 1));
        this.mChildren.add(new PointQuadTree<T>(this.mBounds.minX, this.mBounds.midX, this.mBounds.midY, this.mBounds.maxY, this.mDepth + 1));
        this.mChildren.add(new PointQuadTree<T>(this.mBounds.midX, this.mBounds.maxX, this.mBounds.midY, this.mBounds.maxY, this.mDepth + 1));
        Set<T> items = this.mItems;
        this.mItems = null;
        for (Item item : items) {
            this.insert(item.getPoint().x, item.getPoint().y, item);
        }
    }

    public boolean remove(T item) {
        Point point = item.getPoint();
        if (this.mBounds.contains(point.x, point.y)) {
            return this.remove(point.x, point.y, item);
        }
        return false;
    }

    private boolean remove(double x, double y, T item) {
        if (this.mChildren != null) {
            if (y < this.mBounds.midY) {
                if (x < this.mBounds.midX) {
                    return super.remove(x, y, item);
                }
                return super.remove(x, y, item);
            }
            if (x < this.mBounds.midX) {
                return super.remove(x, y, item);
            }
            return super.remove(x, y, item);
        }
        if (this.mItems == null) {
            return false;
        }
        return this.mItems.remove(item);
    }

    public void clear() {
        this.mChildren = null;
        if (this.mItems != null) {
            this.mItems.clear();
        }
    }

    public Collection<T> search(Bounds searchBounds) {
        ArrayList results = new ArrayList();
        this.search(searchBounds, results);
        return results;
    }

    private void search(Bounds searchBounds, Collection<T> results) {
        block6: {
            block5: {
                if (!this.mBounds.intersects(searchBounds)) {
                    return;
                }
                if (this.mChildren == null) break block5;
                for (PointQuadTree<T> quad : this.mChildren) {
                    super.search(searchBounds, results);
                }
                break block6;
            }
            if (this.mItems == null) break block6;
            if (searchBounds.contains(this.mBounds)) {
                results.addAll(this.mItems);
            } else {
                for (Item item : this.mItems) {
                    if (!searchBounds.contains(item.getPoint())) continue;
                    results.add(item);
                }
            }
        }
    }

    public static interface Item {
        public Point getPoint();
    }
}

