/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import android.content.Context;
import com.google.android.gms.maps.GoogleMap;
import com.google.maps.android.data.Layer;
import com.google.maps.android.data.kml.KmlContainer;
import com.google.maps.android.data.kml.KmlGroundOverlay;
import com.google.maps.android.data.kml.KmlParser;
import com.google.maps.android.data.kml.KmlPlacemark;
import com.google.maps.android.data.kml.KmlRenderer;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class KmlLayer
extends Layer {
    public KmlLayer(GoogleMap map, int resourceId, Context context) throws XmlPullParserException, IOException {
        this(map, context.getResources().openRawResource(resourceId), context);
    }

    public KmlLayer(GoogleMap map, InputStream stream, Context context) throws XmlPullParserException, IOException {
        if (stream == null) {
            throw new IllegalArgumentException("KML InputStream cannot be null");
        }
        KmlRenderer mRenderer = new KmlRenderer(map, context);
        XmlPullParser xmlPullParser = KmlLayer.createXmlParser(stream);
        KmlParser parser = new KmlParser(xmlPullParser);
        parser.parseKml();
        stream.close();
        mRenderer.storeKmlData(parser.getStyles(), parser.getStyleMaps(), parser.getPlacemarks(), parser.getContainers(), parser.getGroundOverlays());
        this.storeRenderer(mRenderer);
    }

    private static XmlPullParser createXmlParser(InputStream stream) throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(stream, null);
        return parser;
    }

    @Override
    public void addLayerToMap() throws IOException, XmlPullParserException {
        super.addKMLToMap();
    }

    public boolean hasPlacemarks() {
        return this.hasFeatures();
    }

    public Iterable<KmlPlacemark> getPlacemarks() {
        return this.getFeatures();
    }

    @Override
    public boolean hasContainers() {
        return super.hasContainers();
    }

    @Override
    public Iterable<KmlContainer> getContainers() {
        return super.getContainers();
    }

    @Override
    public Iterable<KmlGroundOverlay> getGroundOverlays() {
        return super.getGroundOverlays();
    }
}

