/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.maps.android.data.Feature;
import com.google.maps.android.data.Geometry;
import com.google.maps.android.data.kml.KmlStyle;
import java.util.HashMap;

public class KmlPlacemark
extends Feature {
    private final String mStyle;
    private final KmlStyle mInlineStyle;

    public KmlPlacemark(Geometry geometry, String style2, KmlStyle inlineStyle, HashMap<String, String> properties) {
        super(geometry, style2, properties);
        this.mStyle = style2;
        this.mInlineStyle = inlineStyle;
    }

    public String getStyleId() {
        return super.getId();
    }

    public KmlStyle getInlineStyle() {
        return this.mInlineStyle;
    }

    public PolygonOptions getPolygonOptions() {
        if (this.mInlineStyle == null) {
            return null;
        }
        return this.mInlineStyle.getPolygonOptions();
    }

    public MarkerOptions getMarkerOptions() {
        if (this.mInlineStyle == null) {
            return null;
        }
        return this.mInlineStyle.getMarkerOptions();
    }

    public PolylineOptions getPolylineOptions() {
        if (this.mInlineStyle == null) {
            return null;
        }
        return this.mInlineStyle.getPolylineOptions();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Placemark").append("{");
        sb.append("\n style id=").append(this.mStyle);
        sb.append(",\n inline style=").append(this.mInlineStyle);
        sb.append("\n}\n");
        return sb.toString();
    }
}

