/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import android.graphics.Color;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.maps.android.data.Style;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;

public class KmlStyle
extends Style {
    private static final int HSV_VALUES = 3;
    private static final int HUE_VALUE = 0;
    private static final int INITIAL_SCALE = 1;
    private final HashMap<String, String> mBalloonOptions = new HashMap();
    private final HashSet<String> mStylesSet = new HashSet();
    private boolean mFill = true;
    private boolean mOutline = true;
    private String mIconUrl;
    private double mScale = 1.0;
    private String mStyleId = null;
    private boolean mIconRandomColorMode = false;
    private boolean mLineRandomColorMode = false;
    private boolean mPolyRandomColorMode = false;
    private float mMarkerColor = 0.0f;

    KmlStyle() {
    }

    void setInfoWindowText(String text) {
        this.mBalloonOptions.put("text", text);
    }

    String getStyleId() {
        return this.mStyleId;
    }

    void setStyleId(String styleId) {
        this.mStyleId = styleId;
    }

    public boolean isStyleSet(String style) {
        return this.mStylesSet.contains(style);
    }

    public boolean hasFill() {
        return this.mFill;
    }

    public void setFill(boolean fill) {
        this.mFill = fill;
    }

    double getIconScale() {
        return this.mScale;
    }

    void setIconScale(double scale) {
        this.mScale = scale;
        this.mStylesSet.add("iconScale");
    }

    public boolean hasOutline() {
        return this.mOutline;
    }

    public boolean hasBalloonStyle() {
        return this.mBalloonOptions.size() > 0;
    }

    void setOutline(boolean outline) {
        this.mOutline = outline;
        this.mStylesSet.add("outline");
    }

    public String getIconUrl() {
        return this.mIconUrl;
    }

    void setIconUrl(String iconUrl) {
        this.mIconUrl = iconUrl;
        this.mStylesSet.add("iconUrl");
    }

    void setFillColor(String color) {
        int polygonColorNum = Color.parseColor((String)("#" + KmlStyle.convertColor(color)));
        this.setPolygonFillColor(polygonColorNum);
        this.mStylesSet.add("fillColor");
    }

    void setMarkerColor(String color) {
        int integerColor = Color.parseColor((String)("#" + KmlStyle.convertColor(color)));
        this.mMarkerColor = KmlStyle.getHueValue(integerColor);
        this.mMarkerOptions.icon(BitmapDescriptorFactory.defaultMarker((float)this.mMarkerColor));
        this.mStylesSet.add("markerColor");
    }

    private static float getHueValue(int integerColor) {
        float[] hsvValues = new float[3];
        Color.colorToHSV((int)integerColor, (float[])hsvValues);
        return hsvValues[0];
    }

    private static String convertColor(String color) {
        String newColor = color.length() > 6 ? color.substring(0, 2) + color.substring(6, 8) + color.substring(4, 6) + color.substring(2, 4) : color.substring(4, 6) + color.substring(2, 4) + color.substring(0, 2);
        if (newColor.substring(0, 1).equals(" ")) {
            newColor = "0" + newColor.substring(1, newColor.length());
        }
        return newColor;
    }

    void setHeading(float heading) {
        this.setMarkerRotation(heading);
        this.mStylesSet.add("heading");
    }

    void setHotSpot(float x, float y, String xUnits, String yUnits) {
        this.setMarkerHotSpot(x, y, xUnits, yUnits);
        this.mStylesSet.add("hotSpot");
    }

    void setIconColorMode(String colorMode) {
        this.mIconRandomColorMode = colorMode.equals("random");
        this.mStylesSet.add("iconColorMode");
    }

    boolean isIconRandomColorMode() {
        return this.mIconRandomColorMode;
    }

    void setLineColorMode(String colorMode) {
        this.mLineRandomColorMode = colorMode.equals("random");
        this.mStylesSet.add("lineColorMode");
    }

    public boolean isLineRandomColorMode() {
        return this.mLineRandomColorMode;
    }

    void setPolyColorMode(String colorMode) {
        this.mPolyRandomColorMode = colorMode.equals("random");
        this.mStylesSet.add("polyColorMode");
    }

    public boolean isPolyRandomColorMode() {
        return this.mPolyRandomColorMode;
    }

    void setOutlineColor(String color) {
        this.mPolylineOptions.color(Color.parseColor((String)("#" + KmlStyle.convertColor(color))));
        this.mPolygonOptions.strokeColor(Color.parseColor((String)("#" + color)));
        this.mStylesSet.add("outlineColor");
    }

    void setWidth(Float width) {
        this.setLineStringWidth(width.floatValue());
        this.setPolygonStrokeWidth(width.floatValue());
        this.mStylesSet.add("width");
    }

    public HashMap<String, String> getBalloonOptions() {
        return this.mBalloonOptions;
    }

    private static MarkerOptions createMarkerOptions(MarkerOptions originalMarkerOption, boolean iconRandomColorMode, float markerColor) {
        MarkerOptions newMarkerOption = new MarkerOptions();
        newMarkerOption.rotation(originalMarkerOption.getRotation());
        newMarkerOption.anchor(originalMarkerOption.getAnchorU(), originalMarkerOption.getAnchorV());
        if (iconRandomColorMode) {
            float hue = KmlStyle.getHueValue(KmlStyle.computeRandomColor((int)markerColor));
            originalMarkerOption.icon(BitmapDescriptorFactory.defaultMarker((float)hue));
        }
        newMarkerOption.icon(originalMarkerOption.getIcon());
        return newMarkerOption;
    }

    private static PolylineOptions createPolylineOptions(PolylineOptions originalPolylineOption) {
        PolylineOptions polylineOptions = new PolylineOptions();
        polylineOptions.color(originalPolylineOption.getColor());
        polylineOptions.width(originalPolylineOption.getWidth());
        return polylineOptions;
    }

    private static PolygonOptions createPolygonOptions(PolygonOptions originalPolygonOption, boolean isFill, boolean isOutline) {
        PolygonOptions polygonOptions = new PolygonOptions();
        if (isFill) {
            polygonOptions.fillColor(originalPolygonOption.getFillColor());
        }
        if (isOutline) {
            polygonOptions.strokeColor(originalPolygonOption.getStrokeColor());
            polygonOptions.strokeWidth(originalPolygonOption.getStrokeWidth());
        }
        return polygonOptions;
    }

    public MarkerOptions getMarkerOptions() {
        return KmlStyle.createMarkerOptions(this.mMarkerOptions, this.isIconRandomColorMode(), this.mMarkerColor);
    }

    public PolylineOptions getPolylineOptions() {
        return KmlStyle.createPolylineOptions(this.mPolylineOptions);
    }

    public PolygonOptions getPolygonOptions() {
        return KmlStyle.createPolygonOptions(this.mPolygonOptions, this.mFill, this.mOutline);
    }

    public static int computeRandomColor(int color) {
        Random random = new Random();
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        if (red != 0) {
            red = random.nextInt(red);
        }
        if (blue != 0) {
            blue = random.nextInt(blue);
        }
        if (green != 0) {
            green = random.nextInt(green);
        }
        return Color.rgb((int)red, (int)green, (int)blue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Style").append("{");
        sb.append("\n balloon options=").append(this.mBalloonOptions);
        sb.append(",\n fill=").append(this.mFill);
        sb.append(",\n outline=").append(this.mOutline);
        sb.append(",\n icon url=").append(this.mIconUrl);
        sb.append(",\n scale=").append(this.mScale);
        sb.append(",\n style id=").append(this.mStyleId);
        sb.append("\n}\n");
        return sb.toString();
    }
}

