/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.geojson;

import android.util.Log;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.maps.android.geojson.GeoJsonFeature;
import com.google.maps.android.geojson.GeoJsonGeometry;
import com.google.maps.android.geojson.GeoJsonGeometryCollection;
import com.google.maps.android.geojson.GeoJsonLineString;
import com.google.maps.android.geojson.GeoJsonMultiLineString;
import com.google.maps.android.geojson.GeoJsonMultiPoint;
import com.google.maps.android.geojson.GeoJsonMultiPolygon;
import com.google.maps.android.geojson.GeoJsonPoint;
import com.google.maps.android.geojson.GeoJsonPolygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class GeoJsonParser {
    private static final String LOG_TAG = "GeoJsonParser";
    private static final String FEATURE = "Feature";
    private static final String FEATURE_GEOMETRY = "geometry";
    private static final String FEATURE_ID = "id";
    private static final String FEATURE_COLLECTION = "FeatureCollection";
    private static final String FEATURE_COLLECTION_ARRAY = "features";
    private static final String GEOMETRY_COORDINATES_ARRAY = "coordinates";
    private static final String GEOMETRY_COLLECTION = "GeometryCollection";
    private static final String GEOMETRY_COLLECTION_ARRAY = "geometries";
    private static final String BOUNDING_BOX = "bbox";
    private static final String PROPERTIES = "properties";
    private static final String POINT = "Point";
    private static final String MULTIPOINT = "MultiPoint";
    private static final String LINESTRING = "LineString";
    private static final String MULTILINESTRING = "MultiLineString";
    private static final String POLYGON = "Polygon";
    private static final String MULTIPOLYGON = "MultiPolygon";
    private final JSONObject mGeoJsonFile;
    private final ArrayList<GeoJsonFeature> mGeoJsonFeatures;
    private LatLngBounds mBoundingBox;

    GeoJsonParser(JSONObject geoJsonFile) {
        this.mGeoJsonFile = geoJsonFile;
        this.mGeoJsonFeatures = new ArrayList();
        this.mBoundingBox = null;
        this.parseGeoJson();
    }

    private static boolean isGeometry(String type) {
        return type.matches("Point|MultiPoint|LineString|MultiLineString|Polygon|MultiPolygon|GeometryCollection");
    }

    private static GeoJsonFeature parseFeature(JSONObject geoJsonFeature) {
        String id2 = null;
        LatLngBounds boundingBox = null;
        GeoJsonGeometry geometry = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            if (geoJsonFeature.has(FEATURE_ID)) {
                id2 = geoJsonFeature.getString(FEATURE_ID);
            }
            if (geoJsonFeature.has(BOUNDING_BOX)) {
                boundingBox = GeoJsonParser.parseBoundingBox(geoJsonFeature.getJSONArray(BOUNDING_BOX));
            }
            if (geoJsonFeature.has(FEATURE_GEOMETRY) && !geoJsonFeature.isNull(FEATURE_GEOMETRY)) {
                geometry = GeoJsonParser.parseGeometry(geoJsonFeature.getJSONObject(FEATURE_GEOMETRY));
            }
            if (geoJsonFeature.has(PROPERTIES) && !geoJsonFeature.isNull(PROPERTIES)) {
                properties = GeoJsonParser.parseProperties(geoJsonFeature.getJSONObject(PROPERTIES));
            }
        }
        catch (JSONException e) {
            Log.w((String)LOG_TAG, (String)("Feature could not be successfully parsed " + geoJsonFeature.toString()));
            return null;
        }
        return new GeoJsonFeature(geometry, id2, properties, boundingBox);
    }

    private static LatLngBounds parseBoundingBox(JSONArray coordinates) throws JSONException {
        LatLng southWestCorner = new LatLng(coordinates.getDouble(1), coordinates.getDouble(0));
        LatLng northEastCorner = new LatLng(coordinates.getDouble(3), coordinates.getDouble(2));
        return new LatLngBounds(southWestCorner, northEastCorner);
    }

    private static GeoJsonGeometry parseGeometry(JSONObject geoJsonGeometry) {
        try {
            JSONArray geometryArray;
            String geometryType = geoJsonGeometry.getString("type");
            if (geometryType.equals(GEOMETRY_COLLECTION)) {
                geometryArray = geoJsonGeometry.getJSONArray(GEOMETRY_COLLECTION_ARRAY);
            } else if (GeoJsonParser.isGeometry(geometryType)) {
                geometryArray = geoJsonGeometry.getJSONArray(GEOMETRY_COORDINATES_ARRAY);
            } else {
                return null;
            }
            return GeoJsonParser.createGeometry(geometryType, geometryArray);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private static GeoJsonFeature parseGeometryToFeature(JSONObject geoJsonGeometry) {
        GeoJsonGeometry geometry = GeoJsonParser.parseGeometry(geoJsonGeometry);
        if (geometry != null) {
            return new GeoJsonFeature(geometry, null, new HashMap<String, String>(), null);
        }
        Log.w((String)LOG_TAG, (String)"Geometry could not be parsed");
        return null;
    }

    private static HashMap<String, String> parseProperties(JSONObject properties) throws JSONException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Iterator propertyKeys = properties.keys();
        while (propertyKeys.hasNext()) {
            String key = (String)propertyKeys.next();
            propertiesMap.put(key, properties.getString(key));
        }
        return propertiesMap;
    }

    private static GeoJsonGeometry createGeometry(String geometryType, JSONArray geometryArray) throws JSONException {
        if (geometryType.equals(POINT)) {
            return GeoJsonParser.createPoint(geometryArray);
        }
        if (geometryType.equals(MULTIPOINT)) {
            return GeoJsonParser.createMultiPoint(geometryArray);
        }
        if (geometryType.equals(LINESTRING)) {
            return GeoJsonParser.createLineString(geometryArray);
        }
        if (geometryType.equals(MULTILINESTRING)) {
            return GeoJsonParser.createMultiLineString(geometryArray);
        }
        if (geometryType.equals(POLYGON)) {
            return GeoJsonParser.createPolygon(geometryArray);
        }
        if (geometryType.equals(MULTIPOLYGON)) {
            return GeoJsonParser.createMultiPolygon(geometryArray);
        }
        if (geometryType.equals(GEOMETRY_COLLECTION)) {
            return GeoJsonParser.createGeometryCollection(geometryArray);
        }
        return null;
    }

    private static GeoJsonPoint createPoint(JSONArray coordinates) throws JSONException {
        return new GeoJsonPoint(GeoJsonParser.parseCoordinate(coordinates));
    }

    private static GeoJsonMultiPoint createMultiPoint(JSONArray coordinates) throws JSONException {
        ArrayList<GeoJsonPoint> geoJsonPoints = new ArrayList<GeoJsonPoint>();
        for (int i = 0; i < coordinates.length(); ++i) {
            geoJsonPoints.add(GeoJsonParser.createPoint(coordinates.getJSONArray(i)));
        }
        return new GeoJsonMultiPoint(geoJsonPoints);
    }

    private static GeoJsonLineString createLineString(JSONArray coordinates) throws JSONException {
        return new GeoJsonLineString(GeoJsonParser.parseCoordinatesArray(coordinates));
    }

    private static GeoJsonMultiLineString createMultiLineString(JSONArray coordinates) throws JSONException {
        ArrayList<GeoJsonLineString> geoJsonLineStrings = new ArrayList<GeoJsonLineString>();
        for (int i = 0; i < coordinates.length(); ++i) {
            geoJsonLineStrings.add(GeoJsonParser.createLineString(coordinates.getJSONArray(i)));
        }
        return new GeoJsonMultiLineString(geoJsonLineStrings);
    }

    private static GeoJsonPolygon createPolygon(JSONArray coordinates) throws JSONException {
        return new GeoJsonPolygon(GeoJsonParser.parseCoordinatesArrays(coordinates));
    }

    private static GeoJsonMultiPolygon createMultiPolygon(JSONArray coordinates) throws JSONException {
        ArrayList<GeoJsonPolygon> geoJsonPolygons = new ArrayList<GeoJsonPolygon>();
        for (int i = 0; i < coordinates.length(); ++i) {
            geoJsonPolygons.add(GeoJsonParser.createPolygon(coordinates.getJSONArray(i)));
        }
        return new GeoJsonMultiPolygon(geoJsonPolygons);
    }

    private static GeoJsonGeometryCollection createGeometryCollection(JSONArray geometries) throws JSONException {
        ArrayList<GeoJsonGeometry> geometryCollectionElements = new ArrayList<GeoJsonGeometry>();
        for (int i = 0; i < geometries.length(); ++i) {
            JSONObject geometryElement = geometries.getJSONObject(i);
            GeoJsonGeometry geometry = GeoJsonParser.parseGeometry(geometryElement);
            if (geometry == null) continue;
            geometryCollectionElements.add(geometry);
        }
        return new GeoJsonGeometryCollection(geometryCollectionElements);
    }

    private static LatLng parseCoordinate(JSONArray coordinates) throws JSONException {
        return new LatLng(coordinates.getDouble(1), coordinates.getDouble(0));
    }

    private static ArrayList<LatLng> parseCoordinatesArray(JSONArray coordinates) throws JSONException {
        ArrayList<LatLng> coordinatesArray = new ArrayList<LatLng>();
        for (int i = 0; i < coordinates.length(); ++i) {
            coordinatesArray.add(GeoJsonParser.parseCoordinate(coordinates.getJSONArray(i)));
        }
        return coordinatesArray;
    }

    private static ArrayList<ArrayList<LatLng>> parseCoordinatesArrays(JSONArray coordinates) throws JSONException {
        ArrayList<ArrayList<LatLng>> coordinatesArray = new ArrayList<ArrayList<LatLng>>();
        for (int i = 0; i < coordinates.length(); ++i) {
            coordinatesArray.add(GeoJsonParser.parseCoordinatesArray(coordinates.getJSONArray(i)));
        }
        return coordinatesArray;
    }

    private void parseGeoJson() {
        try {
            String type = this.mGeoJsonFile.getString("type");
            if (type.equals(FEATURE)) {
                GeoJsonFeature feature = GeoJsonParser.parseFeature(this.mGeoJsonFile);
                if (feature != null) {
                    this.mGeoJsonFeatures.add(feature);
                }
            } else if (type.equals(FEATURE_COLLECTION)) {
                this.mGeoJsonFeatures.addAll(this.parseFeatureCollection(this.mGeoJsonFile));
            } else if (GeoJsonParser.isGeometry(type)) {
                GeoJsonFeature feature = GeoJsonParser.parseGeometryToFeature(this.mGeoJsonFile);
                if (feature != null) {
                    this.mGeoJsonFeatures.add(feature);
                }
            } else {
                Log.w((String)LOG_TAG, (String)"GeoJSON file could not be parsed.");
            }
        }
        catch (JSONException e) {
            Log.w((String)LOG_TAG, (String)"GeoJSON file could not be parsed.");
        }
    }

    private ArrayList<GeoJsonFeature> parseFeatureCollection(JSONObject geoJsonFeatureCollection) {
        JSONArray geoJsonFeatures;
        ArrayList<GeoJsonFeature> features = new ArrayList<GeoJsonFeature>();
        try {
            geoJsonFeatures = geoJsonFeatureCollection.getJSONArray(FEATURE_COLLECTION_ARRAY);
            if (geoJsonFeatureCollection.has(BOUNDING_BOX)) {
                this.mBoundingBox = GeoJsonParser.parseBoundingBox(geoJsonFeatureCollection.getJSONArray(BOUNDING_BOX));
            }
        }
        catch (JSONException e) {
            Log.w((String)LOG_TAG, (String)"Feature Collection could not be created.");
            return features;
        }
        for (int i = 0; i < geoJsonFeatures.length(); ++i) {
            try {
                JSONObject feature = geoJsonFeatures.getJSONObject(i);
                if (!feature.getString("type").equals(FEATURE)) continue;
                GeoJsonFeature parsedFeature = GeoJsonParser.parseFeature(feature);
                if (parsedFeature != null) {
                    features.add(parsedFeature);
                    continue;
                }
                Log.w((String)LOG_TAG, (String)("Index of Feature in Feature Collection that could not be created: " + i));
                continue;
            }
            catch (JSONException e) {
                Log.w((String)LOG_TAG, (String)("Index of Feature in Feature Collection that could not be created: " + i));
            }
        }
        return features;
    }

    ArrayList<GeoJsonFeature> getFeatures() {
        return this.mGeoJsonFeatures;
    }

    LatLngBounds getBoundingBox() {
        return this.mBoundingBox;
    }
}

