/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.geojson;

import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.maps.android.geojson.GeoJsonStyle;
import java.util.Arrays;
import java.util.Observable;

public class GeoJsonPointStyle
extends Observable
implements GeoJsonStyle {
    private static final String[] GEOMETRY_TYPE = new String[]{"Point", "MultiPoint", "GeometryCollection"};
    private final MarkerOptions mMarkerOptions = new MarkerOptions();

    @Override
    public String[] getGeometryType() {
        return GEOMETRY_TYPE;
    }

    public float getAlpha() {
        return this.mMarkerOptions.getAlpha();
    }

    public void setAlpha(float alpha) {
        this.mMarkerOptions.alpha(alpha);
        this.styleChanged();
    }

    public float getAnchorU() {
        return this.mMarkerOptions.getAnchorU();
    }

    public float getAnchorV() {
        return this.mMarkerOptions.getAnchorV();
    }

    public void setAnchor(float anchorU, float anchorV) {
        this.mMarkerOptions.anchor(anchorU, anchorV);
        this.styleChanged();
    }

    public boolean isDraggable() {
        return this.mMarkerOptions.isDraggable();
    }

    public void setDraggable(boolean draggable) {
        this.mMarkerOptions.draggable(draggable);
        this.styleChanged();
    }

    public boolean isFlat() {
        return this.mMarkerOptions.isFlat();
    }

    public void setFlat(boolean flat) {
        this.mMarkerOptions.flat(flat);
        this.styleChanged();
    }

    public BitmapDescriptor getIcon() {
        return this.mMarkerOptions.getIcon();
    }

    public void setIcon(BitmapDescriptor bitmap) {
        this.mMarkerOptions.icon(bitmap);
        this.styleChanged();
    }

    public float getInfoWindowAnchorU() {
        return this.mMarkerOptions.getInfoWindowAnchorU();
    }

    public float getInfoWindowAnchorV() {
        return this.mMarkerOptions.getInfoWindowAnchorV();
    }

    public void setInfoWindowAnchor(float infoWindowAnchorU, float infoWindowAnchorV) {
        this.mMarkerOptions.infoWindowAnchor(infoWindowAnchorU, infoWindowAnchorV);
        this.styleChanged();
    }

    public float getRotation() {
        return this.mMarkerOptions.getRotation();
    }

    public void setRotation(float rotation) {
        this.mMarkerOptions.rotation(rotation);
        this.styleChanged();
    }

    public String getSnippet() {
        return this.mMarkerOptions.getSnippet();
    }

    public void setSnippet(String snippet) {
        this.mMarkerOptions.snippet(snippet);
        this.styleChanged();
    }

    public String getTitle() {
        return this.mMarkerOptions.getTitle();
    }

    public void setTitle(String title) {
        this.mMarkerOptions.title(title);
        this.styleChanged();
    }

    @Override
    public boolean isVisible() {
        return this.mMarkerOptions.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.mMarkerOptions.visible(visible);
        this.styleChanged();
    }

    private void styleChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public MarkerOptions toMarkerOptions() {
        MarkerOptions markerOptions = new MarkerOptions();
        markerOptions.alpha(this.mMarkerOptions.getAlpha());
        markerOptions.anchor(this.mMarkerOptions.getAnchorU(), this.mMarkerOptions.getAnchorV());
        markerOptions.draggable(this.mMarkerOptions.isDraggable());
        markerOptions.flat(this.mMarkerOptions.isFlat());
        markerOptions.icon(this.mMarkerOptions.getIcon());
        markerOptions.infoWindowAnchor(this.mMarkerOptions.getInfoWindowAnchorU(), this.mMarkerOptions.getInfoWindowAnchorV());
        markerOptions.rotation(this.mMarkerOptions.getRotation());
        markerOptions.snippet(this.mMarkerOptions.getSnippet());
        markerOptions.title(this.mMarkerOptions.getTitle());
        markerOptions.visible(this.mMarkerOptions.isVisible());
        return markerOptions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PointStyle{");
        sb.append("\n geometry type=").append(Arrays.toString(GEOMETRY_TYPE));
        sb.append(",\n alpha=").append(this.getAlpha());
        sb.append(",\n anchor U=").append(this.getAnchorU());
        sb.append(",\n anchor V=").append(this.getAnchorV());
        sb.append(",\n draggable=").append(this.isDraggable());
        sb.append(",\n flat=").append(this.isFlat());
        sb.append(",\n info window anchor U=").append(this.getInfoWindowAnchorU());
        sb.append(",\n info window anchor V=").append(this.getInfoWindowAnchorV());
        sb.append(",\n rotation=").append(this.getRotation());
        sb.append(",\n snippet=").append(this.getSnippet());
        sb.append(",\n title=").append(this.getTitle());
        sb.append(",\n visible=").append(this.isVisible());
        sb.append("\n}\n");
        return sb.toString();
    }
}

