/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.kml;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.LruCache;
import android.text.Html;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.maps.android.R;
import com.google.maps.android.kml.KmlContainer;
import com.google.maps.android.kml.KmlGeometry;
import com.google.maps.android.kml.KmlGroundOverlay;
import com.google.maps.android.kml.KmlLineString;
import com.google.maps.android.kml.KmlMultiGeometry;
import com.google.maps.android.kml.KmlPlacemark;
import com.google.maps.android.kml.KmlPoint;
import com.google.maps.android.kml.KmlPolygon;
import com.google.maps.android.kml.KmlStyle;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class KmlRenderer
extends FragmentActivity {
    private static final String LOG_TAG = "KmlRenderer";
    private static final int LRU_CACHE_SIZE = 50;
    private final LruCache<String, Bitmap> mImagesCache;
    private final ArrayList<String> mMarkerIconUrls;
    private final ArrayList<String> mGroundOverlayUrls;
    private GoogleMap mMap;
    private HashMap<KmlPlacemark, Object> mPlacemarks;
    private HashMap<String, String> mStyleMaps;
    private ArrayList<KmlContainer> mContainers;
    private HashMap<String, KmlStyle> mStyles;
    private HashMap<String, KmlStyle> mStylesRenderer;
    private HashMap<KmlGroundOverlay, GroundOverlay> mGroundOverlays;
    private boolean mLayerVisible;
    private boolean mMarkerIconsDownloaded;
    private boolean mGroundOverlayImagesDownloaded;
    private Context mContext;

    KmlRenderer(GoogleMap map, Context context) {
        this.mContext = context;
        this.mMap = map;
        this.mImagesCache = new LruCache(50);
        this.mMarkerIconUrls = new ArrayList();
        this.mGroundOverlayUrls = new ArrayList();
        this.mStylesRenderer = new HashMap();
        this.mLayerVisible = false;
        this.mMarkerIconsDownloaded = false;
        this.mGroundOverlayImagesDownloaded = false;
    }

    private static boolean getPlacemarkVisibility(KmlPlacemark placemark) {
        String placemarkVisibility;
        boolean isPlacemarkVisible = true;
        if (placemark.hasProperty("visibility") && Integer.parseInt(placemarkVisibility = placemark.getProperty("visibility")) == 0) {
            isPlacemarkVisible = false;
        }
        return isPlacemarkVisible;
    }

    private static BitmapDescriptor scaleIcon(Bitmap unscaledBitmap, Double scale) {
        int width = (int)((double)unscaledBitmap.getWidth() * scale);
        int height = (int)((double)unscaledBitmap.getHeight() * scale);
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)unscaledBitmap, (int)width, (int)height, (boolean)false);
        return BitmapDescriptorFactory.fromBitmap((Bitmap)scaledBitmap);
    }

    private static void removePlacemarks(HashMap<KmlPlacemark, Object> placemarks) {
        for (Object mapObject : placemarks.values()) {
            if (mapObject instanceof Marker) {
                ((Marker)mapObject).remove();
                continue;
            }
            if (mapObject instanceof Polyline) {
                ((Polyline)mapObject).remove();
                continue;
            }
            if (!(mapObject instanceof Polygon)) continue;
            ((Polygon)mapObject).remove();
        }
    }

    static boolean getContainerVisibility(KmlContainer kmlContainer, boolean isParentContainerVisible) {
        String placemarkVisibility;
        boolean isChildContainerVisible = true;
        if (kmlContainer.hasProperty("visibility") && Integer.parseInt(placemarkVisibility = kmlContainer.getProperty("visibility")) == 0) {
            isChildContainerVisible = false;
        }
        return isParentContainerVisible && isChildContainerVisible;
    }

    private void removeGroundOverlays(HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        for (GroundOverlay groundOverlay : groundOverlays.values()) {
            groundOverlay.remove();
        }
    }

    private void removeContainers(Iterable<KmlContainer> containers) {
        for (KmlContainer container : containers) {
            KmlRenderer.removePlacemarks(container.getPlacemarksHashMap());
            this.removeGroundOverlays(container.getGroundOverlayHashMap());
            this.removeContainers(container.getContainers());
        }
    }

    void assignStyleMap(HashMap<String, String> styleMap, HashMap<String, KmlStyle> styles) {
        for (String styleMapKey : styleMap.keySet()) {
            String styleMapValue = styleMap.get(styleMapKey);
            if (!styles.containsKey(styleMapValue)) continue;
            styles.put(styleMapKey, styles.get(styleMapValue));
        }
    }

    void storeKmlData(HashMap<String, KmlStyle> styles, HashMap<String, String> styleMaps, HashMap<KmlPlacemark, Object> placemarks, ArrayList<KmlContainer> folders, HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        this.mStyles = styles;
        this.mStyleMaps = styleMaps;
        this.mPlacemarks = placemarks;
        this.mContainers = folders;
        this.mGroundOverlays = groundOverlays;
    }

    void addLayerToMap() {
        this.mStylesRenderer.putAll(this.mStyles);
        this.assignStyleMap(this.mStyleMaps, this.mStylesRenderer);
        this.addGroundOverlays(this.mGroundOverlays, this.mContainers);
        this.addContainerGroupToMap(this.mContainers, true);
        this.addPlacemarksToMap(this.mPlacemarks);
        if (!this.mGroundOverlayImagesDownloaded) {
            this.downloadGroundOverlays();
        }
        if (!this.mMarkerIconsDownloaded) {
            this.downloadMarkerIcons();
        }
        this.mLayerVisible = true;
    }

    GoogleMap getMap() {
        return this.mMap;
    }

    void setMap(GoogleMap map) {
        this.removeLayerFromMap();
        this.mMap = map;
        this.addLayerToMap();
    }

    boolean hasKmlPlacemarks() {
        return this.mPlacemarks.size() > 0;
    }

    Iterable<KmlPlacemark> getKmlPlacemarks() {
        return this.mPlacemarks.keySet();
    }

    boolean hasNestedContainers() {
        return this.mContainers.size() > 0;
    }

    Iterable<KmlContainer> getNestedContainers() {
        return this.mContainers;
    }

    Iterable<KmlGroundOverlay> getGroundOverlays() {
        return this.mGroundOverlays.keySet();
    }

    void removeLayerFromMap() {
        KmlRenderer.removePlacemarks(this.mPlacemarks);
        this.removeGroundOverlays(this.mGroundOverlays);
        if (this.hasNestedContainers()) {
            this.removeContainers(this.getNestedContainers());
        }
        this.mLayerVisible = false;
        this.mStylesRenderer.clear();
    }

    private void addPlacemarksToMap(HashMap<KmlPlacemark, Object> placemarks) {
        for (KmlPlacemark kmlPlacemark : placemarks.keySet()) {
            boolean isPlacemarkVisible = KmlRenderer.getPlacemarkVisibility(kmlPlacemark);
            Object mapObject = this.addPlacemarkToMap(kmlPlacemark, isPlacemarkVisible);
            placemarks.put(kmlPlacemark, mapObject);
        }
    }

    private Object addPlacemarkToMap(KmlPlacemark placemark, boolean placemarkVisibility) {
        if (placemark.getGeometry() != null) {
            String placemarkId = placemark.getStyleId();
            KmlGeometry geometry = placemark.getGeometry();
            KmlStyle style2 = this.getPlacemarkStyle(placemarkId);
            KmlStyle inlineStyle = placemark.getInlineStyle();
            return this.addToMap(placemark, geometry, style2, inlineStyle, placemarkVisibility);
        }
        return null;
    }

    private void addContainerGroupToMap(Iterable<KmlContainer> kmlContainers, boolean containerVisibility) {
        for (KmlContainer container : kmlContainers) {
            boolean isContainerVisible = KmlRenderer.getContainerVisibility(container, containerVisibility);
            if (container.getStyles() != null) {
                this.mStylesRenderer.putAll(container.getStyles());
            }
            if (container.getStyleMap() != null) {
                this.assignStyleMap(container.getStyleMap(), this.mStylesRenderer);
            }
            this.addContainerObjectToMap(container, isContainerVisible);
            if (!container.hasContainers()) continue;
            this.addContainerGroupToMap(container.getContainers(), isContainerVisible);
        }
    }

    private void addContainerObjectToMap(KmlContainer kmlContainer, boolean isContainerVisible) {
        for (KmlPlacemark placemark : kmlContainer.getPlacemarks()) {
            boolean isPlacemarkVisible = KmlRenderer.getPlacemarkVisibility(placemark);
            boolean isObjectVisible = isContainerVisible && isPlacemarkVisible;
            Object mapObject = this.addPlacemarkToMap(placemark, isObjectVisible);
            kmlContainer.setPlacemark(placemark, mapObject);
        }
    }

    private KmlStyle getPlacemarkStyle(String styleId) {
        KmlStyle style2 = this.mStylesRenderer.get(null);
        if (this.mStylesRenderer.get(styleId) != null) {
            style2 = this.mStylesRenderer.get(styleId);
        }
        return style2;
    }

    private void addMarkerIcons(String styleUrl, MarkerOptions markerOptions) {
        if (this.mImagesCache.get((Object)styleUrl) != null) {
            Bitmap bitmap = (Bitmap)this.mImagesCache.get((Object)styleUrl);
            markerOptions.icon(BitmapDescriptorFactory.fromBitmap((Bitmap)bitmap));
        } else if (!this.mMarkerIconUrls.contains(styleUrl)) {
            this.mMarkerIconUrls.add(styleUrl);
        }
    }

    private void downloadMarkerIcons() {
        this.mMarkerIconsDownloaded = true;
        Iterator<String> iterator = this.mMarkerIconUrls.iterator();
        while (iterator.hasNext()) {
            String markerIconUrl = iterator.next();
            new MarkerIconImageDownload(markerIconUrl).execute(new String[0]);
            iterator.remove();
        }
    }

    private void addIconToMarkers(String iconUrl, HashMap<KmlPlacemark, Object> placemarks) {
        for (KmlPlacemark placemark : placemarks.keySet()) {
            boolean isPlacemarkStyleIcon;
            KmlStyle urlStyle = this.mStylesRenderer.get(placemark.getStyleId());
            KmlStyle inlineStyle = placemark.getInlineStyle();
            if (!"Point".equals(placemark.getGeometry().getGeometryType())) continue;
            boolean isInlineStyleIcon = inlineStyle != null && iconUrl.equals(inlineStyle.getIconUrl());
            boolean bl = isPlacemarkStyleIcon = urlStyle != null && iconUrl.equals(urlStyle.getIconUrl());
            if (isInlineStyleIcon) {
                this.scaleBitmap(inlineStyle, placemarks, placemark);
                continue;
            }
            if (!isPlacemarkStyleIcon) continue;
            this.scaleBitmap(urlStyle, placemarks, placemark);
        }
    }

    private void scaleBitmap(KmlStyle style2, HashMap<KmlPlacemark, Object> placemarks, KmlPlacemark placemark) {
        double bitmapScale = style2.getIconScale();
        String bitmapUrl = style2.getIconUrl();
        Bitmap bitmapImage = (Bitmap)this.mImagesCache.get((Object)bitmapUrl);
        BitmapDescriptor scaledBitmap = KmlRenderer.scaleIcon(bitmapImage, bitmapScale);
        ((Marker)placemarks.get(placemark)).setIcon(scaledBitmap);
    }

    private void addContainerGroupIconsToMarkers(String iconUrl, Iterable<KmlContainer> kmlContainers) {
        for (KmlContainer container : kmlContainers) {
            this.addIconToMarkers(iconUrl, container.getPlacemarksHashMap());
            if (!container.hasContainers()) continue;
            this.addContainerGroupIconsToMarkers(iconUrl, container.getContainers());
        }
    }

    private Object addToMap(KmlPlacemark placemark, KmlGeometry geometry, KmlStyle style2, KmlStyle inlineStyle, boolean isVisible) {
        String geometryType = geometry.getGeometryType();
        if (geometryType.equals("Point")) {
            Marker marker = this.addPointToMap(placemark, (KmlPoint)geometry, style2, inlineStyle);
            marker.setVisible(isVisible);
            return marker;
        }
        if (geometryType.equals("LineString")) {
            Polyline polyline = this.addLineStringToMap((KmlLineString)geometry, style2, inlineStyle);
            polyline.setVisible(isVisible);
            return polyline;
        }
        if (geometryType.equals("Polygon")) {
            Polygon polygon = this.addPolygonToMap((KmlPolygon)geometry, style2, inlineStyle);
            polygon.setVisible(isVisible);
            return polygon;
        }
        if (geometryType.equals("MultiGeometry")) {
            return this.addMultiGeometryToMap(placemark, (KmlMultiGeometry)geometry, style2, inlineStyle, isVisible);
        }
        return null;
    }

    private Marker addPointToMap(KmlPlacemark placemark, KmlPoint point, KmlStyle style2, KmlStyle markerInlineStyle) {
        MarkerOptions markerUrlStyle = style2.getMarkerOptions();
        markerUrlStyle.position(point.getGeometryObject());
        if (markerInlineStyle != null) {
            this.setInlinePointStyle(markerUrlStyle, markerInlineStyle, style2.getIconUrl());
        } else if (style2.getIconUrl() != null) {
            this.addMarkerIcons(style2.getIconUrl(), markerUrlStyle);
        }
        Marker marker = this.mMap.addMarker(markerUrlStyle);
        this.setMarkerInfoWindow(style2, marker, placemark);
        return marker;
    }

    private void setMarkerInfoWindow(KmlStyle style2, Marker marker, KmlPlacemark placemark) {
        boolean hasName = placemark.hasProperty("name");
        boolean hasDescription = placemark.hasProperty("description");
        boolean hasBalloonOptions = style2.hasBalloonStyle();
        boolean hasBalloonText = style2.getBalloonOptions().containsKey("text");
        if (hasBalloonOptions && hasBalloonText) {
            marker.setTitle(style2.getBalloonOptions().get("text"));
            this.createInfoWindow();
        } else if (hasBalloonOptions && hasName) {
            marker.setTitle(placemark.getProperty("name"));
            this.createInfoWindow();
        } else if (hasName && hasDescription) {
            marker.setTitle(placemark.getProperty("name"));
            marker.setSnippet(placemark.getProperty("description"));
            this.createInfoWindow();
        } else if (hasDescription) {
            marker.setTitle(placemark.getProperty("description"));
            this.createInfoWindow();
        }
    }

    private void createInfoWindow() {
        this.mMap.setInfoWindowAdapter(new GoogleMap.InfoWindowAdapter(){

            public View getInfoWindow(Marker arg0) {
                return null;
            }

            public View getInfoContents(Marker arg0) {
                View view = LayoutInflater.from((Context)KmlRenderer.this.mContext).inflate(R.layout.info_window, null);
                TextView infoWindowText = (TextView)view.findViewById(R.id.window);
                if (arg0.getSnippet() != null) {
                    String string = String.valueOf(arg0.getTitle());
                    String string2 = String.valueOf(arg0.getSnippet());
                    infoWindowText.setText((CharSequence)Html.fromHtml((String)new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("<br>").append(string2).toString()));
                } else {
                    infoWindowText.setText((CharSequence)Html.fromHtml((String)arg0.getTitle()));
                }
                return view;
            }
        });
    }

    private void setInlinePointStyle(MarkerOptions markerOptions, KmlStyle inlineStyle, String markerUrlIconUrl) {
        MarkerOptions inlineMarkerOptions = inlineStyle.getMarkerOptions();
        if (inlineStyle.isStyleSet("heading")) {
            markerOptions.rotation(inlineMarkerOptions.getRotation());
        }
        if (inlineStyle.isStyleSet("hotSpot")) {
            markerOptions.anchor(inlineMarkerOptions.getAnchorU(), inlineMarkerOptions.getAnchorV());
        }
        if (inlineStyle.isStyleSet("markerColor")) {
            markerOptions.icon(inlineMarkerOptions.getIcon());
        }
        if (inlineStyle.isStyleSet("iconUrl")) {
            this.addMarkerIcons(inlineStyle.getIconUrl(), markerOptions);
        } else if (markerUrlIconUrl != null) {
            this.addMarkerIcons(markerUrlIconUrl, markerOptions);
        }
    }

    private Polyline addLineStringToMap(KmlLineString lineString, KmlStyle style2, KmlStyle inlineStyle) {
        PolylineOptions polylineOptions = style2.getPolylineOptions();
        polylineOptions.addAll((Iterable)lineString.getGeometryObject());
        if (inlineStyle != null) {
            this.setInlineLineStringStyle(polylineOptions, inlineStyle);
        } else if (style2.isLineRandomColorMode()) {
            polylineOptions.color(KmlStyle.computeRandomColor(polylineOptions.getColor()));
        }
        return this.mMap.addPolyline(polylineOptions);
    }

    private void setInlineLineStringStyle(PolylineOptions polylineOptions, KmlStyle inlineStyle) {
        PolylineOptions inlinePolylineOptions = inlineStyle.getPolylineOptions();
        if (inlineStyle.isStyleSet("outlineColor")) {
            polylineOptions.color(inlinePolylineOptions.getColor());
        }
        if (inlineStyle.isStyleSet("width")) {
            polylineOptions.width(inlinePolylineOptions.getWidth());
        }
        if (inlineStyle.isLineRandomColorMode()) {
            polylineOptions.color(KmlStyle.computeRandomColor(inlinePolylineOptions.getColor()));
        }
    }

    private Polygon addPolygonToMap(KmlPolygon polygon, KmlStyle style2, KmlStyle inlineStyle) {
        PolygonOptions polygonOptions = style2.getPolygonOptions();
        polygonOptions.addAll(polygon.getOuterBoundaryCoordinates());
        for (ArrayList<LatLng> innerBoundary : polygon.getInnerBoundaryCoordinates()) {
            polygonOptions.addHole(innerBoundary);
        }
        if (inlineStyle != null) {
            this.setInlinePolygonStyle(polygonOptions, inlineStyle);
        } else if (style2.isPolyRandomColorMode()) {
            polygonOptions.fillColor(KmlStyle.computeRandomColor(polygonOptions.getFillColor()));
        }
        return this.mMap.addPolygon(polygonOptions);
    }

    private void setInlinePolygonStyle(PolygonOptions polygonOptions, KmlStyle inlineStyle) {
        PolygonOptions inlinePolygonOptions = inlineStyle.getPolygonOptions();
        if (inlineStyle.hasFill() && inlineStyle.isStyleSet("fillColor")) {
            polygonOptions.fillColor(inlinePolygonOptions.getFillColor());
        }
        if (inlineStyle.hasOutline()) {
            if (inlineStyle.isStyleSet("outlineColor")) {
                polygonOptions.strokeColor(inlinePolygonOptions.getStrokeColor());
            }
            if (inlineStyle.isStyleSet("width")) {
                polygonOptions.strokeWidth(inlinePolygonOptions.getStrokeWidth());
            }
        }
        if (inlineStyle.isPolyRandomColorMode()) {
            polygonOptions.fillColor(KmlStyle.computeRandomColor(inlinePolygonOptions.getFillColor()));
        }
    }

    private ArrayList<Object> addMultiGeometryToMap(KmlPlacemark placemark, KmlMultiGeometry multiGeometry, KmlStyle urlStyle, KmlStyle inlineStyle, boolean isContainerVisible) {
        ArrayList<Object> mapObjects = new ArrayList<Object>();
        Object kmlObjects = multiGeometry.getGeometryObject();
        Iterator iterator = ((ArrayList)kmlObjects).iterator();
        while (iterator.hasNext()) {
            KmlGeometry kmlGeometry = (KmlGeometry)iterator.next();
            mapObjects.add(this.addToMap(placemark, kmlGeometry, urlStyle, inlineStyle, isContainerVisible));
        }
        return mapObjects;
    }

    private void addGroundOverlays(HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays, Iterable<KmlContainer> kmlContainers) {
        this.addGroundOverlays(groundOverlays);
        for (KmlContainer container : kmlContainers) {
            this.addGroundOverlays(container.getGroundOverlayHashMap(), container.getContainers());
        }
    }

    private void addGroundOverlays(HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        for (KmlGroundOverlay groundOverlay : groundOverlays.keySet()) {
            String groundOverlayUrl = groundOverlay.getImageUrl();
            if (groundOverlayUrl == null || groundOverlay.getLatLngBox() == null) continue;
            if (this.mImagesCache.get((Object)groundOverlayUrl) != null) {
                this.addGroundOverlayToMap(groundOverlayUrl, this.mGroundOverlays, true);
                continue;
            }
            if (this.mGroundOverlayUrls.contains(groundOverlayUrl)) continue;
            this.mGroundOverlayUrls.add(groundOverlayUrl);
        }
    }

    private void downloadGroundOverlays() {
        this.mGroundOverlayImagesDownloaded = true;
        Iterator<String> iterator = this.mGroundOverlayUrls.iterator();
        while (iterator.hasNext()) {
            String groundOverlayUrl = iterator.next();
            new GroundOverlayImageDownload(groundOverlayUrl).execute(new String[0]);
            iterator.remove();
        }
    }

    private void addGroundOverlayToMap(String groundOverlayUrl, HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays, boolean containerVisibility) {
        BitmapDescriptor groundOverlayBitmap = BitmapDescriptorFactory.fromBitmap((Bitmap)((Bitmap)this.mImagesCache.get((Object)groundOverlayUrl)));
        for (KmlGroundOverlay kmlGroundOverlay : groundOverlays.keySet()) {
            if (!kmlGroundOverlay.getImageUrl().equals(groundOverlayUrl)) continue;
            GroundOverlayOptions groundOverlayOptions = kmlGroundOverlay.getGroundOverlayOptions().image(groundOverlayBitmap);
            GroundOverlay mapGroundOverlay = this.mMap.addGroundOverlay(groundOverlayOptions);
            if (!containerVisibility) {
                mapGroundOverlay.setVisible(false);
            }
            groundOverlays.put(kmlGroundOverlay, mapGroundOverlay);
        }
    }

    private void addGroundOverlayInContainerGroups(String groundOverlayUrl, Iterable<KmlContainer> kmlContainers, boolean containerVisibility) {
        for (KmlContainer container : kmlContainers) {
            boolean isContainerVisible = KmlRenderer.getContainerVisibility(container, containerVisibility);
            this.addGroundOverlayToMap(groundOverlayUrl, container.getGroundOverlayHashMap(), isContainerVisible);
            if (!container.hasContainers()) continue;
            this.addGroundOverlayInContainerGroups(groundOverlayUrl, container.getContainers(), isContainerVisible);
        }
    }

    private class GroundOverlayImageDownload
    extends AsyncTask<String, Void, Bitmap> {
        private final String mGroundOverlayUrl;

        public GroundOverlayImageDownload(String groundOverlayUrl) {
            this.mGroundOverlayUrl = groundOverlayUrl;
        }

        protected Bitmap doInBackground(String ... params) {
            try {
                return BitmapFactory.decodeStream((InputStream)((InputStream)new URL(this.mGroundOverlayUrl).getContent()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        protected void onPostExecute(Bitmap bitmap) {
            if (bitmap == null) {
                String string = String.valueOf(this.mGroundOverlayUrl);
                Log.e((String)KmlRenderer.LOG_TAG, (String)(string.length() != 0 ? "Image at this URL could not be found ".concat(string) : new String("Image at this URL could not be found ")));
            } else {
                KmlRenderer.this.mImagesCache.put((Object)this.mGroundOverlayUrl, (Object)bitmap);
                if (KmlRenderer.this.mLayerVisible) {
                    KmlRenderer.this.addGroundOverlayToMap(this.mGroundOverlayUrl, KmlRenderer.this.mGroundOverlays, true);
                    KmlRenderer.this.addGroundOverlayInContainerGroups(this.mGroundOverlayUrl, KmlRenderer.this.mContainers, true);
                }
            }
        }
    }

    private class MarkerIconImageDownload
    extends AsyncTask<String, Void, Bitmap> {
        private final String mIconUrl;

        public MarkerIconImageDownload(String iconUrl) {
            this.mIconUrl = iconUrl;
        }

        protected Bitmap doInBackground(String ... params) {
            try {
                return BitmapFactory.decodeStream((InputStream)((InputStream)new URL(this.mIconUrl).getContent()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        protected void onPostExecute(Bitmap bitmap) {
            if (bitmap == null) {
                String string = String.valueOf(this.mIconUrl);
                Log.e((String)KmlRenderer.LOG_TAG, (String)(string.length() != 0 ? "Image at this URL could not be found ".concat(string) : new String("Image at this URL could not be found ")));
            } else {
                KmlRenderer.this.mImagesCache.put((Object)this.mIconUrl, (Object)bitmap);
                if (KmlRenderer.this.mLayerVisible) {
                    KmlRenderer.this.addIconToMarkers(this.mIconUrl, KmlRenderer.this.mPlacemarks);
                    KmlRenderer.this.addContainerGroupIconsToMarkers(this.mIconUrl, KmlRenderer.this.mContainers);
                }
            }
        }
    }
}

