/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

import com.google.android.gms.maps.model.LatLng;
import java.util.List;

public class SphericalUtil {
    static final double EARTH_RADIUS = 6378137.0;

    private SphericalUtil() {
    }

    public static double computeHeading(LatLng from, LatLng to) {
        double fromLat = Math.toRadians(from.latitude);
        double fromLng = Math.toRadians(from.longitude);
        double toLat = Math.toRadians(to.latitude);
        double toLng = Math.toRadians(to.longitude);
        double dLng = toLng - fromLng;
        double heading = Math.atan2(Math.sin(dLng) * Math.cos(toLat), Math.cos(fromLat) * Math.sin(toLat) - Math.sin(fromLat) * Math.cos(toLat) * Math.cos(dLng));
        return SphericalUtil.wrap(Math.toDegrees(heading), -180, 180);
    }

    public static LatLng computeOffset(LatLng from, double distance, double heading) {
        heading = Math.toRadians(heading);
        double fromLat = Math.toRadians(from.latitude);
        double fromLng = Math.toRadians(from.longitude);
        double cosDistance = Math.cos(distance /= 6378137.0);
        double sinDistance = Math.sin(distance);
        double sinFromLat = Math.sin(fromLat);
        double cosFromLat = Math.cos(fromLat);
        double sinLat = cosDistance * sinFromLat + sinDistance * cosFromLat * Math.cos(heading);
        double dLng = Math.atan2(sinDistance * cosFromLat * Math.sin(heading), cosDistance - sinFromLat * sinLat);
        return new LatLng(Math.toDegrees(Math.asin(sinLat)), Math.toDegrees(fromLng + dLng));
    }

    public static LatLng computeOffsetOrigin(LatLng to, double distance, double heading) {
        double fromLatRadians;
        heading = Math.toRadians(heading);
        double n1 = Math.cos(distance /= 6378137.0);
        double n2 = Math.sin(distance) * Math.cos(heading);
        double n3 = Math.sin(distance) * Math.sin(heading);
        double n4 = Math.sin(Math.toRadians(to.latitude));
        double discriminant = n2 * n2 * n1 * n1 + n1 * n1 * n1 * n1 - n1 * n1 * n4 * n4;
        if (discriminant < 0.0) {
            return null;
        }
        double b = n2 * n4 + Math.sqrt(discriminant);
        double a = (n4 - n2 * (b /= n1 * n1 + n2 * n2)) / n1;
        if ((fromLatRadians = Math.atan2(a, b)) < -1.5707963267948966 || fromLatRadians > 1.5707963267948966) {
            b = n2 * n4 - Math.sqrt(discriminant);
            fromLatRadians = Math.atan2(a, b /= n1 * n1 + n2 * n2);
        }
        if (fromLatRadians < -1.5707963267948966 || fromLatRadians > 1.5707963267948966) {
            return null;
        }
        double fromLngRadians = Math.toRadians(to.longitude) - Math.atan2(n3, n1 * Math.cos(fromLatRadians) - n2 * Math.sin(fromLatRadians));
        return new LatLng(Math.toDegrees(fromLatRadians), Math.toDegrees(fromLngRadians));
    }

    public static LatLng interpolate(LatLng from, LatLng to, double fraction) {
        double fromLat = Math.toRadians(from.latitude);
        double fromLng = Math.toRadians(from.longitude);
        double toLat = Math.toRadians(to.latitude);
        double toLng = Math.toRadians(to.longitude);
        double cosFromLat = Math.cos(fromLat);
        double cosToLat = Math.cos(toLat);
        double angle = SphericalUtil.computeAngleBetween(from, to);
        double sinAngle = Math.sin(angle);
        if (sinAngle < 1.0E-6) {
            return from;
        }
        double a = Math.sin((1.0 - fraction) * angle) / sinAngle;
        double b = Math.sin(fraction * angle) / sinAngle;
        double x = a * cosFromLat * Math.cos(fromLng) + b * cosToLat * Math.cos(toLng);
        double y = a * cosFromLat * Math.sin(fromLng) + b * cosToLat * Math.sin(toLng);
        double z = a * Math.sin(fromLat) + b * Math.sin(toLat);
        double lat = Math.atan2(z, Math.sqrt(x * x + y * y));
        double lng = Math.atan2(y, x);
        return new LatLng(Math.toDegrees(lat), Math.toDegrees(lng));
    }

    static double computeAngleBetween(LatLng from, LatLng to) {
        double fromLat = Math.toRadians(from.latitude);
        double fromLng = Math.toRadians(from.longitude);
        double toLat = Math.toRadians(to.latitude);
        double toLng = Math.toRadians(to.longitude);
        double dLat = fromLat - toLat;
        double dLng = fromLng - toLng;
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.cos(fromLat) * Math.cos(toLat) * Math.pow(Math.sin(dLng / 2.0), 2.0)));
    }

    public static double computeDistanceBetween(LatLng from, LatLng to) {
        return SphericalUtil.computeAngleBetween(from, to) * 6378137.0;
    }

    public static double computeLength(List<LatLng> path) {
        double length = 0.0;
        int I = path.size() - 1;
        for (int i = 0; i < I; ++i) {
            length += SphericalUtil.computeDistanceBetween(path.get(i), path.get(i + 1));
        }
        return length;
    }

    public static double computeArea(List<LatLng> path) {
        return Math.abs(SphericalUtil.computeSignedArea(path));
    }

    public static double computeSignedArea(List<LatLng> loop) {
        LatLng origin = loop.get(0);
        double total = 0.0;
        int I = loop.size() - 1;
        for (int i = 1; i < I; ++i) {
            total += SphericalUtil.computeSignedTriangleArea(origin, loop.get(i), loop.get(i + 1));
        }
        return total * 6378137.0 * 6378137.0;
    }

    static double computeSignedTriangleArea(LatLng a, LatLng b, LatLng c) {
        return SphericalUtil.computeTriangleArea(a, b, c) * (double)SphericalUtil.isCCW(a, b, c);
    }

    static double computeTriangleArea(LatLng a, LatLng b, LatLng c) {
        LatLng[] points = new LatLng[]{a, b, c, a};
        double[] angles = new double[3];
        double s = 0.0;
        for (int i = 0; i < 3; ++i) {
            angles[i] = SphericalUtil.computeAngleBetween(points[i], points[i + 1]);
            s += angles[i];
        }
        double product = Math.tan((s /= 2.0) / 2.0);
        for (int i = 0; i < 3; ++i) {
            product *= Math.tan((s - angles[i]) / 2.0);
        }
        return 4.0 * Math.atan(Math.sqrt(Math.abs(product)));
    }

    static int isCCW(LatLng a, LatLng b, LatLng c) {
        LatLng[] points = new LatLng[]{a, b, c};
        double[][] pointsR3 = new double[3][];
        for (int i = 0; i < 3; ++i) {
            LatLng latLng = points[i];
            double lat = Math.toRadians(latLng.latitude);
            double lng = Math.toRadians(latLng.longitude);
            double[] r3 = new double[]{Math.cos(lat) * Math.cos(lng), Math.cos(lat) * Math.sin(lng), Math.sin(lat)};
            pointsR3[i] = r3;
        }
        double det = pointsR3[0][0] * pointsR3[1][1] * pointsR3[2][2] + pointsR3[1][0] * pointsR3[2][1] * pointsR3[0][2] + pointsR3[2][0] * pointsR3[0][1] * pointsR3[1][2] - pointsR3[0][0] * pointsR3[2][1] * pointsR3[1][2] - pointsR3[1][0] * pointsR3[0][1] * pointsR3[2][2] - pointsR3[2][0] * pointsR3[1][1] * pointsR3[0][2];
        return det > 0.0 ? 1 : -1;
    }

    static double wrap(double n, int min, int max) {
        return SphericalUtil.mod(n - (double)min, max - min) + (double)min;
    }

    static double mod(double x, int m) {
        return (x % (double)m + (double)m) % (double)m;
    }
}

