

package com.google.javascript.jscomp;

import java.util.function.Function;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_PassFactory extends PassFactory {

  private final String name;
  private final Function<CompilerOptions, Boolean> condition;
  private final boolean runInFixedPointLoop;
  private final Function<AbstractCompiler, ? extends CompilerPass> internalFactory;

  private AutoValue_PassFactory(
      String name,
      Function<CompilerOptions, Boolean> condition,
      boolean runInFixedPointLoop,
      Function<AbstractCompiler, ? extends CompilerPass> internalFactory) {
    this.name = name;
    this.condition = condition;
    this.runInFixedPointLoop = runInFixedPointLoop;
    this.internalFactory = internalFactory;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public Function<CompilerOptions, Boolean> getCondition() {
    return condition;
  }

  @Override
  public boolean isRunInFixedPointLoop() {
    return runInFixedPointLoop;
  }

  @Override
  Function<AbstractCompiler, ? extends CompilerPass> getInternalFactory() {
    return internalFactory;
  }

  @Override
  public String toString() {
    return "PassFactory{"
         + "name=" + name + ", "
         + "condition=" + condition + ", "
         + "runInFixedPointLoop=" + runInFixedPointLoop + ", "
         + "internalFactory=" + internalFactory
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PassFactory) {
      PassFactory that = (PassFactory) o;
      return (this.name.equals(that.getName()))
           && (this.condition.equals(that.getCondition()))
           && (this.runInFixedPointLoop == that.isRunInFixedPointLoop())
           && (this.internalFactory.equals(that.getInternalFactory()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= condition.hashCode();
    h$ *= 1000003;
    h$ ^= runInFixedPointLoop ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= internalFactory.hashCode();
    return h$;
  }

  @Override
  public PassFactory.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends PassFactory.Builder {
    private String name;
    private Function<CompilerOptions, Boolean> condition;
    private Boolean runInFixedPointLoop;
    private Function<AbstractCompiler, ? extends CompilerPass> internalFactory;
    Builder() {
    }
    private Builder(PassFactory source) {
      this.name = source.getName();
      this.condition = source.getCondition();
      this.runInFixedPointLoop = source.isRunInFixedPointLoop();
      this.internalFactory = source.getInternalFactory();
    }
    @Override
    public PassFactory.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public PassFactory.Builder setCondition(Function<CompilerOptions, Boolean> condition) {
      if (condition == null) {
        throw new NullPointerException("Null condition");
      }
      this.condition = condition;
      return this;
    }
    @Override
    public PassFactory.Builder setRunInFixedPointLoop(boolean runInFixedPointLoop) {
      this.runInFixedPointLoop = runInFixedPointLoop;
      return this;
    }
    @Override
    public PassFactory.Builder setInternalFactory(Function<AbstractCompiler, ? extends CompilerPass> internalFactory) {
      if (internalFactory == null) {
        throw new NullPointerException("Null internalFactory");
      }
      this.internalFactory = internalFactory;
      return this;
    }
    @Override
    PassFactory autoBuild() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.condition == null) {
        missing += " condition";
      }
      if (this.runInFixedPointLoop == null) {
        missing += " runInFixedPointLoop";
      }
      if (this.internalFactory == null) {
        missing += " internalFactory";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PassFactory(
          this.name,
          this.condition,
          this.runInFixedPointLoop,
          this.internalFactory);
    }
  }

}
