

package com.google.javascript.jscomp.serialization;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.rhino.Node;
import java.util.function.Supplier;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_TypedAstDeserializer_DeserializedAst extends TypedAstDeserializer.DeserializedAst {

  private final ImmutableMap<String, SourceFile> allFiles;
  private final ImmutableMap<SourceFile, Supplier<Node>> filesystem;
  private final ColorRegistry colorRegistry;
  private final ImmutableSet<String> externProperties;

  AutoValue_TypedAstDeserializer_DeserializedAst(
      ImmutableMap<String, SourceFile> allFiles,
      ImmutableMap<SourceFile, Supplier<Node>> filesystem,
      @Nullable ColorRegistry colorRegistry,
      @Nullable ImmutableSet<String> externProperties) {
    if (allFiles == null) {
      throw new NullPointerException("Null allFiles");
    }
    this.allFiles = allFiles;
    if (filesystem == null) {
      throw new NullPointerException("Null filesystem");
    }
    this.filesystem = filesystem;
    this.colorRegistry = colorRegistry;
    this.externProperties = externProperties;
  }

  @Override
  public ImmutableMap<String, SourceFile> getAllFiles() {
    return allFiles;
  }

  @Override
  public ImmutableMap<SourceFile, Supplier<Node>> getFilesystem() {
    return filesystem;
  }

  @Nullable
  @Override
  public ColorRegistry getColorRegistry() {
    return colorRegistry;
  }

  @Nullable
  @Override
  public ImmutableSet<String> getExternProperties() {
    return externProperties;
  }

  @Override
  public String toString() {
    return "DeserializedAst{"
         + "allFiles=" + allFiles + ", "
         + "filesystem=" + filesystem + ", "
         + "colorRegistry=" + colorRegistry + ", "
         + "externProperties=" + externProperties
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TypedAstDeserializer.DeserializedAst) {
      TypedAstDeserializer.DeserializedAst that = (TypedAstDeserializer.DeserializedAst) o;
      return (this.allFiles.equals(that.getAllFiles()))
           && (this.filesystem.equals(that.getFilesystem()))
           && ((this.colorRegistry == null) ? (that.getColorRegistry() == null) : this.colorRegistry.equals(that.getColorRegistry()))
           && ((this.externProperties == null) ? (that.getExternProperties() == null) : this.externProperties.equals(that.getExternProperties()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= allFiles.hashCode();
    h$ *= 1000003;
    h$ ^= filesystem.hashCode();
    h$ *= 1000003;
    h$ ^= (colorRegistry == null) ? 0 : colorRegistry.hashCode();
    h$ *= 1000003;
    h$ ^= (externProperties == null) ? 0 : externProperties.hashCode();
    return h$;
  }

}
