/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.AbstractIterator;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.PropertyMap;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public abstract class ObjectType
extends JSType
implements Serializable {
    private boolean visited;
    private JSDocInfo docInfo = null;
    private boolean unknown = true;

    ObjectType(JSTypeRegistry registry) {
        super(registry);
    }

    ObjectType(JSTypeRegistry registry, TemplateTypeMap templateTypeMap) {
        super(registry, templateTypeMap);
    }

    PropertyMap getPropertyMap() {
        return PropertyMap.immutableEmptyMap();
    }

    public Property getSlot(String name) {
        Property.OwnedProperty property = this.getPropertyMap().findClosest(name);
        return property == null ? null : property.getValue();
    }

    public final Property getOwnSlot(String name) {
        return this.getPropertyMap().getOwnProperty(name);
    }

    public JSType getTypeOfThis() {
        return null;
    }

    public ImmutableList<JSType> getTemplateTypes() {
        return null;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.docInfo;
    }

    public void setJSDocInfo(JSDocInfo info) {
        this.docInfo = info;
    }

    final boolean detectImplicitPrototypeCycle() {
        ObjectType p;
        this.visited = true;
        for (p = this.getImplicitPrototype(); p != null; p = p.getImplicitPrototype()) {
            if (p.visited) {
                return true;
            }
            p.visited = true;
        }
        p = this;
        do {
            p.visited = false;
        } while ((p = p.getImplicitPrototype()) != null);
        return false;
    }

    final boolean detectInheritanceCycle() {
        if (this.detectImplicitPrototypeCycle() || Iterables.contains(this.getCtorImplementedInterfaces(), this)) {
            return true;
        }
        FunctionType fnType = this.getConstructor();
        return fnType != null && fnType.checkExtendsLoop() != null;
    }

    @Nullable
    public abstract String getReferenceName();

    public final boolean hasReferenceName() {
        return this.getReferenceName() != null;
    }

    @Nullable
    public final String getNormalizedReferenceName() {
        int start;
        String name = this.getReferenceName();
        if (name != null && (start = name.indexOf(40)) != -1) {
            int end = name.lastIndexOf(41);
            String prefix = name.substring(0, start);
            return end + 1 % name.length() == 0 ? prefix : prefix + name.substring(end + 1);
        }
        return name;
    }

    @Override
    public String getDisplayName() {
        return this.getNormalizedReferenceName();
    }

    public static String createDelegateSuffix(String suffix) {
        return "(" + suffix + ")";
    }

    public final ObjectType getRawType() {
        TemplatizedType t = this.toMaybeTemplatizedType();
        return t == null ? this : t.getReferencedType();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isUnknownType() || that.isSubtypeOf(this.getNativeType(JSTypeNative.OBJECT_TYPE)) || that.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_TYPE)) || that.isSubtypeOf(this.getNativeType(JSTypeNative.STRING_TYPE)) || that.isSubtypeOf(this.getNativeType(JSTypeNative.BOOLEAN_TYPE)) || that.isSubtypeOf(this.getNativeType(JSTypeNative.SYMBOL_TYPE)) || that.isSubtypeOf(this.getNativeType(JSTypeNative.BIGINT_TYPE))) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    public abstract FunctionType getConstructor();

    public FunctionType getSuperClassConstructor() {
        ObjectType iproto = this.getImplicitPrototype();
        if (iproto == null) {
            return null;
        }
        return (iproto = iproto.getImplicitPrototype()) == null ? null : iproto.getConstructor();
    }

    public final ObjectType getTopMostDefiningType(String propertyName) {
        Property.OwnedProperty property = this.getPropertyMap().findTopMost(propertyName);
        return property == null ? null : property.getOwner();
    }

    public final ObjectType getClosestDefiningType(String propertyName) {
        Property.OwnedProperty property = this.getPropertyMap().findClosest(propertyName);
        return property == null ? null : property.getOwner();
    }

    public final Property.OwnedProperty findClosestDefinition(String propertyName) {
        return this.getPropertyMap().findClosest(propertyName);
    }

    public abstract ObjectType getImplicitPrototype();

    public final Iterable<ObjectType> getImplicitPrototypeChain() {
        final ObjectType self = this;
        return () -> new AbstractIterator<ObjectType>(){
            private ObjectType next;
            {
                this.next = self;
            }

            @Override
            public ObjectType computeNext() {
                this.next = this.next.getImplicitPrototype();
                return this.next != null ? this.next : (ObjectType)this.endOfData();
            }
        };
    }

    public final boolean defineDeclaredProperty(String propertyName, JSType type, Node propertyNode) {
        boolean result = this.defineProperty(propertyName, type, false, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    public final boolean defineSynthesizedProperty(String propertyName, JSType type, Node propertyNode) {
        return this.defineProperty(propertyName, type, false, propertyNode);
    }

    public final boolean defineInferredProperty(String propertyName, JSType type, Node propertyNode) {
        if (this.hasProperty(propertyName)) {
            if (this.isPropertyTypeDeclared(propertyName)) {
                return true;
            }
            JSType originalType = Preconditions.checkNotNull(this.getPropertyType(propertyName));
            type = originalType.getLeastSupertype(type);
        }
        boolean result = this.defineProperty(propertyName, type, true, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    abstract boolean defineProperty(String var1, JSType var2, boolean var3, Node var4);

    public boolean removeProperty(String propertyName) {
        return false;
    }

    public final Node getPropertyNode(String propertyName) {
        Property p = this.getSlot(propertyName);
        return p == null ? null : p.getNode();
    }

    public final Node getPropertyDefSite(String propertyName) {
        return this.getPropertyNode(propertyName);
    }

    public final JSDocInfo getPropertyJSDocInfo(String propertyName) {
        Property p = this.getSlot(propertyName);
        return p == null ? null : p.getJSDocInfo();
    }

    public final JSDocInfo getOwnPropertyJSDocInfo(String propertyName) {
        Property p = this.getOwnSlot(propertyName);
        return p == null ? null : p.getJSDocInfo();
    }

    public final Node getOwnPropertyDefSite(String propertyName) {
        Property p = this.getOwnSlot(propertyName);
        return p == null ? null : p.getNode();
    }

    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
    }

    public void setPropertyNode(String propertyName, Node defSite) {
    }

    @Override
    protected JSType findPropertyTypeWithoutConsideringTemplateTypes(String propertyName) {
        return this.hasProperty(propertyName) ? this.getPropertyType(propertyName) : null;
    }

    public JSType getPropertyType(String propertyName) {
        Property slot = this.getSlot(propertyName);
        if (slot == null) {
            if (this.isNoResolvedType() || this.isCheckedUnknownType()) {
                return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
            }
            if (this.isEmptyType()) {
                return this.getNativeType(JSTypeNative.NO_TYPE);
            }
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return slot.getType();
    }

    @Override
    public JSType.HasPropertyKind getPropertyKind(String propertyName, boolean autobox) {
        return JSType.HasPropertyKind.of(this.isEmptyType() || this.isUnknownType() || this.getSlot(propertyName) != null);
    }

    public final JSType.HasPropertyKind getOwnPropertyKind(String propertyName) {
        return this.getOwnSlot(propertyName) != null ? JSType.HasPropertyKind.KNOWN_PRESENT : JSType.HasPropertyKind.ABSENT;
    }

    public final boolean hasOwnProperty(String propertyName) {
        return !this.getOwnPropertyKind(propertyName).equals((Object)JSType.HasPropertyKind.ABSENT);
    }

    public Set<String> getOwnPropertyNames() {
        return this.getPropertyMap().getOwnPropertyNames();
    }

    public final boolean isPropertyTypeInferred(String propertyName) {
        Property slot = this.getSlot(propertyName);
        return slot == null ? false : slot.isTypeInferred();
    }

    public final boolean isPropertyTypeDeclared(String propertyName) {
        Property slot = this.getSlot(propertyName);
        return slot == null ? false : !slot.isTypeInferred();
    }

    @Override
    public boolean isStructuralType() {
        FunctionType constructor = this.getConstructor();
        return constructor != null && constructor.isStructuralInterface();
    }

    final boolean hasOwnDeclaredProperty(String name) {
        return this.hasOwnProperty(name) && this.isPropertyTypeDeclared(name);
    }

    public final boolean isPropertyInExterns(String propertyName) {
        Property p = this.getSlot(propertyName);
        return p == null ? false : p.isFromExterns();
    }

    public final int getPropertiesCount() {
        return this.getPropertyMap().getPropertiesCount();
    }

    public final ImmutableSortedSet<String> getPropertyNames() {
        return this.getPropertyMap().keySet();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseObjectType(this, that);
    }

    final boolean isImplicitPrototypeOf(ObjectType other) {
        ObjectType unwrappedThis = ObjectType.deeplyUnwrap(this);
        other = ObjectType.deeplyUnwrap(other);
        while (other != null) {
            if (JSType.areIdentical(unwrappedThis, other)) {
                return true;
            }
            other = ObjectType.deeplyUnwrap(other.getImplicitPrototype());
        }
        return false;
    }

    static ObjectType deeplyUnwrap(ObjectType original) {
        ObjectType current = original;
        while (current instanceof ProxyObjectType) {
            if (current.isTemplatizedType()) {
                current = current.toMaybeTemplatizedType().getReferencedType();
                continue;
            }
            if (current.isNamedType()) {
                if (!current.isSuccessfullyResolved()) break;
                current = current.toMaybeNamedType().getReferencedObjTypeInternal();
                continue;
            }
            current = ((ProxyObjectType)current).getReferencedObjTypeInternal();
        }
        return current;
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    public boolean isUnknownType() {
        if (this.unknown) {
            ObjectType implicitProto = this.getImplicitPrototype();
            if (implicitProto == null || implicitProto.isNativeObjectType()) {
                this.unknown = false;
                for (ObjectType interfaceType : this.getCtorExtendedInterfaces()) {
                    if (!interfaceType.isUnknownType()) continue;
                    this.unknown = true;
                    break;
                }
            } else {
                this.unknown = implicitProto.isUnknownType();
            }
        }
        return this.unknown;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    public boolean hasCachedValues() {
        return !this.unknown;
    }

    public void clearCachedValues() {
        this.unknown = true;
    }

    @Override
    public boolean isNativeObjectType() {
        return false;
    }

    public static ObjectType cast(JSType type) {
        return type == null ? null : type.toObjectType();
    }

    @Override
    public final boolean isFunctionPrototypeType() {
        return this.getOwnerFunction() != null;
    }

    public FunctionType getOwnerFunction() {
        return null;
    }

    void setOwnerFunction(FunctionType type) {
    }

    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return ImmutableSet.of();
    }

    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return ImmutableSet.of();
    }

    public Map<String, JSType> getPropertyTypeMap() {
        ImmutableMap.Builder<String, JSType> propTypeMap = ImmutableMap.builder();
        for (String name : this.getPropertyNames()) {
            propTypeMap.put(name, this.getPropertyType(name));
        }
        return propTypeMap.build();
    }

    public JSType getEnumeratedTypeOfEnumObject() {
        return null;
    }
}

