/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;

final class EqualityChecker {
    private static final int POTENTIALLY_CYCLIC_RECURSION_DEPTH = 20;
    private EqMethod eqMethod;
    private HashMap<CacheKey, JSType.MatchStatus> eqCache;
    private int recursionDepth = 0;
    private boolean hasRun = false;

    EqualityChecker setEqMethod(EqMethod x) {
        this.checkHasNotRun();
        Preconditions.checkState(this.eqMethod == null);
        this.eqMethod = x;
        return this;
    }

    private void checkHasNotRun() {
        Preconditions.checkState(!this.hasRun);
    }

    EqualityChecker() {
    }

    boolean check(JSType left, JSType right) {
        this.checkHasNotRun();
        this.hasRun = true;
        return this.areEqualCaching(left, right);
    }

    boolean checkParameters(ArrowType left, ArrowType right) {
        this.checkHasNotRun();
        this.hasRun = true;
        return JSType.areIdentical(left, right) || this.areArrowParameterEqual(left, right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areEqualCaching(JSType left, JSType right) {
        if (this.recursionDepth > 20 && this.eqCache == null) {
            this.eqCache = new HashMap();
        }
        if (this.eqCache == null) {
            try {
                ++this.recursionDepth;
                boolean bl = this.areEqualInternal(left, right);
                return bl;
            }
            finally {
                --this.recursionDepth;
            }
        }
        CacheKey key = new CacheKey(left, right);
        JSType.MatchStatus cached = this.eqCache.putIfAbsent(key, JSType.MatchStatus.PROCESSING);
        if (cached == null) {
            boolean result = this.areEqualInternal(left, right);
            this.eqCache.put(key, JSType.MatchStatus.valueOf(result));
            return result;
        }
        if (cached == JSType.MatchStatus.PROCESSING) {
            this.eqCache.put(key, JSType.MatchStatus.MATCH);
            return true;
        }
        return cached.subtypeValue();
    }

    private boolean areEqualInternal(JSType left, JSType right) {
        ImmutableList<JSType> rightAlts;
        if (JSType.areIdentical(left, right)) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.isNoResolvedType() && right.isNoResolvedType()) {
            if (left.isNamedType() && right.isNamedType()) {
                return Objects.equals(left.toMaybeNamedType().getReferenceName(), right.toMaybeNamedType().getReferenceName());
            }
            return true;
        }
        boolean leftUnknown = left.isUnknownType();
        boolean rightUnknown = right.isUnknownType();
        if (leftUnknown || rightUnknown) {
            if (this.eqMethod == EqMethod.DATA_FLOW) {
                return leftUnknown && rightUnknown;
            }
            if (leftUnknown && rightUnknown && left.isNominalType() ^ right.isNominalType()) {
                return false;
            }
        }
        if (left.isUnionType() && right.isUnionType()) {
            return this.areUnionEqual(left.toMaybeUnionType(), right.toMaybeUnionType());
        }
        if (left.isUnionType()) {
            ImmutableList<JSType> leftAlts = left.toMaybeUnionType().getAlternates();
            if (leftAlts.size() == 1) {
                return this.areEqualInternal((JSType)leftAlts.get(0), right);
            }
        } else if (right.isUnionType() && (rightAlts = right.toMaybeUnionType().getAlternates()).size() == 1) {
            return this.areEqualInternal(left, (JSType)rightAlts.get(0));
        }
        if (left.isFunctionType() && right.isFunctionType()) {
            return this.areFunctionEqual(left.toMaybeFunctionType(), right.toMaybeFunctionType());
        }
        if (left instanceof ArrowType && right instanceof ArrowType) {
            return this.areArrowEqual((ArrowType)left, (ArrowType)right);
        }
        if (!this.areTypeMapEqual(left.getTemplateTypeMap(), right.getTemplateTypeMap())) {
            return false;
        }
        if (left.isRecordType() && right.isRecordType()) {
            return this.areRecordEqual(left.toMaybeRecordType(), right.toMaybeRecordType());
        }
        if (left.isNominalType() && right.isNominalType()) {
            ObjectType leftUnwrapped = EqualityChecker.unwrapNominalTypeProxies(left.toObjectType());
            ObjectType rightUnwrapped = EqualityChecker.unwrapNominalTypeProxies(right.toObjectType());
            Preconditions.checkState(leftUnwrapped.isNominalType() && rightUnwrapped.isNominalType());
            if (left.isResolved() && right.isResolved()) {
                return JSType.areIdentical(leftUnwrapped, rightUnwrapped);
            }
            String nameOfleft = Preconditions.checkNotNull(leftUnwrapped.getReferenceName());
            String nameOfright = Preconditions.checkNotNull(rightUnwrapped.getReferenceName());
            return Objects.equals(nameOfleft, nameOfright);
        }
        if (left instanceof ProxyObjectType && !(left instanceof TemplateType)) {
            return this.areEqualCaching(((ProxyObjectType)left).getReferencedTypeInternal(), right);
        }
        if (right instanceof ProxyObjectType && !(right instanceof TemplateType)) {
            return this.areEqualCaching(left, ((ProxyObjectType)right).getReferencedTypeInternal());
        }
        return false;
    }

    private boolean areUnionEqual(UnionType left, UnionType right) {
        ImmutableList<JSType> leftAlternates = left.getAlternates();
        ImmutableList<JSType> rightAlternates = right.getAlternates();
        if (this.eqMethod == EqMethod.IDENTITY && leftAlternates.size() != rightAlternates.size()) {
            return false;
        }
        block0: for (int i = 0; i < rightAlternates.size(); ++i) {
            JSType rightAlt = (JSType)rightAlternates.get(i);
            for (int k = 0; k < leftAlternates.size(); ++k) {
                JSType leftAlt = (JSType)leftAlternates.get(k);
                if (this.areEqualCaching(leftAlt, rightAlt)) continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean areFunctionEqual(FunctionType left, FunctionType right) {
        if (JSType.areIdentical(left, right)) {
            return true;
        }
        if (!Objects.equals((Object)left.getKind(), (Object)right.getKind())) {
            return false;
        }
        switch (left.getKind()) {
            case CONSTRUCTOR: 
            case INTERFACE: {
                return false;
            }
            case ORDINARY: {
                return this.areEqualCaching(left.getTypeOfThis(), right.getTypeOfThis()) && this.areEqualCaching(left.getInternalArrowType(), right.getInternalArrowType());
            }
        }
        throw new AssertionError();
    }

    private boolean areArrowEqual(ArrowType left, ArrowType right) {
        return this.areEqualCaching(left.getReturnType(), right.getReturnType()) && this.areArrowParameterEqual(left, right);
    }

    private boolean areArrowParameterEqual(ArrowType left, ArrowType right) {
        if (left.getParameterList().size() != right.getParameterList().size()) {
            return false;
        }
        for (int i = 0; i < left.getParameterList().size(); ++i) {
            FunctionType.Parameter leftParam = (FunctionType.Parameter)left.getParameterList().get(i);
            FunctionType.Parameter rightParam = (FunctionType.Parameter)right.getParameterList().get(i);
            JSType leftParamType = leftParam.getJSType();
            JSType rightParamType = rightParam.getJSType();
            if (leftParamType != null ? rightParamType != null && !this.areEqualCaching(leftParamType, rightParamType) : rightParamType != null) {
                return false;
            }
            if (leftParam.isOptional() != rightParam.isOptional()) {
                return false;
            }
            if (leftParam.isVariadic() == rightParam.isVariadic()) continue;
            return false;
        }
        return true;
    }

    private boolean areRecordEqual(RecordType left, RecordType right) {
        Set<String> leftKeys = left.getOwnPropertyNames();
        Set<String> rightKeys = right.getOwnPropertyNames();
        if (!rightKeys.equals(leftKeys)) {
            return false;
        }
        for (String key : leftKeys) {
            if (this.areEqualCaching(left.getPropertyType(key), right.getPropertyType(key))) continue;
            return false;
        }
        return true;
    }

    private boolean areTypeMapEqual(TemplateTypeMap left, TemplateTypeMap right) {
        ImmutableList<TemplateType> leftKeys = left.getTemplateKeys();
        ImmutableList<TemplateType> rightKeys = right.getTemplateKeys();
        block0: for (int i = 0; i < leftKeys.size(); ++i) {
            TemplateType leftKey = (TemplateType)leftKeys.get(i);
            JSType leftType = left.getResolvedTemplateType(leftKey);
            for (int j = 0; j < rightKeys.size(); ++j) {
                TemplateType rightKey = (TemplateType)rightKeys.get(j);
                JSType rightType = right.getResolvedTemplateType(rightKey);
                if (JSType.areIdentical(leftKey, rightKey) && this.areEqualCaching(leftType, rightType)) continue block0;
            }
            return false;
        }
        return true;
    }

    private static ObjectType unwrapNominalTypeProxies(ObjectType objType) {
        if (!objType.isResolved() || !objType.isNamedType() && !objType.isTemplatizedType()) {
            return objType;
        }
        ObjectType internal = objType.isNamedType() ? objType.toMaybeNamedType().getReferencedObjTypeInternal() : objType.toMaybeTemplatizedType().getReferencedObjTypeInternal();
        return EqualityChecker.unwrapNominalTypeProxies(internal);
    }

    private static final class CacheKey {
        private final JSType left;
        private final JSType right;
        private final int hashCode;

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            CacheKey right = (CacheKey)other;
            if (this == other) {
                return true;
            }
            return this.left == right.left & this.right == right.right | this.left == right.right & this.right == right.left;
        }

        CacheKey(JSType left, JSType right) {
            this.left = left;
            this.right = right;
            this.hashCode = System.identityHashCode(left) ^ System.identityHashCode(right);
        }
    }

    static enum EqMethod {
        IDENTITY,
        DATA_FLOW;

    }
}

