/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckMissingAndExtraRequires;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ArrayListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ListMultimap;
import com.google.javascript.jscomp.lint.CheckExtraRequires;
import com.google.javascript.refactoring.ErrorToFixMapper;
import com.google.javascript.refactoring.SuggestedFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class FixingErrorManager
extends BasicErrorManager {
    private ErrorToFixMapper fixer;
    private final HashMap<JSError, SuggestedFix> sureFixes = new HashMap();
    private final ListMultimap<JSError, SuggestedFix> multiFixes = ArrayListMultimap.create();
    private final ImmutableSet<DiagnosticType> unfixableErrors;

    public FixingErrorManager() {
        this(ImmutableSet.of());
    }

    public FixingErrorManager(ImmutableSet<DiagnosticType> unfixableErrors) {
        this.unfixableErrors = unfixableErrors;
    }

    public void setCompiler(AbstractCompiler compiler) {
        this.fixer = new ErrorToFixMapper(compiler);
    }

    @Override
    public void report(CheckLevel level, JSError error) {
        super.report(level, error);
        if (!this.unfixableErrors.contains(error.getType())) {
            ImmutableList<SuggestedFix> fixes = this.fixer.getFixesForJsError(error);
            if (fixes.size() == 1) {
                this.sureFixes.put(error, (SuggestedFix)fixes.get(0));
            } else {
                this.multiFixes.putAll(error, fixes);
            }
        }
    }

    private boolean containsFixableShorthandModuleWarning() {
        for (JSError error : this.sureFixes.keySet()) {
            if (!error.getType().equals(ClosureCheckModule.REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME)) continue;
            return true;
        }
        for (JSError error : this.multiFixes.keySet()) {
            if (!error.getType().equals(ClosureCheckModule.REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME)) continue;
            return true;
        }
        return false;
    }

    public List<SuggestedFix> getFixesForJsError(JSError error) {
        if (this.sureFixes.containsKey(error)) {
            return ImmutableList.of(this.sureFixes.get(error));
        }
        return this.multiFixes.get((Object)error);
    }

    private Collection<SuggestedFix> getFixes(FixTypes fixTypes) {
        boolean containsFixableShorthandModuleWarning = this.containsFixableShorthandModuleWarning();
        ArrayList<SuggestedFix> fixes = new ArrayList<SuggestedFix>();
        for (JSError error : this.getErrors()) {
            if (containsFixableShorthandModuleWarning && (error.getType().equals(CheckExtraRequires.EXTRA_REQUIRE_WARNING) || error.getType().equals(CheckMissingAndExtraRequires.MISSING_REQUIRE_STRICT_WARNING) || error.getType().equals(CheckMissingAndExtraRequires.MISSING_REQUIRE_WARNING))) continue;
            if (fixTypes == FixTypes.ONE_FIX && this.sureFixes.containsKey(error)) {
                fixes.add(this.sureFixes.get(error));
                continue;
            }
            if (fixTypes != FixTypes.ONE_FIX_AND_MULTI_FIXES) continue;
            fixes.addAll(this.getFixesForJsError(error));
        }
        for (JSError warning : this.getWarnings()) {
            if (warning.getType().equals(CheckExtraRequires.EXTRA_REQUIRE_WARNING) && containsFixableShorthandModuleWarning) continue;
            if (fixTypes == FixTypes.ONE_FIX && this.sureFixes.containsKey(warning)) {
                fixes.add(this.sureFixes.get(warning));
                continue;
            }
            if (fixTypes != FixTypes.ONE_FIX_AND_MULTI_FIXES) continue;
            fixes.addAll(this.getFixesForJsError(warning));
        }
        return fixes;
    }

    public Collection<SuggestedFix> getSureFixes() {
        return this.getFixes(FixTypes.ONE_FIX);
    }

    public Collection<SuggestedFix> getAllFixes() {
        return this.getFixes(FixTypes.ONE_FIX_AND_MULTI_FIXES);
    }

    @Override
    public void printSummary() {
    }

    @Override
    public void println(CheckLevel level, JSError error) {
    }

    private static enum FixTypes {
        ONE_FIX,
        ONE_FIX_AND_MULTI_FIXES;

    }
}

