/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Ascii;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.StaticSourceFile;

public final class TypeTransformationParser {
    private final String typeTransformationString;
    private Node typeTransformationAst;
    private final StaticSourceFile sourceFile;
    private final ErrorReporter errorReporter;
    private final int templateLineno;
    private final int templateCharno;
    private static final int VAR_ARGS = Integer.MAX_VALUE;

    public TypeTransformationParser(String typeTransformationString, StaticSourceFile sourceFile, ErrorReporter errorReporter, int templateLineno, int templateCharno) {
        this.typeTransformationString = typeTransformationString;
        this.sourceFile = sourceFile;
        this.errorReporter = errorReporter;
        this.templateLineno = templateLineno;
        this.templateCharno = templateCharno;
    }

    public Node getTypeTransformationAst() {
        return this.typeTransformationAst;
    }

    private void addNewWarning(String messageId, String messageArg) {
        this.errorReporter.warning("Bad type annotation. " + SimpleErrorReporter.getMessage1(messageId, messageArg), this.sourceFile.getName(), this.templateLineno, this.templateCharno);
    }

    private Keywords nameToKeyword(String s) {
        return Keywords.valueOf(Ascii.toUpperCase(s));
    }

    private boolean isValidKeyword(String name) {
        for (Keywords k : Keywords.values()) {
            if (!k.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isOperationKind(String name, OperationKind kind) {
        return this.isValidKeyword(name) && this.nameToKeyword((String)name).kind == kind;
    }

    private boolean isValidStringPredicate(String name) {
        return this.isOperationKind(name, OperationKind.STRING_PREDICATE);
    }

    private boolean isValidTypePredicate(String name) {
        return this.isOperationKind(name, OperationKind.TYPE_PREDICATE);
    }

    private boolean isValidTypevarPredicate(String name) {
        return this.isOperationKind(name, OperationKind.TYPEVAR_PREDICATE);
    }

    private boolean isBooleanOperation(Node n) {
        return n.isAnd() || n.isOr() || n.isNot();
    }

    private boolean isValidPredicate(String name) {
        return this.isValidStringPredicate(name) || this.isValidTypePredicate(name) || this.isValidTypevarPredicate(name);
    }

    private int getFunctionParamCount(Node n) {
        Preconditions.checkArgument(n.isFunction(), "Expected a function node, found %s", (Object)n);
        return n.getSecondChild().getChildCount();
    }

    private Node getFunctionBody(Node n) {
        Preconditions.checkArgument(n.isFunction(), "Expected a function node, found %s", (Object)n);
        return n.getChildAtIndex(2);
    }

    private String getCallName(Node n) {
        Preconditions.checkArgument(n.isCall(), "Expected a call node, found %s", (Object)n);
        return n.getFirstChild().getString();
    }

    private Node getCallArgument(Node n, int i) {
        Preconditions.checkArgument(n.isCall(), "Expected a call node, found %s", (Object)n);
        return n.getChildAtIndex(i + 1);
    }

    private int getCallParamCount(Node n) {
        Preconditions.checkArgument(n.isCall(), "Expected a call node, found %s", (Object)n);
        return n.getChildCount() - 1;
    }

    private boolean isTypeVar(Node n) {
        return n.isName();
    }

    private boolean isTypeName(Node n) {
        return n.isString();
    }

    private boolean isOperation(Node n) {
        return n.isCall();
    }

    private boolean isValidExpression(Node e) {
        return this.isTypeVar(e) || this.isTypeName(e) || this.isOperation(e);
    }

    private void warnInvalid(String msg) {
        this.addNewWarning("msg.jsdoc.typetransformation.invalid", msg);
    }

    private void warnInvalidExpression(String msg) {
        this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", msg);
    }

    private void warnMissingParam(String msg) {
        this.addNewWarning("msg.jsdoc.typetransformation.missing.param", msg);
    }

    private void warnExtraParam(String msg) {
        this.addNewWarning("msg.jsdoc.typetransformation.extra.param", msg);
    }

    private void warnInvalidInside(String msg) {
        this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", msg);
    }

    private boolean checkParameterCount(Node expr, Keywords keyword) {
        int paramCount = this.getCallParamCount(expr);
        if (paramCount < keyword.minParamCount) {
            this.warnMissingParam(keyword.name);
            return false;
        }
        if (paramCount > keyword.maxParamCount) {
            this.warnExtraParam(keyword.name);
            return false;
        }
        return true;
    }

    public boolean parseTypeTransformation() {
        Config config = Config.builder().setLanguageMode(Config.LanguageMode.ECMASCRIPT6).setStrictMode(Config.StrictMode.SLOPPY).build();
        ParserRunner.ParseResult result = ParserRunner.parse(this.sourceFile, this.typeTransformationString, config, this.errorReporter);
        Node ast = result.ast;
        if (!(ast != null && ast.isScript() && ast.hasChildren() && ast.getFirstChild().isExprResult())) {
            this.warnInvalidExpression("type transformation");
            return false;
        }
        Node expr = ast.getFirstFirstChild();
        if (!this.validTypeTransformationExpression(expr)) {
            return false;
        }
        this.fixLineNumbers(expr);
        this.typeTransformationAst = expr;
        return true;
    }

    private void fixLineNumbers(Node expr) {
        expr.setLineno(expr.getLineno() + this.templateLineno);
        for (Node child : expr.children()) {
            this.fixLineNumbers(child);
        }
    }

    private boolean validTemplateTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.TYPE)) {
            return false;
        }
        int paramCount = this.getCallParamCount(expr);
        Node firstParam = this.getCallArgument(expr, 0);
        if (!this.isTypeVar(firstParam) && !this.isTypeName(firstParam)) {
            this.warnInvalid("type name or type variable");
            this.warnInvalidInside("template type operation");
            return false;
        }
        for (int i = 1; i < paramCount; ++i) {
            if (this.validTypeTransformationExpression(this.getCallArgument(expr, i))) continue;
            this.warnInvalidInside("template type operation");
            return false;
        }
        return true;
    }

    private boolean validUnionTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.UNION)) {
            return false;
        }
        int paramCount = this.getCallParamCount(expr);
        for (int i = 0; i < paramCount; ++i) {
            if (this.validTypeTransformationExpression(this.getCallArgument(expr, i))) continue;
            this.warnInvalidInside("union type");
            return false;
        }
        return true;
    }

    private boolean validNoneTypeExpression(Node expr) {
        return this.checkParameterCount(expr, Keywords.NONE);
    }

    private boolean validAllTypeExpression(Node expr) {
        return this.checkParameterCount(expr, Keywords.ALL);
    }

    private boolean validUnknownTypeExpression(Node expr) {
        return this.checkParameterCount(expr, Keywords.UNKNOWN);
    }

    private boolean validRawTypeOfTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.RAWTYPEOF)) {
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside(Keywords.RAWTYPEOF.name);
            return false;
        }
        return true;
    }

    private boolean validTemplateTypeOfExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.TEMPLATETYPEOF)) {
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside(Keywords.TEMPLATETYPEOF.name);
            return false;
        }
        if (!this.getCallArgument(expr, 1).isNumber()) {
            this.warnInvalid("index");
            this.warnInvalidInside(Keywords.TEMPLATETYPEOF.name);
            return false;
        }
        double index = this.getCallArgument(expr, 1).getDouble();
        if (index < 0.0 || index % 1.0 != 0.0) {
            this.warnInvalid("index");
            this.warnInvalidInside(Keywords.TEMPLATETYPEOF.name);
            return false;
        }
        return true;
    }

    private boolean validRecordParam(Node expr) {
        if (expr.isObjectLit()) {
            for (Node prop : expr.children()) {
                if (prop.isShorthandProperty()) {
                    this.warnInvalid("property, missing type");
                    return false;
                }
                if (this.validTypeTransformationExpression(prop.getFirstChild())) continue;
                return false;
            }
        } else if (!this.validTypeTransformationExpression(expr)) {
            return false;
        }
        return true;
    }

    private boolean validRecordTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.RECORD)) {
            return false;
        }
        for (int i = 0; i < this.getCallParamCount(expr); ++i) {
            if (this.validRecordParam(this.getCallArgument(expr, i))) continue;
            this.warnInvalidInside(Keywords.RECORD.name);
            return false;
        }
        return true;
    }

    private boolean validNativeTypeExpr(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.TYPEEXPR)) {
            return false;
        }
        Node typeString = this.getCallArgument(expr, 0);
        if (!typeString.isString()) {
            this.warnInvalidExpression("native type");
            this.warnInvalidInside(Keywords.TYPEEXPR.name);
            return false;
        }
        Node typeExpr = JsDocInfoParser.parseTypeString(typeString.getString());
        typeString.detach();
        expr.addChildToBack(typeExpr);
        return true;
    }

    private boolean validTypeExpression(Node expr) {
        String name = this.getCallName(expr);
        Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case TYPE: {
                return this.validTemplateTypeExpression(expr);
            }
            case UNION: {
                return this.validUnionTypeExpression(expr);
            }
            case NONE: {
                return this.validNoneTypeExpression(expr);
            }
            case ALL: {
                return this.validAllTypeExpression(expr);
            }
            case UNKNOWN: {
                return this.validUnknownTypeExpression(expr);
            }
            case RAWTYPEOF: {
                return this.validRawTypeOfTypeExpression(expr);
            }
            case TEMPLATETYPEOF: {
                return this.validTemplateTypeOfExpression(expr);
            }
            case RECORD: {
                return this.validRecordTypeExpression(expr);
            }
            case TYPEEXPR: {
                return this.validNativeTypeExpr(expr);
            }
        }
        throw new IllegalStateException("Invalid type expression");
    }

    private boolean validTypePredicate(Node expr, int paramCount) {
        for (int i = 0; i < paramCount; ++i) {
            if (this.validTypeTransformationExpression(this.getCallArgument(expr, i))) continue;
            this.warnInvalidInside("boolean");
            return false;
        }
        return true;
    }

    private boolean isValidStringParam(Node expr) {
        if (!expr.isName() && !expr.isString()) {
            this.warnInvalid("string");
            return false;
        }
        if (expr.getString().isEmpty()) {
            this.warnInvalid("string parameter");
            return false;
        }
        return true;
    }

    private boolean validStringPredicate(Node expr, int paramCount) {
        for (int i = 0; i < paramCount; ++i) {
            if (this.isValidStringParam(this.getCallArgument(expr, i))) continue;
            this.warnInvalidInside("boolean");
            return false;
        }
        return true;
    }

    private boolean validTypevarParam(Node expr) {
        if (!this.isTypeVar(expr)) {
            this.warnInvalid("name");
            return false;
        }
        return true;
    }

    private boolean validTypevarPredicate(Node expr, int paramCount) {
        for (int i = 0; i < paramCount; ++i) {
            if (this.validTypevarParam(this.getCallArgument(expr, i))) continue;
            this.warnInvalidInside("boolean");
            return false;
        }
        return true;
    }

    private boolean validBooleanOperation(Node expr) {
        boolean valid;
        if (expr.isNot()) {
            valid = this.validBooleanExpression(expr.getFirstChild());
        } else {
            boolean bl = valid = this.validBooleanExpression(expr.getFirstChild()) && this.validBooleanExpression(expr.getSecondChild());
        }
        if (!valid) {
            this.warnInvalidInside("boolean");
            return false;
        }
        return true;
    }

    private boolean validBooleanExpression(Node expr) {
        if (this.isBooleanOperation(expr)) {
            return this.validBooleanOperation(expr);
        }
        if (!this.isOperation(expr)) {
            this.warnInvalidExpression("boolean");
            return false;
        }
        if (!this.isValidPredicate(this.getCallName(expr))) {
            this.warnInvalid("boolean predicate");
            return false;
        }
        Keywords keyword = this.nameToKeyword(this.getCallName(expr));
        if (!this.checkParameterCount(expr, keyword)) {
            return false;
        }
        switch (keyword.kind) {
            case TYPE_PREDICATE: {
                return this.validTypePredicate(expr, this.getCallParamCount(expr));
            }
            case STRING_PREDICATE: {
                return this.validStringPredicate(expr, this.getCallParamCount(expr));
            }
            case TYPEVAR_PREDICATE: {
                return this.validTypevarPredicate(expr, this.getCallParamCount(expr));
            }
        }
        throw new IllegalStateException("Invalid boolean expression");
    }

    private boolean validConditionalExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.COND)) {
            return false;
        }
        if (!this.validBooleanExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside("conditional");
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 1))) {
            this.warnInvalidInside("conditional");
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 2))) {
            this.warnInvalidInside("conditional");
            return false;
        }
        return true;
    }

    private boolean validMapunionExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.MAPUNION)) {
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside(Keywords.MAPUNION.name);
            return false;
        }
        if (!this.getCallArgument(expr, 1).isFunction()) {
            this.warnInvalid("map function");
            this.warnInvalidInside(Keywords.MAPUNION.name);
            return false;
        }
        Node mapFn = this.getCallArgument(expr, 1);
        int mapFnParamCount = this.getFunctionParamCount(mapFn);
        if (mapFnParamCount < 1) {
            this.warnMissingParam("map function");
            this.warnInvalidInside(Keywords.MAPUNION.name);
            return false;
        }
        if (mapFnParamCount > 1) {
            this.warnExtraParam("map function");
            this.warnInvalidInside(Keywords.MAPUNION.name);
            return false;
        }
        Node mapFnBody = this.getFunctionBody(mapFn);
        if (!this.validTypeTransformationExpression(mapFnBody)) {
            this.warnInvalidInside("map function body");
            return false;
        }
        return true;
    }

    private boolean validMaprecordExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.MAPRECORD)) {
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside(Keywords.MAPRECORD.name);
            return false;
        }
        if (!this.getCallArgument(expr, 1).isFunction()) {
            this.warnInvalid("map function");
            this.warnInvalidInside(Keywords.MAPRECORD.name);
            return false;
        }
        Node mapFn = this.getCallArgument(expr, 1);
        int mapFnParamCount = this.getFunctionParamCount(mapFn);
        if (mapFnParamCount < 2) {
            this.warnMissingParam("map function");
            this.warnInvalidInside(Keywords.MAPRECORD.name);
            return false;
        }
        if (mapFnParamCount > 2) {
            this.warnExtraParam("map function");
            this.warnInvalidInside(Keywords.MAPRECORD.name);
            return false;
        }
        Node mapFnBody = this.getFunctionBody(mapFn);
        if (!this.validTypeTransformationExpression(mapFnBody)) {
            this.warnInvalidInside("map function body");
            return false;
        }
        return true;
    }

    private boolean validTypeOfVarExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.TYPEOFVAR)) {
            return false;
        }
        if (!this.getCallArgument(expr, 0).isString()) {
            this.warnInvalid("name");
            this.warnInvalidInside(Keywords.TYPEOFVAR.name);
            return false;
        }
        return true;
    }

    private boolean validInstanceOfExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.INSTANCEOF)) {
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside(Keywords.INSTANCEOF.name);
            return false;
        }
        return true;
    }

    private boolean validPrintTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.PRINTTYPE)) {
            return false;
        }
        if (!this.getCallArgument(expr, 0).isString()) {
            this.warnInvalid("message");
            this.warnInvalidInside(Keywords.PRINTTYPE.name);
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 1))) {
            this.warnInvalidInside(Keywords.PRINTTYPE.name);
            return false;
        }
        return true;
    }

    private boolean validPropTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.PROPTYPE)) {
            return false;
        }
        if (!this.getCallArgument(expr, 0).isString()) {
            this.warnInvalid("property name");
            this.warnInvalidInside(Keywords.PROPTYPE.name);
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 1))) {
            this.warnInvalidInside(Keywords.PROPTYPE.name);
            return false;
        }
        return true;
    }

    private boolean validOperationExpression(Node expr) {
        String name = this.getCallName(expr);
        Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case COND: {
                return this.validConditionalExpression(expr);
            }
            case MAPUNION: {
                return this.validMapunionExpression(expr);
            }
            case MAPRECORD: {
                return this.validMaprecordExpression(expr);
            }
            case TYPEOFVAR: {
                return this.validTypeOfVarExpression(expr);
            }
            case INSTANCEOF: {
                return this.validInstanceOfExpression(expr);
            }
            case PRINTTYPE: {
                return this.validPrintTypeExpression(expr);
            }
            case PROPTYPE: {
                return this.validPropTypeExpression(expr);
            }
        }
        throw new IllegalStateException("Invalid type transformation operation");
    }

    private boolean validTypeTransformationExpression(Node expr) {
        if (!this.isValidExpression(expr)) {
            this.warnInvalidExpression("type transformation");
            return false;
        }
        if (this.isTypeVar(expr) || this.isTypeName(expr)) {
            return true;
        }
        String name = this.getCallName(expr);
        if (!this.isValidKeyword(name)) {
            this.warnInvalidExpression("type transformation");
            return false;
        }
        Keywords keyword = this.nameToKeyword(name);
        switch (keyword.kind) {
            case TYPE_CONSTRUCTOR: {
                return this.validTypeExpression(expr);
            }
            case OPERATION: {
                return this.validOperationExpression(expr);
            }
        }
        throw new IllegalStateException("Invalid type transformation expression");
    }

    public static enum Keywords {
        ALL("all", 0, 0, OperationKind.TYPE_CONSTRUCTOR),
        COND("cond", 3, 3, OperationKind.OPERATION),
        EQ("eq", 2, 2, OperationKind.TYPE_PREDICATE),
        ISCTOR("isCtor", 1, 1, OperationKind.TYPE_PREDICATE),
        ISDEFINED("isDefined", 1, 1, OperationKind.TYPEVAR_PREDICATE),
        ISRECORD("isRecord", 1, 1, OperationKind.TYPE_PREDICATE),
        ISTEMPLATIZED("isTemplatized", 1, 1, OperationKind.TYPE_PREDICATE),
        ISUNKNOWN("isUnknown", 1, 1, OperationKind.TYPE_PREDICATE),
        INSTANCEOF("instanceOf", 1, 1, OperationKind.OPERATION),
        MAPUNION("mapunion", 2, 2, OperationKind.OPERATION),
        MAPRECORD("maprecord", 2, 2, OperationKind.OPERATION),
        NONE("none", 0, 0, OperationKind.TYPE_CONSTRUCTOR),
        PRINTTYPE("printType", 2, 2, OperationKind.OPERATION),
        PROPTYPE("propType", 2, 2, OperationKind.OPERATION),
        RAWTYPEOF("rawTypeOf", 1, 1, OperationKind.TYPE_CONSTRUCTOR),
        SUB("sub", 2, 2, OperationKind.TYPE_PREDICATE),
        STREQ("streq", 2, 2, OperationKind.STRING_PREDICATE),
        RECORD("record", 1, Integer.MAX_VALUE, OperationKind.TYPE_CONSTRUCTOR),
        TEMPLATETYPEOF("templateTypeOf", 2, 2, OperationKind.TYPE_CONSTRUCTOR),
        TYPE("type", 2, Integer.MAX_VALUE, OperationKind.TYPE_CONSTRUCTOR),
        TYPEEXPR("typeExpr", 1, 1, OperationKind.TYPE_CONSTRUCTOR),
        TYPEOFVAR("typeOfVar", 1, 1, OperationKind.OPERATION),
        UNION("union", 2, Integer.MAX_VALUE, OperationKind.TYPE_CONSTRUCTOR),
        UNKNOWN("unknown", 0, 0, OperationKind.TYPE_CONSTRUCTOR);

        public final String name;
        public final int minParamCount;
        public final int maxParamCount;
        public final OperationKind kind;

        private Keywords(String name, int minParamCount, int maxParamCount, OperationKind kind) {
            this.name = name;
            this.minParamCount = minParamCount;
            this.maxParamCount = maxParamCount;
            this.kind = kind;
        }
    }

    public static enum OperationKind {
        TYPE_CONSTRUCTOR,
        OPERATION,
        STRING_PREDICATE,
        TYPE_PREDICATE,
        TYPEVAR_PREDICATE;

    }
}

