/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.rhino.Node;

final class ResolveExportResult {
    @Nullable
    private final Binding binding;
    private final State state;
    static final ResolveExportResult AMBIGUOUS = new ResolveExportResult(null, State.AMBIGUOUS);
    static final ResolveExportResult NOT_FOUND = new ResolveExportResult(null, State.NOT_FOUND);
    static final ResolveExportResult ERROR = new ResolveExportResult(null, State.ERROR);

    private ResolveExportResult(@Nullable Binding binding, State state) {
        this.binding = binding;
        this.state = state;
    }

    ResolveExportResult copy(Node sourceNode, Binding.CreatedBy createdBy) {
        Preconditions.checkNotNull(sourceNode);
        if (this.binding == null) {
            return this;
        }
        return new ResolveExportResult(this.binding.copy(sourceNode, createdBy), this.state);
    }

    boolean hadError() {
        return this.state == State.ERROR;
    }

    boolean isAmbiguous() {
        return this.state == State.AMBIGUOUS;
    }

    boolean resolved() {
        return this.state == State.RESOLVED;
    }

    public boolean found() {
        return this.state != State.NOT_FOUND;
    }

    @Nullable
    public Binding getBinding() {
        return this.binding;
    }

    static ResolveExportResult of(Binding binding) {
        Preconditions.checkNotNull(binding);
        return new ResolveExportResult(binding, State.RESOLVED);
    }

    private static enum State {
        RESOLVED,
        AMBIGUOUS,
        NOT_FOUND,
        ERROR;

    }
}

