/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.disambiguate.FlatType;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

class TypeFlattener {
    private final JSTypeRegistry registry;
    private final Predicate<JSType> isInvalidating;
    private final LinkedHashMap<Object, FlatType> typeIndex = new LinkedHashMap();
    private final JSType topType;

    TypeFlattener(JSTypeRegistry registry, Predicate<JSType> isInvalidating) {
        this.registry = registry;
        this.isInvalidating = isInvalidating;
        this.topType = this.registry.getNativeType(JSTypeNative.ALL_TYPE);
    }

    public FlatType flatten(@Nullable JSType type) {
        Object key = this.flattenInternal(type);
        FlatType flat = this.typeIndex.computeIfAbsent(key, this::newFlatType);
        if (!flat.isInvalidating() && this.isInvalidating.test(type)) {
            flat.setInvalidating();
        }
        return flat;
    }

    private FlatType newFlatType(Object key) {
        int id = this.typeIndex.size();
        if (key instanceof JSType) {
            return FlatType.createForSingle((JSType)key, id);
        }
        if (key instanceof ImmutableSet) {
            return FlatType.createForUnion((ImmutableSet)key, id);
        }
        throw new AssertionError(key);
    }

    public FlatType flatten(@Nullable JSTypeNative type) {
        return this.flatten(type == null ? null : this.registry.getNativeType(type));
    }

    public ImmutableSet<FlatType> getAllKnownTypes() {
        return ImmutableSet.copyOf(this.typeIndex.values());
    }

    private Object flattenInternal(JSType type) {
        if (type == null) {
            return this.topType;
        }
        if ((type = type.restrictByNotNullOrUndefined()).isUnknownType() || type.isAllType() || type.isNoType() || type.isNoObjectType()) {
            return this.topType;
        }
        if (type.isTemplatizedType()) {
            return type.toMaybeTemplatizedType().getRawType();
        }
        if (type.isBoxableScalar()) {
            return type.autobox();
        }
        if (type.isUnionType()) {
            return this.flattenUnionInternal(type.toMaybeUnionType());
        }
        return type;
    }

    private Object flattenUnionInternal(UnionType union) {
        ImmutableSet flatUnion = union.getAlternates().stream().map(this::flatten).collect(ImmutableSet.toImmutableSet());
        switch (flatUnion.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return ((FlatType)flatUnion.iterator().next()).getTypeSingle();
            }
        }
        return flatUnion;
    }
}

