/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PropertyRenamingDiagnostics;
import com.google.javascript.jscomp.disambiguate.FlatType;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import com.google.javascript.jscomp.disambiguate.TypeFlattener;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

final class FindPropertyReferences
extends NodeTraversal.AbstractPostOrderCallback {
    private LinkedHashMap<String, PropertyClustering> propIndex = new LinkedHashMap();
    private final TypeFlattener flattener;
    private final Consumer<JSError> errorCb;
    private final IsPropertyDefiner isPropertyDefiner;

    FindPropertyReferences(TypeFlattener flattener, Consumer<JSError> errorCb, IsPropertyDefiner isPropertyDefiner) {
        this.flattener = flattener;
        this.errorCb = errorCb;
        this.isPropertyDefiner = isPropertyDefiner;
    }

    LinkedHashMap<String, PropertyClustering> getPropertyIndex() {
        LinkedHashMap<String, PropertyClustering> tmp = this.propIndex;
        this.propIndex = null;
        return tmp;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETPROP: {
                this.registerPropertyUse(n.getLastChild(), n.getFirstChild().getJSType());
                break;
            }
            case OBJECTLIT: {
                this.handleObjectLit(n);
                break;
            }
            case CALL: {
                this.handleCall(n);
                break;
            }
            case CLASS: {
                this.handleClass(n);
                break;
            }
            case OBJECT_PATTERN: {
                this.handleObjectPattern(n);
                break;
            }
        }
    }

    private void handleObjectLit(Node n) {
        if (n.getParent().isCall() && NodeUtil.isObjectDefinePropertiesDefinition(n.getParent())) {
            return;
        }
        JSType owner = n.getJSType();
        this.traverseObjectlitLike(n, m -> owner);
    }

    private void handleCall(Node call) {
        Node target = call.getFirstChild();
        if (!target.isQualifiedName()) {
            return;
        }
        String functionName = target.getOriginalQualifiedName();
        if (functionName != null && this.isPropertyDefiner.test(functionName)) {
            this.handlePropertyDefiningFunctionCall(call, functionName);
        } else if (NodeUtil.isObjectDefinePropertiesDefinition(call)) {
            this.handleObjectDefineProperties(call);
        }
    }

    private void handleClass(Node classNode) {
        JSType classType = classNode.getJSType();
        ObjectType classPrototypeType = classType.isFunctionType() ? classType.toMaybeFunctionType().getPrototypeProperty() : null;
        this.traverseObjectlitLike(NodeUtil.getClassMembers(classNode), m -> m.isStaticMember() ? classType : classPrototypeType);
    }

    private void handleObjectPattern(Node pattern) {
        JSType owner = pattern.getJSType();
        this.traverseObjectlitLike(pattern, m -> owner);
    }

    private void handlePropertyDefiningFunctionCall(Node call, String renameFunctionName) {
        int childCount = call.getChildCount();
        int argCount = childCount - 1;
        if (argCount != 1 && argCount != 2) {
            this.errorCb.accept(JSError.make(call, PropertyRenamingDiagnostics.INVALID_RENAME_FUNCTION, renameFunctionName, " Must be called with 1 or 2 arguments"));
            return;
        }
        if (!call.getSecondChild().isString()) {
            this.errorCb.accept(JSError.make(call, PropertyRenamingDiagnostics.INVALID_RENAME_FUNCTION, renameFunctionName, " The first argument must be a string literal."));
            return;
        }
        String propName = call.getSecondChild().getString();
        if (propName.contains(".")) {
            this.errorCb.accept(JSError.make(call, PropertyRenamingDiagnostics.INVALID_RENAME_FUNCTION, renameFunctionName, " The first argument must not be a property path."));
            return;
        }
        Node obj = call.getChildAtIndex(2);
        this.registerPropertyUse(call.getSecondChild(), obj.getJSType());
    }

    private void handleObjectDefineProperties(Node call) {
        Node typeObj = call.getSecondChild();
        Node objectLiteral = typeObj.getNext();
        if (!objectLiteral.isObjectLit()) {
            return;
        }
        JSType type = typeObj.getJSType();
        this.traverseObjectlitLike(objectLiteral, m -> type);
    }

    private void traverseObjectlitLike(Node n, Function<Node, JSType> memberOwnerFn) {
        Preconditions.checkState(n.isObjectLit() || n.isObjectPattern() || n.isClassMembers());
        block4: for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            switch (child.getToken()) {
                case COMPUTED_PROP: 
                case OBJECT_REST: 
                case OBJECT_SPREAD: {
                    continue block4;
                }
                case STRING_KEY: 
                case MEMBER_FUNCTION_DEF: 
                case GETTER_DEF: 
                case SETTER_DEF: {
                    if (child.isQuotedString()) continue block4;
                    this.registerPropertyUse(child, memberOwnerFn.apply(child));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unexpected child of " + (Object)((Object)n.getToken()) + ": " + child.toStringTree());
                }
            }
        }
    }

    private void registerPropertyUse(Node site, JSType owner) {
        PropertyClustering prop = this.propIndex.computeIfAbsent(site.getString(), PropertyClustering::new);
        FlatType flatOwner = this.flattener.flatten(owner);
        flatOwner.getAssociatedProps().add(prop);
        prop.getClusters().add(flatOwner);
        prop.getUseSites().put(site, flatOwner);
        if (site.isFromExterns()) {
            prop.registerExternType(flatOwner);
        }
    }

    @FunctionalInterface
    static interface IsPropertyDefiner {
        public boolean test(String var1);
    }
}

