/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.diagnostic;

import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.FormatMethod;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.FormatString;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.MustBeClosed;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;

final class WritingLogFile
extends LogFile {
    private final BufferedWriter writer;

    @MustBeClosed
    static LogFile create(Path file) {
        try {
            Path dir = file.getParent();
            Files.createDirectories(dir, new FileAttribute[0]);
            return new WritingLogFile(Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private WritingLogFile(BufferedWriter writer) {
        this.writer = writer;
    }

    @Override
    public LogFile log(Object value) {
        return this.logInternal(value.toString());
    }

    @Override
    public LogFile log(String value) {
        return this.logInternal(value);
    }

    @Override
    public LogFile log(Supplier<String> value) {
        return this.logInternal(value.get());
    }

    @Override
    @FormatMethod
    public LogFile log(@FormatString String template, Object ... values) {
        return this.logInternal(String.format(template, values));
    }

    private LogFile logInternal(String value) {
        try {
            this.writer.append(value).append('\n');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

