/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TypeInference;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.JSTypeResolver;

class TypeInferencePass {
    static final DiagnosticType DATAFLOW_ERROR = DiagnosticType.error("JSC_INTERNAL_ERROR_DATAFLOW", "non-monotonic data-flow analysis");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private TypedScope topScope;
    private final TypedScopeCreator scopeCreator;
    private final CodingConvention.AssertionFunctionLookup assertionFunctionLookup;

    TypeInferencePass(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, TypedScopeCreator scopeCreator) {
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.reverseInterpreter = reverseInterpreter;
        this.scopeCreator = scopeCreator;
        this.assertionFunctionLookup = CodingConvention.AssertionFunctionLookup.of(compiler.getCodingConvention().getAssertionFunctions());
    }

    TypeInferencePass reuseTopScope(TypedScope topScope) {
        Preconditions.checkNotNull(topScope);
        Preconditions.checkState(this.topScope == null);
        this.topScope = topScope;
        return this;
    }

    TypedScope inferAllScopes(Node inferenceRoot) {
        try (JSTypeResolver.Closer closer = this.registry.getResolver().openForDefinition();){
            if (this.topScope == null) {
                Preconditions.checkState(inferenceRoot.isRoot());
                Preconditions.checkState(inferenceRoot.getParent() == null);
                this.topScope = this.scopeCreator.createScope(inferenceRoot, (AbstractScope)null);
            } else {
                Preconditions.checkState(inferenceRoot.isScript());
                this.scopeCreator.patchGlobalScope(this.topScope, inferenceRoot);
            }
            new NodeTraversal(this.compiler, new FirstScopeBuildingCallback(), this.scopeCreator).traverseWithScope(inferenceRoot, this.topScope);
            this.scopeCreator.resolveWeakImportsPreResolution();
        }
        this.scopeCreator.undoTypeAliasChains();
        new NodeTraversal(this.compiler, new SecondScopeBuildingCallback(), this.scopeCreator).traverseWithScope(inferenceRoot, this.topScope);
        JSType unknownType = this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        for (TypedVar var : this.scopeCreator.getAllSymbols()) {
            if (var.getType() != null) continue;
            var.setType(unknownType);
        }
        return this.topScope;
    }

    private void inferScope(Node n, TypedScope scope) {
        TypeInference typeInference = new TypeInference(this.compiler, this.computeCfg(n), this.reverseInterpreter, scope, this.scopeCreator, this.assertionFunctionLookup);
        try {
            typeInference.analyze();
        }
        catch (DataFlowAnalysis.MaxIterationsExceededException e) {
            this.compiler.report(JSError.make(n, DATAFLOW_ERROR, new String[0]));
        }
    }

    private ControlFlowGraph<Node> computeCfg(Node n) {
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, n);
        return cfa.getCfg();
    }

    private class SecondScopeBuildingCallback
    extends NodeTraversal.AbstractScopedCallback {
        private SecondScopeBuildingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            TypedScope scope = t.getTypedScope();
            if (!scope.isBlockScope() && !scope.isModuleScope()) {
                TypeInferencePass.this.inferScope(t.getCurrentNode(), scope);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    private static class FirstScopeBuildingCallback
    extends NodeTraversal.AbstractScopedCallback {
        private FirstScopeBuildingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            t.getTypedScope();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }
}

