/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class RewriteAsyncFunctions
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final String ASYNC_ARGUMENTS = "$jscomp$async$arguments";
    private static final String ASYNC_THIS = "$jscomp$async$this";
    private static final String ASYNC_SUPER_PROP_GETTER_PREFIX = "$jscomp$async$super$get$";
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_FUNCTIONS);
    private final Deque<LexicalContext> contextStack;
    private final AbstractCompiler compiler;
    private final boolean rewriteSuperPropertyReferencesWithoutSuper;
    private final JSTypeRegistry registry;
    private final AstFactory astFactory;

    private RewriteAsyncFunctions(Builder builder) {
        Preconditions.checkNotNull(builder);
        this.compiler = builder.compiler;
        this.contextStack = new ArrayDeque<LexicalContext>();
        this.rewriteSuperPropertyReferencesWithoutSuper = builder.rewriteSuperPropertyReferencesWithoutSuper;
        this.registry = Preconditions.checkNotNull(builder.registry);
        this.astFactory = Preconditions.checkNotNull(builder.astFactory);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (parent == null) {
            Preconditions.checkState(this.contextStack.isEmpty());
            this.contextStack.push(new RootContext(n));
        } else {
            LexicalContext parentContext = this.contextStack.peek();
            LexicalContext nodeContext = parentContext.getContextForNode(n);
            if (nodeContext != parentContext) {
                this.contextStack.push(nodeContext);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        LexicalContext context = this.contextStack.peek();
        context.visit(t, n);
        if (context.getContextRootNode() == n) {
            this.contextStack.pop();
        }
    }

    private void convertAsyncFunction(NodeTraversal t, FunctionContext functionContext) {
        Node originalFunction = functionContext.getContextRootNode();
        originalFunction.setIsAsyncFunction(false);
        Node originalBody = originalFunction.getLastChild();
        if (originalFunction.isFromExterns()) {
            if (!NodeUtil.isEmptyBlock(originalBody)) {
                originalBody.replaceWith(this.astFactory.createBlock(new Node[0]));
                NodeUtil.markFunctionsDeleted(originalBody, this.compiler);
            }
            return;
        }
        Node newBody = this.astFactory.createBlock(new Node[0]);
        originalFunction.replaceChild(originalBody, newBody);
        if (functionContext.mustAddAsyncThisVariable) {
            newBody.addChildToBack(this.astFactory.createThisAliasDeclarationForFunction(ASYNC_THIS, originalFunction));
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        }
        if (functionContext.mustAddAsyncArgumentsVariable) {
            newBody.addChildToBack(this.astFactory.createArgumentsAliasDeclaration(ASYNC_ARGUMENTS));
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        }
        for (SuperPropertyWrapperInfo superPropertyWrapperInfo : functionContext.superPropertyWrappers.asCollection()) {
            Node arrowFunction = functionContext.createWrapperArrowFunction(superPropertyWrapperInfo);
            Node arrowFunctionDeclarationStatement = this.astFactory.createSingleConstNameDeclaration(superPropertyWrapperInfo.wrapperFunctionName, arrowFunction);
            newBody.addChildToBack(arrowFunctionDeclarationStatement);
            this.compiler.reportChangeToChangeScope(arrowFunction);
            Node enclosingScript = t.getCurrentScript();
            NodeUtil.addFeatureToScript(enclosingScript, FeatureSet.Feature.ARROW_FUNCTIONS, this.compiler);
            NodeUtil.addFeatureToScript(enclosingScript, FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        }
        if (!originalBody.isBlock()) {
            originalBody = this.astFactory.createBlock(this.astFactory.createReturn(originalBody)).useSourceInfoIfMissingFromForTree(originalBody);
        }
        Node generatorFunction = this.astFactory.createZeroArgGeneratorFunction("", originalBody, originalFunction.getJSType());
        this.compiler.reportChangeToChangeScope(generatorFunction);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.GENERATORS, this.compiler);
        newBody.addChildToBack(this.astFactory.createReturn(this.astFactory.createJscompAsyncExecutePromiseGeneratorFunctionCall(t.getScope(), generatorFunction)));
        newBody.useSourceInfoIfMissingFromForTree(originalBody);
        this.compiler.reportChangeToEnclosingScope(newBody);
    }

    static class Builder {
        private final AbstractCompiler compiler;
        private boolean rewriteSuperPropertyReferencesWithoutSuper = false;
        private JSTypeRegistry registry;
        private AstFactory astFactory;

        Builder(AbstractCompiler compiler) {
            Preconditions.checkNotNull(compiler);
            this.compiler = compiler;
        }

        Builder rewriteSuperPropertyReferencesWithoutSuper(boolean value) {
            this.rewriteSuperPropertyReferencesWithoutSuper = value;
            return this;
        }

        RewriteAsyncFunctions build() {
            this.astFactory = this.compiler.createAstFactory();
            this.registry = this.compiler.getTypeRegistry();
            return new RewriteAsyncFunctions(this);
        }
    }

    private final class FunctionContext
    extends LexicalContext {
        @Nullable
        final FunctionContext asyncThisAndArgumentsContext;
        final SuperPropertyWrappers superPropertyWrappers;
        boolean mustAddAsyncThisVariable;
        boolean mustAddAsyncArgumentsVariable;

        FunctionContext(Node contextRootNode) {
            super(contextRootNode);
            this.superPropertyWrappers = new SuperPropertyWrappers();
            this.mustAddAsyncThisVariable = false;
            this.mustAddAsyncArgumentsVariable = false;
            this.asyncThisAndArgumentsContext = contextRootNode.isAsyncFunction() ? this : null;
        }

        FunctionContext(FunctionContext outer, Node contextRootNode) {
            super(contextRootNode);
            this.superPropertyWrappers = new SuperPropertyWrappers();
            this.mustAddAsyncThisVariable = false;
            this.mustAddAsyncArgumentsVariable = false;
            Preconditions.checkState(contextRootNode.isFunction(), contextRootNode);
            this.asyncThisAndArgumentsContext = contextRootNode.isAsyncFunction() ? (contextRootNode.isArrowFunction() ? (outer.asyncThisAndArgumentsContext == null ? this : outer.asyncThisAndArgumentsContext) : this) : (contextRootNode.isArrowFunction() ? outer.asyncThisAndArgumentsContext : null);
        }

        @Override
        public LexicalContext getContextForNode(Node n) {
            if (n == this.contextRootNode) {
                return this;
            }
            if (n.isFunction()) {
                return new FunctionContext(this, n);
            }
            if (n.isParamList()) {
                return new ParameterListContext(this, n);
            }
            return this;
        }

        private void recordAsyncThisReplacementWasDone() {
            this.asyncThisAndArgumentsContext.mustAddAsyncThisVariable = true;
        }

        private SuperPropertyWrapperInfo getOrCreateSuperPropertyWrapperInfo(Node superDotPropertyNode) {
            return this.asyncThisAndArgumentsContext.superPropertyWrappers.getOrCreateSuperPropertyWrapperInfo(superDotPropertyNode);
        }

        private void recordAsyncArgumentsReplacementWasDone() {
            this.asyncThisAndArgumentsContext.mustAddAsyncArgumentsVariable = true;
        }

        private Node createThisVariableReference() {
            this.recordAsyncThisReplacementWasDone();
            return RewriteAsyncFunctions.this.astFactory.createThisAliasReferenceForFunction(RewriteAsyncFunctions.ASYNC_THIS, this.asyncThisAndArgumentsContext.getContextRootNode());
        }

        private Node createThisReference() {
            return RewriteAsyncFunctions.this.astFactory.createThisForFunction(this.asyncThisAndArgumentsContext.getContextRootNode());
        }

        private Node createWrapperArrowFunction(SuperPropertyWrapperInfo wrapperInfo) {
            Node superDotProperty = wrapperInfo.firstInstanceOfSuperDotProperty.cloneTree();
            if (RewriteAsyncFunctions.this.rewriteSuperPropertyReferencesWithoutSuper) {
                Node thisNode = this.createThisReference();
                Node prototypeOfThisNode = RewriteAsyncFunctions.this.astFactory.createObjectGetPrototypeOfCall(thisNode);
                Node originalSuperNode = superDotProperty.getFirstChild();
                if (this.asyncThisAndArgumentsContext.getContextRootNode().getParent().isStaticMember()) {
                    originalSuperNode.replaceWith(prototypeOfThisNode);
                } else {
                    originalSuperNode.replaceWith(RewriteAsyncFunctions.this.astFactory.createObjectGetPrototypeOfCall(prototypeOfThisNode));
                }
            }
            return RewriteAsyncFunctions.this.astFactory.createZeroArgArrowFunctionForExpression(superDotProperty);
        }

        @Override
        public void visit(NodeTraversal t, Node n) {
            if (this.contextRootNode == n && this.contextRootNode.isAsyncFunction()) {
                RewriteAsyncFunctions.this.convertAsyncFunction(t, this);
            } else if (this.asyncThisAndArgumentsContext != null) {
                switch (n.getToken()) {
                    case NAME: {
                        if (!n.matchesQualifiedName("arguments")) break;
                        n.setString(RewriteAsyncFunctions.ASYNC_ARGUMENTS);
                        this.asyncThisAndArgumentsContext.recordAsyncArgumentsReplacementWasDone();
                        RewriteAsyncFunctions.this.compiler.reportChangeToChangeScope(this.contextRootNode);
                        break;
                    }
                    case THIS: {
                        n.replaceWith(this.asyncThisAndArgumentsContext.createThisVariableReference());
                        RewriteAsyncFunctions.this.compiler.reportChangeToChangeScope(this.contextRootNode);
                        break;
                    }
                    case SUPER: {
                        Node parent = n.getParent();
                        if (!parent.isGetProp()) {
                            RewriteAsyncFunctions.this.compiler.report(JSError.make(parent, Es6ToEs3Util.CANNOT_CONVERT_YET, "super expression"));
                        }
                        Node superDotProperty = parent;
                        SuperPropertyWrapperInfo superPropertyWrapperInfo = this.asyncThisAndArgumentsContext.getOrCreateSuperPropertyWrapperInfo(superDotProperty);
                        Node getPropReplacement = superPropertyWrapperInfo.createWrapperFunctionCallNode();
                        Node grandparent = superDotProperty.getParent();
                        if (grandparent.isCall() && grandparent.getFirstChild() == superDotProperty) {
                            getPropReplacement = RewriteAsyncFunctions.this.astFactory.createGetProp(getPropReplacement, "call");
                            grandparent.addChildAfter(RewriteAsyncFunctions.this.astFactory.createThisAliasReferenceForFunction(RewriteAsyncFunctions.ASYNC_THIS, this.asyncThisAndArgumentsContext.getContextRootNode()).useSourceInfoFrom(superDotProperty), superDotProperty);
                            this.asyncThisAndArgumentsContext.recordAsyncThisReplacementWasDone();
                        }
                        getPropReplacement.useSourceInfoFromForTree(superDotProperty);
                        grandparent.replaceChild(superDotProperty, getPropReplacement);
                        RewriteAsyncFunctions.this.compiler.reportChangeToChangeScope(this.contextRootNode);
                        break;
                    }
                    case AWAIT: {
                        n.replaceWith(RewriteAsyncFunctions.this.astFactory.createYield(n.getJSType(), n.removeFirstChild()));
                        break;
                    }
                }
            }
        }
    }

    private final class ParameterListContext
    extends LexicalContext {
        final FunctionContext functionContext;

        public ParameterListContext(FunctionContext functionContext, Node contextRootNode) {
            super(contextRootNode);
            this.functionContext = Preconditions.checkNotNull(functionContext);
        }

        @Override
        public LexicalContext getContextForNode(Node n) {
            if (n.isFunction()) {
                return new FunctionContext(this.functionContext, n);
            }
            return this;
        }

        @Override
        public void visit(NodeTraversal t, Node n) {
            if (this.functionContext.asyncThisAndArgumentsContext != null && this.functionContext.asyncThisAndArgumentsContext != this.functionContext) {
                this.functionContext.visit(t, n);
            }
        }
    }

    private final class RootContext
    extends LexicalContext {
        private RootContext(Node contextRootNode) {
            super(contextRootNode);
        }

        @Override
        public LexicalContext getContextForNode(Node n) {
            if (n.isFunction()) {
                return new FunctionContext(n);
            }
            return this;
        }

        @Override
        public void visit(NodeTraversal t, Node n) {
        }
    }

    private abstract class LexicalContext {
        final Node contextRootNode;

        LexicalContext(Node contextRootNode) {
            this.contextRootNode = Preconditions.checkNotNull(contextRootNode);
        }

        Node getContextRootNode() {
            return this.contextRootNode;
        }

        public abstract LexicalContext getContextForNode(Node var1);

        public abstract void visit(NodeTraversal var1, Node var2);
    }

    private final class SuperPropertyWrappers {
        private final Map<String, SuperPropertyWrapperInfo> propertyNameToTypeMap = new LinkedHashMap<String, SuperPropertyWrapperInfo>();

        private SuperPropertyWrappers() {
        }

        private SuperPropertyWrapperInfo getOrCreateSuperPropertyWrapperInfo(Node superDotPropertyNode) {
            SuperPropertyWrapperInfo superPropertyWrapperInfo;
            Preconditions.checkArgument(superDotPropertyNode.isGetProp(), superDotPropertyNode);
            Node superNode = superDotPropertyNode.getFirstChild();
            Preconditions.checkArgument(superNode.isSuper(), superNode);
            Node propertyNameNode = superDotPropertyNode.getLastChild();
            Preconditions.checkArgument(propertyNameNode.isString(), propertyNameNode);
            String propertyName = propertyNameNode.getString();
            JSType propertyType = superDotPropertyNode.getJSType();
            if (this.propertyNameToTypeMap.containsKey(propertyName)) {
                superPropertyWrapperInfo = this.propertyNameToTypeMap.get(propertyName);
                JSType existingJSType = superPropertyWrapperInfo.getPropertyType();
                Preconditions.checkState(Objects.equals(existingJSType, propertyType), "Previous reference type: %s differs from current reference type: %s", (Object)existingJSType, (Object)propertyType);
            } else {
                superPropertyWrapperInfo = this.createNewInfo(superDotPropertyNode);
                this.propertyNameToTypeMap.put(propertyName, superPropertyWrapperInfo);
            }
            return superPropertyWrapperInfo;
        }

        private SuperPropertyWrapperInfo createNewInfo(Node firstSuperDotPropertyNode) {
            Preconditions.checkArgument(firstSuperDotPropertyNode.isGetProp(), firstSuperDotPropertyNode);
            String propertyName = firstSuperDotPropertyNode.getLastChild().getString();
            JSType propertyType = firstSuperDotPropertyNode.getJSType();
            String wrapperFunctionName = RewriteAsyncFunctions.ASYNC_SUPER_PROP_GETTER_PREFIX + propertyName;
            FunctionType wrapperFunctionType = propertyType == null ? null : FunctionType.builder(RewriteAsyncFunctions.this.registry).withReturnType(propertyType).buildAndResolve();
            return new SuperPropertyWrapperInfo(firstSuperDotPropertyNode, wrapperFunctionName, wrapperFunctionType);
        }

        private Collection<SuperPropertyWrapperInfo> asCollection() {
            return this.propertyNameToTypeMap.values();
        }
    }

    private final class SuperPropertyWrapperInfo {
        private final Node firstInstanceOfSuperDotProperty;
        private final String wrapperFunctionName;
        @Nullable
        private final JSType wrapperFunctionType;

        private SuperPropertyWrapperInfo(Node firstSuperDotPropertyNode, String wrapperFunctionName, JSType wrapperFunctionType) {
            this.firstInstanceOfSuperDotProperty = firstSuperDotPropertyNode;
            this.wrapperFunctionName = wrapperFunctionName;
            this.wrapperFunctionType = wrapperFunctionType;
        }

        @Nullable
        private JSType getPropertyType() {
            return this.firstInstanceOfSuperDotProperty.getJSType();
        }

        private Node createWrapperFunctionNameNode() {
            return RewriteAsyncFunctions.this.astFactory.createName(this.wrapperFunctionName, this.wrapperFunctionType);
        }

        private Node createWrapperFunctionCallNode() {
            return RewriteAsyncFunctions.this.astFactory.createCall(this.createWrapperFunctionNameNode(), new Node[0]);
        }
    }
}

