/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicate;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReplaceStrings
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType BAD_REPLACEMENT_CONFIGURATION = DiagnosticType.warning("JSC_BAD_REPLACEMENT_CONFIGURATION", "Bad replacement configuration.");
    static final DiagnosticType STRING_REPLACEMENT_TAGGED_TEMPLATE = DiagnosticType.warning("JSC_STRING_REPLACEMENT_TAGGED_TEMPLATE", "Cannot string-replace arguments of a template literal tag function.");
    private static final String DEFAULT_PLACEHOLDER_TOKEN = "`";
    public static final String EXCLUSION_PREFIX = ":!";
    private final String placeholderToken;
    private static final String REPLACE_ONE_MARKER = "?";
    private static final String REPLACE_ALL_MARKER = "*";
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final Map<String, Config> functions = new HashMap<String, Config>();
    private final Multimap<String, String> methods = HashMultimap.create();
    private final DefaultNameGenerator nameGenerator;
    private final Map<String, Result> results = new LinkedHashMap<String, Result>();
    static final Predicate<Result> USED_RESULTS = new Predicate<Result>(){

        @Override
        public boolean apply(Result result) {
            return result.didReplacement;
        }
    };

    ReplaceStrings(AbstractCompiler compiler, String placeholderToken, List<String> functionsToInspect, Set<String> skiplisted, VariableMap previousMappings) {
        this.compiler = compiler;
        this.placeholderToken = placeholderToken.isEmpty() ? DEFAULT_PLACEHOLDER_TOKEN : placeholderToken;
        this.registry = compiler.getTypeRegistry();
        Iterable<String> reservedNames = skiplisted;
        if (previousMappings != null) {
            Set previous = previousMappings.getOriginalNameToNewNameMap().keySet();
            reservedNames = Iterables.concat(skiplisted, previous);
            this.initMapping(previousMappings, skiplisted);
        }
        this.nameGenerator = ReplaceStrings.createNameGenerator(reservedNames);
        this.parseConfiguration(functionsToInspect);
    }

    private void initMapping(VariableMap previousVarMap, Set<String> reservedNames) {
        ImmutableMap<String, String> previous = previousVarMap.getOriginalNameToNewNameMap();
        for (Map.Entry entry : previous.entrySet()) {
            String key = (String)entry.getKey();
            if (reservedNames.contains(key)) continue;
            String value = (String)entry.getValue();
            this.results.put(value, new Result(value, key));
        }
    }

    List<Result> getResult() {
        return ImmutableList.copyOf(Iterables.filter(this.results.values(), USED_RESULTS));
    }

    VariableMap getStringMap() {
        ImmutableMap.Builder<String, String> map = ImmutableMap.builder();
        for (Result result : Iterables.filter(this.results.values(), USED_RESULTS)) {
            map.put(result.replacement, result.original);
        }
        VariableMap stringMap = new VariableMap(map.build());
        return stringMap;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NEW: 
            case CALL: 
            case TAGGED_TEMPLATELIT: {
                JSType type;
                Config config;
                Node lhs;
                Node rhs;
                Config config2;
                Node calledFn = n.getFirstChild();
                String name = calledFn.getOriginalQualifiedName();
                if (name != null && (config2 = this.findMatching(name, n.getSourceFileName())) != null) {
                    this.doSubstitutions(t, config2, n);
                    return;
                }
                if (!NodeUtil.isNormalGet(calledFn) || !(rhs = calledFn.getLastChild()).isName() && !rhs.isString()) break;
                String methodName = rhs.getString();
                String originalMethodName = rhs.getParent().getOriginalName();
                Collection<String> classes = originalMethodName != null ? this.methods.get(originalMethodName) : this.methods.get(methodName);
                if (classes == null || (lhs = calledFn.getFirstChild()).getJSType() == null || (config = this.findMatchingClass(type = lhs.getJSType().restrictByNotNullOrUndefined(), classes)) == null) break;
                this.doSubstitutions(t, config, n);
                return;
            }
        }
    }

    private Config findMatching(String name, String callsiteSourceFileName) {
        Config config = this.functions.get(name);
        if (config == null) {
            name = name.replace('$', '.');
            config = this.functions.get(name);
        }
        if (config != null) {
            for (String excludedSuffix : config.excludedFilenameSuffixes) {
                if (!callsiteSourceFileName.endsWith(excludedSuffix)) continue;
                return null;
            }
        }
        return config;
    }

    private Config findMatchingClass(JSType callClassType, Collection<String> declarationNames) {
        if (!callClassType.isEmptyType() && !callClassType.isUnknownType()) {
            for (String declarationName : declarationNames) {
                String className = ReplaceStrings.getClassFromDeclarationName(declarationName);
                JSType methodClassType = this.registry.getGlobalType(className);
                if (methodClassType == null || !callClassType.isSubtypeOf(methodClassType)) continue;
                return this.functions.get(declarationName);
            }
        }
        return null;
    }

    private void doSubstitutions(NodeTraversal t, Config config, Node n) {
        if (n.isTaggedTemplateLit()) {
            this.compiler.report(JSError.make(n, STRING_REPLACEMENT_TAGGED_TEMPLATE, new String[0]));
            return;
        }
        Preconditions.checkState(n.isNew() || n.isCall());
        if (!config.isReplaceAll()) {
            for (int parameter : config.parameters) {
                Node arg = n.getChildAtIndex(parameter);
                if (arg == null) continue;
                this.replaceExpression(t, arg, n);
            }
        } else {
            Node firstParam;
            for (Node arg = firstParam = n.getSecondChild(); arg != null; arg = arg.getNext()) {
                arg = this.replaceExpression(t, arg, n);
            }
        }
    }

    private Node replaceExpression(NodeTraversal t, Node expr, Node parent) {
        Node replacement;
        String replacementString;
        String key = null;
        switch (expr.getToken()) {
            case STRING: {
                key = expr.getString();
                replacementString = this.getReplacement(key);
                replacement = IR.string(replacementString);
                break;
            }
            case TEMPLATELIT: 
            case ADD: 
            case NAME: {
                StringBuilder keyBuilder = new StringBuilder();
                Node keyNode = IR.string("");
                replacement = this.buildReplacement(t, expr, keyNode, keyBuilder);
                key = keyBuilder.toString();
                if (key.equals(this.placeholderToken)) {
                    return expr;
                }
                replacementString = this.getReplacement(key);
                keyNode.setString(replacementString);
                break;
            }
            default: {
                return expr;
            }
        }
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(replacementString);
        this.recordReplacement(key);
        replacement.useSourceInfoIfMissingFromForTree(expr);
        parent.replaceChild(expr, replacement);
        t.reportCodeChange();
        return replacement;
    }

    private String getReplacement(String key) {
        Result result = this.results.get(key);
        if (result != null) {
            return result.replacement;
        }
        String replacement = this.nameGenerator.generateNextName();
        result = new Result(key, replacement);
        this.results.put(key, result);
        return replacement;
    }

    private void recordReplacement(String key) {
        Result result = this.results.get(key);
        Preconditions.checkState(result != null);
        result.didReplacement = true;
    }

    private Node buildReplacement(NodeTraversal t, Node expr, Node prefix, StringBuilder keyBuilder) {
        switch (expr.getToken()) {
            case ADD: {
                Node left = expr.getFirstChild();
                Node right = left.getNext();
                prefix = this.buildReplacement(t, left, prefix, keyBuilder);
                return this.buildReplacement(t, right, prefix, keyBuilder);
            }
            case TEMPLATELIT: {
                block10: for (Node child = expr.getFirstChild(); child != null; child = child.getNext()) {
                    switch (child.getToken()) {
                        case TEMPLATELIT_STRING: {
                            keyBuilder.append(child.getCookedString());
                            continue block10;
                        }
                        case TEMPLATELIT_SUB: {
                            prefix = this.buildReplacement(t, child.getFirstChild(), prefix, keyBuilder);
                            continue block10;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected TEMPLATELIT child: " + child);
                        }
                    }
                }
                return prefix;
            }
            case STRING: {
                keyBuilder.append(expr.getString());
                return prefix;
            }
            case NAME: {
                StringBuilder newKeyBuilder;
                Node newKeyNode;
                Node replacement;
                Node initialValue;
                Var var = (Var)t.getScope().getVar(expr.getString());
                if (var == null || !var.isDeclaredOrInferredConst() && !var.isConst() || (initialValue = var.getInitialValue()) == null || (replacement = this.buildReplacement(t, initialValue, newKeyNode = IR.string(""), newKeyBuilder = new StringBuilder())) != newKeyNode) break;
                keyBuilder.append((CharSequence)newKeyBuilder);
                return prefix;
            }
        }
        keyBuilder.append(this.placeholderToken);
        prefix = IR.add(prefix, IR.string(this.placeholderToken));
        return IR.add(prefix, expr.cloneTree());
    }

    private static String getMethodFromDeclarationName(String fullDeclarationName) {
        String[] parts = fullDeclarationName.split("\\.prototype\\.");
        Preconditions.checkState(parts.length == 1 || parts.length == 2);
        if (parts.length == 2) {
            return parts[1];
        }
        return null;
    }

    private static String getClassFromDeclarationName(String fullDeclarationName) {
        String[] parts = fullDeclarationName.split("\\.prototype\\.");
        Preconditions.checkState(parts.length == 1 || parts.length == 2);
        if (parts.length == 2) {
            return parts[0];
        }
        return null;
    }

    private void parseConfiguration(List<String> functionsToInspect) {
        for (String function : functionsToInspect) {
            Config config = this.parseConfiguration(function);
            this.functions.put(config.name, config);
            String method = ReplaceStrings.getMethodFromDeclarationName(config.name);
            if (method == null) continue;
            this.methods.put(method, config.name);
        }
    }

    private Config parseConfiguration(String function) {
        String[] parts;
        int first = function.indexOf(40);
        int last = function.indexOf(41);
        int colon = function.indexOf(EXCLUSION_PREFIX);
        Preconditions.checkState(first != -1 && last != -1);
        String name = function.substring(0, first);
        String params = function.substring(first + 1, last);
        int paramCount = 0;
        ArrayList<Integer> replacementParameters = new ArrayList<Integer>();
        for (String param : parts = params.split(",")) {
            ++paramCount;
            if (param.equals(REPLACE_ALL_MARKER)) {
                Preconditions.checkState(paramCount == 1 && parts.length == 1);
                replacementParameters.add(0);
                continue;
            }
            if (param.equals(REPLACE_ONE_MARKER)) {
                Preconditions.checkState(!replacementParameters.contains(0));
                replacementParameters.add(paramCount);
                continue;
            }
            Preconditions.checkState(param.isEmpty(), "Unknown marker", (Object)param);
        }
        Preconditions.checkState(!replacementParameters.isEmpty());
        return new Config(name, replacementParameters, colon == -1 ? ImmutableSet.of() : ImmutableSet.copyOf(function.substring(colon + EXCLUSION_PREFIX.length()).split(",")));
    }

    private static DefaultNameGenerator createNameGenerator(Iterable<String> reserved) {
        String namePrefix = "";
        char[] reservedChars = new char[]{};
        return new DefaultNameGenerator(ImmutableSet.copyOf(reserved), "", reservedChars);
    }

    static class Result {
        public final String original;
        public final String replacement;
        public boolean didReplacement = false;

        Result(String original, String replacement) {
            this.original = original;
            this.replacement = replacement;
        }
    }

    private static class Config {
        final String name;
        final List<Integer> parameters;
        final ImmutableSet<String> excludedFilenameSuffixes;
        static final int REPLACE_ALL_VALUE = 0;

        Config(String name, List<Integer> replacementParameters, ImmutableSet<String> excludedFilenameSuffixes) {
            this.name = name;
            this.parameters = replacementParameters;
            this.excludedFilenameSuffixes = excludedFilenameSuffixes;
        }

        public boolean isReplaceAll() {
            return this.parameters.size() == 1 && this.parameters.contains(0);
        }
    }
}

