/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import com.google.javascript.jscomp.jarjar.com.google.common.hash.Hasher;
import com.google.javascript.jscomp.jarjar.com.google.common.hash.Hashing;
import com.google.javascript.jscomp.jarjar.com.google.common.primitives.Chars;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Set;

@GwtIncompatible(value="java.util.Collections.shuffle, com.google.common.hash.Hasher, com.google.common.hash.Hashing")
public final class RandomNameGenerator
implements NameGenerator {
    static final ImmutableSet<Character> FIRST_CHAR = RandomNameGenerator.asSet(DefaultNameGenerator.FIRST_CHAR);
    static final ImmutableSet<Character> NONFIRST_CHAR = RandomNameGenerator.asSet(DefaultNameGenerator.NONFIRST_CHAR);
    private ImmutableSet<Character> firstChars;
    private ImmutableSet<Character> nonFirstChars;
    private final Random random;
    private ImmutableSet<String> reservedNames;
    private String prefix;
    private int nameCount;
    private static final int NUM_SHUFFLES = 16;
    private String shuffledFirst;
    private ImmutableList<String> shuffledNonFirst;

    public RandomNameGenerator(Random random) {
        this.random = random;
        this.reset(ImmutableSet.of(), "", null);
    }

    RandomNameGenerator(Set<String> reservedNames, String prefix, @Nullable char[] reservedCharacters, Random random) {
        this.random = random;
        this.reset(reservedNames, prefix, reservedCharacters);
    }

    RandomNameGenerator(Set<String> reservedNames, String prefix, @Nullable char[] reservedFirstCharacters, @Nullable char[] reservedNonFirstCharacters, Random random) {
        this.random = random;
        this.reset(reservedNames, prefix, reservedFirstCharacters, reservedNonFirstCharacters);
    }

    @Override
    public void reset(Set<String> reservedNames, String prefix, @Nullable char[] reservedCharacters) {
        this.reset(reservedNames, prefix, reservedCharacters, reservedCharacters);
    }

    @Override
    public void reset(Set<String> reservedNames, String prefix, @Nullable char[] reservedFirstCharacters, @Nullable char[] reservedNonFirstCharacters) {
        this.reservedNames = ImmutableSet.copyOf(reservedNames);
        this.prefix = prefix;
        this.nameCount = 0;
        this.firstChars = Sets.difference(FIRST_CHAR, RandomNameGenerator.asSet(reservedFirstCharacters)).immutableCopy();
        this.nonFirstChars = Sets.difference(NONFIRST_CHAR, RandomNameGenerator.asSet(reservedNonFirstCharacters)).immutableCopy();
        this.checkPrefix(prefix);
        this.shuffleAlphabets();
    }

    @Override
    public NameGenerator clone(Set<String> reservedNames, String prefix, @Nullable char[] reservedCharacters) {
        return new RandomNameGenerator(reservedNames, prefix, reservedCharacters, this.random);
    }

    private static ImmutableSet<Character> asSet(@Nullable char[] chars) {
        return chars == null ? ImmutableSet.of() : ImmutableSet.copyOf(Chars.asList(chars));
    }

    private void checkPrefix(String prefix) {
        if (prefix.length() > 0) {
            if (!this.firstChars.contains(Character.valueOf(prefix.charAt(0)))) {
                throw new IllegalArgumentException("prefix must start with one of: " + Joiner.on(", ").join(this.firstChars));
            }
            for (int pos = 1; pos < prefix.length(); ++pos) {
                if (this.nonFirstChars.contains(Character.valueOf(prefix.charAt(pos)))) continue;
                throw new IllegalArgumentException("prefix has invalid characters, must be one of: " + Joiner.on(", ").join(this.nonFirstChars));
            }
        }
    }

    private static String shuffleAndCopyAlphabet(Set<Character> input, Random random) {
        ArrayList<Character> shuffled = new ArrayList<Character>(input);
        Collections.shuffle(shuffled, random);
        return new String(Chars.toArray(shuffled));
    }

    private void shuffleAlphabets() {
        this.shuffledFirst = RandomNameGenerator.shuffleAndCopyAlphabet(this.firstChars, this.random);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 16; ++i) {
            builder.add(RandomNameGenerator.shuffleAndCopyAlphabet(this.nonFirstChars, this.random));
        }
        this.shuffledNonFirst = builder.build();
    }

    private int getNameLength(int position, int nameIdx) {
        int alphabetSize;
        int length = 0;
        ++nameIdx;
        do {
            --nameIdx;
            alphabetSize = position == 0 ? this.firstChars.size() : this.nonFirstChars.size();
            ++position;
            ++length;
        } while ((nameIdx /= alphabetSize) > 0);
        return length;
    }

    private String generateSuffix(int position, int nameIdx) {
        int alphabetSize;
        StringBuilder name = new StringBuilder();
        int length = this.getNameLength(position, nameIdx);
        ++nameIdx;
        do {
            String alphabet;
            --nameIdx;
            if (position == 0) {
                alphabet = this.shuffledFirst;
            } else {
                Hasher hasher = Hashing.murmur3_128().newHasher();
                hasher.putInt(length);
                hasher.putUnencodedChars(name);
                int alphabetIdx = (hasher.hash().asInt() & Integer.MAX_VALUE) % 16;
                alphabet = (String)this.shuffledNonFirst.get(alphabetIdx);
            }
            alphabetSize = alphabet.length();
            char character = alphabet.charAt(nameIdx % alphabetSize);
            name.append(character);
            ++position;
        } while ((nameIdx /= alphabetSize) > 0);
        return name.toString();
    }

    @Override
    public String generateNextName() {
        String name;
        while (TokenStream.isKeyword(name = this.prefix + this.generateSuffix(this.prefix.length(), this.nameCount++)) || this.reservedNames.contains(name)) {
        }
        return name;
    }
}

