/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class ProcessClosurePrimitives
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType NULL_ARGUMENT_ERROR = DiagnosticType.error("JSC_NULL_ARGUMENT_ERROR", "method \"{0}\" called without an argument");
    static final DiagnosticType EXPECTED_OBJECTLIT_ERROR = DiagnosticType.error("JSC_EXPECTED_OBJECTLIT_ERROR", "method \"{0}\" expected an object literal argument");
    static final DiagnosticType EXPECTED_STRING_ERROR = DiagnosticType.error("JSC_EXPECTED_STRING_ERROR", "method \"{0}\" expected a string argument");
    static final DiagnosticType INVALID_ARGUMENT_ERROR = DiagnosticType.error("JSC_INVALID_ARGUMENT_ERROR", "method \"{0}\" called with invalid argument");
    static final DiagnosticType INVALID_STYLE_ERROR = DiagnosticType.error("JSC_INVALID_CSS_NAME_MAP_STYLE_ERROR", "Invalid CSS name map style {0}");
    static final DiagnosticType TOO_MANY_ARGUMENTS_ERROR = DiagnosticType.error("JSC_TOO_MANY_ARGUMENTS_ERROR", "method \"{0}\" called with more than one argument");
    static final DiagnosticType WEAK_NAMESPACE_TYPE = DiagnosticType.warning("JSC_WEAK_NAMESPACE_TYPE", "Provided symbol declared with type Object. This is rarely useful. For more information see https://github.com/google/closure-compiler/wiki/A-word-about-the-type-Object");
    static final DiagnosticType CLASS_NAMESPACE_ERROR = DiagnosticType.error("JSC_CLASS_NAMESPACE_ERROR", "\"{0}\" cannot be both provided and declared as a class. Try var {0} = class '{'...'}'");
    static final DiagnosticType FUNCTION_NAMESPACE_ERROR = DiagnosticType.error("JSC_FUNCTION_NAMESPACE_ERROR", "\"{0}\" cannot be both provided and declared as a function");
    static final DiagnosticType INVALID_PROVIDE_ERROR = DiagnosticType.error("JSC_INVALID_PROVIDE_ERROR", "\"{0}\" is not a valid {1} qualified name");
    static final DiagnosticType INVALID_DEFINE_NAME_ERROR = DiagnosticType.error("JSC_INVALID_DEFINE_NAME_ERROR", "\"{0}\" is not a valid JS identifier name");
    static final DiagnosticType MISSING_DEFINE_ANNOTATION = DiagnosticType.error("JSC_INVALID_MISSING_DEFINE_ANNOTATION", "Missing @define annotation");
    static final DiagnosticType XMODULE_REQUIRE_ERROR = DiagnosticType.warning("JSC_XMODULE_REQUIRE_ERROR", "namespace \"{0}\" is required in module {2} but provided in module {1}. Is module {2} missing a dependency on module {1}?");
    static final DiagnosticType NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR = DiagnosticType.error("JSC_NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR", "goog.setCssNameMapping only takes an object literal with string values");
    static final DiagnosticType INVALID_CSS_RENAMING_MAP = DiagnosticType.warning("INVALID_CSS_RENAMING_MAP", "Invalid entries in css renaming map: {0}");
    static final DiagnosticType BASE_CLASS_ERROR = DiagnosticType.error("JSC_BASE_CLASS_ERROR", "incorrect use of {0}.base: {1}");
    static final DiagnosticType CLOSURE_DEFINES_ERROR = DiagnosticType.error("JSC_CLOSURE_DEFINES_ERROR", "Invalid CLOSURE_DEFINES definition");
    static final DiagnosticType DEFINE_CALL_WITHOUT_ASSIGNMENT = DiagnosticType.error("JSC_DEFINE_CALL_WITHOUT_ASSIGNMENT", "The result of a goog.define call must be assigned as an isolated statement.");
    static final DiagnosticType INVALID_FORWARD_DECLARE = DiagnosticType.error("JSC_INVALID_FORWARD_DECLARE", "Malformed goog.forwardDeclare");
    static final DiagnosticType CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR = DiagnosticType.error("JSC_CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR", "Closure primitive method {0} may not be aliased");
    static final DiagnosticType CLOSURE_CALL_CANNOT_BE_ALIASED_OUTSIDE_MODULE_ERROR = DiagnosticType.error("JSC_CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR", "Closure primitive method {0} may not be aliased  outside a module (ES module, CommonJS module, or goog.module)");
    static final String GOOG = "goog";
    private final AbstractCompiler compiler;
    private final Set<String> knownClosureSubclasses = new HashSet<String>();
    private final Set<String> exportedVariables = new HashSet<String>();
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final List<Node> defineCalls = new ArrayList<Node>();

    ProcessClosurePrimitives(AbstractCompiler compiler, @Nullable PreprocessorSymbolTable preprocessorSymbolTable) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
    }

    Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        for (Node n : this.defineCalls) {
            this.replaceGoogDefines(n);
        }
    }

    private void replaceGoogDefines(Node n) {
        Node parent = n.getParent();
        String name = n.getSecondChild().getString();
        Node value = n.getChildAtIndex(2).detach();
        switch (parent.getToken()) {
            case NAME: {
                parent.setDefineName(name);
                n.replaceWith(value);
                this.compiler.reportChangeToEnclosingScope(parent);
                break;
            }
            case ASSIGN: {
                Preconditions.checkState(n == parent.getLastChild());
                parent.getFirstChild().setDefineName(name);
                n.replaceWith(value);
                this.compiler.reportChangeToEnclosingScope(parent);
                break;
            }
            default: {
                throw new IllegalStateException("goog.define outside of NAME, or ASSIGN");
            }
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.compiler.process(this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case CALL: {
                Node left = n.getFirstChild();
                if (!left.isGetProp()) break;
                Node name = left.getFirstChild();
                if (name.isName() && GOOG.equals(name.getString())) {
                    String methodName;
                    switch (methodName = name.getNext().getString()) {
                        case "define": {
                            this.processDefineCall(t, n, parent);
                            break;
                        }
                        case "inherits": {
                            this.processInheritsCall(n);
                            break;
                        }
                        case "exportSymbol": {
                            Node arg = left.getNext();
                            if (!arg.isString()) break;
                            String argString = arg.getString();
                            int dot = argString.indexOf(46);
                            if (dot == -1) {
                                this.exportedVariables.add(argString);
                                break;
                            }
                            this.exportedVariables.add(argString.substring(0, dot));
                            break;
                        }
                        case "addDependency": {
                            if (!this.validateUnaliasablePrimitiveCall(t, n, methodName)) break;
                            this.processAddDependency(n, parent);
                            break;
                        }
                        case "setCssNameMapping": {
                            this.processSetCssNameMapping(n, parent);
                            break;
                        }
                        case "forwardDeclare": {
                            if (!this.validatePrimitiveCallWithMessage(t, n, methodName, CLOSURE_CALL_CANNOT_BE_ALIASED_OUTSIDE_MODULE_ERROR)) break;
                            this.processForwardDeclare(n);
                            break;
                        }
                    }
                    break;
                }
                if (!left.getLastChild().getString().equals("base")) break;
                this.maybeProcessClassBaseCall(n);
                break;
            }
            case NAME: 
            case ASSIGN: {
                if (!n.isName() || !n.getString().equals("CLOSURE_DEFINES")) break;
                this.handleClosureDefinesValues(n);
                break;
            }
        }
    }

    private boolean validateUnaliasablePrimitiveCall(NodeTraversal t, Node n, String methodName) {
        return this.validatePrimitiveCallWithMessage(t, n, methodName, CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR);
    }

    private boolean validatePrimitiveCallWithMessage(NodeTraversal t, Node n, String methodName, DiagnosticType invalidAliasingError) {
        if (this.compiler.getOptions().shouldPreserveGoogModule()) {
            return true;
        }
        if (!t.inGlobalHoistScope() && !t.inModuleScope()) {
            this.compiler.report(JSError.make(n, ClosurePrimitiveErrors.INVALID_CLOSURE_CALL_SCOPE_ERROR, new String[0]));
            return false;
        }
        if (!(n.getParent().isExprResult() || t.inModuleScope() || "goog.define".equals(methodName))) {
            this.compiler.report(JSError.make(n, invalidAliasingError, "goog." + methodName));
            return false;
        }
        return true;
    }

    private void handleClosureDefinesValues(Node n) {
        if (NodeUtil.isNameDeclaration(n.getParent()) && n.hasOneChild() && n.getFirstChild().isObjectLit()) {
            HashMap<String, Node> builder = new HashMap<String, Node>();
            builder.putAll(this.compiler.getDefaultDefineValues());
            for (Node c : n.getFirstChild().children()) {
                if (c.isStringKey() && ProcessClosurePrimitives.isValidDefineValue(c.getFirstChild())) {
                    builder.put(c.getString(), c.getFirstChild().cloneTree());
                    continue;
                }
                this.reportBadClosureCommonDefinesDefinition(c);
            }
            this.compiler.setDefaultDefineValues(ImmutableMap.copyOf(builder));
        }
    }

    static boolean isValidDefineValue(Node val) {
        switch (val.getToken()) {
            case STRING: 
            case NUMBER: 
            case TRUE: 
            case FALSE: {
                return true;
            }
            case NEG: {
                return val.getFirstChild().isNumber();
            }
        }
        return false;
    }

    private void processDefineCall(NodeTraversal t, Node n, Node parent) {
        Node args;
        Node left = n.getFirstChild();
        if (this.verifyDefine(t, parent, left, args = left.getNext())) {
            Node nameNode = args;
            this.maybeAddNameToSymbolTable(left);
            this.maybeAddNameToSymbolTable(nameNode);
            this.defineCalls.add(n);
        }
    }

    private void maybeProcessClassBaseCall(Node n) {
        Node callTarget = n.getFirstChild();
        Node baseContainerNode = callTarget.getFirstChild();
        if (!baseContainerNode.isUnscopedQualifiedName()) {
            return;
        }
        String baseContainer = callTarget.getFirstChild().getQualifiedName();
        Node enclosingFnNameNode = ProcessClosurePrimitives.getEnclosingDeclNameNode(n);
        if (enclosingFnNameNode == null || !enclosingFnNameNode.isUnscopedQualifiedName()) {
            Node clazz;
            if (this.knownClosureSubclasses.contains(baseContainer)) {
                this.reportBadBaseMethodUse(n, baseContainer, "Could not find enclosing method.");
            } else if (ProcessClosurePrimitives.baseUsedInClass(n) && ((clazz = NodeUtil.getEnclosingClass(n)).getFirstChild().isName() && clazz.getFirstChild().getString().equals(baseContainer) || clazz.getSecondChild().isName() && clazz.getSecondChild().getString().equals(baseContainer))) {
                this.reportBadBaseMethodUse(n, clazz.getFirstChild().getString(), "base method is not allowed in ES6 class. Use super instead.");
            }
            return;
        }
        if (ProcessClosurePrimitives.baseUsedInClass(n)) {
            Node clazz = NodeUtil.getEnclosingClass(n);
            String name = NodeUtil.getBestLValueName(clazz);
            this.reportBadBaseMethodUse(n, name, "base method is not allowed in ES6 class. Use super instead.");
            return;
        }
        String enclosingQname = enclosingFnNameNode.getQualifiedName();
        if (!enclosingQname.contains(".prototype.")) {
            this.rewriteBaseCallInConstructor(enclosingQname, baseContainer, n, enclosingFnNameNode);
        } else {
            this.rewriteBaseCallInMethod(enclosingQname, baseContainer, n, enclosingFnNameNode);
        }
    }

    private void rewriteBaseCallInConstructor(String enclosingQname, String baseContainer, Node n, Node enclosingFnNameNode) {
        if (!enclosingQname.equals(baseContainer)) {
            if (this.knownClosureSubclasses.contains(baseContainer)) {
                this.reportBadBaseMethodUse(n, baseContainer, "Must be used within " + baseContainer + " methods");
            }
            return;
        }
        Node enclosingParent = enclosingFnNameNode.getParent();
        Node baseClassNode = ProcessClosurePrimitives.findGoogInheritsCall(enclosingParent.isAssign() ? enclosingParent.getParent() : enclosingParent);
        if (baseClassNode == null) {
            return;
        }
        Node callee = n.getFirstChild();
        Node thisArg = callee.getNext();
        if (thisArg == null || !thisArg.isThis()) {
            this.reportBadBaseMethodUse(n, baseContainer, "First argument must be 'this'.");
            return;
        }
        Node methodNameNode = thisArg.getNext();
        if (methodNameNode == null || !methodNameNode.isString() || !methodNameNode.getString().equals("constructor")) {
            this.reportBadBaseMethodUse(n, baseContainer, "Second argument must be 'constructor'.");
            return;
        }
        n.replaceChild(callee, NodeUtil.newQName(this.compiler, baseClassNode.getQualifiedName() + ".call", callee, enclosingQname + ".base"));
        n.removeChild(methodNameNode);
        this.compiler.reportChangeToEnclosingScope(n);
    }

    private void rewriteBaseCallInMethod(String enclosingQname, String baseContainer, Node n, Node enclosingFnNameNode) {
        boolean misuseOfBase;
        if (!this.knownClosureSubclasses.contains(baseContainer)) {
            return;
        }
        boolean bl = misuseOfBase = !enclosingFnNameNode.getFirstFirstChild().matchesQualifiedName(baseContainer);
        if (misuseOfBase) {
            this.reportBadBaseMethodUse(n, baseContainer, "Must be used within " + baseContainer + " methods");
            return;
        }
        Node callee = n.getFirstChild();
        Node thisArg = callee.getNext();
        if (thisArg == null || !thisArg.isThis()) {
            this.reportBadBaseMethodUse(n, baseContainer, "First argument must be 'this'.");
            return;
        }
        Node methodNameNode = thisArg.getNext();
        if (methodNameNode == null || !methodNameNode.isString()) {
            this.reportBadBaseMethodUse(n, baseContainer, "Second argument must name a method.");
            return;
        }
        String methodName = methodNameNode.getString();
        String ending = ".prototype." + methodName;
        if (enclosingQname == null || !enclosingQname.endsWith(ending)) {
            this.reportBadBaseMethodUse(n, baseContainer, "Enclosing method does not match " + methodName);
            return;
        }
        Node className = enclosingFnNameNode.getFirstFirstChild();
        n.replaceChild(callee, NodeUtil.newQName(this.compiler, className.getQualifiedName() + ".superClass_." + methodName + ".call", callee, enclosingQname + ".base"));
        n.removeChild(methodNameNode);
        this.compiler.reportChangeToEnclosingScope(n);
    }

    private static Node findGoogInheritsCall(Node ctorDeclarationNode) {
        Node callNode;
        Node maybeInheritsExpr;
        for (maybeInheritsExpr = ctorDeclarationNode.getNext(); maybeInheritsExpr != null && (maybeInheritsExpr.isEmpty() || NodeUtil.isExprAssign(maybeInheritsExpr)); maybeInheritsExpr = maybeInheritsExpr.getNext()) {
        }
        Node baseClassNode = null;
        if (maybeInheritsExpr != null && NodeUtil.isExprCall(maybeInheritsExpr) && (callNode = maybeInheritsExpr.getFirstChild()).getFirstChild().matchesQualifiedName("goog.inherits") && callNode.getLastChild().isQualifiedName()) {
            baseClassNode = callNode.getLastChild();
        }
        return baseClassNode;
    }

    private void processInheritsCall(Node n) {
        if (n.hasXChildren(3)) {
            Node subClass = n.getSecondChild();
            Node superClass = subClass.getNext();
            if (subClass.isUnscopedQualifiedName() && superClass.isUnscopedQualifiedName()) {
                this.knownClosureSubclasses.add(subClass.getQualifiedName());
            }
        }
    }

    private static Node getEnclosingDeclNameNode(Node n) {
        Node fn = NodeUtil.getEnclosingFunction(n);
        return fn == null ? null : NodeUtil.getNameNode(fn);
    }

    private static boolean baseUsedInClass(Node n) {
        for (Node curr = n; curr != null; curr = curr.getParent()) {
            if (!curr.isClassMembers()) continue;
            return true;
        }
        return false;
    }

    private void reportBadBaseMethodUse(Node n, String className, String extraMessage) {
        this.compiler.report(JSError.make(n, BASE_CLASS_ERROR, className, extraMessage));
    }

    private void reportBadClosureCommonDefinesDefinition(Node n) {
        this.compiler.report(JSError.make(n, CLOSURE_DEFINES_ERROR, new String[0]));
    }

    private void processSetCssNameMapping(Node n, Node parent) {
        Node arg;
        Node left = n.getFirstChild();
        if (this.verifySetCssNameMapping(left, arg = left.getNext())) {
            ArrayList<String> errors;
            CssRenamingMap.Style style;
            final HashMap<String, String> cssNames = new HashMap<String, String>();
            for (Node key = arg.getFirstChild(); key != null; key = key.getNext()) {
                Node value = key.getFirstChild();
                if (!key.isStringKey() || value == null || !value.isString()) {
                    this.compiler.report(JSError.make(n, NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR, new String[0]));
                    return;
                }
                cssNames.put(key.getString(), value.getString());
            }
            String styleStr = "BY_PART";
            if (arg.getNext() != null) {
                styleStr = arg.getNext().getString();
            }
            try {
                style = CssRenamingMap.Style.valueOf(styleStr);
            }
            catch (IllegalArgumentException e) {
                this.compiler.report(JSError.make(n, INVALID_STYLE_ERROR, styleStr));
                return;
            }
            if (style == CssRenamingMap.Style.BY_PART) {
                errors = new ArrayList<String>();
                for (String key : cssNames.keySet()) {
                    if (!key.contains("-")) continue;
                    errors.add(key);
                }
                if (!errors.isEmpty()) {
                    this.compiler.report(JSError.make(n, INVALID_CSS_RENAMING_MAP, ((Object)errors).toString()));
                }
            } else if (style == CssRenamingMap.Style.BY_WHOLE) {
                errors = new ArrayList();
                for (Map.Entry b : cssNames.entrySet()) {
                    if (((String)b.getKey()).length() > 10) continue;
                    for (Map.Entry a : cssNames.entrySet()) {
                        String combined = (String)cssNames.get((String)a.getKey() + "-" + (String)b.getKey());
                        if (combined == null || combined.equals((String)a.getValue() + "-" + (String)b.getValue())) continue;
                        errors.add("map(" + (String)a.getKey() + "-" + (String)b.getKey() + ") != map(" + (String)a.getKey() + ")-map(" + (String)b.getKey() + ")");
                    }
                }
                if (!errors.isEmpty()) {
                    this.compiler.report(JSError.make(n, INVALID_CSS_RENAMING_MAP, ((Object)errors).toString()));
                }
            }
            CssRenamingMap cssRenamingMap = new CssRenamingMap(){

                @Override
                public String get(String value) {
                    if (cssNames.containsKey(value)) {
                        return (String)cssNames.get(value);
                    }
                    return value;
                }

                @Override
                public CssRenamingMap.Style getStyle() {
                    return style;
                }
            };
            this.compiler.setCssRenamingMap(cssRenamingMap);
            this.compiler.reportChangeToEnclosingScope(parent);
            parent.detach();
        }
    }

    private boolean verifyDefine(NodeTraversal t, Node parent, Node methodName, Node args) {
        if (!(this.compiler.getOptions().shouldPreserveGoogModule() || t.inGlobalHoistScope() || t.inModuleScope())) {
            this.compiler.report(JSError.make(methodName.getParent(), ClosurePrimitiveErrors.INVALID_CLOSURE_CALL_SCOPE_ERROR, new String[0]));
            return false;
        }
        if (parent.isAssign() && parent.getParent().isExprResult()) {
            parent = parent.getParent();
        } else if (parent.isName() && NodeUtil.isNameDeclaration(parent.getParent())) {
            parent = parent.getParent();
        } else {
            this.compiler.report(JSError.make(methodName.getParent(), DEFINE_CALL_WITHOUT_ASSIGNMENT, new String[0]));
            return false;
        }
        Node arg = args;
        if (!this.verifyNotNull(methodName, arg) || !this.verifyOfType(methodName, arg, Token.STRING)) {
            return false;
        }
        arg = arg.getNext();
        if (!(args.isFromExterns() || this.verifyNotNull(methodName, arg) && this.verifyIsLast(methodName, arg))) {
            return false;
        }
        String name = args.getString();
        if (!NodeUtil.isValidQualifiedName(this.compiler.getOptions().getLanguageIn().toFeatureSet(), name)) {
            this.compiler.report(JSError.make(args, INVALID_DEFINE_NAME_ERROR, name));
            return false;
        }
        JSDocInfo info = (parent.isExprResult() ? parent.getFirstChild() : parent).getJSDocInfo();
        if (info == null || !info.isDefine()) {
            this.compiler.report(JSError.make(parent, MISSING_DEFINE_ANNOTATION, new String[0]));
            return false;
        }
        return true;
    }

    private void processAddDependency(Node n, Node parent) {
        CodingConvention convention = this.compiler.getCodingConvention();
        List<String> typeDecls = convention.identifyTypeDeclarationCall(n);
        if (typeDecls != null) {
            for (String typeDecl : typeDecls) {
                this.compiler.forwardDeclareType(typeDecl);
            }
        }
        Node emptyNode = IR.number(0.0);
        parent.replaceChild(n, emptyNode);
        this.compiler.reportChangeToEnclosingScope(emptyNode);
    }

    private void processForwardDeclare(Node n) {
        if (!n.getParent().isExprResult()) {
            return;
        }
        CodingConvention convention = this.compiler.getCodingConvention();
        String typeDeclaration = null;
        try {
            typeDeclaration = Iterables.getOnlyElement(convention.identifyTypeDeclarationCall(n));
        }
        catch (IllegalArgumentException | NullPointerException | NoSuchElementException e) {
            this.compiler.report(JSError.make(n, INVALID_FORWARD_DECLARE, "A single type could not identified for the goog.forwardDeclare statement"));
        }
        if (typeDeclaration != null) {
            this.compiler.forwardDeclareType(typeDeclaration);
        }
    }

    private boolean verifyNotNull(Node methodName, Node arg) {
        if (arg == null) {
            this.compiler.report(JSError.make(methodName, NULL_ARGUMENT_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifyOfType(Node methodName, Node arg, Token desiredType) {
        if (arg.getToken() != desiredType) {
            this.compiler.report(JSError.make(methodName, INVALID_ARGUMENT_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifyIsLast(Node methodName, Node arg) {
        if (arg.getNext() != null) {
            this.compiler.report(JSError.make(methodName, TOO_MANY_ARGUMENTS_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifySetCssNameMapping(Node methodName, Node firstArg) {
        DiagnosticType diagnostic = null;
        if (firstArg == null) {
            diagnostic = NULL_ARGUMENT_ERROR;
        } else if (!firstArg.isObjectLit()) {
            diagnostic = EXPECTED_OBJECTLIT_ERROR;
        } else if (firstArg.getNext() != null) {
            Node secondArg = firstArg.getNext();
            if (!secondArg.isString()) {
                diagnostic = EXPECTED_STRING_ERROR;
            } else if (secondArg.getNext() != null) {
                diagnostic = TOO_MANY_ARGUMENTS_ERROR;
            }
        }
        if (diagnostic != null) {
            this.compiler.report(JSError.make(methodName, diagnostic, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private void maybeAddNameToSymbolTable(Node name) {
        if (this.preprocessorSymbolTable != null) {
            this.preprocessorSymbolTable.addReference(name);
        }
    }
}

