/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AutoValue_PolyfillUsageFinder_PolyfillUsage;
import com.google.javascript.jscomp.GuardedCallback;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Splitter;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class PolyfillUsageFinder {
    private final AbstractCompiler compiler;
    private final Polyfills polyfills;
    private static final ImmutableSet<String> GLOBAL_NAMES = ImmutableSet.of("goog.global.", "window.", "goog$global.", "globalThis.");

    PolyfillUsageFinder(AbstractCompiler compiler, Polyfills polyfills) {
        this.polyfills = polyfills;
        this.compiler = compiler;
    }

    void traverseExcludingGuarded(Node root, Consumer<PolyfillUsage> polyfillConsumer) {
        NodeTraversal.traverse(this.compiler, root, new Traverser(this.compiler, polyfillConsumer, Guard.ONLY_UNGUARDED));
    }

    void traverseIncludingGuarded(Node root, Consumer<PolyfillUsage> polyfillConsumer) {
        NodeTraversal.traverse(this.compiler, root, new Traverser(this.compiler, polyfillConsumer, Guard.ALL));
    }

    void traverseOnlyGuarded(Node root, Consumer<PolyfillUsage> polyfillConsumer) {
        NodeTraversal.traverse(this.compiler, root, new Traverser(this.compiler, polyfillConsumer, Guard.ONLY_GUARDED));
    }

    @Nullable
    private PolyfillUsage maybeCreateStaticPolyfillUsageForGetPropChain(NodeTraversal traversal, Node getPropNode) {
        Preconditions.checkArgument(getPropNode.isGetProp() || getPropNode.isOptChainGetProp(), getPropNode);
        String lastComponent = getPropNode.getSecondChild().getString();
        if (!this.polyfills.suffixes.contains(lastComponent)) {
            return null;
        }
        ArrayDeque<String> components = new ArrayDeque<String>();
        components.addFirst(lastComponent);
        Node ownerNode = getPropNode.getFirstChild();
        while (ownerNode.isGetProp() || ownerNode.isOptChainGetProp()) {
            components.addFirst(ownerNode.getSecondChild().getString());
            ownerNode = ownerNode.getFirstChild();
        }
        if (!ownerNode.isName()) {
            return null;
        }
        String rootName = ownerNode.getString();
        components.addFirst(rootName);
        String fullName = String.join((CharSequence)".", components);
        String globalPrefix = PolyfillUsageFinder.findGlobalPrefix(fullName);
        if (globalPrefix != null) {
            Polyfill polyfill = (Polyfill)this.polyfills.statics.get(fullName.substring(globalPrefix.length()));
            if (polyfill != null) {
                return PolyfillUsage.createExplicit(polyfill, getPropNode, polyfill.nativeSymbol);
            }
        } else {
            Polyfill polyfill = (Polyfill)this.polyfills.statics.get(fullName);
            if (polyfill != null && traversal.getScope().getVar(rootName) == null) {
                return PolyfillUsage.createNonExplicit(polyfill, getPropNode, polyfill.nativeSymbol);
            }
        }
        return null;
    }

    @Nullable
    private static String findGlobalPrefix(String qualifiedName) {
        for (String global : GLOBAL_NAMES) {
            if (!qualifiedName.startsWith(global)) continue;
            return global;
        }
        return null;
    }

    private class Traverser
    extends GuardedCallback<String> {
        private final Consumer<PolyfillUsage> polyfillConsumer;
        private final Guard includeGuardedUsages;

        Traverser(AbstractCompiler compiler, Consumer<PolyfillUsage> polyfillConsumer, Guard includeGuardedUsages) {
            super(compiler);
            this.polyfillConsumer = polyfillConsumer;
            this.includeGuardedUsages = includeGuardedUsages;
        }

        @Override
        public void visitGuarded(NodeTraversal traversal, Node node, Node parent) {
            switch (node.getToken()) {
                case NAME: {
                    this.visitName(traversal, node);
                    break;
                }
                case GETPROP: 
                case OPTCHAIN_GETPROP: {
                    this.visitGetPropChain(traversal, node);
                    break;
                }
            }
        }

        private void visitName(NodeTraversal traversal, Node nameNode) {
            String name = nameNode.getString();
            Polyfill polyfill = (Polyfill)PolyfillUsageFinder.this.polyfills.statics.get(name);
            if (polyfill == null) {
                return;
            }
            if (traversal.getScope().getVar(name) != null) {
                return;
            }
            if (this.includeGuardedUsages.shouldInclude(this.isGuarded(name))) {
                this.polyfillConsumer.accept(PolyfillUsage.createNonExplicit(polyfill, nameNode, name));
            }
        }

        private void visitGetPropChain(NodeTraversal traversal, Node getPropNode) {
            PolyfillUsage staticPolyfillUsage = PolyfillUsageFinder.this.maybeCreateStaticPolyfillUsageForGetPropChain(traversal, getPropNode);
            if (staticPolyfillUsage != null) {
                if (this.includeGuardedUsages.shouldInclude(this.isGuarded(staticPolyfillUsage.name()))) {
                    this.polyfillConsumer.accept(staticPolyfillUsage);
                }
            } else {
                String propertyName = getPropNode.getSecondChild().getString();
                Collection methodPolyfills = PolyfillUsageFinder.this.polyfills.methods.get(propertyName);
                if (!methodPolyfills.isEmpty() && this.includeGuardedUsages.shouldInclude(this.isGuarded("." + propertyName))) {
                    for (Polyfill polyfill : methodPolyfills) {
                        this.polyfillConsumer.accept(PolyfillUsage.createNonExplicit(polyfill, getPropNode, propertyName));
                    }
                }
            }
        }
    }

    private static enum Guard {
        ONLY_GUARDED,
        ONLY_UNGUARDED,
        ALL;


        boolean shouldInclude(boolean isGuarded) {
            switch (this) {
                case ALL: {
                    return true;
                }
                case ONLY_GUARDED: {
                    return isGuarded;
                }
                case ONLY_UNGUARDED: {
                    return !isGuarded;
                }
            }
            throw new AssertionError();
        }
    }

    @AutoValue
    static abstract class PolyfillUsage {
        PolyfillUsage() {
        }

        abstract Polyfill polyfill();

        abstract Node node();

        abstract String name();

        abstract boolean isExplicitGlobal();

        private static PolyfillUsage createExplicit(Polyfill polyfill, Node node, String name) {
            return new AutoValue_PolyfillUsageFinder_PolyfillUsage(polyfill, node, name, true);
        }

        private static PolyfillUsage createNonExplicit(Polyfill polyfill, Node node, String name) {
            return new AutoValue_PolyfillUsageFinder_PolyfillUsage(polyfill, node, name, false);
        }
    }

    static final class Polyfills {
        private final ImmutableMultimap<String, Polyfill> methods;
        private final ImmutableMap<String, Polyfill> statics;
        private final ImmutableSet<String> suffixes;

        private Polyfills(ImmutableMultimap<String, Polyfill> methods, ImmutableMap<String, Polyfill> statics) {
            this.methods = methods;
            this.statics = statics;
            this.suffixes = ImmutableSet.copyOf(statics.keySet().stream().map(arg -> arg.substring(arg.lastIndexOf(46) + 1)).collect(Collectors.toList()));
        }

        static Polyfills fromTable(String table) {
            ImmutableMultimap.Builder<String, Polyfill> methods = ImmutableMultimap.builder();
            ImmutableMap.Builder<String, Polyfill> statics = ImmutableMap.builder();
            for (String line : Splitter.on('\n').omitEmptyStrings().split(table)) {
                List<String> tokens = Splitter.on(' ').omitEmptyStrings().splitToList(line.trim());
                if (tokens.size() == 1 && tokens.get(0).isEmpty()) continue;
                if (tokens.size() < 3) {
                    throw new IllegalArgumentException("Invalid table: too few tokens on line: " + line);
                }
                String symbol = tokens.get(0);
                boolean isPrototypeMethod = symbol.contains(".prototype.");
                String nativeVersionStr = tokens.get(1);
                String polyfillVersionStr = tokens.get(2);
                Polyfill polyfill = new Polyfill(symbol, nativeVersionStr, polyfillVersionStr, tokens.size() > 3 ? tokens.get(3) : "", isPrototypeMethod ? Polyfill.Kind.METHOD : Polyfill.Kind.STATIC);
                if (isPrototypeMethod) {
                    methods.put(symbol.replaceAll(".*\\.prototype\\.", ""), polyfill);
                    continue;
                }
                statics.put(symbol, polyfill);
            }
            return new Polyfills(methods.build(), statics.build());
        }
    }

    static final class Polyfill {
        final String nativeSymbol;
        final String nativeVersion;
        final String polyfillVersion;
        final String library;
        final Kind kind;

        Polyfill(String nativeSymbol, String nativeVersion, String polyfillVersion, String library, Kind kind) {
            this.nativeSymbol = nativeSymbol;
            this.nativeVersion = nativeVersion;
            this.polyfillVersion = polyfillVersion;
            this.library = library;
            this.kind = kind;
        }

        static enum Kind {
            STATIC,
            METHOD;

        }
    }
}

