/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.Es6SortedDependencies;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.LinkedListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Ordering;
import com.google.javascript.jscomp.jarjar.com.google.gson.JsonArray;
import com.google.javascript.jscomp.jarjar.com.google.gson.JsonObject;
import com.google.javascript.jscomp.jarjar.com.google.gson.JsonPrimitive;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class JSModuleGraph
implements Serializable {
    static final DiagnosticType WEAK_FILE_REACHABLE_FROM_ENTRY_POINT_ERROR = DiagnosticType.error("JSC_WEAK_FILE_REACHABLE_FROM_ENTRY_POINT_ERROR", "File strongly reachable from an entry point must not be weak: {0}");
    static final DiagnosticType EXPLICIT_WEAK_ENTRY_POINT_ERROR = DiagnosticType.error("JSC_EXPLICIT_WEAK_ENTRY_POINT_ERROR", "Explicit entry point input must not be weak: {0}");
    static final DiagnosticType IMPLICIT_WEAK_ENTRY_POINT_ERROR = DiagnosticType.warning("JSC_IMPLICIT_WEAK_ENTRY_POINT_ERROR", "Implicit entry point input should not be weak: {0}");
    private final JSModule[] modules;
    private final BitSet[] selfPlusTransitiveDeps;
    private final int[] subtreeSize;
    private final List<List<JSModule>> modulesByDepth;
    private final Map<JSModule, Set<JSModule>> dependencyMap = new IdentityHashMap<JSModule, Set<JSModule>>();

    public JSModuleGraph(JSModule[] modulesInDepOrder) {
        this(Arrays.asList(modulesInDepOrder));
    }

    public JSModuleGraph(List<JSModule> modulesInDepOrder) {
        Preconditions.checkState(!modulesInDepOrder.isEmpty());
        modulesInDepOrder = this.makeWeakModule(modulesInDepOrder);
        this.modules = new JSModule[modulesInDepOrder.size()];
        for (int moduleIndex = 0; moduleIndex < this.modules.length; ++moduleIndex) {
            JSModule module = modulesInDepOrder.get(moduleIndex);
            Preconditions.checkState(module.getIndex() == -1, "Module index already set: %s", (Object)module);
            module.setIndex(moduleIndex);
            this.modules[moduleIndex] = module;
        }
        this.modulesByDepth = this.initModulesByDepth();
        this.selfPlusTransitiveDeps = this.initTransitiveDepsBitSets();
        this.subtreeSize = this.initSubtreeSize();
        JSModuleGraph.moveMarkedWeakSources(this.getModuleByName("$weak$"), this.getAllInputs());
    }

    private List<List<JSModule>> initModulesByDepth() {
        ArrayList<List<JSModule>> tmpModulesByDepth = new ArrayList<List<JSModule>>();
        for (int moduleIndex = 0; moduleIndex < this.modules.length; ++moduleIndex) {
            JSModule module = this.modules[moduleIndex];
            Preconditions.checkState(module.getDepth() == -1, "Module depth already set: %s", (Object)module);
            int depth = 0;
            for (JSModule dep : module.getDependencies()) {
                int depDepth = dep.getDepth();
                if (depDepth < 0) {
                    throw new ModuleDependenceException(SimpleFormat.format("Modules not in dependency order: %s preceded %s", module.getName(), dep.getName()), module, dep);
                }
                depth = Math.max(depth, depDepth + 1);
            }
            module.setDepth(depth);
            if (depth == tmpModulesByDepth.size()) {
                tmpModulesByDepth.add(new ArrayList());
            }
            ((List)tmpModulesByDepth.get(depth)).add(module);
        }
        return tmpModulesByDepth;
    }

    private List<JSModule> makeWeakModule(List<JSModule> modulesInDepOrder) {
        boolean hasWeakModule = false;
        for (JSModule module : modulesInDepOrder) {
            if (!module.getName().equals("$weak$")) continue;
            hasWeakModule = true;
            HashSet<JSModule> allOtherModules = new HashSet<JSModule>(modulesInDepOrder);
            allOtherModules.remove(module);
            Preconditions.checkState(module.getAllDependencies().containsAll(allOtherModules), "A weak module already exists but it does not depend on every other module.");
            Preconditions.checkState(module.getAllDependencies().size() == allOtherModules.size(), "The weak module cannot have extra dependencies.");
            break;
        }
        if (hasWeakModule) {
            ArrayList<String> misplacedWeakFiles = new ArrayList<String>();
            ArrayList<String> misplacedStrongFiles = new ArrayList<String>();
            for (JSModule module : modulesInDepOrder) {
                boolean isWeakModule = module.getName().equals("$weak$");
                for (CompilerInput input : module.getInputs()) {
                    if (isWeakModule && !input.getSourceFile().isWeak()) {
                        misplacedStrongFiles.add(input.getSourceFile().getName());
                        continue;
                    }
                    if (isWeakModule || !input.getSourceFile().isWeak()) continue;
                    misplacedWeakFiles.add(input.getSourceFile().getName() + " (in module " + module.getName() + ")");
                }
            }
            if (!misplacedStrongFiles.isEmpty() || !misplacedWeakFiles.isEmpty()) {
                StringBuilder sb = new StringBuilder("A weak module exists but some sources are misplaced.");
                if (!misplacedStrongFiles.isEmpty()) {
                    sb.append("\nFound these strong sources in the weak module:\n  ").append(Joiner.on("\n  ").join(misplacedStrongFiles));
                }
                if (!misplacedWeakFiles.isEmpty()) {
                    sb.append("\nFound these weak sources in other modules:\n  ").append(Joiner.on("\n  ").join(misplacedWeakFiles));
                }
                throw new IllegalStateException(sb.toString());
            }
        } else {
            JSModule weakModule = new JSModule("$weak$");
            for (JSModule module : modulesInDepOrder) {
                weakModule.addDependency(module);
            }
            modulesInDepOrder = new ArrayList<JSModule>(modulesInDepOrder);
            modulesInDepOrder.add(weakModule);
        }
        return modulesInDepOrder;
    }

    private BitSet[] initTransitiveDepsBitSets() {
        BitSet[] array = new BitSet[this.modules.length];
        for (int moduleIndex = 0; moduleIndex < this.modules.length; ++moduleIndex) {
            BitSet selfPlusTransitiveDeps;
            JSModule module = this.modules[moduleIndex];
            array[moduleIndex] = selfPlusTransitiveDeps = new BitSet(moduleIndex + 1);
            selfPlusTransitiveDeps.set(moduleIndex);
            for (JSModule dep : module.getDependencies()) {
                selfPlusTransitiveDeps.or(array[dep.getIndex()]);
            }
        }
        return array;
    }

    private int[] initSubtreeSize() {
        int[] subtreeSize = new int[this.modules.length];
        for (int dependentIndex = 0; dependentIndex < this.modules.length; ++dependentIndex) {
            BitSet dependencies = this.selfPlusTransitiveDeps[dependentIndex];
            int requiredIndex = dependentIndex;
            while (requiredIndex >= 0) {
                int n = requiredIndex;
                subtreeSize[n] = subtreeSize[n] + 1;
                requiredIndex = dependencies.previousSetBit(requiredIndex - 1);
            }
        }
        return subtreeSize;
    }

    Iterable<CompilerInput> getAllInputs() {
        return Iterables.concat(Iterables.transform(Arrays.asList(this.modules), JSModule::getInputs));
    }

    int getInputCount() {
        int count = 0;
        for (JSModule module : this.modules) {
            count += module.getInputCount();
        }
        return count;
    }

    Iterable<JSModule> getAllModules() {
        return Arrays.asList(this.modules);
    }

    @Nullable
    JSModule getModuleByName(String name) {
        for (JSModule m : this.modules) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    Map<String, JSModule> getModulesByName() {
        HashMap<String, JSModule> result = new HashMap<String, JSModule>();
        for (JSModule m : this.modules) {
            result.put(m.getName(), m);
        }
        return result;
    }

    int getModuleCount() {
        return this.modules.length;
    }

    JSModule getRootModule() {
        return (JSModule)Iterables.getOnlyElement((Iterable)this.modulesByDepth.get(0));
    }

    @GwtIncompatible(value="com.google.javascript.jscomp.jarjar.com.google.gson")
    JsonArray toJson() {
        JsonArray modules = new JsonArray();
        for (JSModule module : this.getAllModules()) {
            JsonObject node = new JsonObject();
            node.add("name", new JsonPrimitive(module.getName()));
            JsonArray deps = new JsonArray();
            node.add("dependencies", deps);
            for (JSModule jSModule : module.getDependencies()) {
                deps.add(new JsonPrimitive(jSModule.getName()));
            }
            JsonArray transitiveDeps = new JsonArray();
            node.add("transitive-dependencies", transitiveDeps);
            for (JSModule m3 : this.getTransitiveDepsDeepestFirst(module)) {
                transitiveDeps.add(new JsonPrimitive(m3.getName()));
            }
            JsonArray jsonArray = new JsonArray();
            node.add("inputs", jsonArray);
            for (CompilerInput input : module.getInputs()) {
                jsonArray.add(new JsonPrimitive(input.getSourceFile().getOriginalPath()));
            }
            modules.add(node);
        }
        return modules;
    }

    public boolean dependsOn(JSModule src, JSModule m) {
        return src != m && this.selfPlusTransitiveDeps[src.getIndex()].get(m.getIndex());
    }

    public JSModule getSmallestCoveringSubtree(JSModule parentTree, BitSet dependentModules) {
        int parentTreeIndex;
        Preconditions.checkState(!dependentModules.isEmpty());
        int minDependentModuleIndex = this.modules.length;
        BitSet candidates = new BitSet(this.modules.length);
        candidates.set(0, this.modules.length, true);
        int dependentIndex = dependentModules.nextSetBit(0);
        while (dependentIndex >= 0) {
            minDependentModuleIndex = Math.min(minDependentModuleIndex, dependentIndex);
            candidates.and(this.selfPlusTransitiveDeps[dependentIndex]);
            dependentIndex = dependentModules.nextSetBit(dependentIndex + 1);
        }
        Preconditions.checkState(!candidates.isEmpty(), "No common dependency found for %s", (Object)dependentModules);
        int bestCandidateIndex = parentTreeIndex = parentTree.getIndex();
        int candidateIndex = candidates.previousSetBit(minDependentModuleIndex);
        while (candidateIndex >= 0) {
            BitSet candidatePlusTransitiveDeps = this.selfPlusTransitiveDeps[candidateIndex];
            if (candidatePlusTransitiveDeps.get(parentTreeIndex)) {
                candidates.andNot(candidatePlusTransitiveDeps);
                if (this.subtreeSize[candidateIndex] < this.subtreeSize[bestCandidateIndex]) {
                    bestCandidateIndex = candidateIndex;
                }
            }
            candidateIndex = candidates.previousSetBit(candidateIndex - 1);
        }
        return this.modules[bestCandidateIndex];
    }

    JSModule getDeepestCommonDependency(JSModule m1, JSModule m2) {
        int m1Depth = m1.getDepth();
        int m2Depth = m2.getDepth();
        for (int depth = Math.min(m1Depth, m2Depth) - 1; depth >= 0; --depth) {
            List<JSModule> modulesAtDepth = this.modulesByDepth.get(depth);
            for (int i = modulesAtDepth.size() - 1; i >= 0; --i) {
                JSModule m = modulesAtDepth.get(i);
                if (!this.dependsOn(m1, m) || !this.dependsOn(m2, m)) continue;
                return m;
            }
        }
        return null;
    }

    public JSModule getDeepestCommonDependencyInclusive(JSModule m1, JSModule m2) {
        if (m2 == m1 || this.dependsOn(m2, m1)) {
            return m1;
        }
        if (this.dependsOn(m1, m2)) {
            return m2;
        }
        return this.getDeepestCommonDependency(m1, m2);
    }

    public JSModule getDeepestCommonDependencyInclusive(Collection<JSModule> modules) {
        Iterator<JSModule> iter = modules.iterator();
        JSModule dep = iter.next();
        while (iter.hasNext()) {
            dep = this.getDeepestCommonDependencyInclusive(dep, iter.next());
        }
        return dep;
    }

    @VisibleForTesting
    List<JSModule> getTransitiveDepsDeepestFirst(JSModule m) {
        return InverseDepthComparator.INSTANCE.sortedCopy(this.getTransitiveDeps(m));
    }

    private Set<JSModule> getTransitiveDeps(JSModule m) {
        Set deps = this.dependencyMap.computeIfAbsent(m, JSModule::getAllDependencies);
        return deps;
    }

    private static void moveMarkedWeakSources(JSModule weakModule, Iterable<CompilerInput> inputs) {
        Preconditions.checkNotNull(weakModule);
        ImmutableList<CompilerInput> allInputs = ImmutableList.copyOf(inputs);
        for (CompilerInput i : allInputs) {
            JSModule existingModule;
            if (!i.getSourceFile().isWeak() || (existingModule = i.getModule()) == weakModule) continue;
            if (existingModule != null) {
                existingModule.remove(i);
            }
            weakModule.add(i);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ImmutableList<CompilerInput> manageDependencies(AbstractCompiler compiler, DependencyOptions dependencyOptions) throws SortedDependencies.MissingProvideException, MissingModuleException {
        ImmutableList<CompilerInput> originalInputs = ImmutableList.copyOf(this.getAllInputs());
        Es6SortedDependencies<CompilerInput> sorter = new Es6SortedDependencies<CompilerInput>(originalInputs);
        Set<CompilerInput> entryPointInputs = this.createEntryPointInputs(compiler, dependencyOptions, this.getAllInputs(), sorter);
        HashMap<String, Set<CompilerInput>> inputsByProvide = new HashMap<String, Set<CompilerInput>>();
        for (CompilerInput input : originalInputs) {
            for (String provide : input.getKnownProvides()) {
                inputsByProvide.computeIfAbsent(provide, k -> new LinkedHashSet());
                ((Set)inputsByProvide.get(provide)).add(input);
            }
            Iterator<DependencyInfo.Base> moduleName = input.getPath().toModuleName();
            inputsByProvide.computeIfAbsent((String)((Object)moduleName), (Function<String, Set<CompilerInput>>)((Function<String, Set>)k -> new LinkedHashSet()));
            ((Set)inputsByProvide.get(moduleName)).add(input);
        }
        for (CompilerInput input : originalInputs) {
            for (String require : input.getDynamicRequires()) {
                if (!inputsByProvide.containsKey(require)) continue;
                entryPointInputs.addAll((Collection)inputsByProvide.get(require));
            }
        }
        List<CompilerInput> absoluteOrder = sorter.getStrongDependenciesOf(originalInputs, dependencyOptions.shouldSort());
        LinkedListMultimap<JSModule, CompilerInput> entryPointInputsPerModule = LinkedListMultimap.create();
        for (CompilerInput input : entryPointInputs) {
            JSModule module = input.getModule();
            Preconditions.checkNotNull(module);
            entryPointInputsPerModule.put(module, input);
        }
        for (JSModule module : this.getAllModules()) {
            module.removeAll();
        }
        List<Object> orderedInputs = new ArrayList();
        HashSet<CompilerInput> reachedInputs = new HashSet<CompilerInput>();
        for (JSModule module : entryPointInputsPerModule.keySet()) {
            void var13_13;
            if (dependencyOptions.shouldSort() && dependencyOptions.shouldPrune()) {
                ArrayList<CompilerInput> arrayList = new ArrayList<CompilerInput>();
                HashSet<CompilerInput> inputsNotYetReached = new HashSet<CompilerInput>(originalInputs);
                for (CompilerInput entryPoint : entryPointInputsPerModule.get((Object)module)) {
                    arrayList.addAll(this.getDepthFirstDependenciesOf(entryPoint, (Set<CompilerInput>)inputsNotYetReached, inputsByProvide));
                }
                for (CompilerInput orderedInput : arrayList) {
                    if (!reachedInputs.add(orderedInput)) continue;
                    orderedInputs.add(orderedInput);
                }
            } else {
                List<CompilerInput> list = sorter.getStrongDependenciesOf((List<CompilerInput>)entryPointInputsPerModule.get((Object)module), dependencyOptions.shouldSort());
            }
            for (CompilerInput input : var13_13) {
                JSModule oldModule;
                if (dependencyOptions.shouldPrune() && input.getSourceFile().isWeak() && !entryPointInputs.contains(input)) {
                    compiler.report(JSError.make(WEAK_FILE_REACHABLE_FROM_ENTRY_POINT_ERROR, input.getSourceFile().getName()));
                }
                if ((oldModule = input.getModule()) == null) {
                    input.setModule(module);
                    continue;
                }
                input.setModule(null);
                input.setModule(this.getDeepestCommonDependencyInclusive(oldModule, module));
            }
        }
        if (!dependencyOptions.shouldSort() || !dependencyOptions.shouldPrune() || entryPointInputsPerModule.isEmpty()) {
            orderedInputs = absoluteOrder;
        }
        JSModule weakModule = this.getModuleByName("$weak$");
        Preconditions.checkNotNull(weakModule);
        if (dependencyOptions.shouldPrune()) {
            List weakInputs = sorter.getSortedWeakDependenciesOf(orderedInputs);
            Iterator iterator = weakInputs.iterator();
            while (iterator.hasNext()) {
                CompilerInput i = (CompilerInput)iterator.next();
                Preconditions.checkState(i.getModule() == null);
                i.getSourceFile().setKind(StaticSourceFile.SourceKind.WEAK);
                i.setModule(weakModule);
                weakModule.add(i);
            }
        } else {
            JSModuleGraph.moveMarkedWeakSources(weakModule, originalInputs);
        }
        for (CompilerInput compilerInput : orderedInputs) {
            JSModule module = compilerInput.getModule();
            if (module == null || module.getInputs().contains(compilerInput)) continue;
            module.add(compilerInput);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (JSModule module : this.getAllModules()) {
            result.addAll(module.getInputs());
        }
        return result.build();
    }

    private List<CompilerInput> getDepthFirstDependenciesOf(CompilerInput rootInput, Set<CompilerInput> unreachedInputs, Map<String, Set<CompilerInput>> inputsByProvide) {
        ArrayList<CompilerInput> orderedInputs = new ArrayList<CompilerInput>();
        if (!unreachedInputs.remove(rootInput)) {
            return orderedInputs;
        }
        for (String importedNamespace : rootInput.getRequiredSymbols()) {
            if (!inputsByProvide.containsKey(importedNamespace)) continue;
            for (CompilerInput input : inputsByProvide.get(importedNamespace)) {
                if (!unreachedInputs.contains(input)) continue;
                orderedInputs.addAll(this.getDepthFirstDependenciesOf(input, unreachedInputs, inputsByProvide));
            }
        }
        orderedInputs.add(rootInput);
        return orderedInputs;
    }

    private Set<CompilerInput> createEntryPointInputs(AbstractCompiler compiler, DependencyOptions dependencyOptions, Iterable<CompilerInput> inputs, SortedDependencies<CompilerInput> sorter) throws MissingModuleException, SortedDependencies.MissingProvideException {
        LinkedHashSet<CompilerInput> entryPointInputs = new LinkedHashSet<CompilerInput>();
        Map<String, JSModule> modulesByName = this.getModulesByName();
        if (dependencyOptions.shouldPrune()) {
            CompilerInput baseJs = sorter.maybeGetInputProviding("goog");
            if (baseJs != null) {
                entryPointInputs.add(baseJs);
            }
            if (!dependencyOptions.shouldDropMoochers()) {
                for (CompilerInput entryPointInput : sorter.getInputsWithoutProvides()) {
                    if (entryPointInput.getSourceFile().isWeak()) {
                        compiler.report(JSError.make(IMPLICIT_WEAK_ENTRY_POINT_ERROR, entryPointInput.getSourceFile().getName()));
                        continue;
                    }
                    entryPointInputs.add(entryPointInput);
                }
            }
            for (ModuleIdentifier entryPoint : dependencyOptions.getEntryPoints()) {
                CompilerInput entryPointInput = null;
                try {
                    if (entryPoint.getClosureNamespace().equals(entryPoint.getModuleName())) {
                        entryPointInput = sorter.maybeGetInputProviding(entryPoint.getClosureNamespace());
                        if (entryPointInput == null) {
                            entryPointInput = sorter.getInputProviding(entryPoint.getName());
                        }
                    } else {
                        JSModule module = modulesByName.get(entryPoint.getModuleName());
                        if (module == null) {
                            throw new MissingModuleException(entryPoint.getModuleName());
                        }
                        entryPointInput = sorter.getInputProviding(entryPoint.getClosureNamespace());
                        entryPointInput.overrideModule(module);
                    }
                }
                catch (SortedDependencies.MissingProvideException e) {
                    throw new SortedDependencies.MissingProvideException(entryPoint.getName(), e);
                }
                if (entryPointInput.getSourceFile().isWeak()) {
                    compiler.report(JSError.make(EXPLICIT_WEAK_ENTRY_POINT_ERROR, entryPointInput.getSourceFile().getName()));
                    continue;
                }
                entryPointInputs.add(entryPointInput);
            }
        } else {
            Iterables.addAll(entryPointInputs, inputs);
        }
        return entryPointInputs;
    }

    LinkedDirectedGraph<JSModule, String> toGraphvizGraph() {
        LinkedDirectedGraph<JSModule, String> graphViz = LinkedDirectedGraph.create();
        for (JSModule module : this.getAllModules()) {
            graphViz.createNode((Object)module);
            for (JSModule dep : module.getDependencies()) {
                graphViz.createNode((Object)dep);
                graphViz.connect(module, "->", dep);
            }
        }
        return graphViz;
    }

    private static int depthCompare(JSModule m1, JSModule m2) {
        int d2;
        if (m1 == m2) {
            return 0;
        }
        int d1 = m1.getDepth();
        return d1 < (d2 = m2.getDepth()) ? -1 : (d2 == d1 ? m1.getName().compareTo(m2.getName()) : 1);
    }

    public static class MissingModuleException
    extends Exception {
        MissingModuleException(String moduleName) {
            super(moduleName);
        }
    }

    protected static class ModuleDependenceException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private final JSModule module;
        private final JSModule dependentModule;

        protected ModuleDependenceException(String message, JSModule module, JSModule dependentModule) {
            super(message);
            this.module = module;
            this.dependentModule = dependentModule;
        }

        public JSModule getModule() {
            return this.module;
        }

        public JSModule getDependentModule() {
            return this.dependentModule;
        }
    }

    private static final class InverseDepthComparator
    extends Ordering<JSModule> {
        static final InverseDepthComparator INSTANCE = new InverseDepthComparator();

        private InverseDepthComparator() {
        }

        @Override
        public int compare(JSModule m1, JSModule m2) {
            return JSModuleGraph.depthCompare(m2, m1);
        }
    }
}

