/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;

public class J2clChecksPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType J2CL_REFERENCE_EQUALITY = DiagnosticType.warning("JSC_J2CL_REFERENCE_EQUALITY", "Reference equality may not be used with the specified type: {0}");
    static final ImmutableMap<String, String> REFERENCE_EQUALITY_TYPE_PATTERNS = ImmutableMap.of("java.lang.Integer", "java/lang/Integer.impl.java.js", "java.lang.Float", "java/lang/Float.impl.java.js", "goog.math.Long", "javascript/closure/math/long.js");
    private final AbstractCompiler compiler;

    J2clChecksPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void visit(NodeTraversal unused, Node n, Node parent) {
        for (String typeName : REFERENCE_EQUALITY_TYPE_PATTERNS.keySet()) {
            this.checkReferenceEquality(n, typeName, REFERENCE_EQUALITY_TYPE_PATTERNS.get(typeName));
        }
    }

    private void checkReferenceEquality(Node n, String typeName, String fileName) {
        if (n.getToken() == Token.SHEQ || n.getToken() == Token.EQ || n.getToken() == Token.SHNE || n.isNE()) {
            boolean hasNullType;
            JSType firstJsType = n.getFirstChild().getJSType();
            JSType lastJsType = n.getLastChild().getJSType();
            boolean hasType = this.isType(firstJsType, fileName) || this.isType(lastJsType, fileName);
            boolean bl = hasNullType = this.isNullType(firstJsType) || this.isNullType(lastJsType);
            if (hasType && !hasNullType) {
                this.compiler.report(JSError.make(n, J2CL_REFERENCE_EQUALITY, typeName));
            }
        }
    }

    private boolean isNullType(JSType jsType) {
        if (jsType == null) {
            return false;
        }
        return jsType.isNullType() || jsType.isVoidType();
    }

    private boolean isType(JSType jsType, String fileName) {
        if (jsType == null) {
            return false;
        }
        if ((jsType = jsType.restrictByNotNullOrUndefined()).toMaybeObjectType() == null) {
            return false;
        }
        String sourceName = this.getSourceName(jsType);
        return sourceName != null && sourceName.endsWith(fileName);
    }

    private String getSourceName(JSType jsType) {
        FunctionType constructor = jsType.toMaybeObjectType().getConstructor();
        if (constructor == null) {
            return "";
        }
        return NodeUtil.getSourceName(constructor.getSource());
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }
}

