/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableCollection;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimap;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.LinkedHashSet;
import java.util.Objects;

public final class InvalidatingTypes {
    private final ImmutableSet<JSType> types;
    private final boolean allowEnums;
    private final boolean allowScalars;

    private InvalidatingTypes(Builder builder, ImmutableSet<JSType> types) {
        this.types = types;
        this.allowEnums = builder.allowEnums;
        this.allowScalars = builder.allowScalars;
    }

    public boolean isInvalidating(JSType type) {
        if (type == null || type.isUnknownType() || type.isEmptyType()) {
            return true;
        }
        if (type.isUnionType() && (type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.getUnionMembers()) {
                if (!this.isInvalidating(alt)) continue;
                return true;
            }
            return false;
        }
        ObjectType objType = type.toMaybeObjectType();
        if (objType == null) {
            return !this.allowScalars;
        }
        if (objType.isTemplatizedType()) {
            objType = objType.toMaybeTemplatizedType().getReferencedType();
        }
        return this.types.contains(objType) || InvalidatingTypes.isAmbiguousOrStructuralType(objType) || !this.allowEnums && objType.isEnumType() || !this.allowScalars && objType.isBoxableScalar();
    }

    private static boolean isAmbiguousOrStructuralType(ObjectType type) {
        if (type.isEnumType()) {
            return false;
        }
        if (type.isEnumElementType()) {
            ObjectType primitive = type.toMaybeEnumElementType().getPrimitiveType().toMaybeObjectType();
            return primitive == null || InvalidatingTypes.isAmbiguousOrStructuralType(primitive);
        }
        if (type.isFunctionType()) {
            return !type.isNominalConstructorOrInterface() || type.toMaybeFunctionType().isAmbiguousConstructor();
        }
        if (type.isFunctionPrototypeType()) {
            FunctionType ownerFunction = type.getOwnerFunction();
            return ownerFunction == null || !ownerFunction.isNominalConstructorOrInterface() || ownerFunction.isAmbiguousConstructor();
        }
        if (type.isInstanceType()) {
            FunctionType ctor = type.getConstructor();
            return ctor == null || ctor.isAmbiguousConstructor();
        }
        return true;
    }

    public static final class Builder {
        private final JSTypeRegistry registry;
        @Nullable
        private Multimap<JSType, Node> invalidationMap;
        private final LinkedHashSet<TypeMismatch> mismatches = new LinkedHashSet();
        private boolean allowEnums = false;
        private boolean allowScalars = false;
        private final boolean alsoInvalidateRelatedTypes = true;
        private ImmutableSet.Builder<JSType> types;

        public Builder(JSTypeRegistry registry) {
            this.registry = registry;
        }

        public InvalidatingTypes build() {
            Preconditions.checkState(this.types == null);
            this.types = ImmutableSet.builder();
            this.types.add(new JSType[]{this.registry.getNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE), this.registry.getNativeType(JSTypeNative.FUNCTION_TYPE), this.registry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_PROTOTYPE), this.registry.getNativeType(JSTypeNative.OBJECT_TYPE), this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), this.registry.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE)});
            for (TypeMismatch mismatch : this.mismatches) {
                this.addTypeWithReason(mismatch.getFound(), mismatch.getLocation());
                this.addTypeWithReason(mismatch.getRequired(), mismatch.getLocation());
            }
            ImmutableCollection types = this.types.build();
            this.types = null;
            return new InvalidatingTypes(this, (ImmutableSet)types);
        }

        public Builder writeInvalidationsInto(@Nullable Multimap<JSType, Node> invalidationMap) {
            this.invalidationMap = invalidationMap;
            return this;
        }

        public Builder allowEnums() {
            this.allowEnums = true;
            return this;
        }

        public Builder allowScalars() {
            this.allowScalars = true;
            return this;
        }

        public Builder addAllTypeMismatches(Iterable<TypeMismatch> mismatches) {
            mismatches.forEach(this.mismatches::add);
            return this;
        }

        private void addTypeWithReason(JSType type, Node location) {
            if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
                for (JSType alt : type.getUnionMembers()) {
                    this.addTypeWithReason(alt, location);
                }
                return;
            }
            Preconditions.checkState(!type.isUnionType(), type);
            Objects.requireNonNull(this);
            if (type.isEnumElementType()) {
                this.recordTypeWithReason(type.getEnumeratedTypeOfEnumElement(), location);
                return;
            }
            this.recordTypeWithReason(type, location);
            ObjectType objType = type.toMaybeObjectType();
            if (objType == null) {
                return;
            }
            this.recordTypeWithReason(objType.getImplicitPrototype(), location);
            if (objType.isConstructor()) {
                this.recordTypeWithReason(objType.toMaybeFunctionType().getInstanceType(), location);
            } else if (objType.isInstanceType()) {
                this.recordTypeWithReason(objType.getConstructor(), location);
            }
        }

        private void recordTypeWithReason(JSType type, Node location) {
            if (type == null || !type.isObjectType()) {
                return;
            }
            if (type.isTemplatizedType()) {
                type = type.toMaybeTemplatizedType().getReferencedType();
            }
            this.types.add((Object)type);
            if (this.invalidationMap != null) {
                this.invalidationMap.put(type, location);
            }
        }
    }
}

