/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.InvocationsCallback;
import com.google.javascript.jscomp.MethodCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

class InlineSimpleMethods
extends MethodCompilerPass {
    private static final Logger logger = Logger.getLogger(InlineSimpleMethods.class.getName());
    private final AstAnalyzer astAnalyzer;
    static final MethodCompilerPass.SignatureStore DUMMY_SIGNATURE_STORE = new MethodCompilerPass.SignatureStore(){

        @Override
        public void addSignature(String functionName, Node functionNode, String sourceFile) {
        }

        @Override
        public void removeSignature(String functionName) {
        }

        @Override
        public void reset() {
        }
    };

    InlineSimpleMethods(AbstractCompiler compiler) {
        super(compiler);
        this.astAnalyzer = compiler.getAstAnalyzer();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.compiler.getLifeCycleStage().isNormalized(), this.compiler.getLifeCycleStage());
        super.process(externs, root);
    }

    @Override
    NodeTraversal.Callback getActingCallback() {
        return new InlineTrivialAccessors();
    }

    private static boolean isPropertyTree(Node expectedGetprop) {
        if (!expectedGetprop.isGetProp()) {
            return false;
        }
        Node getpropLhs = expectedGetprop.getFirstChild();
        return getpropLhs.isThis() || InlineSimpleMethods.isPropertyTree(getpropLhs);
    }

    private static void replaceThis(Node expectedGetprop, Node replacement) {
        Node leftChild = expectedGetprop.getFirstChild();
        if (leftChild.isThis()) {
            expectedGetprop.replaceChild(leftChild, replacement);
        } else {
            InlineSimpleMethods.replaceThis(leftChild, replacement);
        }
    }

    private static Node returnedExpression(Node fn) {
        Node expectedBlock = NodeUtil.getFunctionBody(fn);
        if (!expectedBlock.hasOneChild()) {
            return null;
        }
        Node expectedReturn = expectedBlock.getFirstChild();
        if (!expectedReturn.isReturn()) {
            return null;
        }
        if (!expectedReturn.hasOneChild()) {
            return null;
        }
        return expectedReturn.getOnlyChild();
    }

    private static boolean isEmptyMethod(Node fn) {
        return NodeUtil.isEmptyBlock(NodeUtil.getFunctionBody(fn));
    }

    private boolean allDefinitionsEquivalent(Collection<Node> definitions) {
        Node first = null;
        for (Node n : definitions) {
            if (first == null) {
                first = n;
                continue;
            }
            if (this.compiler.areNodesEqualForInlining(first, n)) continue;
            return false;
        }
        return true;
    }

    private void inlinePropertyReturn(Node parent, Node call, Node returnedValue) {
        Node getProp = returnedValue.cloneTree();
        InlineSimpleMethods.replaceThis(getProp, call.getFirstChild().removeFirstChild());
        parent.replaceChild(call, getProp);
        this.compiler.reportChangeToEnclosingScope(getProp);
    }

    private void inlineConstReturn(Node parent, Node call, Node returnedValue) {
        Node retValue = returnedValue.cloneTree();
        parent.replaceChild(call, retValue);
        this.compiler.reportChangeToEnclosingScope(retValue);
    }

    private void inlineEmptyMethod(NodeTraversal t, Node parent, Node call) {
        if (NodeUtil.isExprCall(parent)) {
            parent.replaceWith(IR.empty());
            NodeUtil.markFunctionsDeleted(parent, this.compiler);
        } else {
            Node srcLocation = call;
            parent.replaceChild(call, NodeUtil.newUndefinedNode(srcLocation));
            NodeUtil.markFunctionsDeleted(call, this.compiler);
        }
        t.reportCodeChange();
    }

    private boolean argsMayHaveSideEffects(Node call) {
        for (Node currentChild = call.getSecondChild(); currentChild != null; currentChild = currentChild.getNext()) {
            if (!this.astAnalyzer.mayHaveSideEffects(currentChild)) continue;
            return true;
        }
        return false;
    }

    @Override
    MethodCompilerPass.SignatureStore getSignatureStore() {
        return DUMMY_SIGNATURE_STORE;
    }

    private class InlineTrivialAccessors
    extends InvocationsCallback {
        private InlineTrivialAccessors() {
        }

        @Override
        void visit(NodeTraversal t, Node callNode, Node parent, String callName) {
            if (InlineSimpleMethods.this.externMethods.contains(callName) || InlineSimpleMethods.this.nonMethodProperties.contains(callName)) {
                return;
            }
            Collection definitions = InlineSimpleMethods.this.methodDefinitions.get(callName);
            if (definitions == null || definitions.isEmpty()) {
                return;
            }
            Node firstDefinition = (Node)definitions.iterator().next();
            if (definitions.size() == 1 || InlineSimpleMethods.this.allDefinitionsEquivalent(definitions)) {
                if (!InlineSimpleMethods.this.argsMayHaveSideEffects(callNode)) {
                    Node returned = InlineSimpleMethods.returnedExpression(firstDefinition);
                    if (returned != null) {
                        if (InlineSimpleMethods.isPropertyTree(returned)) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Inlining property accessor: " + callName);
                            }
                            InlineSimpleMethods.this.inlinePropertyReturn(parent, callNode, returned);
                        } else if (NodeUtil.isLiteralValue(returned, false) && !InlineSimpleMethods.this.astAnalyzer.mayHaveSideEffects(callNode.getFirstChild())) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Inlining constant accessor: " + callName);
                            }
                            InlineSimpleMethods.this.inlineConstReturn(parent, callNode, returned);
                        }
                    } else if (InlineSimpleMethods.isEmptyMethod(firstDefinition) && !InlineSimpleMethods.this.astAnalyzer.mayHaveSideEffects(callNode.getFirstChild())) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Inlining empty method: " + callName);
                        }
                        InlineSimpleMethods.this.inlineEmptyMethod(t, parent, callNode);
                    }
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Method '" + callName + "' has conflicting definitions.");
            }
        }
    }
}

