/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.ArrayList;
import java.util.List;

public final class Es6RewriteRestAndSpread
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType BAD_REST_PARAMETER_ANNOTATION = DiagnosticType.warning("BAD_REST_PARAMETER_ANNOTATION", "Missing \"...\" in type annotation for rest parameter.");
    private static final String REST_INDEX = "$jscomp$restIndex";
    private static final String REST_PARAMS = "$jscomp$restParams";
    private static final String FRESH_SPREAD_VAR = "$jscomp$spread$args";
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.REST_PARAMETERS, FeatureSet.Feature.SPREAD_EXPRESSIONS);
    private final AbstractCompiler compiler;
    private final JSType arrayType;
    private final JSType boolType;
    private final JSType concatFnType;
    private final JSType nullType;
    private final JSType numberType;
    private final JSType functionFunctionType;

    public Es6RewriteRestAndSpread(AbstractCompiler compiler) {
        this.compiler = compiler;
        if (compiler.hasTypeCheckingRun()) {
            JSTypeRegistry registry = compiler.getTypeRegistry();
            this.arrayType = registry.getNativeType(JSTypeNative.ARRAY_TYPE);
            this.boolType = registry.getNativeType(JSTypeNative.BOOLEAN_TYPE);
            this.concatFnType = this.arrayType.findPropertyType("concat");
            this.nullType = registry.getNativeType(JSTypeNative.NULL_TYPE);
            this.numberType = registry.getNativeType(JSTypeNative.NUMBER_TYPE);
            this.functionFunctionType = registry.getNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
        } else {
            this.arrayType = null;
            this.boolType = null;
            this.concatFnType = null;
            this.nullType = null;
            this.numberType = null;
            this.functionFunctionType = null;
        }
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void visit(NodeTraversal traversal, Node current, Node parent) {
        block0 : switch (current.getToken()) {
            case ITER_REST: {
                this.visitRestParam(traversal, current, parent);
                break;
            }
            case ARRAYLIT: 
            case NEW: 
            case CALL: {
                for (Node child : current.children()) {
                    if (!child.isSpread()) continue;
                    this.visitArrayLitOrCallWithSpread(current);
                    break block0;
                }
                break;
            }
        }
    }

    private void visitRestParam(NodeTraversal t, Node restParam, Node paramList) {
        Node functionBody = paramList.getNext();
        int restIndex = paramList.getIndexOfChild(restParam);
        Node nameNode = restParam.getOnlyChild();
        String paramName = nameNode.getString();
        nameNode.setJSDocInfo(restParam.getJSDocInfo());
        paramList.replaceChild(restParam, nameNode.detach());
        JSDocInfo inlineInfo = restParam.getJSDocInfo();
        JSDocInfo functionInfo = NodeUtil.getBestJSDocInfo(paramList.getParent());
        JSTypeExpression paramTypeAnnotation = inlineInfo != null ? inlineInfo.getType() : (functionInfo != null ? functionInfo.getParameterType(paramName) : null);
        if (paramTypeAnnotation != null && paramTypeAnnotation.getRoot().getToken() != Token.ITER_REST) {
            this.compiler.report(JSError.make(restParam, BAD_REST_PARAMETER_ANNOTATION, new String[0]));
        }
        if (!functionBody.hasChildren()) {
            t.reportCodeChange();
            return;
        }
        Node newArrayName = IR.name(REST_PARAMS).setJSType(this.arrayType);
        Node cursorName = IR.name(REST_INDEX).setJSType(this.numberType);
        Node newBlock = IR.block().useSourceInfoFrom(functionBody);
        Node name = IR.name(paramName);
        Node let = IR.let(name, newArrayName).useSourceInfoIfMissingFromForTree(functionBody);
        newBlock.addChildToFront(let);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
        for (Node child : functionBody.children()) {
            newBlock.addChildToBack(child.detach());
        }
        Node newArrayDeclaration = IR.var(newArrayName.cloneTree(), this.arrayLitWithJSType());
        functionBody.addChildToFront(newArrayDeclaration.useSourceInfoIfMissingFromForTree(restParam));
        Node copyLoop = IR.forNode(IR.var(cursorName.cloneTree(), IR.number(restIndex).setJSType(this.numberType)), IR.lt(cursorName.cloneTree(), IR.getprop(IR.name("arguments"), IR.string("length")).setJSType(this.numberType)).setJSType(this.boolType), IR.inc(cursorName.cloneTree(), false).setJSType(this.numberType), IR.block(IR.exprResult(IR.assign(IR.getelem(newArrayName.cloneTree(), IR.sub(cursorName.cloneTree(), IR.number(restIndex).setJSType(this.numberType)).setJSType(this.numberType)), IR.getelem(IR.name("arguments"), cursorName.cloneTree()).setJSType(this.numberType)).setJSType(this.numberType)))).useSourceInfoIfMissingFromForTree(restParam);
        functionBody.addChildAfter(copyLoop, newArrayDeclaration);
        functionBody.addChildToBack(newBlock);
        this.compiler.reportChangeToEnclosingScope(newBlock);
    }

    private void visitArrayLitOrCallWithSpread(Node spreadParent) {
        if (spreadParent.isArrayLit()) {
            this.visitArrayLitContainingSpread(spreadParent);
        } else if (spreadParent.isCall()) {
            this.visitCallContainingSpread(spreadParent);
        } else {
            Preconditions.checkArgument(spreadParent.isNew(), spreadParent);
            this.visitNewWithSpread(spreadParent);
        }
    }

    private List<Node> extractSpreadGroups(Node spreadParent) {
        Preconditions.checkArgument(spreadParent.isCall() || spreadParent.isArrayLit() || spreadParent.isNew());
        ArrayList<Node> groups = new ArrayList<Node>();
        Node currGroup = null;
        Node currElement = spreadParent.removeFirstChild();
        while (currElement != null) {
            if (currElement.isSpread()) {
                Node spreadExpression = currElement.removeFirstChild();
                if (spreadExpression.isArrayLit()) {
                    if (currGroup == null) {
                        currGroup = spreadExpression;
                    } else {
                        currGroup.addChildrenToBack(spreadExpression.removeChildren());
                    }
                } else {
                    if (currGroup != null) {
                        groups.add(currGroup);
                        currGroup = null;
                    }
                    groups.add(Es6ToEs3Util.arrayFromIterable(this.compiler, spreadExpression));
                }
            } else {
                if (currGroup == null) {
                    currGroup = this.arrayLitWithJSType();
                }
                currGroup.addChildToBack(currElement);
            }
            currElement = spreadParent.removeFirstChild();
        }
        if (currGroup != null) {
            groups.add(currGroup);
        }
        return groups;
    }

    private void visitArrayLitContainingSpread(Node spreadParent) {
        Node joinedGroups;
        Preconditions.checkArgument(spreadParent.isArrayLit());
        List<Node> groups = this.extractSpreadGroups(spreadParent);
        Node baseArrayLit = groups.get(0).isArrayLit() ? groups.remove(0) : this.arrayLitWithJSType();
        if (groups.isEmpty()) {
            joinedGroups = baseArrayLit;
        } else {
            Node concat = IR.getprop(baseArrayLit, IR.string("concat")).setJSType(this.concatFnType);
            joinedGroups = IR.call(concat, groups.toArray(new Node[0]));
        }
        joinedGroups.useSourceInfoIfMissingFromForTree(spreadParent);
        joinedGroups.setJSType(this.arrayType);
        spreadParent.replaceWith(joinedGroups);
        this.compiler.reportChangeToEnclosingScope(joinedGroups);
    }

    private void visitCallContainingSpread(Node spreadParent) {
        Node callToApply;
        Node joinedGroups;
        Preconditions.checkArgument(spreadParent.isCall());
        Node callee = spreadParent.getFirstChild();
        Preconditions.checkState(!callee.isSuper(), "Cannot spread into super calls");
        boolean calleeMayHaveSideEffects = this.compiler.getAstAnalyzer().mayHaveSideEffects(callee);
        spreadParent.removeChild(callee);
        while (callee.isCast()) {
            callee = callee.removeFirstChild();
        }
        if (spreadParent.hasOneChild() && this.isSpreadOfArguments(spreadParent.getOnlyChild())) {
            joinedGroups = spreadParent.removeFirstChild().removeFirstChild();
        } else {
            List<Node> groups = this.extractSpreadGroups(spreadParent);
            Preconditions.checkState(!groups.isEmpty());
            if (groups.size() == 1) {
                joinedGroups = groups.remove(0);
            } else {
                Node baseArrayLit = groups.get(0).isArrayLit() ? groups.remove(0) : this.arrayLitWithJSType();
                Node concat = IR.getprop(baseArrayLit, IR.string("concat")).setJSType(this.concatFnType);
                joinedGroups = IR.call(concat, groups.toArray(new Node[0])).setJSType(this.arrayType);
            }
            joinedGroups.setJSType(this.arrayType);
        }
        boolean isFreeCall = spreadParent.getBooleanProp(Node.FREE_CALL);
        if (calleeMayHaveSideEffects && callee.isGetProp() && !isFreeCall) {
            JSType receiverType = callee.getFirstChild().getJSType();
            Node freshVar = IR.name(FRESH_SPREAD_VAR + this.compiler.getUniqueNameIdSupplier().get()).setJSType(receiverType);
            Node freshVarDeclaration = IR.var(freshVar.cloneTree());
            Node statementContainingSpread = NodeUtil.getEnclosingStatement(spreadParent);
            freshVarDeclaration.useSourceInfoIfMissingFromForTree(statementContainingSpread);
            statementContainingSpread.getParent().addChildBefore(freshVarDeclaration, statementContainingSpread);
            callee.addChildToFront(IR.assign(freshVar.cloneTree(), callee.removeFirstChild()).setJSType(receiverType));
            callToApply = IR.call(this.getpropInferringJSType(callee, "apply"), freshVar.cloneTree(), joinedGroups);
        } else {
            Node context = (callee.isGetProp() || callee.isGetElem()) && !isFreeCall ? callee.getFirstChild().cloneTree() : this.nullWithJSType();
            callToApply = IR.call(this.getpropInferringJSType(callee, "apply"), context, joinedGroups);
        }
        callToApply.setJSType(spreadParent.getJSType());
        callToApply.useSourceInfoIfMissingFromForTree(spreadParent);
        spreadParent.replaceWith(callToApply);
        this.compiler.reportChangeToEnclosingScope(callToApply);
    }

    private boolean isSpreadOfArguments(Node n) {
        return n.isSpread() && n.getOnlyChild().matchesName("arguments");
    }

    private void visitNewWithSpread(Node spreadParent) {
        Node joinedGroups;
        Preconditions.checkArgument(spreadParent.isNew());
        Node callee = spreadParent.removeFirstChild();
        List<Node> groups = this.extractSpreadGroups(spreadParent);
        Node baseArrayLit = groups.get(0).isArrayLit() ? groups.remove(0) : this.arrayLitWithJSType();
        baseArrayLit.addChildToFront(this.nullWithJSType());
        Node node = joinedGroups = groups.isEmpty() ? baseArrayLit : IR.call(IR.getprop(baseArrayLit, IR.string("concat")).setJSType(this.concatFnType), groups.toArray(new Node[0])).setJSType(this.arrayType);
        if (FeatureSet.ES3.contains(this.compiler.getOptions().getOutputFeatureSet())) {
            Es6ToEs3Util.cannotConvert(this.compiler, spreadParent, "\"...\" passed to a constructor (consider using --language_out=ES5)");
        }
        Node bindApply = this.getpropInferringJSType(this.getpropInferringJSType(this.getpropInferringJSType(IR.name("Function").setJSType(this.functionFunctionType), "prototype"), "bind"), "apply");
        Node result = IR.newNode(this.callInferringJSType(bindApply, callee, joinedGroups), new Node[0]).setJSType(spreadParent.getJSType());
        result.useSourceInfoIfMissingFromForTree(spreadParent);
        spreadParent.replaceWith(result);
        this.compiler.reportChangeToEnclosingScope(result);
    }

    private Node arrayLitWithJSType() {
        return IR.arraylit(new Node[0]).setJSType(this.arrayType);
    }

    private Node nullWithJSType() {
        return IR.nullNode().setJSType(this.nullType);
    }

    private Node getpropInferringJSType(Node receiver, String propName) {
        Node getprop = IR.getprop(receiver, propName, new String[0]);
        JSType receiverType = receiver.getJSType();
        if (receiverType == null) {
            return getprop;
        }
        JSType getpropType = receiverType.findPropertyType(propName);
        if (getpropType == null && receiverType instanceof FunctionType) {
            getpropType = ((FunctionType)receiverType).getPropertyType(propName);
        }
        return getprop.setJSType(getpropType);
    }

    private Node callInferringJSType(Node callee, Node ... args) {
        Node call = IR.call(callee, args);
        JSType calleeType = callee.getJSType();
        if (!(calleeType instanceof FunctionType)) {
            return call;
        }
        JSType returnType = ((FunctionType)calleeType).getReturnType();
        return call.setJSType(returnType);
    }
}

