/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicate;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;

public final class Es6ConvertSuper
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.SUPER);

    public Es6ConvertSuper(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass()) {
            if (NodeUtil.getEs6ClassConstructorMemberFunctionDef(n) == null) {
                this.addSyntheticConstructor(t, n);
            }
        } else if (n.isSuper()) {
            this.visitSuper(n, parent);
        }
    }

    private void addSyntheticConstructor(NodeTraversal t, Node classNode) {
        Node memberDef;
        Node superClass = classNode.getSecondChild();
        Node classMembers = classNode.getLastChild();
        if (superClass.isEmpty()) {
            Node function = this.astFactory.createEmptyFunction(Es6ConvertSuper.getTypeBeforeCast(classNode));
            this.compiler.reportChangeToChangeScope(function);
            memberDef = this.astFactory.createMemberFunctionDef("constructor", function);
        } else {
            if (!superClass.isQualifiedName()) {
                return;
            }
            Node body = IR.block();
            if (!classNode.isFromExterns() && !this.isInterface(classNode)) {
                Node exprResult = IR.exprResult(this.astFactory.createConstructorCall(classNode.getJSType(), IR.superNode().setJSType(superClass.getJSType()), IR.iterSpread(this.astFactory.createArgumentsReference())));
                body.addChildToFront(exprResult);
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.SUPER, this.compiler);
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.SPREAD_EXPRESSIONS, this.compiler);
            }
            Node constructor = this.astFactory.createFunction("", IR.paramList(new Node[0]), body, classNode.getJSType());
            memberDef = this.astFactory.createMemberFunctionDef("constructor", constructor);
        }
        memberDef.useSourceInfoIfMissingFromForTree(classNode);
        memberDef.makeNonIndexableRecursive();
        classMembers.addChildToFront(memberDef);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.MEMBER_DECLARATIONS, this.compiler);
        this.compiler.reportChangeToChangeScope(memberDef.getOnlyChild());
        this.compiler.reportChangeToEnclosingScope(memberDef);
    }

    private static JSType getTypeBeforeCast(Node node) {
        JSType typeBeforeCast = node.getJSTypeBeforeCast();
        return typeBeforeCast != null ? typeBeforeCast : node.getJSType();
    }

    private boolean isInterface(Node classNode) {
        JSDocInfo classJsDocInfo = NodeUtil.getBestJSDocInfo(classNode);
        return classJsDocInfo != null && classJsDocInfo.isInterface();
    }

    private void visitSuper(Node node, Node parent) {
        Preconditions.checkState(node.isSuper());
        Node exprRoot = node;
        if (exprRoot.getParent().isGetElem() || exprRoot.getParent().isGetProp()) {
            exprRoot = exprRoot.getParent();
        }
        Node enclosingMemberDef = NodeUtil.getEnclosingNode(exprRoot, new Predicate<Node>(){

            @Override
            public boolean apply(Node n) {
                switch (n.getToken()) {
                    case MEMBER_FUNCTION_DEF: 
                    case GETTER_DEF: 
                    case SETTER_DEF: 
                    case COMPUTED_PROP: {
                        return true;
                    }
                }
                return false;
            }
        });
        if (parent.isCall()) {
            this.visitSuperCall(node, parent, enclosingMemberDef);
        } else if (parent.isGetProp() || parent.isGetElem()) {
            if (parent.getFirstChild() == node) {
                if (parent.getParent().isCall() && NodeUtil.isInvocationTarget(parent)) {
                    this.visitSuperPropertyCall(node, parent, enclosingMemberDef);
                } else {
                    this.visitSuperPropertyAccess(node, parent, enclosingMemberDef);
                }
            } else {
                this.compiler.report(JSError.make(node, Es6ToEs3Util.CANNOT_CONVERT_YET, "Only calls to super or to a method of super are supported."));
            }
        } else {
            if (parent.isNew()) {
                throw new IllegalStateException("This should never happen. Did Es6SuperCheck fail to run?");
            }
            this.compiler.report(JSError.make(node, Es6ToEs3Util.CANNOT_CONVERT_YET, "Only calls to super or to a method of super are supported."));
        }
    }

    private void visitSuperCall(Node node, Node parent, Node enclosingMemberDef) {
        Preconditions.checkState(parent.isCall(), parent);
        Preconditions.checkState(node.isSuper(), node);
        Node clazz = NodeUtil.getEnclosingClass(node);
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        if (NodeUtil.isEs6ConstructorMemberFunctionDef(enclosingMemberDef)) {
            if (node.isFromExterns() || this.isInterface(clazz)) {
                Node enclosingStatement = NodeUtil.getEnclosingStatement(node);
                Node enclosingStatementParent = enclosingStatement.getParent();
                enclosingStatement.detach();
                this.compiler.reportChangeToEnclosingScope(enclosingStatementParent);
            }
            return;
        }
        throw new IllegalStateException("This should never happen. Did Es6SuperCheck fail to run?");
    }

    private void visitSuperPropertyCall(Node node, Node parent, Node enclosingMemberDef) {
        Preconditions.checkState(parent.isGetProp() || parent.isGetElem(), parent);
        Preconditions.checkState(node.isSuper(), node);
        Node grandparent = parent.getParent();
        Preconditions.checkState(grandparent.isCall());
        Node clazz = NodeUtil.getEnclosingClass(node);
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        Node callTarget = parent;
        Node callNode = IR.string("call");
        callNode.makeNonIndexable();
        if (enclosingMemberDef.isStaticMember()) {
            Node expandedSuper = superName.cloneTree().useSourceInfoFromForTree(node);
            expandedSuper.setOriginalName("super");
            callTarget.replaceChild(node, expandedSuper);
            callTarget = this.astFactory.createGetProp(callTarget.detach(), "call");
            grandparent.addChildToFront(callTarget);
            Node thisNode = this.astFactory.createThis(clazz.getJSType());
            thisNode.makeNonIndexable();
            grandparent.addChildAfter(thisNode, callTarget);
            grandparent.useSourceInfoIfMissingFromForTree(parent);
        } else {
            Node expandedSuper = this.astFactory.createGetProp(superName.cloneTree(), "prototype").useSourceInfoFromForTree(node);
            expandedSuper.setOriginalName("super");
            node.replaceWith(expandedSuper);
            callTarget = this.astFactory.createGetProp(callTarget.detach(), "call");
            grandparent.addChildToFront(callTarget);
            JSType thisType = this.getInstanceTypeForClassNode(clazz);
            Node thisNode = this.astFactory.createThis(thisType);
            thisNode.makeNonIndexable();
            grandparent.addChildAfter(thisNode, callTarget);
            grandparent.putBooleanProp(Node.FREE_CALL, false);
            grandparent.useSourceInfoIfMissingFromForTree(parent);
        }
        this.compiler.reportChangeToEnclosingScope(grandparent);
    }

    private JSType getInstanceTypeForClassNode(Node classNode) {
        ObjectType result;
        Preconditions.checkArgument(classNode.isClass(), classNode);
        JSType constructorType = classNode.getJSType();
        if (constructorType != null) {
            Preconditions.checkArgument(constructorType.isConstructor(), classNode);
            result = JSType.toMaybeFunctionType(constructorType).getInstanceType();
        } else {
            result = null;
        }
        return result;
    }

    private void visitSuperPropertyAccess(Node node, Node parent, Node enclosingMemberDef) {
        Preconditions.checkState(parent.isGetProp() || parent.isGetElem(), parent);
        Preconditions.checkState(node.isSuper(), node);
        Node grandparent = parent.getParent();
        if (NodeUtil.isLValue(parent)) {
            this.compiler.report(JSError.make(parent, Es6ToEs3Util.CANNOT_CONVERT_YET, "assigning to a super property"));
            return;
        }
        Node clazz = NodeUtil.getEnclosingClass(node);
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        if (enclosingMemberDef.isStaticMember()) {
            Node expandedSuper = superName.cloneTree().useSourceInfoFromForTree(node);
            expandedSuper.setOriginalName("super");
            node.replaceWith(expandedSuper);
        } else if (this.astFactory.isAddingTypes()) {
            Node newprop = this.astFactory.createGetProp(superName.cloneTree(), "prototype").useSourceInfoFromForTree(node);
            newprop.setOriginalName("super");
            node.replaceWith(newprop);
        } else {
            String newPropName = Joiner.on('.').join(superName.getQualifiedName(), "prototype", new Object[0]);
            node.replaceWith(NodeUtil.newQName(this.compiler, newPropName, node, "super").useSourceInfoFromForTree(node));
        }
        this.compiler.reportChangeToEnclosingScope(grandparent);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }
}

