/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedMap;
import com.google.javascript.jscomp.jarjar.com.google.gson.Gson;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@GwtIncompatible
public final class DiagnosticToSuppressionMapper {
    private final Set<String> validSuppressions;
    private final ImmutableMap<String, DiagnosticGroup> diagnosticGroups;

    DiagnosticToSuppressionMapper(Set<String> validSuppressions, ImmutableMap<String, DiagnosticGroup> diagnosticGroups) {
        this.validSuppressions = validSuppressions;
        this.diagnosticGroups = diagnosticGroups;
    }

    void printSuppressions(OutputFormat output) {
        switch (output) {
            case JSON: {
                DiagnosticToSuppressionMapper.printAsJson(this.createSuppressionMap());
                break;
            }
            case MD: {
                DiagnosticToSuppressionMapper.printAsMarkdown(this.createSuppressionMap());
            }
        }
    }

    @VisibleForTesting
    ImmutableSortedMap<String, String> createSuppressionMap() {
        HashSet<String> validSuppressions = new HashSet<String>(this.validSuppressions);
        validSuppressions.remove("accessControls");
        LinkedHashMap<DiagnosticType, String> diagnosticToSuppression = new LinkedHashMap<DiagnosticType, String>();
        for (Map.Entry entry : this.diagnosticGroups.entrySet()) {
            String suppression = (String)entry.getKey();
            if (!validSuppressions.contains(suppression)) continue;
            DiagnosticGroup group = (DiagnosticGroup)entry.getValue();
            for (DiagnosticType diagnosticType : group.getTypes()) {
                diagnosticToSuppression.merge(diagnosticType, suppression, this::preferMoreTargetedGroup);
            }
        }
        return diagnosticToSuppression.entrySet().stream().collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), entrySet -> ((DiagnosticType)entrySet.getKey()).key, Map.Entry::getValue));
    }

    private String preferMoreTargetedGroup(String next, String current) {
        DiagnosticGroup nextGroup = this.diagnosticGroups.get(next);
        DiagnosticGroup currentGroup = this.diagnosticGroups.get(current);
        return nextGroup.getTypes().size() < currentGroup.getTypes().size() ? next : current;
    }

    private static void printAsJson(ImmutableSortedMap<String, String> diagnosticToSuppression) {
        System.out.println(new Gson().toJson(diagnosticToSuppression));
    }

    private static void printAsMarkdown(ImmutableSortedMap<String, String> diagnosticToSuppression) {
        System.out.println("| Error | Suppression tag |");
        System.out.println("|---|---|");
        diagnosticToSuppression.entrySet().stream().map(e -> String.format("|%s|%s|", e.getKey(), e.getValue())).forEachOrdered(System.out::println);
    }

    static enum OutputFormat {
        MD,
        JSON;

    }
}

