/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

abstract class DataFlowAnalysis<N, L extends LatticeElement> {
    private final ControlFlowGraph<N> cfg;
    final JoinOp<L> joinOp;
    protected final Set<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> orderedWorkSet;
    public static final int MAX_STEPS = 1000000;

    DataFlowAnalysis(ControlFlowGraph<N> targetCfg, JoinOp<L> joinOp) {
        this.cfg = targetCfg;
        this.joinOp = joinOp;
        Comparator<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> nodeComparator = this.cfg.getOptionalNodeComparator(this.isForward());
        this.orderedWorkSet = nodeComparator != null ? new TreeSet<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>>(nodeComparator) : new LinkedHashSet<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>>();
    }

    final ControlFlowGraph<N> getCfg() {
        return this.cfg;
    }

    protected L join(L latticeA, L latticeB) {
        return (L)((LatticeElement)this.joinOp.apply(ImmutableList.of(latticeA, latticeB)));
    }

    abstract boolean isForward();

    abstract L flowThrough(N var1, L var2);

    final void analyze() {
        this.analyze(1000000);
    }

    final void analyze(int maxSteps) {
        this.initialize();
        int step = 0;
        while (!this.orderedWorkSet.isEmpty()) {
            if (step > maxSteps) {
                throw new MaxIterationsExceededException("Analysis did not terminate after " + maxSteps + " iterations");
            }
            DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> curNode = this.orderedWorkSet.iterator().next();
            this.orderedWorkSet.remove(curNode);
            this.joinInputs(curNode);
            if (this.flow(curNode)) {
                List<LinkedDirectedGraph.LinkedDiGraphNode<N, ControlFlowGraph.Branch>> nextNodes = this.isForward() ? this.cfg.getDirectedSuccNodes(curNode) : this.cfg.getDirectedPredNodes(curNode);
                for (DiGraph.DiGraphNode diGraphNode : nextNodes) {
                    if (diGraphNode == this.cfg.getImplicitReturn()) continue;
                    this.orderedWorkSet.add(diGraphNode);
                }
            }
            ++step;
        }
        if (this.isForward()) {
            this.joinInputs(this.getCfg().getImplicitReturn());
        }
    }

    abstract L createInitialEstimateLattice();

    abstract L createEntryLattice();

    protected void initialize() {
        this.orderedWorkSet.clear();
        for (DiGraph.DiGraphNode diGraphNode : this.cfg.getNodes()) {
            diGraphNode.setAnnotation(new FlowState((LatticeElement)this.createInitialEstimateLattice(), (LatticeElement)this.createInitialEstimateLattice(), null));
            if (diGraphNode == this.cfg.getImplicitReturn()) continue;
            this.orderedWorkSet.add(diGraphNode);
        }
    }

    protected boolean flow(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
        FlowState state = (FlowState)node.getAnnotation();
        if (this.isForward()) {
            LatticeElement outBefore = state.out;
            state.out = this.flowThrough(node.getValue(), state.in);
            return !outBefore.equals(state.out);
        }
        LatticeElement inBefore = state.in;
        state.in = this.flowThrough(node.getValue(), state.out);
        return !inBefore.equals(state.in);
    }

    protected void joinInputs(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
        FlowState state = (FlowState)node.getAnnotation();
        if (this.isForward()) {
            if (this.cfg.getEntry() == node) {
                state.setIn(this.createEntryLattice());
            } else {
                List<LinkedDirectedGraph.LinkedDiGraphNode<N, ControlFlowGraph.Branch>> inNodes = this.cfg.getDirectedPredNodes(node);
                if (inNodes.size() == 1) {
                    FlowState inNodeState = (FlowState)((DiGraph.DiGraphNode)inNodes.get(0)).getAnnotation();
                    state.setIn(inNodeState.getOut());
                } else if (inNodes.size() > 1) {
                    ArrayList values = new ArrayList(inNodes.size());
                    for (DiGraph.DiGraphNode diGraphNode : inNodes) {
                        FlowState currentNodeState = (FlowState)diGraphNode.getAnnotation();
                        values.add(currentNodeState.getOut());
                    }
                    state.setIn((LatticeElement)this.joinOp.apply(values));
                }
            }
        } else {
            List<LinkedDirectedGraph.LinkedDiGraphNode<N, ControlFlowGraph.Branch>> inNodes = this.cfg.getDirectedSuccNodes(node);
            if (inNodes.size() == 1) {
                DiGraph.DiGraphNode inNode = inNodes.get(0);
                if (inNode == this.cfg.getImplicitReturn()) {
                    state.setOut(this.createEntryLattice());
                } else {
                    FlowState inNodeState = (FlowState)inNode.getAnnotation();
                    state.setOut(inNodeState.getIn());
                }
            } else if (inNodes.size() > 1) {
                ArrayList values = new ArrayList(inNodes.size());
                for (DiGraph.DiGraphNode diGraphNode : inNodes) {
                    FlowState currentNodeState = (FlowState)diGraphNode.getAnnotation();
                    values.add(currentNodeState.getIn());
                }
                state.setOut((LatticeElement)this.joinOp.apply(values));
            }
        }
    }

    static void computeEscaped(final Scope jsScope, final Set<Var> escaped, AbstractCompiler compiler, SyntacticScopeCreator scopeCreator) {
        Preconditions.checkArgument(jsScope.isFunctionScope());
        NodeTraversal.AbstractPostOrderCallback finder = new NodeTraversal.AbstractPostOrderCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                Node enclosingScopeNode;
                Node enclosingBlock = NodeUtil.getEnclosingFunction(n);
                if (jsScope.getRootNode() == enclosingBlock || !n.isName() || parent.isFunction()) {
                    return;
                }
                String name = n.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (var != null && (enclosingScopeNode = NodeUtil.getEnclosingFunction(var.getNode())) == jsScope.getRootNode()) {
                    escaped.add(var);
                }
            }
        };
        HashMap<String, Var> allVarsInFn = new HashMap<String, Var>();
        ArrayList<Var> orderedVars = new ArrayList<Var>();
        NodeUtil.getAllVarsDeclaredInFunction(allVarsInFn, orderedVars, compiler, scopeCreator, jsScope);
        NodeTraversal t = new NodeTraversal(compiler, finder, scopeCreator);
        t.traverseAtScope(jsScope);
        for (Var var : allVarsInFn.values()) {
            if (!var.getParentNode().isCatch() && !compiler.getCodingConvention().isExported(var.getName())) continue;
            escaped.add(var);
        }
    }

    static class BranchedFlowState<L extends LatticeElement>
    implements Annotation {
        private L in;
        private List<L> out;

        private BranchedFlowState(L inState, List<L> outState) {
            Preconditions.checkNotNull(inState);
            Preconditions.checkNotNull(outState);
            this.in = inState;
            this.out = outState;
        }

        L getIn() {
            return this.in;
        }

        void setIn(L in) {
            Preconditions.checkNotNull(in);
            this.in = in;
        }

        public String toString() {
            return SimpleFormat.format("IN: %s OUT: %s", this.in, this.out);
        }

        public boolean equals(Object o) {
            if (o instanceof BranchedFlowState) {
                BranchedFlowState that = (BranchedFlowState)o;
                return that.in.equals(this.in) && that.out.equals(this.out);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.in, this.out);
        }

        /* synthetic */ BranchedFlowState(LatticeElement x0, List x1, 1 x2) {
            this(x0, x1);
        }
    }

    static abstract class BranchedForwardDataFlowAnalysis<N, L extends LatticeElement>
    extends DataFlowAnalysis<N, L> {
        @Override
        protected void initialize() {
            this.orderedWorkSet.clear();
            for (DiGraph.DiGraphNode diGraphNode : this.getCfg().getNodes()) {
                int outEdgeCount = this.getCfg().getOutEdges(diGraphNode.getValue()).size();
                ArrayList outLattices = new ArrayList();
                for (int i = 0; i < outEdgeCount; ++i) {
                    outLattices.add(this.createInitialEstimateLattice());
                }
                diGraphNode.setAnnotation(new BranchedFlowState((LatticeElement)this.createInitialEstimateLattice(), outLattices, null));
                if (diGraphNode == this.getCfg().getImplicitReturn()) continue;
                this.orderedWorkSet.add(diGraphNode);
            }
        }

        BranchedForwardDataFlowAnalysis(ControlFlowGraph<N> targetCfg, JoinOp<L> joinOp) {
            super(targetCfg, joinOp);
        }

        @Override
        final boolean isForward() {
            return true;
        }

        abstract List<L> branchedFlowThrough(N var1, L var2);

        @Override
        protected final boolean flow(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
            BranchedFlowState state = (BranchedFlowState)node.getAnnotation();
            List outBefore = state.out;
            state.out = this.branchedFlowThrough(node.getValue(), state.in);
            Preconditions.checkState(outBefore.size() == state.out.size());
            for (int i = 0; i < outBefore.size(); ++i) {
                if (((LatticeElement)outBefore.get(i)).equals(state.out.get(i))) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void joinInputs(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
            BranchedFlowState state = (BranchedFlowState)node.getAnnotation();
            List<LinkedDirectedGraph.LinkedDiGraphNode<N, ControlFlowGraph.Branch>> predNodes = this.getCfg().getDirectedPredNodes(node);
            ArrayList<LatticeElement> values = new ArrayList<LatticeElement>(predNodes.size());
            for (DiGraph.DiGraphNode diGraphNode : predNodes) {
                BranchedFlowState predNodeState = (BranchedFlowState)diGraphNode.getAnnotation();
                LatticeElement in = (LatticeElement)predNodeState.out.get(this.getCfg().getDirectedSuccNodes(diGraphNode).indexOf(node));
                values.add(in);
            }
            if (this.getCfg().getEntry() == node) {
                state.setIn(this.createEntryLattice());
            } else if (!values.isEmpty()) {
                state.setIn((LatticeElement)this.joinOp.apply(values));
            }
        }
    }

    static class MaxIterationsExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        MaxIterationsExceededException(String msg) {
            super(msg);
        }
    }

    static class FlowState<L extends LatticeElement>
    implements Annotation {
        private L in;
        private L out;

        private FlowState(L inState, L outState) {
            Preconditions.checkNotNull(inState);
            Preconditions.checkNotNull(outState);
            this.in = inState;
            this.out = outState;
        }

        L getIn() {
            return this.in;
        }

        void setIn(L in) {
            Preconditions.checkNotNull(in);
            this.in = in;
        }

        L getOut() {
            return this.out;
        }

        void setOut(L out) {
            Preconditions.checkNotNull(out);
            this.out = out;
        }

        public String toString() {
            return SimpleFormat.format("IN: %s OUT: %s", this.in, this.out);
        }

        public boolean equals(Object o) {
            if (o instanceof FlowState) {
                FlowState that = (FlowState)o;
                return that.in.equals(this.in) && that.out.equals(this.out);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.in, this.out);
        }

        /* synthetic */ FlowState(LatticeElement x0, LatticeElement x1, 1 x2) {
            this(x0, x1);
        }
    }
}

