/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AccessControlUtils;
import com.google.javascript.jscomp.AutoValue_CheckAccessControls_PropertyReference;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollectFileOverviewVisibility;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimap;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Supplier;

class CheckAccessControls
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    static final DiagnosticType DEPRECATED_NAME = DiagnosticType.disabled("JSC_DEPRECATED_VAR", "Variable {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_NAME_REASON = DiagnosticType.disabled("JSC_DEPRECATED_VAR_REASON", "Variable {0} has been deprecated: {1}");
    static final DiagnosticType DEPRECATED_PROP = DiagnosticType.disabled("JSC_DEPRECATED_PROP", "Property {0} of type {1} has been deprecated.");
    static final DiagnosticType DEPRECATED_PROP_REASON = DiagnosticType.disabled("JSC_DEPRECATED_PROP_REASON", "Property {0} of type {1} has been deprecated: {2}");
    static final DiagnosticType DEPRECATED_CLASS = DiagnosticType.disabled("JSC_DEPRECATED_CLASS", "Class {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_CLASS_REASON = DiagnosticType.disabled("JSC_DEPRECATED_CLASS_REASON", "Class {0} has been deprecated: {1}");
    static final DiagnosticType BAD_PACKAGE_PROPERTY_ACCESS = DiagnosticType.error("JSC_BAD_PACKAGE_PROPERTY_ACCESS", "Access to package-private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PRIVATE_GLOBAL_ACCESS = DiagnosticType.error("JSC_BAD_PRIVATE_GLOBAL_ACCESS", "Access to private variable {0} not allowed outside file {1}.");
    static final DiagnosticType BAD_PRIVATE_PROPERTY_ACCESS = DiagnosticType.warning("JSC_BAD_PRIVATE_PROPERTY_ACCESS", "Access to private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PROTECTED_PROPERTY_ACCESS = DiagnosticType.warning("JSC_BAD_PROTECTED_PROPERTY_ACCESS", "Access to protected property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY = DiagnosticType.error("JSC_BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY", "Overridden property {0} in file with fileoverview visibility {1} must explicitly redeclare superclass visibility");
    static final DiagnosticType PRIVATE_OVERRIDE = DiagnosticType.warning("JSC_PRIVATE_OVERRIDE", "Overriding private property of {0}.");
    static final DiagnosticType EXTEND_FINAL_CLASS = DiagnosticType.error("JSC_EXTEND_FINAL_CLASS", "{0} is not allowed to extend final class {1}.");
    static final DiagnosticType VISIBILITY_MISMATCH = DiagnosticType.warning("JSC_VISIBILITY_MISMATCH", "Overriding {0} property of {1} with {2} property.");
    static final DiagnosticType CONST_PROPERTY_REASSIGNED_VALUE = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_REASSIGNED_VALUE", "constant property {0} assigned a value more than once");
    static final DiagnosticType CONST_PROPERTY_DELETED = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_DELETED", "constant property {0} cannot be deleted");
    static final DiagnosticType CONVENTION_MISMATCH = DiagnosticType.warning("JSC_CONVENTION_MISMATCH", "Declared access conflicts with access convention.");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry typeRegistry;
    private final boolean enforceCodingConventions;
    private int deprecationDepth = 0;
    private final Deque<ObjectType> currentClassStack = new LinkedList<ObjectType>();
    private ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> defaultVisibilityForFiles;
    private final Multimap<JSType, String> initializedConstantProperties;

    CheckAccessControls(AbstractCompiler compiler, boolean enforceCodingConventions) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
        this.initializedConstantProperties = HashMultimap.create();
        this.enforceCodingConventions = enforceCodingConventions;
    }

    @Override
    public void process(Node externs, Node root) {
        CollectFileOverviewVisibility collectPass = new CollectFileOverviewVisibility(this.compiler);
        collectPass.process(externs, root);
        this.defaultVisibilityForFiles = collectPass.getFileOverviewVisibilityMap();
        NodeTraversal.traverse(this.compiler, externs, this);
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        CollectFileOverviewVisibility collectPass = new CollectFileOverviewVisibility(this.compiler);
        collectPass.hotSwapScript(scriptRoot, originalRoot);
        this.defaultVisibilityForFiles = collectPass.getFileOverviewVisibilityMap();
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    private void enterAccessControlScope(Node root) {
        ObjectType scopeType = this.bestInstanceTypeForMethodOrCtor(root);
        if (CheckAccessControls.isMarkedDeprecated(root)) {
            ++this.deprecationDepth;
        }
        this.currentClassStack.push(scopeType);
    }

    private void exitAccessControlScope(Node root) {
        if (CheckAccessControls.isMarkedDeprecated(root)) {
            --this.deprecationDepth;
        }
        this.currentClassStack.pop();
    }

    @Nullable
    private static Node primaryAccessControlScopeRootFor(Node node) {
        if (CheckAccessControls.isExtendsTarget(node)) {
            return node.getParent();
        }
        if (CheckAccessControls.isFunctionOrClass(node)) {
            return node;
        }
        return null;
    }

    @Nullable
    private ObjectType bestInstanceTypeForMethodOrCtor(Node n) {
        Preconditions.checkState(CheckAccessControls.isFunctionOrClass(n), n);
        Node parent = n.getParent();
        if (NodeUtil.isFunctionDeclaration(n) || NodeUtil.isClassDeclaration(n)) {
            return CheckAccessControls.instanceTypeFor(n.getJSType());
        }
        switch (parent.getToken()) {
            case NAME: {
                return CheckAccessControls.instanceTypeFor(n.getJSType());
            }
            case ASSIGN: {
                Node lValue = parent.getFirstChild();
                if (NodeUtil.isNormalGet(lValue)) {
                    JSType lValueType = lValue.getJSType();
                    if (lValueType != null && (lValueType.isConstructor() || lValueType.isInterface())) {
                        return CheckAccessControls.instanceTypeFor(lValueType);
                    }
                    if (NodeUtil.isPrototypeProperty(lValue)) {
                        return CheckAccessControls.instanceTypeFor(NodeUtil.getPrototypeClassName(lValue).getJSType());
                    }
                    return CheckAccessControls.instanceTypeFor(lValue.getFirstChild().getJSType());
                }
                return CheckAccessControls.instanceTypeFor(lValue.getJSType());
            }
            case STRING_KEY: 
            case GETTER_DEF: 
            case SETTER_DEF: 
            case MEMBER_FUNCTION_DEF: 
            case COMPUTED_PROP: {
                Node grandparent = parent.getParent();
                Node greatGrandparent = grandparent.getParent();
                if (grandparent.isObjectLit()) {
                    return grandparent.getJSType().isFunctionPrototypeType() ? CheckAccessControls.instanceTypeFor(grandparent.getJSType()) : null;
                }
                if (greatGrandparent.isClass()) {
                    return CheckAccessControls.instanceTypeFor(greatGrandparent.getJSType());
                }
                throw new AssertionError(greatGrandparent);
            }
        }
        return null;
    }

    @Nullable
    private static ObjectType instanceTypeFor(JSType type) {
        if (type == null) {
            return null;
        }
        if (type.isUnionType()) {
            return null;
        }
        if (type.isInstanceType() || type.isUnknownType()) {
            return type.toMaybeObjectType();
        }
        if (type.isConstructor() || type.isInterface()) {
            return type.toMaybeFunctionType().getInstanceType();
        }
        if (type.isFunctionType()) {
            return null;
        }
        if (type.isFunctionPrototypeType()) {
            return CheckAccessControls.instanceTypeFor(type.toMaybeObjectType().getOwnerFunction());
        }
        return type.toMaybeObjectType();
    }

    @Override
    public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
        Node accessControlRoot = CheckAccessControls.primaryAccessControlScopeRootFor(node);
        if (accessControlRoot != null) {
            this.enterAccessControlScope(accessControlRoot);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        IdentifierBehaviour identifierBehaviour = IdentifierBehaviour.select(node);
        PropertyReference propRef = this.createPropertyReference(node);
        this.checkDeprecation(node, propRef, identifierBehaviour, traversal);
        this.checkVisibility(node, propRef, identifierBehaviour, traversal.getScope());
        this.checkConstantProperty(propRef, identifierBehaviour);
        this.checkFinalClassOverrides(node);
        Node accessControlRoot = CheckAccessControls.primaryAccessControlScopeRootFor(node);
        if (accessControlRoot != null) {
            this.exitAccessControlScope(accessControlRoot);
        }
    }

    private void checkDeprecation(Node node, @Nullable PropertyReference propRef, IdentifierBehaviour identifierBehaviour, NodeTraversal traversal) {
        switch (identifierBehaviour) {
            case ES5_CLASS_INVOCATION: 
            case ES6_CLASS_INVOCATION: 
            case ES6_CLASS_NAMESPACE: {
                this.checkTypeDeprecation(traversal, node);
                break;
            }
            case NON_CONSTRUCTOR: {
                this.checkNameDeprecation(traversal, node);
                break;
            }
        }
        if (propRef != null && !identifierBehaviour.equals((Object)IdentifierBehaviour.ES5_CLASS_NAMESPACE)) {
            this.checkPropertyDeprecation(traversal, propRef);
        }
    }

    private void checkVisibility(Node node, @Nullable PropertyReference propRef, IdentifierBehaviour identifierBehaviour, Scope scope) {
        if (identifierBehaviour.equals((Object)IdentifierBehaviour.ES6_CLASS_INVOCATION)) {
            this.checkEs6ConstructorInvocationVisibility(node);
        }
        if (!identifierBehaviour.equals((Object)IdentifierBehaviour.ES5_CLASS_NAMESPACE)) {
            this.checkNameVisibility(scope, node);
        }
        if (node.getParent().isObjectLit()) {
            switch (node.getToken()) {
                case STRING_KEY: 
                case GETTER_DEF: 
                case SETTER_DEF: 
                case MEMBER_FUNCTION_DEF: {
                    this.checkKeyVisibilityConvention(node, node.getParent());
                    break;
                }
            }
        }
        if (propRef != null && !identifierBehaviour.equals((Object)IdentifierBehaviour.ES5_CLASS_NAMESPACE)) {
            this.checkPropertyVisibility(propRef);
        }
    }

    private void checkTypeDeprecation(NodeTraversal t, Node n) {
        if (!this.shouldEmitDeprecationWarning(t, n)) {
            return;
        }
        ObjectType instanceType = n.getJSType().toMaybeFunctionType().getInstanceType();
        String deprecationInfo = CheckAccessControls.getTypeDeprecationInfo(instanceType);
        if (deprecationInfo == null) {
            return;
        }
        DiagnosticType message = deprecationInfo.isEmpty() ? DEPRECATED_CLASS : DEPRECATED_CLASS_REASON;
        this.compiler.report(JSError.make(n, message, instanceType.toString(), deprecationInfo));
    }

    private void checkNameDeprecation(NodeTraversal t, Node n) {
        JSDocInfo docInfo;
        if (!n.isName()) {
            return;
        }
        if (!this.shouldEmitDeprecationWarning(t, n)) {
            return;
        }
        Var var = (Var)t.getScope().getVar(n.getString());
        JSDocInfo jSDocInfo = docInfo = var == null ? null : var.getJSDocInfo();
        if (docInfo != null && docInfo.isDeprecated()) {
            if (docInfo.getDeprecationReason() != null) {
                this.compiler.report(JSError.make(n, DEPRECATED_NAME_REASON, n.getString(), docInfo.getDeprecationReason()));
            } else {
                this.compiler.report(JSError.make(n, DEPRECATED_NAME, n.getString()));
            }
        }
    }

    private void checkPropertyDeprecation(NodeTraversal t, PropertyReference propRef) {
        String deprecationInfo;
        if (!this.shouldEmitDeprecationWarning(t, propRef)) {
            return;
        }
        if (propRef.getSourceNode().getParent().isNew()) {
            return;
        }
        ObjectType objectType = CheckAccessControls.castToObject(CheckAccessControls.dereference(propRef.getReceiverType()));
        String propertyName = propRef.getName();
        if (objectType != null && (deprecationInfo = CheckAccessControls.getPropertyDeprecationInfo(objectType, propertyName)) != null) {
            if (!deprecationInfo.isEmpty()) {
                this.compiler.report(JSError.make(propRef.getSourceNode(), DEPRECATED_PROP_REASON, propertyName, propRef.getReadableTypeNameOrDefault(), deprecationInfo));
            } else {
                this.compiler.report(JSError.make(propRef.getSourceNode(), DEPRECATED_PROP, propertyName, propRef.getReadableTypeNameOrDefault()));
            }
        }
    }

    private boolean isPrivateByConvention(String name) {
        return this.enforceCodingConventions && this.compiler.getCodingConvention().isPrivate(name);
    }

    private void checkKeyVisibilityConvention(Node key, Node parent) {
        JSDocInfo info = key.getJSDocInfo();
        if (info == null) {
            return;
        }
        if (!this.isPrivateByConvention(key.getString())) {
            return;
        }
        Node assign = parent.getParent();
        if (assign == null || !assign.isAssign()) {
            return;
        }
        Node left = assign.getFirstChild();
        if (!left.isGetProp() || !left.getLastChild().getString().equals("prototype")) {
            return;
        }
        JSDocInfo.Visibility declaredVisibility = info.getVisibility();
        if (declaredVisibility != JSDocInfo.Visibility.INHERITED && declaredVisibility != JSDocInfo.Visibility.PRIVATE) {
            this.compiler.report(JSError.make(key, CONVENTION_MISMATCH, new String[0]));
        }
    }

    private void checkNameVisibility(Scope scope, Node name) {
        if (!name.isName()) {
            return;
        }
        Var var = (Var)scope.getVar(name.getString());
        if (var == null) {
            return;
        }
        JSDocInfo.Visibility v = this.checkPrivateNameConvention(AccessControlUtils.getEffectiveNameVisibility(name, var, this.defaultVisibilityForFiles), name);
        switch (v) {
            case PACKAGE: {
                if (this.isPackageAccessAllowed(var, name)) break;
                this.compiler.report(JSError.make(name, BAD_PACKAGE_PROPERTY_ACCESS, name.getString(), var.getSourceFile().getName()));
                break;
            }
            case PRIVATE: {
                if (CheckAccessControls.isPrivateAccessAllowed(var, name)) break;
                this.compiler.report(JSError.make(name, BAD_PRIVATE_GLOBAL_ACCESS, name.getString(), var.getSourceFile().getName()));
                break;
            }
        }
    }

    private JSDocInfo.Visibility checkPrivateNameConvention(JSDocInfo.Visibility v, Node name) {
        if (this.isPrivateByConvention(name.getString())) {
            if (v != JSDocInfo.Visibility.PRIVATE && v != JSDocInfo.Visibility.INHERITED) {
                this.compiler.report(JSError.make(name, CONVENTION_MISMATCH, new String[0]));
            }
            return JSDocInfo.Visibility.PRIVATE;
        }
        return v;
    }

    private static boolean isPrivateAccessAllowed(Var var, Node name) {
        StaticSourceFile varSrc = var.getSourceFile();
        StaticSourceFile refSrc = name.getStaticSourceFile();
        return varSrc == null || refSrc == null || Objects.equals(varSrc.getName(), refSrc.getName());
    }

    private boolean isPackageAccessAllowed(Var var, Node name) {
        StaticSourceFile varSrc = var.getSourceFile();
        StaticSourceFile refSrc = name.getStaticSourceFile();
        if (varSrc == null && refSrc == null) {
            return false;
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        String srcPackage = codingConvention.getPackageName(varSrc);
        String refPackage = codingConvention.getPackageName(refSrc);
        return srcPackage != null && refPackage != null && Objects.equals(srcPackage, refPackage);
    }

    private void checkPropertyOverrideVisibilityIsSame(JSDocInfo.Visibility overriding, JSDocInfo.Visibility overridden, @Nullable JSDocInfo.Visibility fileOverview, PropertyReference propRef) {
        if (overriding == JSDocInfo.Visibility.INHERITED && overriding != overridden && fileOverview != null && fileOverview != JSDocInfo.Visibility.INHERITED) {
            this.compiler.report(JSError.make(propRef.getSourceNode(), BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY, propRef.getName(), fileOverview.name()));
        }
    }

    @Nullable
    private static JSDocInfo.Visibility getOverridingPropertyVisibility(PropertyReference propRef) {
        JSDocInfo overridingInfo = propRef.getJSDocInfo();
        return overridingInfo == null || !overridingInfo.isOverride() ? null : overridingInfo.getVisibility();
    }

    private void checkFinalClassOverrides(Node ctor) {
        if (!CheckAccessControls.isFunctionOrClass(ctor)) {
            return;
        }
        FunctionType ctorType = ctor.getJSType().toMaybeFunctionType();
        if (ctorType == null || !ctorType.isConstructor()) {
            return;
        }
        ObjectType finalParentClass = CheckAccessControls.getSuperClassInstanceIfFinal(ctorType);
        if (finalParentClass != null) {
            this.compiler.report(JSError.make(ctor, EXTEND_FINAL_CLASS, ctorType.getDisplayName(), finalParentClass.getDisplayName()));
        }
    }

    private void checkConstantProperty(@Nullable PropertyReference propRef, IdentifierBehaviour identifierBehaviour) {
        String propertyName;
        if (propRef == null || identifierBehaviour.equals((Object)IdentifierBehaviour.ES5_CLASS_NAMESPACE)) {
            return;
        }
        if (!propRef.isMutation()) {
            return;
        }
        ObjectType objectType = CheckAccessControls.castToObject(CheckAccessControls.dereference(propRef.getReceiverType()));
        boolean isConstant = this.isPropertyDeclaredConstant(objectType, propertyName = propRef.getName());
        if (isConstant) {
            ObjectType prototype;
            if (propRef.isDeletion()) {
                this.compiler.report(JSError.make(propRef.getSourceNode(), CONST_PROPERTY_DELETED, propertyName));
                return;
            }
            if (objectType == null || objectType.isFunctionType() && !objectType.toMaybeFunctionType().isConstructor()) {
                return;
            }
            if (this.isIllegalMutationOfConstantProperty(propRef, objectType)) {
                this.compiler.report(JSError.make(propRef.getSourceNode(), CONST_PROPERTY_REASSIGNED_VALUE, propertyName));
            }
            this.initializedConstantProperties.put(objectType, propertyName);
            if (objectType.isInstanceType() && (prototype = objectType.getImplicitPrototype()) != null && prototype.hasProperty(propertyName)) {
                this.initializedConstantProperties.put(prototype, propertyName);
            }
        }
    }

    private boolean isIllegalMutationOfConstantProperty(PropertyReference ref, ObjectType type) {
        if (type.isStructuralType() && !ref.isDeclaration()) {
            return true;
        }
        String name = ref.getName();
        while (type != null) {
            if (this.initializedConstantProperties.containsEntry(type, name) || this.initializedConstantProperties.containsEntry(CheckAccessControls.getCanonicalInstance(type), name)) {
                return true;
            }
            type = type.getImplicitPrototype();
        }
        return false;
    }

    static ObjectType getCanonicalInstance(ObjectType obj) {
        FunctionType ctor = obj.getConstructor();
        return ctor == null ? obj : ctor.getInstanceType();
    }

    @Nullable
    private static ObjectType dereference(JSType type) {
        return type == null ? null : type.dereference();
    }

    private JSType typeOrUnknown(JSType type) {
        return type == null ? this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : type;
    }

    private ObjectType typeOrUnknown(ObjectType type) {
        return (ObjectType)this.typeOrUnknown((JSType)type);
    }

    private ObjectType boxedOrUnknown(@Nullable JSType type) {
        return this.typeOrUnknown(CheckAccessControls.dereference(type));
    }

    private void checkPropertyVisibility(PropertyReference propRef) {
        JSDocInfo.Visibility overriding;
        if (NodeUtil.isEs6ConstructorMemberFunctionDef(propRef.getSourceNode())) {
            return;
        }
        JSType rawReferenceType = this.typeOrUnknown(propRef.getReceiverType()).autobox();
        ObjectType referenceType = CheckAccessControls.castToObject(rawReferenceType);
        String propertyName = propRef.getName();
        boolean isPrivateByConvention = this.isPrivateByConvention(propertyName);
        if (isPrivateByConvention && CheckAccessControls.propertyIsDeclaredButNotPrivate(propRef)) {
            this.compiler.report(JSError.make(propRef.getSourceNode(), CONVENTION_MISMATCH, new String[0]));
            return;
        }
        StaticSourceFile definingSource = AccessControlUtils.getDefiningSource(propRef.getSourceNode(), referenceType, propertyName);
        boolean isOverride = propRef.isDocumentedDeclaration() || propRef.isOverride();
        ObjectType objectType = AccessControlUtils.getObjectType(referenceType, isOverride, propertyName);
        JSDocInfo.Visibility fileOverviewVisibility = this.defaultVisibilityForFiles.get(definingSource);
        JSDocInfo.Visibility visibility = CheckAccessControls.getEffectivePropertyVisibility(propRef, referenceType, this.defaultVisibilityForFiles, this.enforceCodingConventions ? this.compiler.getCodingConvention() : null);
        if (isOverride && (overriding = CheckAccessControls.getOverridingPropertyVisibility(propRef)) != null) {
            this.checkPropertyOverrideVisibilityIsSame(overriding, visibility, fileOverviewVisibility, propRef);
        }
        JSType reportType = rawReferenceType;
        if (objectType != null) {
            Node node = objectType.getOwnPropertyDefSite(propertyName);
            if (node == null) {
                return;
            }
            reportType = objectType;
            definingSource = node.getStaticSourceFile();
        } else if (!isPrivateByConvention && fileOverviewVisibility == null) {
            return;
        }
        StaticSourceFile referenceSource = propRef.getSourceNode().getStaticSourceFile();
        if (isOverride) {
            boolean sameInput = referenceSource != null && referenceSource.getName().equals(definingSource.getName());
            this.checkPropertyOverrideVisibility(propRef, visibility, fileOverviewVisibility, reportType, sameInput);
        } else {
            this.checkPropertyAccessVisibility(propRef, visibility, reportType, referenceSource, definingSource);
        }
    }

    private void checkEs6ConstructorInvocationVisibility(Node target) {
        FunctionType ctorType = target.getJSType().toMaybeFunctionType();
        ObjectType prototypeType = ctorType.getPrototype();
        Node classDefinition = ctorType.getSource();
        StaticSourceFile definingSource = classDefinition == null ? null : AccessControlUtils.getDefiningSource(classDefinition, prototypeType, "constructor");
        PropertyReference fauxCtorRef = PropertyReference.builder().setSourceNode(target).setName("constructor").setReceiverType(prototypeType).setMutation(false).setDeclaration(false).setOverride(false).setReadableTypeName(() -> ctorType.getInstanceType().toString()).build();
        JSDocInfo.Visibility annotatedCtorVisibility = CheckAccessControls.getEffectiveVisibilityForNonOverriddenProperty(fauxCtorRef, prototypeType, this.defaultVisibilityForFiles.get(definingSource), this.enforceCodingConventions ? this.compiler.getCodingConvention() : null);
        JSDocInfo.Visibility effectiveCtorVisibility = annotatedCtorVisibility.equals((Object)JSDocInfo.Visibility.INHERITED) ? JSDocInfo.Visibility.PUBLIC : annotatedCtorVisibility;
        this.checkPropertyAccessVisibility(fauxCtorRef, effectiveCtorVisibility, ctorType, target.getStaticSourceFile(), definingSource);
    }

    private static boolean propertyIsDeclaredButNotPrivate(PropertyReference propRef) {
        if (!propRef.isDocumentedDeclaration() && !propRef.isOverride()) {
            return false;
        }
        JSDocInfo.Visibility declaredVisibility = propRef.getJSDocInfo().getVisibility();
        return declaredVisibility != JSDocInfo.Visibility.PRIVATE && declaredVisibility != JSDocInfo.Visibility.INHERITED;
    }

    private void checkPropertyOverrideVisibility(PropertyReference propRef, JSDocInfo.Visibility visibility, JSDocInfo.Visibility fileOverviewVisibility, JSType objectType, boolean sameInput) {
        JSDocInfo.Visibility overridingVisibility;
        JSDocInfo.Visibility visibility2 = overridingVisibility = propRef.isOverride() ? propRef.getJSDocInfo().getVisibility() : JSDocInfo.Visibility.INHERITED;
        if (visibility == JSDocInfo.Visibility.PRIVATE && !sameInput) {
            this.compiler.report(JSError.make(propRef.getSourceNode(), PRIVATE_OVERRIDE, objectType.toString()));
        } else if (overridingVisibility != JSDocInfo.Visibility.INHERITED && overridingVisibility != visibility && fileOverviewVisibility == null) {
            this.compiler.report(JSError.make(propRef.getSourceNode(), VISIBILITY_MISMATCH, visibility.name(), objectType.toString(), overridingVisibility.name()));
        }
    }

    private void checkPropertyAccessVisibility(PropertyReference propRef, JSDocInfo.Visibility visibility, JSType objectType, StaticSourceFile referenceSource, StaticSourceFile definingSource) {
        if (referenceSource != null && definingSource != null && referenceSource.getName().equals(definingSource.getName())) {
            return;
        }
        ObjectType ownerType = CheckAccessControls.instanceTypeFor(objectType);
        switch (visibility) {
            case PACKAGE: {
                this.checkPackagePropertyVisibility(propRef, referenceSource, definingSource);
                break;
            }
            case PRIVATE: {
                this.checkPrivatePropertyVisibility(propRef, ownerType);
                break;
            }
            case PROTECTED: {
                this.checkProtectedPropertyVisibility(propRef, ownerType);
                break;
            }
        }
    }

    private void checkPackagePropertyVisibility(PropertyReference propRef, StaticSourceFile referenceSource, StaticSourceFile definingSource) {
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        String refPackage = codingConvention.getPackageName(referenceSource);
        String defPackage = codingConvention.getPackageName(definingSource);
        if (refPackage == null || defPackage == null || !refPackage.equals(defPackage)) {
            this.compiler.report(JSError.make(propRef.getSourceNode(), BAD_PACKAGE_PROPERTY_ACCESS, propRef.getName(), propRef.getReadableTypeNameOrDefault()));
        }
    }

    private void checkPrivatePropertyVisibility(PropertyReference propRef, @Nullable ObjectType ownerType) {
        String readableTypeName = ownerType == null || ownerType.equals(propRef.getReceiverType()) ? propRef.getReadableTypeNameOrDefault() : ownerType.toString();
        this.compiler.report(JSError.make(propRef.getSourceNode(), BAD_PRIVATE_PROPERTY_ACCESS, propRef.getName(), readableTypeName));
    }

    private void checkProtectedPropertyVisibility(PropertyReference propRef, @Nullable ObjectType ownerType) {
        if (ownerType != null) {
            for (JSType jSType : this.currentClassStack) {
                if (jSType == null || !jSType.isSubtypeOf(ownerType)) continue;
                return;
            }
        }
        this.compiler.report(JSError.make(propRef.getSourceNode(), BAD_PROTECTED_PROPERTY_ACCESS, propRef.getName(), propRef.getReadableTypeNameOrDefault()));
    }

    private boolean shouldEmitDeprecationWarning(NodeTraversal t, Node n) {
        if (t.inGlobalScope() && !NodeUtil.isInvocationTarget(n) && !n.isNew()) {
            return false;
        }
        return !this.canAccessDeprecatedTypes(t);
    }

    private boolean shouldEmitDeprecationWarning(NodeTraversal t, PropertyReference propRef) {
        if (t.inGlobalScope() && !NodeUtil.isInvocationTarget(propRef.getSourceNode())) {
            return false;
        }
        if (propRef.isMutation()) {
            return false;
        }
        JSDocInfo jsdoc = propRef.getJSDocInfo();
        if (propRef.isDeclaration() && jsdoc != null && jsdoc.isDeprecated()) {
            return false;
        }
        return !this.canAccessDeprecatedTypes(t);
    }

    private boolean canAccessDeprecatedTypes(NodeTraversal t) {
        Node scopeRoot = t.getClosestHoistScopeRoot();
        if (NodeUtil.isFunctionBlock(scopeRoot)) {
            scopeRoot = scopeRoot.getParent();
        }
        Node scopeRootParent = scopeRoot.getParent();
        return this.deprecationDepth > 0 || CheckAccessControls.getTypeDeprecationInfo(this.getTypeOfThis(scopeRoot)) != null || scopeRootParent != null && scopeRootParent.isAssign() && CheckAccessControls.getTypeDeprecationInfo(this.bestInstanceTypeForMethodOrCtor(scopeRoot)) != null;
    }

    private static boolean isMarkedDeprecated(Node n) {
        return CheckAccessControls.getDeprecationReason(NodeUtil.getBestJSDocInfo(n)) != null;
    }

    private static String getTypeDeprecationInfo(JSType type) {
        if (type == null) {
            return null;
        }
        return CheckAccessControls.getDeprecationReason(type.getJSDocInfo());
    }

    private static String getDeprecationReason(JSDocInfo info) {
        if (info != null && info.isDeprecated()) {
            if (info.getDeprecationReason() != null) {
                return info.getDeprecationReason();
            }
            return "";
        }
        return null;
    }

    private boolean isPropertyDeclaredConstant(ObjectType objectType, String prop) {
        if (this.enforceCodingConventions && this.compiler.getCodingConvention().isConstant(prop)) {
            return true;
        }
        while (objectType != null) {
            JSDocInfo docInfo = objectType.getOwnPropertyJSDocInfo(prop);
            if (docInfo != null && docInfo.isConstant()) {
                return true;
            }
            objectType = objectType.getImplicitPrototype();
        }
        return false;
    }

    @Nullable
    private static String getPropertyDeprecationInfo(ObjectType type, String prop) {
        String depReason = CheckAccessControls.getDeprecationReason(type.getOwnPropertyJSDocInfo(prop));
        if (depReason != null) {
            return depReason;
        }
        ObjectType implicitProto = type.getImplicitPrototype();
        if (implicitProto != null) {
            return CheckAccessControls.getPropertyDeprecationInfo(implicitProto, prop);
        }
        return null;
    }

    @Nullable
    private static ObjectType getSuperClassInstanceIfFinal(FunctionType subCtor) {
        JSDocInfo doc;
        FunctionType ctor = subCtor.getSuperClassConstructor();
        JSDocInfo jSDocInfo = doc = ctor == null ? null : ctor.getJSDocInfo();
        if (doc != null && doc.isFinal()) {
            return ctor.getInstanceType();
        }
        return null;
    }

    @Nullable
    private static ObjectType castToObject(@Nullable JSType type) {
        return type == null ? null : type.toMaybeObjectType();
    }

    private static boolean isFunctionOrClass(Node n) {
        return n.isFunction() || n.isClass();
    }

    private static boolean isExtendsTarget(Node node) {
        Node parent = node.getParent();
        return parent.isClass() && node.isSecondChildOf(parent);
    }

    @Nullable
    private JSType getTypeOfThis(Node scopeRoot) {
        if (scopeRoot.isRoot() || scopeRoot.isScript()) {
            return CheckAccessControls.castToObject(scopeRoot.getJSType());
        }
        if (scopeRoot.isModuleBody()) {
            return null;
        }
        Preconditions.checkArgument(scopeRoot.isFunction(), scopeRoot);
        JSType nodeType = scopeRoot.getJSType();
        if (nodeType != null && nodeType.isFunctionType()) {
            return nodeType.toMaybeFunctionType().getTypeOfThis();
        }
        return null;
    }

    @Nullable
    private PropertyReference createPropertyReference(Node sourceNode) {
        Node parent = sourceNode.getParent();
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(sourceNode);
        PropertyReference.Builder builder = PropertyReference.builder();
        block0 : switch (sourceNode.getToken()) {
            case GETPROP: {
                boolean isLValue = NodeUtil.isLValue(sourceNode);
                builder.setName(sourceNode.getLastChild().getString()).setReceiverType(this.boxedOrUnknown(sourceNode.getFirstChild().getJSType())).setMutation(isLValue || sourceNode.getParent().isDelProp()).setDeclaration(parent.isExprResult() || jsdoc != null && jsdoc.isConstant() && isLValue).setOverride(jsdoc != null && isLValue).setReadableTypeName(() -> this.typeRegistry.getReadableTypeName(sourceNode.getFirstChild()));
                break;
            }
            case STRING_KEY: 
            case GETTER_DEF: 
            case SETTER_DEF: 
            case MEMBER_FUNCTION_DEF: {
                switch (parent.getToken()) {
                    case OBJECTLIT: {
                        if (!parent.getJSType().isLiteralObject()) {
                            return null;
                        }
                        builder.setName(sourceNode.getString()).setReceiverType(this.typeOrUnknown(ObjectType.cast(parent.getJSType()))).setMutation(true).setDeclaration(true).setOverride(false).setReadableTypeName(() -> this.typeRegistry.getReadableTypeName(parent));
                        break block0;
                    }
                    case OBJECT_PATTERN: {
                        builder.setName(sourceNode.getString()).setReceiverType(this.typeOrUnknown(ObjectType.cast(parent.getJSType()))).setMutation(false).setDeclaration(false).setOverride(false).setReadableTypeName(() -> this.typeRegistry.getReadableTypeName(parent));
                        break block0;
                    }
                    case CLASS_MEMBERS: {
                        builder.setName(sourceNode.getString()).setReceiverType(this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE)).setMutation(true).setDeclaration(true).setOverride(jsdoc != null).setReadableTypeName(() -> "");
                        JSType ctorType = parent.getParent().getJSType();
                        if (ctorType == null || !ctorType.isFunctionType()) break block0;
                        FunctionType ctorFunctionType = ctorType.toMaybeFunctionType();
                        builder.setReceiverType(sourceNode.isStaticMember() ? ctorFunctionType : ctorFunctionType.getPrototype());
                        break block0;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            default: {
                return null;
            }
        }
        return builder.setSourceNode(sourceNode).build();
    }

    static JSDocInfo.Visibility getEffectivePropertyVisibility(PropertyReference propRef, ObjectType referenceType, ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> fileVisibilityMap, @Nullable CodingConvention codingConvention) {
        String propertyName = propRef.getName();
        boolean isOverride = propRef.isOverride();
        StaticSourceFile definingSource = AccessControlUtils.getDefiningSource(propRef.getSourceNode(), referenceType, propertyName);
        JSDocInfo.Visibility fileOverviewVisibility = fileVisibilityMap.get(definingSource);
        ObjectType objectType = AccessControlUtils.getObjectType(referenceType, isOverride, propertyName);
        if (isOverride) {
            JSDocInfo.Visibility overridden = AccessControlUtils.getOverriddenPropertyVisibility(objectType, propertyName);
            return AccessControlUtils.getEffectiveVisibilityForOverriddenProperty(overridden, fileOverviewVisibility, propertyName, codingConvention);
        }
        return CheckAccessControls.getEffectiveVisibilityForNonOverriddenProperty(propRef, objectType, fileOverviewVisibility, codingConvention);
    }

    private static JSDocInfo.Visibility getEffectiveVisibilityForNonOverriddenProperty(PropertyReference propRef, ObjectType objectType, @Nullable JSDocInfo.Visibility fileOverviewVisibility, @Nullable CodingConvention codingConvention) {
        JSType type;
        JSDocInfo jsdoc;
        String propertyName = propRef.getName();
        if (codingConvention != null && codingConvention.isPrivate(propertyName)) {
            return JSDocInfo.Visibility.PRIVATE;
        }
        JSDocInfo.Visibility raw = JSDocInfo.Visibility.INHERITED;
        if (objectType != null && (jsdoc = objectType.getOwnPropertyJSDocInfo(propertyName)) != null) {
            raw = jsdoc.getVisibility();
        }
        boolean createdFromGoogProvide = (type = propRef.getJSType()) != null && type.isLiteralObject();
        return raw != JSDocInfo.Visibility.INHERITED || fileOverviewVisibility == null || createdFromGoogProvide ? raw : fileOverviewVisibility;
    }

    @AutoValue
    static abstract class PropertyReference {
        PropertyReference() {
        }

        public static Builder builder() {
            return new AutoValue_CheckAccessControls_PropertyReference.Builder();
        }

        public abstract Node getSourceNode();

        public abstract String getName();

        public abstract ObjectType getReceiverType();

        public abstract boolean isMutation();

        public abstract boolean isDeclaration();

        public abstract boolean isOverride();

        public abstract Supplier<String> getReadableTypeName();

        public final Node getParentNode() {
            return this.getSourceNode().getParent();
        }

        public final JSType getJSType() {
            return this.getSourceNode().getJSType();
        }

        @Nullable
        public final JSDocInfo getJSDocInfo() {
            return NodeUtil.getBestJSDocInfo(this.getSourceNode());
        }

        public final boolean isDocumentedDeclaration() {
            return this.isDeclaration() && this.getJSDocInfo() != null;
        }

        public final boolean isDeletion() {
            return this.getSourceNode().getParent().isDelProp();
        }

        public final String getReadableTypeNameOrDefault() {
            String preferred = this.getReadableTypeName().get();
            return preferred.isEmpty() ? this.getReceiverType().toString() : preferred;
        }

        @AutoValue.Builder
        static interface Builder {
            public Builder setSourceNode(Node var1);

            public Builder setName(String var1);

            public Builder setReceiverType(ObjectType var1);

            public Builder setMutation(boolean var1);

            public Builder setDeclaration(boolean var1);

            public Builder setOverride(boolean var1);

            public Builder setReadableTypeName(Supplier<String> var1);

            public PropertyReference build();
        }
    }

    private static enum IdentifierBehaviour {
        NON_CONSTRUCTOR,
        ES5_CLASS_INVOCATION,
        ES5_CLASS_NAMESPACE,
        ES6_CLASS_INVOCATION,
        ES6_CLASS_NAMESPACE;


        public static IdentifierBehaviour select(Node target) {
            boolean isEs6;
            JSType type = target.getJSType();
            if (type == null || !type.isFunctionType()) {
                return NON_CONSTRUCTOR;
            }
            FunctionType ctorType = type.toMaybeFunctionType();
            if (!ctorType.isConstructor()) {
                return NON_CONSTRUCTOR;
            }
            boolean isInvocation = NodeUtil.isInvocationTarget(target) || CheckAccessControls.isExtendsTarget(target);
            boolean bl = isEs6 = ctorType.getSource() != null && ctorType.getSource().isClass();
            if (!isEs6) {
                return isInvocation ? ES5_CLASS_INVOCATION : ES5_CLASS_NAMESPACE;
            }
            return isInvocation ? ES6_CLASS_INVOCATION : ES6_CLASS_NAMESPACE;
        }
    }
}

