/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;

public final class JSDocInfoPrinter {
    public static String print(JSDocInfo info) {
        StringBuilder sb = new StringBuilder("/**");
        if (info.isConstructor()) {
            sb.append("@constructor ");
        }
        if (info.isInterface()) {
            sb.append("@interface ");
        }
        if (info.makesDicts()) {
            sb.append("@dict ");
        }
        if (info.makesStructs()) {
            sb.append("@struct ");
        }
        if (info.makesUnrestricted()) {
            sb.append("@unrestricted ");
        }
        if (info.isDefine()) {
            sb.append("@define {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getType().getRoot());
            sb.append("} ");
        }
        if (info.isOverride()) {
            sb.append("@override ");
        }
        if (info.isConstant()) {
            sb.append("@const ");
        }
        if (info.isDeprecated()) {
            sb.append("@deprecated ");
            sb.append(info.getDeprecationReason() + " ");
        }
        if (info.getVisibility() != null && info.getVisibility() != JSDocInfo.Visibility.INHERITED) {
            sb.append("@" + info.getVisibility().toString().toLowerCase() + " ");
        }
        for (String string : info.getSuppressions()) {
            sb.append("@suppress {" + string + "} ");
        }
        ImmutableList<String> names = info.getTemplateTypeNames();
        if (!names.isEmpty()) {
            sb.append("@template ");
            Joiner.on((char)',').appendTo(sb, names);
            sb.append("\n");
        }
        if (info.getParameterCount() > 0) {
            for (String name : info.getParameterNames()) {
                sb.append("@param {");
                JSDocInfoPrinter.appendTypeNode(sb, info.getParameterType(name).getRoot());
                sb.append("} " + name + "\n");
            }
        }
        if (info.hasReturnType()) {
            sb.append("@return {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getReturnType().getRoot());
            sb.append("}\n");
        }
        if (info.hasThisType()) {
            sb.append("@this {");
            Node node = info.getThisType().getRoot();
            if (node.getType() == 306) {
                JSDocInfoPrinter.appendTypeNode(sb, node.getFirstChild());
            } else {
                JSDocInfoPrinter.appendTypeNode(sb, node);
            }
            sb.append("}\n");
        }
        if (info.hasBaseType()) {
            sb.append("@extends {");
            Node node = info.getBaseType().getRoot();
            if (node.getType() == 306) {
                JSDocInfoPrinter.appendTypeNode(sb, node.getFirstChild());
            } else {
                JSDocInfoPrinter.appendTypeNode(sb, node);
            }
            sb.append("}\n");
        }
        for (JSTypeExpression type : info.getImplementedInterfaces()) {
            sb.append("@implements {");
            Node typeNode2 = type.getRoot();
            if (typeNode2.getType() == 306) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode2.getFirstChild());
            } else {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode2);
            }
            sb.append("}\n");
        }
        if (info.hasTypedefType()) {
            sb.append("@typedef {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getTypedefType().getRoot());
            sb.append("}\n");
        }
        if (info.hasType()) {
            if (info.isInlineType()) {
                sb.append(" ");
                JSDocInfoPrinter.appendTypeNode(sb, info.getType().getRoot());
                sb.append(" ");
            } else {
                sb.append("@type {");
                JSDocInfoPrinter.appendTypeNode(sb, info.getType().getRoot());
                sb.append("}\n");
            }
        }
        if (!info.getThrownTypes().isEmpty()) {
            sb.append("@throws {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getThrownTypes().get(0).getRoot());
            sb.append("}\n");
        }
        if (info.hasEnumParameterType()) {
            sb.append("@enum {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getEnumParameterType().getRoot());
            sb.append("}\n");
        }
        sb.append("*/");
        return sb.toString();
    }

    private static void appendTypeNode(StringBuilder sb, Node typeNode) {
        if (typeNode.getType() == 306) {
            sb.append("!");
            JSDocInfoPrinter.appendTypeNode(sb, typeNode.getFirstChild());
        } else if (typeNode.getType() == 307) {
            JSDocInfoPrinter.appendTypeNode(sb, typeNode.getFirstChild());
            sb.append("=");
        } else if (typeNode.getType() == 301) {
            sb.append("(");
            for (int i = 0; i < typeNode.getChildCount() - 1; ++i) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode.getChildAtIndex(i));
                sb.append("|");
            }
            JSDocInfoPrinter.appendTypeNode(sb, typeNode.getLastChild());
            sb.append(")");
        } else if (typeNode.getType() == 305) {
            sb.append("...");
            if (typeNode.hasChildren()) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode.getFirstChild());
            }
        } else if (typeNode.getType() == 302) {
            sb.append("*");
        } else if (typeNode.getType() == 304) {
            sb.append("?");
        } else if (typeNode.isFunction()) {
            JSDocInfoPrinter.appendFunctionNode(sb, typeNode);
        } else if (typeNode.getType() == 309) {
            sb.append("{");
            Node lb = typeNode.getFirstChild();
            for (int i = 0; i < lb.getChildCount() - 1; ++i) {
                Node colon = lb.getChildAtIndex(i);
                sb.append(colon.getFirstChild().getString() + ":");
                JSDocInfoPrinter.appendTypeNode(sb, colon.getLastChild());
                sb.append(",");
            }
            Node lastColon = lb.getLastChild();
            sb.append(lastColon.getFirstChild().getString() + ":");
            JSDocInfoPrinter.appendTypeNode(sb, lastColon.getLastChild());
            sb.append("}");
        } else if (typeNode.getType() == 122) {
            sb.append("void");
        } else if (typeNode.hasChildren()) {
            sb.append(typeNode.getString()).append("<");
            Node child = typeNode.getFirstChild();
            JSDocInfoPrinter.appendTypeNode(sb, child.getFirstChild());
            for (int i = 1; i < child.getChildCount(); ++i) {
                sb.append(",");
                JSDocInfoPrinter.appendTypeNode(sb, child.getChildAtIndex(i));
            }
            sb.append(">");
        } else {
            sb.append(typeNode.getString());
        }
    }

    private static void appendFunctionNode(StringBuilder sb, Node function) {
        boolean hasNewOrThis = false;
        sb.append("function(");
        Node first = function.getFirstChild();
        if (first.isNew()) {
            sb.append("new:");
            JSDocInfoPrinter.appendTypeNode(sb, first.getFirstChild());
            hasNewOrThis = true;
        } else if (first.isThis()) {
            sb.append("this:");
            JSDocInfoPrinter.appendTypeNode(sb, first.getFirstChild());
            hasNewOrThis = true;
        } else {
            if (first.isEmpty()) {
                sb.append(")");
                return;
            }
            if (!first.isParamList()) {
                sb.append("):");
                JSDocInfoPrinter.appendTypeNode(sb, first);
                return;
            }
        }
        Node paramList = null;
        if (first.isParamList()) {
            paramList = first;
        } else if (first.getNext().isParamList()) {
            paramList = first.getNext();
        }
        if (paramList != null) {
            boolean firstParam = true;
            for (Node param : paramList.children()) {
                if (!firstParam || hasNewOrThis) {
                    sb.append(",");
                }
                JSDocInfoPrinter.appendTypeNode(sb, param);
                firstParam = false;
            }
        }
        sb.append(")");
        Node returnType = function.getLastChild();
        if (!returnType.isEmpty()) {
            sb.append(":");
            JSDocInfoPrinter.appendTypeNode(sb, returnType);
        }
    }
}

