/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

class ES6ModuleLoader {
    static final String MODULE_SLASH = "/";
    static final String INDEX_FILE = "index.js";
    static final DiagnosticType LOAD_ERROR = DiagnosticType.error("JSC_ES6_MODULE_LOAD_ERROR", "Failed to load module \"{0}\"");
    private final Map<String, CompilerInput> inputsByAddress = new HashMap<String, CompilerInput>();
    private final String moduleRoot;
    private final URI moduleRootURI;
    private final AbstractCompiler compiler;

    static boolean isRelativeIdentifier(String name) {
        return name.startsWith("./") || name.startsWith("../");
    }

    ES6ModuleLoader(AbstractCompiler compiler, String moduleRoot) {
        this.moduleRoot = moduleRoot;
        this.moduleRootURI = ES6ModuleLoader.createUri(moduleRoot);
        this.compiler = compiler;
    }

    private void initInputs() {
        if (this.inputsByAddress.isEmpty()) {
            for (CompilerInput input : this.compiler.getInputsInOrder()) {
                this.inputsByAddress.put(this.getLoadAddress(input), input);
            }
        }
    }

    String locate(String name, CompilerInput referrer) {
        URI base = ES6ModuleLoader.isRelativeIdentifier(name) ? ES6ModuleLoader.createUri(referrer) : this.moduleRootURI;
        return this.convertSourceUriToModuleAddress(base.resolve(ES6ModuleLoader.createUri(name)));
    }

    CompilerInput load(String name) throws LoadFailedException {
        this.initInputs();
        return this.inputsByAddress.get(name);
    }

    String getLoadAddress(CompilerInput input) {
        return this.convertSourceUriToModuleAddress(ES6ModuleLoader.createUri(input));
    }

    private static URI createUri(CompilerInput input) {
        return ES6ModuleLoader.createUri(input.getName().replace("\\", MODULE_SLASH));
    }

    private static URI createUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String resolveInFileSystem(String filename) {
        File index;
        File f = new File(filename);
        if (f.exists() && f.isDirectory() && (index = new File(f, INDEX_FILE)).exists()) {
            return this.moduleRootURI.relativize(index.toURI()).getPath();
        }
        return filename;
    }

    private String convertSourceUriToModuleAddress(URI uri) {
        String filename = this.resolveInFileSystem(uri.normalize().toString());
        filename = filename.replace("\\", MODULE_SLASH);
        if (!this.moduleRoot.isEmpty() && filename.indexOf(this.moduleRoot) == 0) {
            filename = filename.substring(this.moduleRoot.length());
        }
        return filename;
    }

    static class LoadFailedException
    extends Exception {
        LoadFailedException() {
        }
    }
}

