/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.BlockFuzzer;
import com.google.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Set;

class IfFuzzer
extends AbstractFuzzer {
    IfFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 3;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        int numComponents = budget <= 3 ? 2 : (this.context.random.nextDouble() < this.getOwnConfig().get("hasElse").getAsDouble() ? 3 : 2);
        Object[] fuzzers = new AbstractFuzzer[numComponents];
        BlockFuzzer blockFuzzer = new BlockFuzzer(this.context);
        Arrays.fill(fuzzers, blockFuzzer);
        fuzzers[0] = new ExpressionFuzzer(this.context);
        Node[] components = this.distribute(budget - 1, (AbstractFuzzer[])fuzzers);
        return new Node(108, components);
    }

    @Override
    protected String getConfigName() {
        return "if";
    }
}

