/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SourceMap {
    private final SourceMapGenerator generator;
    private List<LocationMapping> prefixMappings = Collections.emptyList();
    private final Map<String, String> sourceLocationFixupCache = Maps.newHashMap();

    private SourceMap(SourceMapGenerator generator) {
        this.generator = generator;
    }

    public void addMapping(Node node, FilePosition outputStartPosition, FilePosition outputEndPosition) {
        String sourceFile = node.getSourceFileName();
        if (sourceFile == null || node.getLineno() < 0) {
            return;
        }
        sourceFile = this.fixupSourceLocation(sourceFile);
        String originalName = (String)node.getProp(40);
        int lineBaseOffset = 1;
        this.generator.addMapping(sourceFile, originalName, new FilePosition(node.getLineno() - lineBaseOffset, node.getCharno()), outputStartPosition, outputEndPosition);
    }

    private String fixupSourceLocation(String sourceFile) {
        if (File.separatorChar == '\\') {
            sourceFile = sourceFile.replace('\\', '/');
        }
        if (this.prefixMappings.isEmpty()) {
            return sourceFile;
        }
        String fixed = this.sourceLocationFixupCache.get(sourceFile);
        if (fixed != null) {
            return fixed;
        }
        for (LocationMapping mapping : this.prefixMappings) {
            if (!sourceFile.startsWith(mapping.prefix)) continue;
            fixed = mapping.replacement + sourceFile.substring(mapping.prefix.length());
            break;
        }
        if (fixed == null) {
            fixed = sourceFile;
        }
        this.sourceLocationFixupCache.put(sourceFile, fixed);
        return fixed;
    }

    public void appendTo(Appendable out, String name) throws IOException {
        this.generator.appendTo(out, this.fixupSourceLocation(name));
    }

    public void reset() {
        this.generator.reset();
        this.sourceLocationFixupCache.clear();
    }

    public void setStartingPosition(int offsetLine, int offsetIndex) {
        this.generator.setStartingPosition(offsetLine, offsetIndex);
    }

    public void setWrapperPrefix(String prefix) {
        this.generator.setWrapperPrefix(prefix);
    }

    public void validate(boolean validate) {
        this.generator.validate(validate);
    }

    public void setPrefixMappings(List<LocationMapping> sourceMapLocationMappings) {
        this.prefixMappings = sourceMapLocationMappings;
    }

    public static class LocationMapping {
        final String prefix;
        final String replacement;

        public LocationMapping(String prefix, String replacement) {
            this.prefix = prefix;
            this.replacement = replacement;
        }

        public String toString() {
            return "(" + this.prefix + "|" + this.replacement + ")";
        }
    }

    public static enum DetailLevel implements Predicate<Node>
    {
        ALL{

            public boolean apply(Node node) {
                return true;
            }
        }
        ,
        SYMBOLS{

            public boolean apply(Node node) {
                return node.isCall() || node.isNew() || node.isFunction() || node.isName() || NodeUtil.isGet(node) || NodeUtil.isObjectLitKey(node) || node.isString() && NodeUtil.isGet(node.getParent());
            }
        };

    }

    public static enum Format {
        DEFAULT{

            @Override
            SourceMap getInstance() {
                return new SourceMap(SourceMapGeneratorFactory.getInstance(SourceMapFormat.DEFAULT));
            }
        }
        ,
        V3{

            @Override
            SourceMap getInstance() {
                return new SourceMap(SourceMapGeneratorFactory.getInstance(SourceMapFormat.V3));
            }
        };


        abstract SourceMap getInstance();
    }
}

