/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AliasKeywords
implements CompilerPass {
    static final String ALIAS_NULL = "JSCompiler_alias_NULL";
    static final String ALIAS_TRUE = "JSCompiler_alias_TRUE";
    static final String ALIAS_FALSE = "JSCompiler_alias_FALSE";
    static final String ALIAS_THROW = "JSCompiler_alias_THROW";
    static final String ALIAS_VOID = "JSCompiler_alias_VOID";
    static final int MIN_OCCURRENCES_REQUIRED_TO_ALIAS_LITERAL = 6;
    static final int MIN_OCCURRENCES_REQUIRED_TO_ALIAS_THROW = AliasKeywords.estimateMinOccurrencesRequriedToAlias();
    private final AbstractCompiler compiler;
    private final List<AliasSpecification> aliasSpecifications;
    private final Map<Integer, AliasSpecification> aliasTypes;
    private final Set<String> aliasNames;

    static int estimateMinOccurrencesRequriedToAlias() {
        Node alias = AliasKeywords.createAliasFunctionNode("TT");
        return InlineCostEstimator.getCost(alias) / 2 + 1;
    }

    private static Node createAliasFunctionNode(String aliasName) {
        String paramName = "jscomp_throw_param";
        return IR.function(IR.name(aliasName), IR.paramList(IR.name("jscomp_throw_param")), IR.block(IR.throwNode(IR.name("jscomp_throw_param"))));
    }

    AliasKeywords(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.aliasSpecifications = this.createAliasSpecifications();
        this.aliasTypes = Maps.newLinkedHashMap();
        this.aliasNames = Sets.newLinkedHashSet();
        for (AliasSpecification specification : this.aliasSpecifications) {
            this.aliasTypes.put(specification.getTokenId(), specification);
            this.aliasNames.add(specification.getAliasName());
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new FindAliasableNodes());
        if (this.needsAliases()) {
            this.addAliasNodes(this.compiler.getNodeForCodeInsertion(null));
            for (AliasSpecification spec : this.aliasSpecifications) {
                spec.doAlias(this.compiler);
            }
        }
    }

    private boolean needsAliases() {
        for (AliasSpecification spec : this.aliasSpecifications) {
            if (spec.nodes.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void addAliasNodes(Node codeRoot) {
        boolean codeChanged = false;
        for (AliasSpecification spec : this.aliasSpecifications) {
            if (!spec.maybeInsertAliasDeclarationIntoParseTree(codeRoot)) continue;
            codeChanged = true;
        }
        if (codeChanged) {
            this.compiler.reportCodeChange();
        }
    }

    private boolean isAliasDefinition(Node n) {
        if (!n.isName()) {
            return false;
        }
        if (!this.isAliasName(n.getString())) {
            return false;
        }
        return n.getFirstChild() != null;
    }

    private boolean isAliasableType(int type) {
        return this.aliasTypes.containsKey(type);
    }

    private boolean isAliasName(String name) {
        return this.aliasNames.contains(name);
    }

    private List<AliasSpecification> createAliasSpecifications() {
        ArrayList l = Lists.newArrayList();
        l.add(new KeywordAliasSpecification(ALIAS_FALSE, 43));
        l.add(new KeywordAliasSpecification(ALIAS_NULL, 41));
        l.add(new KeywordAliasSpecification(ALIAS_TRUE, 44));
        l.add(new VoidKeywordAliasSpecification(ALIAS_VOID, 122));
        l.add(new ThrowAliasSpecification(ALIAS_THROW));
        return l;
    }

    private class VoidKeywordAliasSpecification
    extends AliasSpecification {
        VoidKeywordAliasSpecification(String aliasName, int tokenId) {
            super(aliasName, tokenId);
        }

        @Override
        public void visit(Node n, Node parent) {
            Node value = n.getFirstChild();
            if (value.isNumber() && value.getDouble() == 0.0) {
                super.visit(n, parent);
            }
        }

        @Override
        protected int minOccurrencesRequiredToAlias() {
            return 6;
        }

        @Override
        protected void aliasNode(Node n, Node parent) {
            Node aliasNode = NodeUtil.newName(AliasKeywords.this.compiler, this.getAliasName(), n, this.getAliasName());
            parent.replaceChild(n, aliasNode);
        }

        @Override
        protected void insertAliasDeclaration(Node codeRoot) {
            Node varNode = new Node(118);
            Node value = IR.voidNode(IR.number(0.0));
            Node name = NodeUtil.newName(AliasKeywords.this.compiler, this.getAliasName(), varNode, this.getAliasName());
            name.addChildToBack(value);
            varNode.addChildToBack(name);
            codeRoot.addChildrenToFront(varNode);
        }
    }

    private class KeywordAliasSpecification
    extends AliasSpecification {
        KeywordAliasSpecification(String aliasName, int tokenId) {
            super(aliasName, tokenId);
        }

        @Override
        protected int minOccurrencesRequiredToAlias() {
            return 6;
        }

        @Override
        protected void aliasNode(Node n, Node parent) {
            Node aliasNode = NodeUtil.newName(AliasKeywords.this.compiler, this.getAliasName(), n, this.getAliasName());
            parent.replaceChild(n, aliasNode);
        }

        @Override
        protected void insertAliasDeclaration(Node codeRoot) {
            Node varNode = new Node(118);
            Node value = new Node(this.getTokenId());
            Node name = NodeUtil.newName(AliasKeywords.this.compiler, this.getAliasName(), varNode, this.getAliasName());
            name.addChildToBack(value);
            varNode.addChildToBack(name);
            codeRoot.addChildrenToFront(varNode);
        }
    }

    private class ThrowAliasSpecification
    extends AliasSpecification {
        ThrowAliasSpecification(String aliasName) {
            super(aliasName, 49);
        }

        @Override
        protected void aliasNode(Node throwNode, Node parent) {
            Node name = NodeUtil.newName(AliasKeywords.this.compiler, this.getAliasName(), throwNode, this.getAliasName());
            Node aliasCall = IR.call(name, throwNode.removeFirstChild());
            aliasCall.putBooleanProp(50, true);
            Node exprResult = IR.exprResult(aliasCall);
            parent.replaceChild(throwNode, exprResult);
        }

        @Override
        protected void insertAliasDeclaration(Node codeRoot) {
            codeRoot.addChildToFront(AliasKeywords.createAliasFunctionNode(this.getAliasName()));
        }

        @Override
        protected int minOccurrencesRequiredToAlias() {
            return MIN_OCCURRENCES_REQUIRED_TO_ALIAS_THROW;
        }
    }

    private static abstract class AliasSpecification {
        private final Map<Node, Node> nodes = Maps.newHashMap();
        private boolean isAliased = false;
        private String aliasName;
        private int tokenId;

        public AliasSpecification(String aliasName, int tokenId) {
            this.aliasName = aliasName;
            this.tokenId = tokenId;
        }

        public void visit(Node n, Node parent) {
            this.nodes.put(n, parent);
        }

        boolean maybeInsertAliasDeclarationIntoParseTree(Node codeRoot) {
            if (this.nodes.size() >= this.minOccurrencesRequiredToAlias()) {
                this.insertAliasDeclaration(codeRoot);
                this.isAliased = true;
                return true;
            }
            return false;
        }

        public void doAlias(AbstractCompiler compiler) {
            if (this.isAliased) {
                for (Map.Entry<Node, Node> entry : this.nodes.entrySet()) {
                    Node n = entry.getKey();
                    Node parent = entry.getValue();
                    this.aliasNode(n, parent);
                    compiler.reportCodeChange();
                }
            }
        }

        public int getTokenId() {
            return this.tokenId;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        protected abstract int minOccurrencesRequiredToAlias();

        protected abstract void insertAliasDeclaration(Node var1);

        protected abstract void aliasNode(Node var1, Node var2);
    }

    private class FindAliasableNodes
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindAliasableNodes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            int type = n.getType();
            if (AliasKeywords.this.isAliasableType(type)) {
                this.visitAliasableNode(n, parent);
            } else if (type == 38) {
                this.visitNameNode(n);
            }
        }

        private void visitAliasableNode(Node n, Node parent) {
            AliasSpecification aliasableNodes = (AliasSpecification)AliasKeywords.this.aliasTypes.get(n.getType());
            aliasableNodes.visit(n, parent);
        }

        private void visitNameNode(Node n) {
            if (AliasKeywords.this.isAliasDefinition(n)) {
                throw new IllegalStateException("Existing alias definition for " + Token.name(n.getType()));
            }
        }
    }
}

