/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticReference;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import com.google.javascript.rhino.jstype.StaticSymbolTable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Scope
implements StaticScope<JSType>,
StaticSymbolTable<Var, Var> {
    private final Map<String, Var> vars = new LinkedHashMap<String, Var>();
    private final Scope parent;
    private final int depth;
    private final Node rootNode;
    private final boolean isBottom;
    private Var arguments;
    private static final Predicate<Var> DECLARATIVELY_UNBOUND_VARS_WITHOUT_TYPES = new Predicate<Var>(){

        public boolean apply(Var var) {
            return var.getParentNode() != null && var.getType() == null && var.getParentNode().isVar() && !var.isExtern();
        }
    };
    private TypeResolver typeResolver;

    Scope(Scope parent, Node rootNode) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkArgument((rootNode != parent.rootNode ? 1 : 0) != 0);
        this.parent = parent;
        this.rootNode = rootNode;
        this.isBottom = false;
        this.depth = parent.depth + 1;
    }

    private Scope(Node rootNode, boolean isBottom) {
        this.parent = null;
        this.rootNode = rootNode;
        this.isBottom = isBottom;
        this.depth = 0;
    }

    static Scope createGlobalScope(Node rootNode) {
        return new Scope(rootNode, false);
    }

    static Scope createLatticeBottom(Node rootNode) {
        return new Scope(rootNode, true);
    }

    int getDepth() {
        return this.depth;
    }

    boolean isBottom() {
        return this.isBottom;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    public Scope getParent() {
        return this.parent;
    }

    Scope getGlobalScope() {
        Scope result = this;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    @Override
    public StaticScope<JSType> getParentScope() {
        return this.parent;
    }

    @Override
    public JSType getTypeOfThis() {
        if (this.isGlobal()) {
            return ObjectType.cast(this.rootNode.getJSType());
        }
        Preconditions.checkState((boolean)this.rootNode.isFunction());
        JSType nodeType = this.rootNode.getJSType();
        if (nodeType != null && nodeType.isFunctionType()) {
            return nodeType.toMaybeFunctionType().getTypeOfThis();
        }
        return this.parent.getTypeOfThis();
    }

    Var declare(String name, Node nameNode, JSType type, CompilerInput input) {
        return this.declare(name, nameNode, type, input, true);
    }

    Var declare(String name, Node nameNode, JSType type, CompilerInput input, boolean inferred) {
        Preconditions.checkState((name != null && !name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.vars.get(name) == null ? 1 : 0) != 0);
        Var var = new Var(inferred, name, nameNode, type, this, this.vars.size(), input);
        this.vars.put(name, var);
        return var;
    }

    void undeclare(Var var) {
        Preconditions.checkState((var.scope == this ? 1 : 0) != 0);
        Preconditions.checkState((this.vars.get(var.name) == var ? 1 : 0) != 0);
        this.vars.remove(var.name);
    }

    public Var getSlot(String name) {
        return this.getVar(name);
    }

    public Var getOwnSlot(String name) {
        return this.vars.get(name);
    }

    public Var getVar(String name) {
        Scope scope = this;
        while (scope != null) {
            Var var = scope.vars.get(name);
            if (var != null) {
                return var;
            }
            scope = scope.parent;
        }
        return null;
    }

    public Var getArgumentsVar() {
        if (this.arguments == null) {
            this.arguments = new Arguments(this);
        }
        return this.arguments;
    }

    public boolean isDeclared(String name, boolean recurse) {
        Scope scope = this;
        while (true) {
            if (scope.vars.containsKey(name)) {
                return true;
            }
            if (scope.parent == null || !recurse) break;
            scope = scope.parent;
        }
        return false;
    }

    public Iterator<Var> getVars() {
        return this.vars.values().iterator();
    }

    Iterable<Var> getVarIterable() {
        return this.vars.values();
    }

    @Override
    public Iterable<Var> getReferences(Var var) {
        return ImmutableList.of((Object)var);
    }

    @Override
    public StaticScope<JSType> getScope(Var var) {
        return var.scope;
    }

    @Override
    public Iterable<Var> getAllSymbols() {
        return Collections.unmodifiableCollection(this.vars.values());
    }

    public int getVarCount() {
        return this.vars.size();
    }

    public boolean isGlobal() {
        return this.parent == null;
    }

    public boolean isLocal() {
        return this.parent != null;
    }

    public Iterator<Var> getDeclarativelyUnboundVarsWithoutTypes() {
        return Iterators.filter(this.getVars(), DECLARATIVELY_UNBOUND_VARS_WITHOUT_TYPES);
    }

    void resolveTypes() {
        if (this.typeResolver != null) {
            this.typeResolver.resolveTypes();
            this.typeResolver = null;
        }
    }

    void setTypeResolver(TypeResolver resolver) {
        this.typeResolver = resolver;
    }

    static interface TypeResolver {
        public void resolveTypes();
    }

    public static class Arguments
    extends Var {
        Arguments(Scope scope) {
            super(false, "arguments", null, null, scope, -1, null);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Arguments)) {
                return false;
            }
            Arguments otherVar = (Arguments)other;
            return otherVar.scope.getRootNode() == this.scope.getRootNode();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    public static class Var
    implements StaticSlot<JSType>,
    StaticReference<JSType> {
        final String name;
        final Node nameNode;
        private JSType type;
        private final boolean typeInferred;
        final CompilerInput input;
        final int index;
        final Scope scope;
        private boolean markedEscaped = false;
        private boolean markedAssignedExactlyOnce = false;

        private Var(boolean inferred, String name, Node nameNode, JSType type, Scope scope, int index, CompilerInput input) {
            this.name = name;
            this.nameNode = nameNode;
            this.type = type;
            this.scope = scope;
            this.index = index;
            this.input = input;
            this.typeInferred = inferred;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Node getNode() {
            return this.nameNode;
        }

        CompilerInput getInput() {
            return this.input;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.nameNode.getStaticSourceFile();
        }

        public Var getSymbol() {
            return this;
        }

        public Var getDeclaration() {
            return this.nameNode == null ? null : this;
        }

        public Node getParentNode() {
            return this.nameNode == null ? null : this.nameNode.getParent();
        }

        public boolean isBleedingFunction() {
            return NodeUtil.isFunctionExpression(this.getParentNode());
        }

        Scope getScope() {
            return this.scope;
        }

        public boolean isGlobal() {
            return this.scope.isGlobal();
        }

        public boolean isLocal() {
            return this.scope.isLocal();
        }

        boolean isExtern() {
            return this.input == null || this.input.isExtern();
        }

        public boolean isConst() {
            if (this.nameNode == null) {
                return false;
            }
            return this.nameNode.getBooleanProp(64) || this.nameNode.getBooleanProp(43);
        }

        public boolean isDefine() {
            JSDocInfo info = this.getJSDocInfo();
            return info != null && info.isDefine();
        }

        public Node getInitialValue() {
            return NodeUtil.getRValueOfLValue(this.nameNode);
        }

        @Override
        public JSType getType() {
            return this.type;
        }

        public Node getNameNode() {
            return this.nameNode;
        }

        @Override
        public JSDocInfo getJSDocInfo() {
            return this.nameNode == null ? null : NodeUtil.getBestJSDocInfo(this.nameNode);
        }

        void setType(JSType type) {
            Preconditions.checkState((boolean)this.isTypeInferred());
            this.type = type;
        }

        void resolveType(ErrorReporter errorReporter) {
            if (this.type != null) {
                this.type = this.type.resolve(errorReporter, this.scope);
            }
        }

        @Override
        public boolean isTypeInferred() {
            return this.typeInferred;
        }

        public String getInputName() {
            if (this.input == null) {
                return "<non-file>";
            }
            return this.input.getName();
        }

        public boolean isNoShadow() {
            JSDocInfo info = this.getJSDocInfo();
            return info != null && info.isNoShadow();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Var)) {
                return false;
            }
            Var otherVar = (Var)other;
            return otherVar.nameNode == this.nameNode;
        }

        public int hashCode() {
            return this.nameNode.hashCode();
        }

        public String toString() {
            return "Scope.Var " + this.name + "{" + this.type + "}";
        }

        void markEscaped() {
            this.markedEscaped = true;
        }

        boolean isMarkedEscaped() {
            return this.markedEscaped;
        }

        void markAssignedExactlyOnce() {
            this.markedAssignedExactlyOnce = true;
        }

        boolean isMarkedAssignedExactlyOnce() {
            return this.markedAssignedExactlyOnce;
        }
    }
}

