/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TemplateType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

final class FunctionTypeBuilder {
    private final String fnName;
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private final Node errorRoot;
    private final String sourceName;
    private final Scope scope;
    private FunctionContents contents = UnknownFunctionContents.get();
    private JSType returnType = null;
    private boolean returnTypeInferred = false;
    private List<ObjectType> implementedInterfaces = null;
    private List<ObjectType> extendedInterfaces = null;
    private ObjectType baseType = null;
    private JSType thisType = null;
    private boolean isConstructor = false;
    private boolean makesStructs = false;
    private boolean makesDicts = false;
    private boolean isInterface = false;
    private Node parametersNode = null;
    private ImmutableList<TemplateType> templateTypeNames = ImmutableList.of();
    private ImmutableList<TemplateType> classTemplateTypeNames = ImmutableList.of();
    static final DiagnosticType EXTENDS_WITHOUT_TYPEDEF = DiagnosticType.warning("JSC_EXTENDS_WITHOUT_TYPEDEF", "@extends used without @constructor or @interface for {0}");
    static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} @extends non-object type {1}");
    static final DiagnosticType RESOLVED_TAG_EMPTY = DiagnosticType.warning("JSC_RESOLVED_TAG_EMPTY", "Could not resolve type in {0} tag of {1}");
    static final DiagnosticType IMPLEMENTS_WITHOUT_CONSTRUCTOR = DiagnosticType.warning("JSC_IMPLEMENTS_WITHOUT_CONSTRUCTOR", "@implements used without @constructor or @interface for {0}");
    static final DiagnosticType CONSTRUCTOR_REQUIRED = DiagnosticType.warning("JSC_CONSTRUCTOR_REQUIRED", "{0} used without @constructor for {1}");
    static final DiagnosticType VAR_ARGS_MUST_BE_LAST = DiagnosticType.warning("JSC_VAR_ARGS_MUST_BE_LAST", "variable length argument must be last");
    static final DiagnosticType OPTIONAL_ARG_AT_END = DiagnosticType.warning("JSC_OPTIONAL_ARG_AT_END", "optional arguments must be at the end");
    static final DiagnosticType INEXISTANT_PARAM = DiagnosticType.warning("JSC_INEXISTANT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType TYPE_REDEFINITION = DiagnosticType.warning("JSC_TYPE_REDEFINITION", "attempted re-definition of type {0}\nfound   : {1}\nexpected: {2}");
    static final DiagnosticType TEMPLATE_TYPE_DUPLICATED = DiagnosticType.warning("JSC_TEMPLATE_TYPE_DUPLICATED", "Only one parameter type must be the template type");
    static final DiagnosticType TEMPLATE_TYPE_EXPECTED = DiagnosticType.warning("JSC_TEMPLATE_TYPE_EXPECTED", "The template type must be a parameter type");
    static final DiagnosticType THIS_TYPE_NON_OBJECT = DiagnosticType.warning("JSC_THIS_TYPE_NON_OBJECT", "@this type of a function must be an object\nActual type: {0}");
    static final DiagnosticType SAME_INTERFACE_MULTIPLE_IMPLEMENTS = DiagnosticType.warning("JSC_SAME_INTERFACE_MULTIPLE_IMPLEMENTS", "Cannot @implement the same interface more than once\nRepeated interface: {0}");

    FunctionTypeBuilder(String fnName, AbstractCompiler compiler, Node errorRoot, String sourceName, Scope scope) {
        Preconditions.checkNotNull((Object)errorRoot);
        this.fnName = fnName == null ? "" : fnName;
        this.codingConvention = compiler.getCodingConvention();
        this.typeRegistry = compiler.getTypeRegistry();
        this.errorRoot = errorRoot;
        this.sourceName = sourceName;
        this.compiler = compiler;
        this.scope = scope;
    }

    String formatFnName() {
        return this.fnName.isEmpty() ? "<anonymous>" : this.fnName;
    }

    FunctionTypeBuilder setContents(@Nullable FunctionContents contents) {
        if (contents != null) {
            this.contents = contents;
        }
        return this;
    }

    FunctionTypeBuilder inferFromOverriddenFunction(@Nullable FunctionType oldType, @Nullable Node paramsParent) {
        if (oldType == null) {
            return this;
        }
        this.returnType = oldType.getReturnType();
        this.returnTypeInferred = oldType.isReturnTypeInferred();
        if (paramsParent == null) {
            this.parametersNode = oldType.getParametersNode();
            if (this.parametersNode == null) {
                this.parametersNode = new FunctionParamBuilder(this.typeRegistry).build();
            }
        } else {
            FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this.typeRegistry);
            Iterator<Node> oldParams = oldType.getParameters().iterator();
            boolean warnedAboutArgList = false;
            boolean oldParamsListHitOptArgs = false;
            for (Node currentParam = paramsParent.getFirstChild(); currentParam != null; currentParam = currentParam.getNext()) {
                if (oldParams.hasNext()) {
                    Node oldParam = oldParams.next();
                    Node newParam = paramBuilder.newParameterFromNode(oldParam);
                    boolean bl = oldParamsListHitOptArgs = oldParamsListHitOptArgs || oldParam.isVarArgs() || oldParam.isOptionalArg();
                    if (currentParam.getNext() == null || !newParam.isVarArgs()) continue;
                    newParam.setVarArgs(false);
                    newParam.setOptionalArg(true);
                    continue;
                }
                warnedAboutArgList |= this.addParameter(paramBuilder, this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE), warnedAboutArgList, this.codingConvention.isOptionalParameter(currentParam) || oldParamsListHitOptArgs, this.codingConvention.isVarArgsParameter(currentParam));
            }
            while (oldParams.hasNext()) {
                paramBuilder.newOptionalParameterFromNode(oldParams.next());
            }
            this.parametersNode = paramBuilder.build();
        }
        return this;
    }

    FunctionTypeBuilder inferReturnType(@Nullable JSDocInfo info) {
        if (info != null && info.hasReturnType()) {
            this.returnType = info.getReturnType().evaluate(this.scope, this.typeRegistry);
            this.returnTypeInferred = false;
        }
        return this;
    }

    FunctionTypeBuilder inferInheritance(@Nullable JSDocInfo info) {
        if (info != null) {
            this.isConstructor = info.isConstructor();
            this.makesStructs = info.makesStructs();
            this.makesDicts = info.makesDicts();
            this.isInterface = info.isInterface();
            if (this.makesStructs && !this.isConstructor) {
                this.reportWarning(CONSTRUCTOR_REQUIRED, "@struct", this.formatFnName());
            } else if (this.makesDicts && !this.isConstructor) {
                this.reportWarning(CONSTRUCTOR_REQUIRED, "@dict", this.formatFnName());
            }
            ImmutableList<String> typeParameters = info.getTemplateTypeNames();
            if (!typeParameters.isEmpty() && (this.isConstructor || this.isInterface)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (String typeParameter : typeParameters) {
                    builder.add((Object)this.typeRegistry.createTemplateType(typeParameter));
                }
                this.classTemplateTypeNames = builder.build();
                this.typeRegistry.setTemplateTypeNames((List<TemplateType>)this.classTemplateTypeNames);
            }
            if (info.hasBaseType()) {
                if (this.isConstructor) {
                    JSType maybeBaseType = info.getBaseType().evaluate(this.scope, this.typeRegistry);
                    if (maybeBaseType != null && maybeBaseType.setValidator(new ExtendedTypeValidator())) {
                        this.baseType = (ObjectType)maybeBaseType;
                    }
                } else {
                    this.reportWarning(EXTENDS_WITHOUT_TYPEDEF, this.formatFnName());
                }
            }
            if (info.getImplementedInterfaceCount() > 0) {
                if (this.isConstructor) {
                    this.implementedInterfaces = Lists.newArrayList();
                    HashSet<JSType> baseInterfaces = new HashSet<JSType>();
                    for (JSTypeExpression t : info.getImplementedInterfaces()) {
                        JSType maybeInterType = t.evaluate(this.scope, this.typeRegistry);
                        if (maybeInterType == null || !maybeInterType.setValidator(new ImplementedTypeValidator())) continue;
                        JSType baseInterface = maybeInterType;
                        if (baseInterface.toMaybeTemplatizedType() != null) {
                            baseInterface = baseInterface.toMaybeTemplatizedType().getReferencedType();
                        }
                        if (baseInterfaces.contains(baseInterface)) {
                            this.reportWarning(SAME_INTERFACE_MULTIPLE_IMPLEMENTS, baseInterface.toString());
                        } else {
                            baseInterfaces.add(baseInterface);
                        }
                        this.implementedInterfaces.add((ObjectType)maybeInterType);
                    }
                } else if (this.isInterface) {
                    this.reportWarning(TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, this.formatFnName());
                } else {
                    this.reportWarning(CONSTRUCTOR_REQUIRED, "@implements", this.formatFnName());
                }
            }
            if (this.isInterface) {
                this.extendedInterfaces = Lists.newArrayList();
                for (JSTypeExpression t : info.getExtendedInterfaces()) {
                    JSType maybeInterfaceType = t.evaluate(this.scope, this.typeRegistry);
                    if (maybeInterfaceType == null || !maybeInterfaceType.setValidator(new ExtendedTypeValidator())) continue;
                    this.extendedInterfaces.add((ObjectType)maybeInterfaceType);
                }
            }
        }
        return this;
    }

    FunctionTypeBuilder inferThisType(JSDocInfo info, JSType type) {
        ObjectType objType;
        this.inferThisType(info);
        if (!(this.thisType != null || (objType = ObjectType.cast(type)) == null || info != null && info.hasType())) {
            this.thisType = objType;
        }
        return this;
    }

    FunctionTypeBuilder inferThisType(JSDocInfo info) {
        JSType maybeThisType = null;
        if (info != null && info.hasThisType()) {
            maybeThisType = info.getThisType().evaluate(this.scope, this.typeRegistry).restrictByNotNullOrUndefined();
        }
        if (maybeThisType != null) {
            this.thisType = maybeThisType;
        }
        return this;
    }

    FunctionTypeBuilder inferParameterTypes(JSDocInfo info) {
        Node lp = IR.paramList();
        for (String name : info.getParameterNames()) {
            lp.addChildToBack(IR.name(name));
        }
        return this.inferParameterTypes(lp, info);
    }

    FunctionTypeBuilder inferParameterTypes(@Nullable Node argsParent, @Nullable JSDocInfo info) {
        if (argsParent == null) {
            if (info == null) {
                return this;
            }
            return this.inferParameterTypes(info);
        }
        Node oldParameterType = null;
        if (this.parametersNode != null) {
            oldParameterType = this.parametersNode.getFirstChild();
        }
        FunctionParamBuilder builder = new FunctionParamBuilder(this.typeRegistry);
        boolean warnedAboutArgList = false;
        HashSet allJsDocParams = info == null ? Sets.newHashSet() : Sets.newHashSet(info.getParameterNames());
        boolean isVarArgs = false;
        for (Node arg : argsParent.children()) {
            String argumentName = arg.getString();
            allJsDocParams.remove(argumentName);
            JSType parameterType = null;
            boolean isOptionalParam = this.isOptionalParameter(arg, info);
            isVarArgs = this.isVarArgsParameter(arg, info);
            if (info != null && info.hasParameterType(argumentName)) {
                parameterType = info.getParameterType(argumentName).evaluate(this.scope, this.typeRegistry);
            } else if (arg.getJSDocInfo() != null && arg.getJSDocInfo().hasType()) {
                parameterType = arg.getJSDocInfo().getType().evaluate(this.scope, this.typeRegistry);
            } else if (oldParameterType != null && oldParameterType.getJSType() != null) {
                parameterType = oldParameterType.getJSType();
                isOptionalParam = oldParameterType.isOptionalArg();
                isVarArgs = oldParameterType.isVarArgs();
            } else {
                parameterType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            warnedAboutArgList |= this.addParameter(builder, parameterType, warnedAboutArgList, isOptionalParam, isVarArgs);
            if (oldParameterType == null) continue;
            oldParameterType = oldParameterType.getNext();
        }
        if (!isVarArgs) {
            while (oldParameterType != null && !isVarArgs) {
                builder.newParameterFromNode(oldParameterType);
                oldParameterType = oldParameterType.getNext();
            }
        }
        for (String inexistentName : allJsDocParams) {
            this.reportWarning(INEXISTANT_PARAM, inexistentName, this.formatFnName());
        }
        this.parametersNode = builder.build();
        return this;
    }

    private boolean isOptionalParameter(Node param, @Nullable JSDocInfo info) {
        if (this.codingConvention.isOptionalParameter(param)) {
            return true;
        }
        String paramName = param.getString();
        return info != null && info.hasParameterType(paramName) && info.getParameterType(paramName).isOptionalArg();
    }

    private boolean isVarArgsParameter(Node param, @Nullable JSDocInfo info) {
        if (this.codingConvention.isVarArgsParameter(param)) {
            return true;
        }
        String paramName = param.getString();
        return info != null && info.hasParameterType(paramName) && info.getParameterType(paramName).isVarArgs();
    }

    FunctionTypeBuilder inferTemplateTypeName(@Nullable JSDocInfo info, JSType ownerType) {
        ImmutableList<TemplateType> ownerTypeKeys;
        if (info != null && !info.getTemplateTypeNames().isEmpty()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String key : info.getTemplateTypeNames()) {
                builder.add((Object)this.typeRegistry.createTemplateType(key));
            }
            this.templateTypeNames = builder.build();
        } else {
            this.templateTypeNames = ImmutableList.of();
        }
        ImmutableList keys = this.templateTypeNames;
        if (ownerType != null && !(ownerTypeKeys = ownerType.getTemplateTypeMap().getTemplateKeys()).isEmpty()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.templateTypeNames);
            builder.addAll(ownerTypeKeys);
            keys = builder.build();
        }
        if (!keys.isEmpty()) {
            this.typeRegistry.setTemplateTypeNames((List<TemplateType>)keys);
        }
        return this;
    }

    private boolean addParameter(FunctionParamBuilder builder, JSType paramType, boolean warnedAboutArgList, boolean isOptional, boolean isVarArgs) {
        boolean emittedWarning = false;
        if (isOptional) {
            if (!builder.addOptionalParams(paramType) && !warnedAboutArgList) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
                emittedWarning = true;
            }
        } else if (isVarArgs) {
            if (!builder.addVarArgs(paramType) && !warnedAboutArgList) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
                emittedWarning = true;
            }
        } else if (!builder.addRequiredParams(paramType) && !warnedAboutArgList) {
            if (builder.hasVarArgs()) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
            } else {
                this.reportWarning(OPTIONAL_ARG_AT_END, new String[0]);
            }
            emittedWarning = true;
        }
        return emittedWarning;
    }

    FunctionType buildAndRegister() {
        FunctionType fnType;
        if (!(this.returnType != null || this.contents.mayHaveNonEmptyReturns() || this.contents.mayHaveSingleThrow() || this.contents.mayBeFromExterns())) {
            this.returnType = this.typeRegistry.getNativeType(JSTypeNative.VOID_TYPE);
            this.returnTypeInferred = true;
        }
        if (this.returnType == null) {
            this.returnType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (this.parametersNode == null) {
            throw new IllegalStateException("All Function types must have params and a return type");
        }
        if (this.isConstructor) {
            fnType = this.getOrCreateConstructor();
        } else if (this.isInterface) {
            fnType = this.typeRegistry.createInterfaceType(this.fnName, this.contents.getSourceNode(), this.classTemplateTypeNames);
            if (this.getScopeDeclaredIn().isGlobal() && !this.fnName.isEmpty()) {
                this.typeRegistry.declareType(this.fnName, fnType.getInstanceType());
            }
            this.maybeSetBaseType(fnType);
        } else {
            fnType = new FunctionBuilder(this.typeRegistry).withName(this.fnName).withSourceNode(this.contents.getSourceNode()).withParamsNode(this.parametersNode).withReturnType(this.returnType, this.returnTypeInferred).withTypeOfThis(this.thisType).withTemplateKeys(this.templateTypeNames).build();
            this.maybeSetBaseType(fnType);
        }
        if (this.implementedInterfaces != null) {
            fnType.setImplementedInterfaces(this.implementedInterfaces);
        }
        if (this.extendedInterfaces != null) {
            fnType.setExtendedInterfaces(this.extendedInterfaces);
        }
        this.typeRegistry.clearTemplateTypeNames();
        return fnType;
    }

    private void maybeSetBaseType(FunctionType fnType) {
        if (!fnType.isInterface() && this.baseType != null) {
            fnType.setPrototypeBasedOn(this.baseType);
            fnType.extendTemplateTypeMapBasedOn(this.baseType);
        }
    }

    private FunctionType getOrCreateConstructor() {
        boolean isInstanceObject;
        FunctionType fnType = this.typeRegistry.createConstructorType(this.fnName, this.contents.getSourceNode(), this.parametersNode, this.returnType, this.classTemplateTypeNames);
        JSType existingType = this.typeRegistry.getType(this.fnName);
        if (this.makesStructs) {
            fnType.setStruct();
        } else if (this.makesDicts) {
            fnType.setDict();
        }
        if (existingType != null && ((isInstanceObject = existingType.isInstanceType()) || this.fnName.equals("Function"))) {
            FunctionType existingFn;
            FunctionType functionType = existingFn = isInstanceObject ? existingType.toObjectType().getConstructor() : this.typeRegistry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
            if (existingFn.getSource() == null) {
                existingFn.setSource(this.contents.getSourceNode());
            }
            if (!existingFn.hasEqualCallType(fnType)) {
                this.reportWarning(TYPE_REDEFINITION, this.formatFnName(), fnType.toString(), existingFn.toString());
            }
            return existingFn;
        }
        this.maybeSetBaseType(fnType);
        if (this.getScopeDeclaredIn().isGlobal() && !this.fnName.isEmpty()) {
            this.typeRegistry.declareType(this.fnName, fnType.getInstanceType());
        }
        return fnType;
    }

    private void reportWarning(DiagnosticType warning, String ... args) {
        this.compiler.report(JSError.make(this.sourceName, this.errorRoot, warning, args));
    }

    private void reportError(DiagnosticType error, String ... args) {
        this.compiler.report(JSError.make(this.sourceName, this.errorRoot, error, args));
    }

    static boolean isFunctionTypeDeclaration(JSDocInfo info) {
        return info.getParameterCount() > 0 || info.hasReturnType() || info.hasThisType() || info.isConstructor() || info.isInterface();
    }

    private Scope getScopeDeclaredIn() {
        String rootVarName;
        Scope.Var rootVar;
        int dotIndex = this.fnName.indexOf(".");
        if (dotIndex != -1 && (rootVar = this.scope.getVar(rootVarName = this.fnName.substring(0, dotIndex))) != null) {
            return rootVar.getScope();
        }
        return this.scope;
    }

    private static boolean hasMoreTagsToResolve(ObjectType objectType) {
        Preconditions.checkArgument((boolean)objectType.isUnknownType());
        if (objectType.getImplicitPrototype() != null) {
            return !objectType.getImplicitPrototype().isResolved();
        }
        FunctionType ctor = objectType.getConstructor();
        if (ctor != null) {
            for (ObjectType interfaceType : ctor.getExtendedInterfaces()) {
                if (interfaceType.isResolved()) continue;
                return true;
            }
        }
        return false;
    }

    static class AstFunctionContents
    implements FunctionContents {
        private final Node n;
        private boolean hasNonEmptyReturns = false;
        private Set<String> escapedVarNames;
        private Set<String> escapedQualifiedNames;
        private final Multiset<String> assignedVarNames = HashMultiset.create();

        AstFunctionContents(Node n) {
            this.n = n;
        }

        @Override
        public Node getSourceNode() {
            return this.n;
        }

        @Override
        public boolean mayBeFromExterns() {
            return this.n.isFromExterns();
        }

        @Override
        public boolean mayHaveNonEmptyReturns() {
            return this.hasNonEmptyReturns;
        }

        void recordNonEmptyReturn() {
            this.hasNonEmptyReturns = true;
        }

        @Override
        public boolean mayHaveSingleThrow() {
            Node block = this.n.getLastChild();
            return block.hasOneChild() && block.getFirstChild().isThrow();
        }

        @Override
        public Iterable<String> getEscapedVarNames() {
            return this.escapedVarNames == null ? ImmutableList.of() : this.escapedVarNames;
        }

        void recordEscapedVarName(String name) {
            if (this.escapedVarNames == null) {
                this.escapedVarNames = Sets.newHashSet();
            }
            this.escapedVarNames.add(name);
        }

        @Override
        public Set<String> getEscapedQualifiedNames() {
            return this.escapedQualifiedNames == null ? ImmutableSet.of() : this.escapedQualifiedNames;
        }

        void recordEscapedQualifiedName(String name) {
            if (this.escapedQualifiedNames == null) {
                this.escapedQualifiedNames = Sets.newHashSet();
            }
            this.escapedQualifiedNames.add(name);
        }

        @Override
        public Multiset<String> getAssignedNameCounts() {
            return this.assignedVarNames;
        }

        void recordAssignedName(String name) {
            this.assignedVarNames.add((Object)name);
        }
    }

    static class UnknownFunctionContents
    implements FunctionContents {
        private static UnknownFunctionContents singleton = new UnknownFunctionContents();

        UnknownFunctionContents() {
        }

        static FunctionContents get() {
            return singleton;
        }

        @Override
        public Node getSourceNode() {
            return null;
        }

        @Override
        public boolean mayBeFromExterns() {
            return true;
        }

        @Override
        public boolean mayHaveNonEmptyReturns() {
            return true;
        }

        @Override
        public boolean mayHaveSingleThrow() {
            return true;
        }

        @Override
        public Iterable<String> getEscapedVarNames() {
            return ImmutableList.of();
        }

        @Override
        public Set<String> getEscapedQualifiedNames() {
            return ImmutableSet.of();
        }

        @Override
        public Multiset<String> getAssignedNameCounts() {
            return ImmutableMultiset.of();
        }
    }

    static interface FunctionContents {
        public Node getSourceNode();

        public boolean mayBeFromExterns();

        public boolean mayHaveNonEmptyReturns();

        public boolean mayHaveSingleThrow();

        public Iterable<String> getEscapedVarNames();

        public Set<String> getEscapedQualifiedNames();

        public Multiset<String> getAssignedNameCounts();
    }

    private class ImplementedTypeValidator
    implements Predicate<JSType> {
        private ImplementedTypeValidator() {
        }

        public boolean apply(JSType type) {
            ObjectType objectType = ObjectType.cast(type);
            if (objectType == null) {
                FunctionTypeBuilder.this.reportError(TypeCheck.BAD_IMPLEMENTED_TYPE, new String[]{FunctionTypeBuilder.this.fnName});
                return false;
            }
            if (objectType.isEmptyType()) {
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@implements", FunctionTypeBuilder.this.fnName});
                return false;
            }
            if (objectType.isUnknownType()) {
                if (FunctionTypeBuilder.hasMoreTagsToResolve(objectType)) {
                    return true;
                }
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@implements", FunctionTypeBuilder.this.fnName});
                return false;
            }
            return true;
        }
    }

    private class ExtendedTypeValidator
    implements Predicate<JSType> {
        private ExtendedTypeValidator() {
        }

        public boolean apply(JSType type) {
            ObjectType objectType = ObjectType.cast(type);
            if (objectType == null) {
                FunctionTypeBuilder.this.reportWarning(EXTENDS_NON_OBJECT, new String[]{FunctionTypeBuilder.this.formatFnName(), type.toString()});
                return false;
            }
            if (objectType.isEmptyType()) {
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@extends", FunctionTypeBuilder.this.formatFnName()});
                return false;
            }
            if (objectType.isUnknownType()) {
                if (FunctionTypeBuilder.hasMoreTagsToResolve(objectType)) {
                    return true;
                }
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@extends", FunctionTypeBuilder.this.fnName});
                return false;
            }
            return true;
        }
    }
}

