/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

final class CheckSuspiciousCode
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType SUSPICIOUS_SEMICOLON = DiagnosticType.warning("JSC_SUSPICIOUS_SEMICOLON", "If this if/for/while really shouldn't have a body, use {}");
    static final DiagnosticType SUSPICIOUS_COMPARISON_WITH_NAN = DiagnosticType.warning("JSC_SUSPICIOUS_NAN", "Comparison again NaN is always false. Did you mean isNaN()?");

    CheckSuspiciousCode() {
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.checkMissingSemicolon(t, n);
        this.checkNaN(t, n);
    }

    private void checkMissingSemicolon(NodeTraversal t, Node n) {
        switch (n.getType()) {
            case 108: {
                Node trueCase = n.getFirstChild().getNext();
                this.reportIfWasEmpty(t, trueCase);
                Node elseCase = trueCase.getNext();
                if (elseCase == null) break;
                this.reportIfWasEmpty(t, elseCase);
                break;
            }
            case 113: 
            case 115: {
                this.reportIfWasEmpty(t, NodeUtil.getLoopCodeBlock(n));
            }
        }
    }

    private void reportIfWasEmpty(NodeTraversal t, Node block) {
        Preconditions.checkState((boolean)block.isBlock());
        if (!block.hasChildren() && block.wasEmptyNode()) {
            t.getCompiler().report(t.makeError(block, SUSPICIOUS_SEMICOLON, new String[0]));
        }
    }

    private void checkNaN(NodeTraversal t, Node n) {
        switch (n.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 45: 
            case 46: {
                this.reportIfNaN(t, n.getFirstChild());
                this.reportIfNaN(t, n.getLastChild());
            }
        }
    }

    private void reportIfNaN(NodeTraversal t, Node n) {
        if (NodeUtil.isNaN(n)) {
            t.getCompiler().report(t.makeError(n.getParent(), SUSPICIOUS_COMPARISON_WITH_NAN, new String[0]));
        }
    }
}

