/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Predicate;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.CanCastToVisitor;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.Serializable;
import java.util.Comparator;

public abstract class JSType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean resolved = false;
    private JSType resolveResult = null;
    protected TemplateTypeMap templateTypeMap;
    private boolean inTemplatedCheckVisit = false;
    private static final CanCastToVisitor CAN_CAST_TO_VISITOR = new CanCastToVisitor();
    public static final String UNKNOWN_NAME = "Unknown class name";
    public static final String NOT_A_CLASS = "Not declared as a constructor";
    public static final String NOT_A_TYPE = "Not declared as a type name";
    public static final String EMPTY_TYPE_COMPONENT = "Named type with empty name component";
    static final Comparator<JSType> ALPHA = new Comparator<JSType>(){

        @Override
        public int compare(JSType t1, JSType t2) {
            return t1.toString().compareTo(t2.toString());
        }
    };
    public static final int ENUMDECL = 1;
    public static final int NOT_ENUMDECL = 0;
    final JSTypeRegistry registry;

    JSType(JSTypeRegistry registry) {
        this(registry, null);
    }

    JSType(JSTypeRegistry registry, TemplateTypeMap templateTypeMap) {
        this.registry = registry;
        this.templateTypeMap = templateTypeMap == null ? registry.createTemplateTypeMap(null, null) : templateTypeMap;
    }

    JSType getNativeType(JSTypeNative typeId) {
        return this.registry.getNativeType(typeId);
    }

    public JSDocInfo getJSDocInfo() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public boolean hasDisplayName() {
        String displayName = this.getDisplayName();
        return displayName != null && !displayName.isEmpty();
    }

    public boolean hasProperty(String pname) {
        return false;
    }

    public boolean isNoType() {
        return false;
    }

    public boolean isNoResolvedType() {
        return false;
    }

    public boolean isNoObjectType() {
        return false;
    }

    public final boolean isEmptyType() {
        return this.isNoType() || this.isNoObjectType() || this.isNoResolvedType() || this.registry.getNativeFunctionType(JSTypeNative.LEAST_FUNCTION_TYPE) == this;
    }

    public boolean isNumberObjectType() {
        return false;
    }

    public boolean isNumberValueType() {
        return false;
    }

    public boolean isFunctionPrototypeType() {
        return false;
    }

    public boolean isStringObjectType() {
        return false;
    }

    boolean isTheObjectType() {
        return false;
    }

    public boolean isStringValueType() {
        return false;
    }

    public final boolean isString() {
        return this.isSubtype(this.getNativeType(JSTypeNative.STRING_VALUE_OR_OBJECT_TYPE));
    }

    public final boolean isNumber() {
        return this.isSubtype(this.getNativeType(JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE));
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isBooleanObjectType() {
        return false;
    }

    public boolean isBooleanValueType() {
        return false;
    }

    public boolean isRegexpType() {
        return false;
    }

    public boolean isDateType() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isVoidType() {
        return false;
    }

    public boolean isAllType() {
        return false;
    }

    public boolean isUnknownType() {
        return false;
    }

    public boolean isCheckedUnknownType() {
        return false;
    }

    public final boolean isUnionType() {
        return this.toMaybeUnionType() != null;
    }

    public boolean isStruct() {
        if (this.isObject()) {
            ObjectType objType = this.toObjectType();
            ObjectType iproto = objType.getImplicitPrototype();
            if (iproto != null && iproto.isStruct()) {
                return true;
            }
            FunctionType ctor = objType.getConstructor();
            if (ctor == null) {
                JSDocInfo info = objType.getJSDocInfo();
                return info != null && info.makesStructs();
            }
            return ctor.makesStructs();
        }
        return false;
    }

    public boolean isDict() {
        if (this.isObject()) {
            ObjectType objType = this.toObjectType();
            ObjectType iproto = objType.getImplicitPrototype();
            if (iproto != null && iproto.isDict()) {
                return true;
            }
            FunctionType ctor = objType.getConstructor();
            if (ctor == null) {
                JSDocInfo info = objType.getJSDocInfo();
                return info != null && info.makesDicts();
            }
            return ctor.makesDicts();
        }
        return false;
    }

    public UnionType toMaybeUnionType() {
        return null;
    }

    public final boolean isGlobalThisType() {
        return this == this.registry.getNativeType(JSTypeNative.GLOBAL_THIS);
    }

    public final boolean isFunctionType() {
        return this.toMaybeFunctionType() != null;
    }

    public FunctionType toMaybeFunctionType() {
        return null;
    }

    public static FunctionType toMaybeFunctionType(JSType type) {
        return type == null ? null : type.toMaybeFunctionType();
    }

    public final boolean isEnumElementType() {
        return this.toMaybeEnumElementType() != null;
    }

    public EnumElementType toMaybeEnumElementType() {
        return null;
    }

    public boolean isEnumType() {
        return this.toMaybeEnumType() != null;
    }

    public EnumType toMaybeEnumType() {
        return null;
    }

    boolean isNamedType() {
        return false;
    }

    public boolean isRecordType() {
        return this.toMaybeRecordType() != null;
    }

    RecordType toMaybeRecordType() {
        return null;
    }

    public final boolean isTemplatizedType() {
        return this.toMaybeTemplatizedType() != null;
    }

    public TemplatizedType toMaybeTemplatizedType() {
        return null;
    }

    public static TemplatizedType toMaybeTemplatizedType(JSType type) {
        return type == null ? null : type.toMaybeTemplatizedType();
    }

    public final boolean isTemplateType() {
        return this.toMaybeTemplateType() != null;
    }

    public TemplateType toMaybeTemplateType() {
        return null;
    }

    public static TemplateType toMaybeTemplateType(JSType type) {
        return type == null ? null : type.toMaybeTemplateType();
    }

    public boolean hasAnyTemplateTypes() {
        if (!this.inTemplatedCheckVisit) {
            this.inTemplatedCheckVisit = true;
            boolean result = this.hasAnyTemplateTypesInternal();
            this.inTemplatedCheckVisit = false;
            return result;
        }
        return false;
    }

    boolean hasAnyTemplateTypesInternal() {
        return this.templateTypeMap.hasAnyTemplateTypesInternal();
    }

    public TemplateTypeMap getTemplateTypeMap() {
        return this.templateTypeMap;
    }

    public void extendTemplateTypeMap(TemplateTypeMap otherMap) {
        this.templateTypeMap = this.templateTypeMap.extend(otherMap);
    }

    public boolean isObject() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isNominalType() {
        return false;
    }

    public final boolean isNominalConstructor() {
        if (this.isConstructor() || this.isInterface()) {
            FunctionType fn = this.toMaybeFunctionType();
            if (fn == null) {
                return false;
            }
            if (fn.getSource() != null) {
                return true;
            }
            return fn.isNativeObjectType();
        }
        return false;
    }

    public boolean isInstanceType() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isOrdinaryFunction() {
        return false;
    }

    public final boolean isEquivalentTo(JSType that) {
        return this.checkEquivalenceHelper(that, EquivalenceMethod.IDENTITY);
    }

    public final boolean isInvariant(JSType that) {
        return this.checkEquivalenceHelper(that, EquivalenceMethod.INVARIANT);
    }

    public final boolean differsFrom(JSType that) {
        return !this.checkEquivalenceHelper(that, EquivalenceMethod.DATA_FLOW);
    }

    boolean checkEquivalenceHelper(JSType that, EquivalenceMethod eqMethod) {
        if (this == that) {
            return true;
        }
        boolean thisUnknown = this.isUnknownType();
        boolean thatUnknown = that.isUnknownType();
        if (thisUnknown || thatUnknown) {
            if (eqMethod == EquivalenceMethod.INVARIANT) {
                return true;
            }
            if (eqMethod == EquivalenceMethod.DATA_FLOW) {
                return thisUnknown && thatUnknown;
            }
            if (thisUnknown && thatUnknown && this.isNominalType() ^ that.isNominalType()) {
                return false;
            }
        }
        if (this.isUnionType() && that.isUnionType()) {
            return this.toMaybeUnionType().checkUnionEquivalenceHelper(that.toMaybeUnionType(), eqMethod);
        }
        if (this.isFunctionType() && that.isFunctionType()) {
            return this.toMaybeFunctionType().checkFunctionEquivalenceHelper(that.toMaybeFunctionType(), eqMethod);
        }
        if (this.isRecordType() && that.isRecordType()) {
            return this.toMaybeRecordType().checkRecordEquivalenceHelper(that.toMaybeRecordType(), eqMethod);
        }
        if (!this.getTemplateTypeMap().checkEquivalenceHelper(that.getTemplateTypeMap(), eqMethod)) {
            return false;
        }
        if (this.isNominalType() && that.isNominalType()) {
            return this.toObjectType().getReferenceName().equals(that.toObjectType().getReferenceName());
        }
        if (this instanceof ProxyObjectType) {
            return ((ProxyObjectType)this).getReferencedTypeInternal().checkEquivalenceHelper(that, eqMethod);
        }
        if (that instanceof ProxyObjectType) {
            return this.checkEquivalenceHelper(((ProxyObjectType)that).getReferencedTypeInternal(), eqMethod);
        }
        return this == that;
    }

    public static boolean isEquivalent(JSType typeA, JSType typeB) {
        return typeA == null || typeB == null ? typeA == typeB : typeA.isEquivalentTo(typeB);
    }

    public boolean equals(Object jsType) {
        return jsType instanceof JSType ? this.isEquivalentTo((JSType)jsType) : false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean matchesInt32Context() {
        return this.matchesNumberContext();
    }

    public final boolean matchesUint32Context() {
        return this.matchesNumberContext();
    }

    public boolean matchesNumberContext() {
        return false;
    }

    public boolean matchesStringContext() {
        return false;
    }

    public boolean matchesObjectContext() {
        return false;
    }

    public JSType findPropertyType(String propertyName) {
        ObjectType autoboxObjType = ObjectType.cast(this.autoboxesTo());
        if (autoboxObjType != null) {
            return autoboxObjType.findPropertyType(propertyName);
        }
        return null;
    }

    public boolean canBeCalled() {
        return false;
    }

    public boolean canCastTo(JSType that) {
        return this.visit(CAN_CAST_TO_VISITOR, that);
    }

    public JSType autoboxesTo() {
        return null;
    }

    public JSType unboxesTo() {
        return null;
    }

    public ObjectType toObjectType() {
        return this instanceof ObjectType ? (ObjectType)this : null;
    }

    public JSType autobox() {
        JSType restricted = this.restrictByNotNullOrUndefined();
        JSType autobox = restricted.autoboxesTo();
        return autobox == null ? restricted : autobox;
    }

    public final ObjectType dereference() {
        return this.autobox().toObjectType();
    }

    public final boolean canTestForEqualityWith(JSType that) {
        return this.testForEquality(that).equals((Object)TernaryValue.UNKNOWN);
    }

    public TernaryValue testForEquality(JSType that) {
        return this.testForEqualityHelper(this, that);
    }

    TernaryValue testForEqualityHelper(JSType aType, JSType bType) {
        if (bType.isAllType() || bType.isUnknownType() || bType.isNoResolvedType() || aType.isAllType() || aType.isUnknownType() || aType.isNoResolvedType()) {
            return TernaryValue.UNKNOWN;
        }
        boolean aIsEmpty = aType.isEmptyType();
        boolean bIsEmpty = bType.isEmptyType();
        if (aIsEmpty || bIsEmpty) {
            if (aIsEmpty && bIsEmpty) {
                return TernaryValue.TRUE;
            }
            return TernaryValue.UNKNOWN;
        }
        if (aType.isFunctionType() || bType.isFunctionType()) {
            JSType otherType = aType.isFunctionType() ? bType : aType;
            JSType meet = otherType.getGreatestSubtype(this.getNativeType(JSTypeNative.OBJECT_TYPE));
            if (meet.isNoType() || meet.isNoObjectType()) {
                return TernaryValue.FALSE;
            }
            return TernaryValue.UNKNOWN;
        }
        if (bType.isEnumElementType() || bType.isUnionType()) {
            return bType.testForEquality(aType);
        }
        return null;
    }

    public final boolean canTestForShallowEqualityWith(JSType that) {
        if (this.isEmptyType() || that.isEmptyType()) {
            return this.isSubtype(that) || that.isSubtype(this);
        }
        JSType inf = this.getGreatestSubtype(that);
        return !inf.isEmptyType() || inf == this.registry.getNativeType(JSTypeNative.LEAST_FUNCTION_TYPE);
    }

    public boolean isNullable() {
        return this.isSubtype(this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType collapseUnion() {
        return this;
    }

    public JSType getLeastSupertype(JSType that) {
        if (that.isUnionType()) {
            return that.toMaybeUnionType().getLeastSupertype(this);
        }
        return JSType.getLeastSupertype(this, that);
    }

    static JSType getLeastSupertype(JSType thisType, JSType thatType) {
        boolean areEquivalent = thisType.isEquivalentTo(thatType);
        return areEquivalent ? thisType : JSType.filterNoResolvedType(thisType.registry.createUnionType(thisType, thatType));
    }

    public JSType getGreatestSubtype(JSType that) {
        return JSType.getGreatestSubtype(this, that);
    }

    static JSType getGreatestSubtype(JSType thisType, JSType thatType) {
        JSType inf;
        if (thisType.isFunctionType() && thatType.isFunctionType()) {
            return thisType.toMaybeFunctionType().supAndInfHelper(thatType.toMaybeFunctionType(), false);
        }
        if (thisType.isEquivalentTo(thatType)) {
            return thisType;
        }
        if (thisType.isUnknownType() || thatType.isUnknownType()) {
            return thisType.isEquivalentTo(thatType) ? thisType : thisType.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (thisType.isUnionType()) {
            return thisType.toMaybeUnionType().meet(thatType);
        }
        if (thatType.isUnionType()) {
            return thatType.toMaybeUnionType().meet(thisType);
        }
        if (thisType.isTemplatizedType()) {
            return thisType.toMaybeTemplatizedType().getGreatestSubtypeHelper(thatType);
        }
        if (thatType.isTemplatizedType()) {
            return thatType.toMaybeTemplatizedType().getGreatestSubtypeHelper(thisType);
        }
        if (thisType.isSubtype(thatType)) {
            return JSType.filterNoResolvedType(thisType);
        }
        if (thatType.isSubtype(thisType)) {
            return JSType.filterNoResolvedType(thatType);
        }
        if (thisType.isRecordType()) {
            return thisType.toMaybeRecordType().getGreatestSubtypeHelper(thatType);
        }
        if (thatType.isRecordType()) {
            return thatType.toMaybeRecordType().getGreatestSubtypeHelper(thisType);
        }
        if (thisType.isEnumElementType()) {
            JSType inf2 = thisType.toMaybeEnumElementType().meet(thatType);
            if (inf2 != null) {
                return inf2;
            }
        } else if (thatType.isEnumElementType() && (inf = thatType.toMaybeEnumElementType().meet(thisType)) != null) {
            return inf;
        }
        if (thisType.isObject() && thatType.isObject()) {
            return thisType.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return thisType.getNativeType(JSTypeNative.NO_TYPE);
    }

    static JSType filterNoResolvedType(JSType type) {
        if (type.isNoResolvedType()) {
            return type.getNativeType(JSTypeNative.NO_RESOLVED_TYPE);
        }
        if (type.isUnionType()) {
            UnionType unionType = type.toMaybeUnionType();
            boolean needsFiltering = false;
            for (JSType alt : unionType.getAlternates()) {
                if (!alt.isNoResolvedType()) continue;
                needsFiltering = true;
                break;
            }
            if (needsFiltering) {
                UnionTypeBuilder builder = new UnionTypeBuilder(type.registry);
                builder.addAlternate(type.getNativeType(JSTypeNative.NO_RESOLVED_TYPE));
                for (JSType alt : unionType.getAlternates()) {
                    if (alt.isNoResolvedType()) continue;
                    builder.addAlternate(alt);
                }
                return builder.build();
            }
        }
        return type;
    }

    public JSType getRestrictedTypeGivenToBooleanOutcome(boolean outcome) {
        if (outcome && this == this.getNativeType(JSTypeNative.UNKNOWN_TYPE)) {
            return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
        }
        BooleanLiteralSet literals = this.getPossibleToBooleanOutcomes();
        if (literals.contains(outcome)) {
            return this;
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    public abstract BooleanLiteralSet getPossibleToBooleanOutcomes();

    public TypePair getTypesUnderEquality(JSType that) {
        if (that.isUnionType()) {
            TypePair p = that.toMaybeUnionType().getTypesUnderEquality(this);
            return new TypePair(p.typeB, p.typeA);
        }
        switch (this.testForEquality(that)) {
            case FALSE: {
                return new TypePair(null, null);
            }
            case TRUE: 
            case UNKNOWN: {
                return new TypePair(this, that);
            }
        }
        throw new IllegalStateException();
    }

    public TypePair getTypesUnderInequality(JSType that) {
        if (that.isUnionType()) {
            TypePair p = that.toMaybeUnionType().getTypesUnderInequality(this);
            return new TypePair(p.typeB, p.typeA);
        }
        switch (this.testForEquality(that)) {
            case TRUE: {
                JSType noType = this.getNativeType(JSTypeNative.NO_TYPE);
                return new TypePair(noType, noType);
            }
            case FALSE: 
            case UNKNOWN: {
                return new TypePair(this, that);
            }
        }
        throw new IllegalStateException();
    }

    public TypePair getTypesUnderShallowEquality(JSType that) {
        JSType commonType = this.getGreatestSubtype(that);
        return new TypePair(commonType, commonType);
    }

    public TypePair getTypesUnderShallowInequality(JSType that) {
        if (that.isUnionType()) {
            TypePair p = that.toMaybeUnionType().getTypesUnderShallowInequality(this);
            return new TypePair(p.typeB, p.typeA);
        }
        if (this.isNullType() && that.isNullType() || this.isVoidType() && that.isVoidType()) {
            return new TypePair(null, null);
        }
        return new TypePair(this, that);
    }

    public JSType restrictByNotNullOrUndefined() {
        return this;
    }

    public boolean isSubtype(JSType that) {
        return JSType.isSubtypeHelper(this, that);
    }

    static boolean isSubtypeHelper(JSType thisType, JSType thatType) {
        JSType thatElement;
        TemplateType key;
        JSType thisElement;
        if (thatType.isUnknownType()) {
            return true;
        }
        if (thatType.isAllType()) {
            return true;
        }
        if (thisType.isEquivalentTo(thatType)) {
            return true;
        }
        if (thatType.isUnionType()) {
            UnionType union = thatType.toMaybeUnionType();
            for (JSType element : union.alternates) {
                if (!thisType.isSubtype(element)) continue;
                return true;
            }
            return false;
        }
        TemplateTypeMap thisTypeParams = thisType.getTemplateTypeMap();
        TemplateTypeMap thatTypeParams = thatType.getTemplateTypeMap();
        boolean templateMatch = true;
        templateMatch = JSType.isExemptFromTemplateTypeInvariance(thatType) ? (thisElement = thisTypeParams.getTemplateType(key = thisType.registry.getObjectElementKey())).isSubtype(thatElement = thatTypeParams.getTemplateType(key)) || thatElement.isSubtype(thisElement) : thisTypeParams.checkEquivalenceHelper(thatTypeParams, EquivalenceMethod.INVARIANT);
        if (!templateMatch) {
            return false;
        }
        if (thisType.isTemplatizedType()) {
            return thisType.toMaybeTemplatizedType().getReferencedType().isSubtype(thatType);
        }
        if (thatType instanceof ProxyObjectType) {
            return thisType.isSubtype(((ProxyObjectType)thatType).getReferencedTypeInternal());
        }
        return false;
    }

    static boolean isExemptFromTemplateTypeInvariance(JSType type) {
        ObjectType objType = type.toObjectType();
        return objType == null || "Array".equals(objType.getReferenceName()) || "Object".equals(objType.getReferenceName());
    }

    public abstract <T> T visit(Visitor<T> var1);

    abstract <T> T visit(RelationshipVisitor<T> var1, JSType var2);

    public final JSType forceResolve(ErrorReporter t, StaticScope<JSType> scope) {
        JSTypeRegistry.ResolveMode oldResolveMode = this.registry.getResolveMode();
        this.registry.setResolveMode(JSTypeRegistry.ResolveMode.IMMEDIATE);
        JSType result = this.resolve(t, scope);
        this.registry.setResolveMode(oldResolveMode);
        return result;
    }

    public final JSType resolve(ErrorReporter t, StaticScope<JSType> scope) {
        if (this.resolved) {
            if (this.resolveResult == null) {
                return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            return this.resolveResult;
        }
        this.resolved = true;
        this.resolveResult = this.resolveInternal(t, scope);
        this.resolveResult.setResolvedTypeInternal(this.resolveResult);
        return this.resolveResult;
    }

    abstract JSType resolveInternal(ErrorReporter var1, StaticScope<JSType> var2);

    void setResolvedTypeInternal(JSType type) {
        this.resolveResult = type;
        this.resolved = true;
    }

    public final boolean isResolved() {
        return this.resolved;
    }

    public final void clearResolved() {
        this.resolved = false;
        this.resolveResult = null;
    }

    static final JSType safeResolve(JSType type, ErrorReporter t, StaticScope<JSType> scope) {
        return type == null ? null : type.resolve(t, scope);
    }

    public boolean setValidator(Predicate<JSType> validator) {
        return validator.apply((Object)this);
    }

    public String toString() {
        return this.toStringHelper(false);
    }

    public String toDebugHashCodeString() {
        return "{" + this.hashCode() + "}";
    }

    public final String toAnnotationString() {
        return this.toStringHelper(true);
    }

    abstract String toStringHelper(boolean var1);

    public void matchConstraint(JSType constraint) {
    }

    public static class TypePair {
        public final JSType typeA;
        public final JSType typeB;

        public TypePair(JSType typeA, JSType typeB) {
            this.typeA = typeA;
            this.typeB = typeB;
        }
    }
}

