/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.head.tools.shell;

import com.google.javascript.rhino.head.Kit;
import com.google.javascript.rhino.head.Scriptable;
import com.google.javascript.rhino.head.tools.shell.FlexibleCompletor;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ShellLine {
    public static InputStream getStream(Scriptable scope) {
        ClassLoader classLoader = ShellLine.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            return null;
        }
        Class<?> readerClass = Kit.classOrNull(classLoader, "jline.ConsoleReader");
        if (readerClass == null) {
            return null;
        }
        try {
            Constructor<?> c = readerClass.getConstructor(new Class[0]);
            Object reader = c.newInstance(new Object[0]);
            Method m = readerClass.getMethod("setBellEnabled", Boolean.TYPE);
            m.invoke(reader, Boolean.FALSE);
            Class<?> completorClass = Kit.classOrNull(classLoader, "jline.Completor");
            m = readerClass.getMethod("addCompletor", completorClass);
            Object completor = Proxy.newProxyInstance(classLoader, new Class[]{completorClass}, (InvocationHandler)new FlexibleCompletor(completorClass, scope));
            m.invoke(reader, completor);
            Class<?> inputStreamClass = Kit.classOrNull(classLoader, "jline.ConsoleReaderInputStream");
            c = inputStreamClass.getConstructor(readerClass);
            return (InputStream)c.newInstance(reader);
        }
        catch (NoSuchMethodException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }
}

