/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.Visitor;

public final class VoidType
extends ValueType {
    VoidType(JSTypeRegistry registry) {
        super(registry);
    }

    @Override
    JSTypeClass getTypeClass() {
        return JSTypeClass.VOID;
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public JSType restrictByNotUndefined() {
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public Tri testForEquality(JSType that) {
        if (Tri.UNKNOWN.equals((Object)super.testForEquality(that))) {
            return Tri.UNKNOWN;
        }
        if (that.isSubtypeOf(this) || that.isSubtypeOf(this.getNativeType(JSTypeNative.NULL_TYPE))) {
            return Tri.TRUE;
        }
        return Tri.FALSE;
    }

    @Override
    public boolean matchesNumberContext() {
        return false;
    }

    @Override
    public boolean matchesObjectContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean isVoidType() {
        return true;
    }

    @Override
    public boolean isVoidable() {
        return true;
    }

    @Override
    public boolean isExplicitlyVoidable() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "undefined";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.FALSE;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseVoidType();
    }
}

