/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Outcome;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeIterations;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.nullness.Nullable;

public final class UnionType
extends JSType {
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.UNION;
    private static final int MAX_UNION_SIZE = 30;
    private ImmutableList<JSType> alternates;
    private boolean alternatesResolvedBeforeBuild;

    private UnionType(Builder builder) {
        super(builder.registry);
        this.fillFromBuilder(builder);
        this.registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    public static Builder builder(JSTypeRegistry registry) {
        return new Builder(registry);
    }

    public ImmutableList<JSType> getAlternates() {
        if (!this.isResolved() && !this.alternatesResolvedBeforeBuild) {
            Builder b = new Builder(this).addAlternates((List<? extends JSType>)this.alternates);
            if (!this.isResolved() && !this.alternatesResolvedBeforeBuild) {
                b.build();
            }
        }
        return this.alternates;
    }

    private void fillFromBuilder(Builder builder) {
        Preconditions.checkState((!this.alternatesResolvedBeforeBuild ? 1 : 0) != 0);
        Preconditions.checkState((!builder.finalAlternates.isEmpty() ? 1 : 0) != 0);
        this.alternates = builder.finalAlternates;
        this.alternatesResolvedBeforeBuild = builder.alternatesResolvedBeforeBuild;
    }

    @Override
    public boolean matchesNumberContext() {
        return JSTypeIterations.anyTypeMatches(JSType::matchesNumberContext, this);
    }

    @Override
    public boolean matchesStringContext() {
        return JSTypeIterations.anyTypeMatches(JSType::matchesStringContext, this);
    }

    @Override
    public boolean matchesSymbolContext() {
        return JSTypeIterations.anyTypeMatches(JSType::matchesSymbolContext, this);
    }

    @Override
    public boolean matchesObjectContext() {
        return JSTypeIterations.anyTypeMatches(JSType::matchesObjectContext, this);
    }

    @Override
    protected JSType findPropertyTypeWithoutConsideringTemplateTypes(String propertyName) {
        JSType propertyType = null;
        for (JSType alternate : this.alternates) {
            JSType altPropertyType;
            if (alternate.isNullType() || alternate.isVoidType() || (altPropertyType = alternate.findPropertyType(propertyName)) == null) continue;
            if (propertyType == null) {
                propertyType = altPropertyType;
                continue;
            }
            propertyType = propertyType.getLeastSupertype(altPropertyType);
        }
        return propertyType;
    }

    @Override
    public boolean canBeCalled() {
        return JSTypeIterations.allTypesMatch(JSType::canBeCalled, this);
    }

    @Override
    public JSType autobox() {
        return JSTypeIterations.mapTypes(JSType::autobox, this);
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        return JSTypeIterations.mapTypes(JSType::restrictByNotNullOrUndefined, this);
    }

    @Override
    public JSType restrictByNotUndefined() {
        return JSTypeIterations.mapTypes(JSType::restrictByNotUndefined, this);
    }

    @Override
    public JSType restrictByNotNull() {
        return JSTypeIterations.mapTypes(JSType::restrictByNotNull, this);
    }

    @Override
    public Tri testForEquality(JSType that) {
        Tri result = null;
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType t = (JSType)this.alternates.get(i);
            Tri test = t.testForEquality(that);
            if (result == null) {
                result = test;
                continue;
            }
            if (result.equals((Object)test)) continue;
            return Tri.UNKNOWN;
        }
        return result;
    }

    @Override
    public boolean isNullable() {
        return JSTypeIterations.anyTypeMatches(JSType::isNullable, this);
    }

    @Override
    public boolean isVoidable() {
        return JSTypeIterations.anyTypeMatches(JSType::isVoidable, this);
    }

    @Override
    public boolean isExplicitlyVoidable() {
        return JSTypeIterations.anyTypeMatches(JSType::isExplicitlyVoidable, this);
    }

    @Override
    public boolean isUnknownType() {
        return JSTypeIterations.anyTypeMatches(JSType::isUnknownType, this);
    }

    @Override
    public boolean isStruct() {
        return JSTypeIterations.anyTypeMatches(JSType::isStruct, this);
    }

    @Override
    public boolean isDict() {
        return JSTypeIterations.anyTypeMatches(JSType::isDict, this);
    }

    @Override
    public JSType getLeastSupertype(JSType that) {
        if (!that.isUnknownType() && !that.isUnionType()) {
            for (int i = 0; i < this.alternates.size(); ++i) {
                JSType alternate = (JSType)this.alternates.get(i);
                if (alternate.isUnknownType() || that.isNoResolvedType() || !that.isSubtypeOf(alternate)) continue;
                return this;
            }
        }
        return JSType.getLeastSupertype(this, that);
    }

    static JSType getGreatestSubtype(UnionType union, JSType that) {
        JSType result;
        JSTypeRegistry registry = union.registry;
        Builder builder = UnionType.builder(registry);
        for (int i = 0; i < union.alternates.size(); ++i) {
            JSType alternate = (JSType)union.alternates.get(i);
            if (!alternate.isSubtypeOf(that)) continue;
            builder.addAlternate(alternate);
        }
        if (that.isUnionType()) {
            ImmutableList<JSType> thoseAlternates = that.toMaybeUnionType().getAlternates();
            for (int i = 0; i < thoseAlternates.size(); ++i) {
                JSType otherAlternate = (JSType)thoseAlternates.get(i);
                if (!otherAlternate.isSubtypeOf(union)) continue;
                builder.addAlternate(otherAlternate);
            }
        } else if (that.isSubtypeOf(union)) {
            builder.addAlternate(that);
        }
        if (!(result = builder.build()).isNoType()) {
            return result;
        }
        if (union.isObject() && that.isObject() && !that.isNoType()) {
            return registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public JSType.HasPropertyKind getPropertyKind(String pname, boolean autobox) {
        boolean found = false;
        boolean always = true;
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType alternate = (JSType)this.alternates.get(i);
            if (alternate.isNullType() || alternate.isVoidType()) continue;
            switch (alternate.getPropertyKind(pname, autobox)) {
                case KNOWN_PRESENT: {
                    found = true;
                    break;
                }
                case ABSENT: {
                    always = false;
                    break;
                }
                case MAYBE_PRESENT: {
                    found = true;
                    always = false;
                }
            }
            if (found && !always) break;
        }
        return found ? (always ? JSType.HasPropertyKind.KNOWN_PRESENT : JSType.HasPropertyKind.MAYBE_PRESENT) : JSType.HasPropertyKind.ABSENT;
    }

    @Override
    final int recursionUnsafeHashCode() {
        int hashCode = this.alternates.size();
        for (int i = 0; i < this.alternates.size(); ++i) {
            hashCode *= ((JSType)this.alternates.get(i)).hashCode();
        }
        return hashCode;
    }

    @Override
    public UnionType toMaybeUnionType() {
        return this;
    }

    @Override
    public boolean isObject() {
        return JSTypeIterations.allTypesMatch(JSType::isObject, this);
    }

    public boolean contains(JSType type) {
        return JSTypeIterations.anyTypeMatches(type::equals, this);
    }

    public JSType getRestrictedUnion(JSType type) {
        Builder restricted = UnionType.builder(this.registry);
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType t = (JSType)this.alternates.get(i);
            if (!t.isUnknownType() && !t.isNoResolvedType() && t.isSubtypeOf(type)) continue;
            restricted.addAlternate(t);
        }
        return restricted.build();
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        sb.append("(");
        ArrayList<String> names = new ArrayList<String>();
        for (JSType alt : this.alternates) {
            names.add(sb.cloneWithConfig().append(alt).build());
        }
        Collections.sort(names);
        sb.appendAll(names, "|");
        sb.append(")");
    }

    @Override
    public JSType getRestrictedTypeGivenOutcome(Outcome outcome) {
        return JSTypeIterations.mapTypes(t -> t.getRestrictedTypeGivenOutcome(outcome), this);
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        JSType element;
        BooleanLiteralSet literals = BooleanLiteralSet.EMPTY;
        for (int i = 0; i < this.alternates.size() && (literals = literals.union((element = (JSType)this.alternates.get(i)).getPossibleToBooleanOutcomes())) != BooleanLiteralSet.BOTH; ++i) {
        }
        return literals;
    }

    @Override
    public JSType.TypePair getTypesUnderEquality(JSType that) {
        Builder thisRestricted = UnionType.builder(this.registry);
        Builder thatRestricted = UnionType.builder(this.registry);
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType element = (JSType)this.alternates.get(i);
            JSType.TypePair p = element.getTypesUnderEquality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderInequality(JSType that) {
        Builder thisRestricted = UnionType.builder(this.registry);
        Builder thatRestricted = UnionType.builder(this.registry);
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType element = (JSType)this.alternates.get(i);
            JSType.TypePair p = element.getTypesUnderInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderShallowInequality(JSType that) {
        Builder thisRestricted = UnionType.builder(this.registry);
        Builder thatRestricted = UnionType.builder(this.registry);
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType element = (JSType)this.alternates.get(i);
            JSType.TypePair p = element.getTypesUnderShallowInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseUnionType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseUnionType(this, that);
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        if (this.alternatesResolvedBeforeBuild) {
            return this;
        }
        for (int i = 0; i < this.alternates.size(); ++i) {
            ((JSType)this.alternates.get(i)).resolve(reporter);
        }
        return new Builder(this).addAlternates((List<? extends JSType>)this.alternates).build();
    }

    @Override
    public JSType collapseUnion() {
        JSType currentValue = null;
        ObjectType currentCommonSuper = null;
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType a = (JSType)this.alternates.get(i);
            if (a.isUnknownType()) {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            ObjectType obj = a.toObjectType();
            if (obj == null) {
                if (currentValue == null && currentCommonSuper == null) {
                    currentValue = a;
                    continue;
                }
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            if (currentValue != null) {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            currentCommonSuper = currentCommonSuper == null ? obj : this.registry.findCommonSuperObject(currentCommonSuper, obj);
        }
        return currentCommonSuper;
    }

    @Override
    public void matchConstraint(JSType constraint) {
        for (int i = 0; i < this.alternates.size(); ++i) {
            JSType alternate = (JSType)this.alternates.get(i);
            alternate.matchConstraint(constraint);
        }
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return JSTypeIterations.anyTypeMatches(JSType::hasAnyTemplateTypes, this);
    }

    public static final class Builder {
        private final @Nullable UnionType rebuildTarget;
        private final JSTypeRegistry registry;
        private final List<JSType> alternates = new ArrayList<JSType>();
        private @Nullable ImmutableList<JSType> finalAlternates = null;
        private boolean containsVoidType = false;
        private boolean isAllType = false;
        private boolean isNativeUnknownType = false;
        private boolean areAllUnknownsChecked = true;
        private boolean alternatesResolvedBeforeBuild = true;
        private int functionTypePosition = -1;

        private Builder(JSTypeRegistry registry) {
            this.rebuildTarget = null;
            this.registry = registry;
        }

        private Builder(UnionType rebuildTarget) {
            this.rebuildTarget = rebuildTarget;
            this.registry = rebuildTarget.registry;
        }

        private static boolean isSubtype(JSType rightType, JSType leftType) {
            return rightType.isSubtypeWithoutStructuralTyping(leftType);
        }

        public Builder addAlternates(Collection<? extends JSType> c) {
            for (JSType jSType : c) {
                this.addAlternate(jSType);
            }
            return this;
        }

        public Builder addAlternates(List<? extends JSType> list) {
            for (int i = 0; i < list.size(); ++i) {
                this.addAlternate(list.get(i));
            }
            return this;
        }

        public Builder addAlternate(JSType alternate) {
            this.checkHasNotBuilt();
            if (alternate.isUnionType()) {
                this.addAlternates((List<? extends JSType>)alternate.toMaybeUnionType().getAlternates());
                return this;
            }
            if (this.alternates.size() > 30) {
                return this;
            }
            if (!alternate.isResolved()) {
                this.alternatesResolvedBeforeBuild = false;
                for (JSType current : this.alternates) {
                    if (!JSCompObjects.identical(current, alternate)) continue;
                    return this;
                }
                this.alternates.add(alternate);
                return this;
            }
            if (alternate.isNoType()) {
                return this;
            }
            this.isAllType = this.isAllType || alternate.isAllType();
            this.containsVoidType = this.containsVoidType || alternate.isVoidType();
            boolean isAlternateUnknown = alternate instanceof UnknownType;
            boolean bl = this.isNativeUnknownType = this.isNativeUnknownType || isAlternateUnknown;
            if (isAlternateUnknown) {
                boolean bl2 = this.areAllUnknownsChecked = this.areAllUnknownsChecked && alternate.isCheckedUnknownType();
            }
            if (this.isAllType || this.isNativeUnknownType) {
                return this;
            }
            if (alternate.isFunctionType() && this.functionTypePosition != -1) {
                FunctionType other = this.alternates.get(this.functionTypePosition).toMaybeFunctionType();
                FunctionType supremum = alternate.toMaybeFunctionType().supAndInfHelper(other, true);
                this.alternates.set(this.functionTypePosition, supremum);
                return this;
            }
            for (int index = 0; index < this.alternates.size(); ++index) {
                boolean removeCurrent = false;
                JSType current = this.alternates.get(index);
                if (!current.isResolved()) continue;
                if (alternate.isUnknownType() || current.isUnknownType() || alternate.isNoResolvedType() || current.isNoResolvedType() || alternate.hasAnyTemplateTypes() || current.hasAnyTemplateTypes()) {
                    if (alternate.equals(current)) {
                        return this;
                    }
                } else if (alternate.isTemplatizedType() || current.isTemplatizedType()) {
                    if (!current.isTemplatizedType()) {
                        if (Builder.isSubtype(alternate, current)) {
                            return this;
                        }
                    } else if (!alternate.isTemplatizedType()) {
                        if (Builder.isSubtype(current, alternate)) {
                            removeCurrent = true;
                        }
                    } else {
                        Preconditions.checkState((current.isTemplatizedType() && alternate.isTemplatizedType() ? 1 : 0) != 0);
                        TemplatizedType templatizedAlternate = alternate.toMaybeTemplatizedType();
                        TemplatizedType templatizedCurrent = current.toMaybeTemplatizedType();
                        if (templatizedCurrent.wrapsSameRawType(templatizedAlternate)) {
                            if (current.equals(alternate)) {
                                return this;
                            }
                            if (!templatizedCurrent.getReferencedType().isReadonlyArrayType()) {
                                ObjectType rawType = templatizedCurrent.getReferencedObjTypeInternal();
                                alternate = this.registry.createTemplatizedType(rawType, (ImmutableList<JSType>)ImmutableList.of());
                                removeCurrent = true;
                            }
                        }
                    }
                } else {
                    if (Builder.isSubtype(alternate, current)) {
                        this.mayRegisterDroppedProperties(alternate, current);
                        return this;
                    }
                    if (Builder.isSubtype(current, alternate)) {
                        this.mayRegisterDroppedProperties(current, alternate);
                        removeCurrent = true;
                    }
                }
                if (!removeCurrent) continue;
                this.alternates.remove(index);
                if (index == this.functionTypePosition) {
                    this.functionTypePosition = -1;
                } else if (index < this.functionTypePosition) {
                    --this.functionTypePosition;
                }
                --index;
            }
            if (alternate.isFunctionType()) {
                Preconditions.checkState((this.functionTypePosition == -1 ? 1 : 0) != 0);
                this.functionTypePosition = this.alternates.size();
            }
            this.alternates.add(alternate);
            return this;
        }

        private void mayRegisterDroppedProperties(JSType subtype, JSType supertype) {
            if (subtype.toMaybeRecordType() != null && supertype.toMaybeRecordType() != null) {
                this.registry.registerDroppedPropertiesInUnion(subtype.toMaybeRecordType(), supertype.toMaybeRecordType());
            }
        }

        public JSType build() {
            this.buildInternal();
            if (this.rebuildTarget != null) {
                this.rebuildTarget.fillFromBuilder(this);
            }
            if (this.finalAlternates.size() == 1) {
                return (JSType)this.finalAlternates.get(0);
            }
            if (this.rebuildTarget != null) {
                return this.rebuildTarget;
            }
            return new UnionType(this);
        }

        private Builder buildInternal() {
            this.checkHasNotBuilt();
            JSType wildcard = this.getNativeWildcardType();
            this.finalAlternates = wildcard != null ? (this.containsVoidType ? ImmutableList.of((Object)wildcard, (Object)this.registry.getNativeType(JSTypeNative.VOID_TYPE)) : ImmutableList.of((Object)wildcard)) : (this.alternates.isEmpty() ? ImmutableList.of((Object)this.registry.getNativeType(JSTypeNative.NO_TYPE)) : (this.alternates.size() > 30 ? ImmutableList.of((Object)this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE)) : ImmutableList.copyOf(this.alternates)));
            Preconditions.checkNotNull(this.finalAlternates);
            return this;
        }

        private @Nullable JSType getNativeWildcardType() {
            if (this.isAllType) {
                return this.registry.getNativeType(JSTypeNative.ALL_TYPE);
            }
            if (this.isNativeUnknownType) {
                if (this.areAllUnknownsChecked) {
                    return this.registry.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
                }
                return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            return null;
        }

        private void checkHasNotBuilt() {
            Preconditions.checkState((this.finalAlternates == null ? 1 : 0) != 0, (Object)"Cannot reuse a `UnionType.Builder` that has already built.");
        }
    }
}

