/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeIterations;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NoResolvedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.nullness.Nullable;

public final class NamedType
extends ProxyObjectType {
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.NAMED;
    private final String reference;
    private final String sourceName;
    private final int lineno;
    private final int charno;
    private final ResolutionKind resolutionKind;
    private @Nullable StaticTypedScope resolutionScope;
    private transient Predicate<JSType> validator;
    private transient @Nullable List<PropertyContinuation> propertyContinuations = null;
    private final ImmutableList<JSType> templateTypes;
    private final boolean restrictByNull;

    static int nominalHashCode(ObjectType type) {
        Preconditions.checkState((boolean)type.hasReferenceName());
        String name = (String)Preconditions.checkNotNull((Object)type.getReferenceName());
        return name.hashCode();
    }

    private NamedType(Builder builder) {
        super(builder.registry, builder.referencedType);
        Preconditions.checkNotNull((Object)builder.referenceName);
        Preconditions.checkNotNull((Object)((Object)builder.resolutionKind));
        Preconditions.checkNotNull(builder.templateTypes);
        if (builder.resolutionKind.equals((Object)ResolutionKind.TYPEOF)) {
            Preconditions.checkState((boolean)builder.referenceName.startsWith("typeof "));
        }
        this.restrictByNull = builder.restrictByNull;
        this.resolutionScope = builder.scope;
        this.reference = builder.referenceName;
        this.sourceName = builder.sourceName;
        this.lineno = builder.lineno;
        this.charno = builder.charno;
        this.templateTypes = builder.templateTypes;
        this.resolutionKind = builder.resolutionKind;
        this.registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    JSType getBangType() {
        if (this.restrictByNull) {
            return this;
        }
        if (this.isResolved()) {
            return this.isNoResolvedType() || this.isUnknownType() ? this : this.getReferencedType().restrictByNotNullOrUndefined();
        }
        return this.toBuilder().setRestrictByNull(true).build();
    }

    @Override
    public ImmutableList<JSType> getTemplateTypes() {
        return this.templateTypes;
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        if (!this.isResolved()) {
            if (this.propertyContinuations == null) {
                this.propertyContinuations = new ArrayList<PropertyContinuation>();
            }
            this.propertyContinuations.add(new PropertyContinuation(propertyName, type, inferred, propertyNode));
            return true;
        }
        return super.defineProperty(propertyName, type, inferred, propertyNode);
    }

    private void finishPropertyContinuations() {
        ObjectType referencedObjType = this.getReferencedObjTypeInternal();
        if (referencedObjType != null && !referencedObjType.isUnknownType() && this.propertyContinuations != null) {
            for (PropertyContinuation c : this.propertyContinuations) {
                c.commit(this);
            }
        }
        this.propertyContinuations = null;
    }

    public JSType getReferencedType() {
        return this.getReferencedTypeInternal();
    }

    @Override
    public String getReferenceName() {
        return this.reference;
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        JSType type = this.getReferencedType();
        if (!this.isResolved() || type.isNoResolvedType()) {
            sb.append(this.getReferenceName());
        } else {
            sb.append(type);
        }
    }

    @Override
    public NamedType toMaybeNamedType() {
        return this;
    }

    @Override
    public boolean isNominalType() {
        return this.isResolved() ? super.isNominalType() : true;
    }

    @Override
    int recursionUnsafeHashCode() {
        return this.isSuccessfullyResolved() ? super.recursionUnsafeHashCode() : NamedType.nominalHashCode(this);
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        ImmutableList resolvedTypeArgs = JSTypeIterations.mapTypes(t -> t.resolve(reporter), this.templateTypes);
        if (this.resolutionKind.equals((Object)ResolutionKind.NONE)) {
            return super.resolveInternal(reporter);
        }
        Preconditions.checkState((boolean)this.getReferencedType().isUnknownType(), (Object)"NamedTypes given a referenced type pre-resolution should have ResolutionKind.NONE");
        if (this.resolutionScope == null) {
            return this;
        }
        boolean unused = this.resolveTypeof(reporter) || this.resolveViaRegistry(reporter);
        super.resolveInternal(reporter);
        if (this.detectInheritanceCycle()) {
            this.handleTypeCycle(reporter);
        }
        this.finishPropertyContinuations();
        JSType result = this.getReferencedType();
        if (this.isSuccessfullyResolved()) {
            this.resolutionScope = null;
            ObjectType resultAsObject = result.toMaybeObjectType();
            if (resultAsObject == null) {
                return result;
            }
            if (resolvedTypeArgs.isEmpty() || !resultAsObject.isRawTypeOfTemplatizedType()) {
                return result;
            }
            int numKeys = result.getTemplateParamCount();
            if (numKeys < resolvedTypeArgs.size()) {
                resolvedTypeArgs = resolvedTypeArgs.subList(0, numKeys);
            }
            result = this.registry.createTemplatizedType(resultAsObject, (ImmutableList<JSType>)resolvedTypeArgs);
            this.setReferencedType(result.resolve(reporter));
        }
        return result;
    }

    private boolean resolveViaRegistry(ErrorReporter reporter) {
        JSType type = this.registry.getType(this.resolutionScope, this.reference);
        if (type == null) {
            this.handleUnresolvedType(reporter);
            return false;
        }
        this.setReferencedAndResolvedType(type, reporter);
        return true;
    }

    private boolean resolveTypeof(ErrorReporter reporter) {
        if (!this.resolutionKind.equals((Object)ResolutionKind.TYPEOF)) {
            return false;
        }
        String scopeName = this.reference.substring("typeof ".length());
        JSType type = this.resolutionScope.lookupQualifiedName(QualifiedName.of(scopeName));
        if (type == null || type.isUnknownType()) {
            if (this.registry.isForwardDeclaredType(scopeName)) {
                this.setReferencedType(new NoResolvedType(this.registry, this.getReferenceName(), this.getTemplateTypes()));
                if (this.validator != null) {
                    boolean bl = this.validator.apply((Object)this.getReferencedType());
                }
            } else {
                this.warning(reporter, "Missing type for `typeof` value. The value must be declared and const.");
                this.setReferencedAndResolvedType(this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE), reporter);
            }
        } else {
            if (type.isLiteralObject()) {
                JSType objlit = type;
                type = NamedType.builder(this.registry, this.getReferenceName()).setResolutionKind(ResolutionKind.NONE).setReferencedType(objlit).build();
            }
            this.setReferencedAndResolvedType(type, reporter);
        }
        return true;
    }

    private void setReferencedAndResolvedType(JSType type, ErrorReporter reporter) {
        if (this.restrictByNull) {
            type = type.restrictByNotNullOrUndefined();
        }
        if (this.validator != null) {
            boolean bl = this.validator.apply((Object)type);
        }
        this.setReferencedType(type);
        this.checkEnumElementCycle(reporter);
        this.checkProtoCycle(reporter);
    }

    private void handleTypeCycle(ErrorReporter reporter) {
        this.setReferencedType(this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        this.warning(reporter, "Cycle detected in inheritance chain of type " + this.reference);
    }

    private void checkEnumElementCycle(ErrorReporter reporter) {
        JSType referencedType = this.getReferencedType();
        if (referencedType instanceof EnumElementType && JSCompObjects.identical(this, ((EnumElementType)referencedType).getPrimitiveType())) {
            this.handleTypeCycle(reporter);
        }
    }

    private void checkProtoCycle(ErrorReporter reporter) {
        JSType referencedType = this.getReferencedType();
        if (JSCompObjects.identical(referencedType, this)) {
            this.handleTypeCycle(reporter);
        }
    }

    private void handleUnresolvedType(ErrorReporter reporter) {
        boolean isForwardDeclared = this.registry.isForwardDeclaredType(this.reference);
        if (!isForwardDeclared) {
            String root;
            String msg = "Bad type annotation. Unknown type " + this.reference;
            String string = root = this.reference.contains(".") ? this.reference.substring(0, this.reference.indexOf(".")) : this.reference;
            if (this.localVariableShadowsGlobalNamespace(root)) {
                msg = msg + "\nIt's possible that a local variable called '" + root + "' is shadowing the intended global namespace.";
            } else if (this.resolutionScope.getSlot(root) != null) {
                msg = msg + "\nIt's possible that '" + this.reference + "' refers to a value, not a type.";
            }
            this.warning(reporter, msg);
        } else {
            this.setReferencedType(new NoResolvedType(this.registry, this.getReferenceName(), this.getTemplateTypes()));
            if (this.validator != null) {
                boolean bl = this.validator.apply((Object)this.getReferencedType());
            }
        }
    }

    private boolean localVariableShadowsGlobalNamespace(String root) {
        StaticTypedSlot rootVar = this.resolutionScope.getSlot(root);
        if (rootVar != null) {
            Preconditions.checkNotNull((Object)rootVar.getScope(), (Object)rootVar);
            StaticScope parent = rootVar.getScope().getParentScope();
            if (parent != null) {
                StaticSlot globalVar = parent.getSlot(root);
                return globalVar != null;
            }
        }
        return false;
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        if (this.isResolved()) {
            return super.setValidator(validator);
        }
        this.validator = validator;
        return true;
    }

    void warning(ErrorReporter reporter, String message) {
        reporter.warning(message, this.sourceName, this.lineno, this.charno);
    }

    @Override
    public boolean isObject() {
        if (this.isEnumElementType()) {
            return this.toMaybeEnumElementType().isObject();
        }
        return super.isObject();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNamedType(this);
    }

    static Builder builder(JSTypeRegistry registry, String reference) {
        return new Builder(registry, reference);
    }

    Builder toBuilder() {
        Preconditions.checkState((!this.isResolved() ? 1 : 0) != 0, (Object)"Only call toBuilder on unresolved NamedTypes");
        return new Builder(this.registry, this.reference).setScope(this.resolutionScope).setResolutionKind(this.resolutionKind).setErrorReportingLocation(this.sourceName, this.lineno, this.charno).setTemplateTypes(this.templateTypes).setReferencedType(this.getReferencedType()).setRestrictByNull(this.restrictByNull);
    }

    static final class Builder {
        private final JSTypeRegistry registry;
        private ResolutionKind resolutionKind;
        private final String referenceName;
        private StaticTypedScope scope;
        private String sourceName;
        private int lineno;
        private int charno;
        private JSType referencedType;
        private boolean restrictByNull;
        private ImmutableList<JSType> templateTypes = ImmutableList.of();

        private Builder(JSTypeRegistry registry, String referenceName) {
            this.registry = registry;
            this.referenceName = referenceName;
            this.referencedType = registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        Builder setScope(StaticTypedScope scope) {
            this.scope = scope;
            return this;
        }

        Builder setResolutionKind(ResolutionKind resolutionKind) {
            this.resolutionKind = resolutionKind;
            return this;
        }

        Builder setErrorReportingLocation(String sourceName, int lineno, int charno) {
            this.sourceName = sourceName;
            this.lineno = lineno;
            this.charno = charno;
            return this;
        }

        Builder setErrorReportingLocationFrom(Node source) {
            this.sourceName = source.getSourceFileName();
            this.lineno = source.getLineno();
            this.charno = source.getCharno();
            return this;
        }

        Builder setTemplateTypes(ImmutableList<JSType> templateTypes) {
            this.templateTypes = templateTypes;
            return this;
        }

        Builder setReferencedType(JSType referencedType) {
            this.referencedType = referencedType;
            return this;
        }

        private Builder setRestrictByNull(boolean restrictByNull) {
            this.restrictByNull = restrictByNull;
            return this;
        }

        NamedType build() {
            return new NamedType(this);
        }
    }

    static enum ResolutionKind {
        NONE,
        TYPE_NAME,
        TYPEOF;

    }

    private static final class PropertyContinuation {
        private final String propertyName;
        private final JSType type;
        private final boolean inferred;
        private final Node propertyNode;

        private PropertyContinuation(String propertyName, JSType type, boolean inferred, Node propertyNode) {
            this.propertyName = propertyName;
            this.type = type;
            this.inferred = inferred;
            this.propertyNode = propertyNode;
        }

        void commit(ObjectType target) {
            target.defineProperty(this.propertyName, this.type, this.inferred, this.propertyNode);
        }
    }
}

